// http://akelpad.sourceforge.net/forum/viewtopic.php?p=28612#28612
// Version: 1.0
// Author: Shengalts Aleksander aka Instructor
//
//
// Description(1033): Go to nearest undo.
// Description(1049):     .
//
// Arguments:
// -Up=true     -Go up. Default is false.
//
// Usage (go down):
// Call("Scripts::Main", 1, "UndoPos.js")
//
// Usage (go up):
// Call("Scripts::Main", 1, "UndoPos.js", `-Up=true`)

//Arguments
var bUp=AkelPad.GetArgValue("Up", false);

//Variables
var hWndEdit=AkelPad.GetEditWnd();
var lpUndoItem;
var aOffset=[];
var nCount=0;
var nCaret;
var nGoto=-1;
var i;

if (lpUndoItem=AkelPad.MemAlloc(_X64?8:4 /*sizeof(HANDLE)*/))
{
  for (;;)
  {
    aOffset[nCount]=AkelPad.SendMessage(hWndEdit, 3092 /*AEM_GETUNDOPOS*/, 0x02 /*AEGUP_PREV*/, lpUndoItem);
    if (aOffset[nCount] == -1)
      break;
    ++nCount;
  }
  aOffset.sort(function(a, b)
  {
    return a - b;
  });
  AkelPad.MemFree(lpUndoItem);
}
if (aOffset.length)
{
  nCaret=AkelPad.SendMessage(hWndEdit, 3138 /*AEM_GETRICHOFFSET*/, 5 /*AEGI_CARETCHAR*/, 0);

  if (bUp)
  {
    for (i=0; i < aOffset.length; ++i)
    {
      if (aOffset[i] > nCaret)
      {
        nGoto=aOffset[i];
        break;
      }
    }
  }
  else
  {
    for (i=aOffset.length - 1; i >= 0; --i)
    {
      if (aOffset[i] < nCaret)
      {
        nGoto=aOffset[i];
        break;
      }
    }
  }
  if (nGoto != -1)
    AkelPad.SetSel(nGoto, nGoto);
}
