﻿// http://akelpad.sourceforge.net/forum/viewtopic.php?p=11455#11455
// Description(1033): Comparison of current and selected files using WinMerge
// 	(http://winmerge.org/)
// Description(1049): Сравнение двух открытых файлов в WinMerge
// Version: 0.5.2 (2014.12.17)
// Modifier: VladSh
// Author: se7h
//
// Usage:
// 	-"Compare..." Call("Scripts::Main", 1, "WinMerge.js") Icon(pathToAnyIcon)		- searching for a path to WinMerge automatically (when WinMerge installed with registration in Windows)
// 	-"Compare..." Call("Scripts::Main", 1, "WinMerge.js", `-toolDir="d:\Programs\TotalCmd\UTILs\WinMerge\"`)      - takes a path from scripts Arguments (when WinMerge installed as portable), else searching a path automatically
//
// Dependencies:
// 	FileTabs.js you found here: http://akelpad.sourceforge.net/forum/viewtopic.php?p=16297#16297
// 	CommonFunctions.js - here: http://akelpad.sourceforge.net/forum/viewtopic.php?p=1582#1582

if (!AkelPad.GetMainWnd()) WScript.Quit();

if (!AkelPad.Include("FileTabs.js")) WScript.Quit();
if (!AkelPad.Include("CommonFunctions.js")) WScript.Quit();

var pToolFileName = "WinMergeU.exe";

var FILES = {};
var nFileCurIndex = getTabIndexCurrent();
if (nFileCurIndex > 1) nFileCurIndex = 1;
FILES[nFileCurIndex] = getCurrentFileWithSave();
if (!FILES[nFileCurIndex]) WScript.Quit();

var nFileOtherIndex = Number(!nFileCurIndex);
if (AkelPad.SendMessage(hWndMain, 1291 /*AKD_FRAMESTATS*/, 0 /*FWS_COUNTALL*/, 0) == 2) {
	//если открыто всего 2 файла, то будем передавать их
	FILES[nFileOtherIndex] = getTabFilePrev();	//MDI and PMDI
	if (!FILES[nFileOtherIndex])		//если файл новый, переходим на его вкладку чтобы попытаться сохранить
	{
		activateTabByIndex(nFileOtherIndex);
		FILES[nFileOtherIndex] = getCurrentFileWithSave();
	}
}
else {
	//если открыто не 2 файла, то в утилиту будем передавать текущий и выбранный в диалоге открытия файла
	FILES[nFileOtherIndex] = FILES[nFileCurIndex];
	FILES[nFileCurIndex] = fileDialogDefault(true, FILES[nFileCurIndex], getFileExt(FILES[nFileCurIndex]));
}

if (FILES[nFileOtherIndex]) {
	var cmdLine = "\"" + FILES[0] + "\" \"" + FILES[1] + "\"";
	var pToolPath = AkelPad.GetArgValue("toolDir", "");
	if (pToolPath) {
		//сначала пытаемся взять из аргументов (возможно WinMerge был установлен как portable)
		pToolPath = getEnvironmentPath(pToolPath + pToolFileName);
		if (pToolPath) {
			cmdLine = "\"" + pToolPath + "\" " + cmdLine;
			var WshShell = new ActiveXObject("WScript.shell");
			WshShell.Exec(cmdLine);
			WScript.Quit();
		}
	}
	//для нормально инсталлированного WinMerge или когда портативный не был найден
	var AppShell = new ActiveXObject("shell.application");
	AppShell.ShellExecute(pToolFileName, cmdLine);
}

function getCurrentFileWithSave() {
	var pCurrentFile = AkelPad.GetEditFile(0);
	if (!pCurrentFile) {
		//если файл не сохранён, пытаемся его сохранить
		AkelPad.Command(4105);
		pCurrentFile = AkelPad.GetEditFile(0);
	}
	return pCurrentFile;
}