﻿// === [coder2wl.js] ===
// Panych Y.W. AKA FeyFre(c) 2011-2012
// Parses all existing Coder syntax files, merging context of Words:
// section with correspondent whitelist of SpellCheck plugin.
// 
// http://akelpad.sourceforge.net/forum/viewtopic.php?p=15212#15212
//	v0.99.2 2012.15.01
//	v0.99.1
//
// Example:
//	Call("Scripts::Main", 1, "coder2wl.js")
//

var ADTYPE_PLUGS	= 4;

var plugs = AkelPad.GetAkelDir(ADTYPE_PLUGS);
var coder = plugs+"\\coder";
var white = ";;\n;;\n;; Generated by coder2wl.js\n;;\n;;\n"

var fso = new ActiveXObject("Scripting.FileSystemObject");
var fcoder = fso.GetFolder(coder);
var coders = new Enumerator(fcoder.files);
var files = 0;
for(;!coders.atEnd();coders.moveNext())
{
	var name = ""+coders.item();
	if(name.match(/(\.coder)$/gi))
	{
		var temp = parse_coder_file(name);
		if(temp != "")
		{
			white += temp;
			files++;
		}
	}
	
}
if(files>0)
{
	//! Breed new data to spellcheck
	AkelPad.Call("SpellCheck::Background",1,white);
	//! Or copy to clipboard to be inserted to permanent storage(.spellcheck file)
	//AkelPad.SetClipboardText(white);
}


function parse_coder_file(file)
{
	var text = AkelPad.ReadFile(file);
	{
		var arr = file.split("\\");
		if(arr.length>0)
			file = arr[arr.length-1];
	}
	if(!text) return "";
	var exts=[];
	var words=[];
	var lines = text.split("\r\n");
	var pos = 0, cnt = lines.length;
	var	st_find_extensions=1,
		st_find_font=2,
		st_find_words=3,
		st_find_foldpanel=4;
	var st = st_find_extensions;
	var n=0;
	while(pos<cnt)
	{
		var line = ""+lines[pos]+"";
		if(st == st_find_extensions)
		{
			var m = line.match(/^Files:$/gi);
			if(m)
			{
				st = st_find_font;
			}
		}
		else if(st == st_find_font)
		{
			var m = line.match(/^font:$/i);
			if(m)
			{
				st = st_find_words;
				if(exts.length ==0) break;
			}
			else
			{
				if(!line.match(/^((;.*)|(\s*))$/gi))
				{
					var ttt = line.split("*.");
					if(ttt.length>0)
					{
						var e = ttt[ttt.length-1];
						if(	e.indexOf('.')==-1 &&
							e.indexOf('*')==-1 &&
							e.indexOf('?')==-1)
							exts.push(e);
					}
				}
			}
		}
		else if(st == st_find_words)
		{
			var m = line.match(/^words:$/gi);
			if(m)
			{
				st = st_find_foldpanel;
			}
		}
		else if(st == st_find_foldpanel)
		{
			if(line.match(/^foldpanel:$/gi))
			{
				break;
			}
			else if(!line.match(/^((;.*)|(\s*))$/gi))
			{
				var mm = line.match(/^\s*(\$\{[^}]+\}|\d+)\s+(\$\{[^}]+\}|\d+)\s+(\$\{[^}]+\}|\d+)\s+(\$\{[^}]+\}|\d+)\s+(.*)\s*$/gi);
				if(mm)
				{
					var splits = mm[0].split("\t");
					var opt=[];
					for(var spl in splits)
						opt = opt.concat(splits[spl].split(' '));
					if(!isNaN(opt[0]))
					{
						if(parseInt(opt[0])%2==1)
							words.push({ignorecase:false,word:opt[4]});
						else
							words.push({ignorecase:true,word:opt[4]});
					}
					else
					{
						words.push({ignorecase:true,word:opt[4]});
					}
				}
			}
		} else {"not reached";}
		pos++;
	}
	if(exts.length ==0) return "";
	if(words.length ==0) return "";
	result = ";; Generated from "+file+"\n";
	result += "+"+exts.join("\n+")+"\n";
	var pind,pair;
	for(pind in words)
	{
		pair = words[pind];
		if(pair.ignorecase==true) {result +="|";}
		result+=pair.word+"\n";
	}
	result += "-"+exts.join("\n-")+"\n";
	result += ";;End of "+file+"\n";
	return result;
}
