// http://akelpad.sourceforge.net/forum/viewtopic.php?p=18482#18482
// cpFontSwitch.js    ver.1.6    2012-07-19
// Cycling between specified font settings.
// Usage: Call("Scripts::Main", 1, "cpFontSwitch.js", `m [n1] [t1] [s1] [ [n2] [t2] [s2] [n3] [t3] [s3]  ...]`)
//    m - options mask, integer 1...7:
//      0x001 (1)  -  process font name
//      0x010 (2)  -  process font type
//      0x100 (4)  -  process font size
//    n - font name, in quotes
//    t - font type:
//      1 - normal
//      2 - bold
//      3 - italic
//      4 - bold italic
//    s - font size
// Examples:
//     Call("Scripts::Main", 1, "cpFontSwitch.js", `2 1 2 3`)
//        Switch font between normal/bold/italic.
//     Call("Scripts::Main", 1, "cpFontSwitch.js", `6 1 10 2 12`)
//        Switch between normal font(size 10) and bold font(size 12).
//     Call("Scripts::Main", 1, "cpFontSwitch.js", `7 "MS Sans Serif" 1 8 "Courier New" 2 10`)
//        Switch between normal "MS Sans Serif"(size 8) and bold "Courier New"(size 10).
//     Call("Scripts::Main", 1, "cpFontSwitch.js", `5 "MS Sans Serif" 8 "Courier New" 10 "Arial" 9`)
//        Switch between "MS Sans Serif"(size 8), "Courier New"(size 10) and "Arial"(size 9).

var hMainWnd = AkelPad.GetMainWnd();
var hWndEdit = AkelPad.GetEditWnd();
var lpLogFont;
var pFontName = "";
var nWeight;
var bItalic;
var nFontType;
var nFontSize;
var i;
var oMask;
var rowLen;
var colLen;

if (hMainWnd && hWndEdit && IsIntRng(0, 0, 1, 7) && (lpLogFont = AkelPad.MemAlloc(92 /*sizeof(LOGFONTW)*/)))      ///////////////////
{
   AkelPad.SendMessage(hMainWnd, 1233 /*AKD_GETFONTW*/, hWndEdit, lpLogFont);
   pFontName = AkelPad.MemRead(lpLogFont + 28 /*offsetof(LOGFONTW, lfFaceName)*/, 1 /*DT_UNICODE*/);
   nWeight = AkelPad.MemRead(lpLogFont + 16 /*offsetof(LOGFONTW, lfWeight)*/, 3 /*DT_DWORD*/);
   bItalic = AkelPad.MemRead(lpLogFont + 20 /*offsetof(LOGFONTW, lfItalic)*/, 5 /*DT_BYTE*/);
   nFontSize = AkelPad.SendMessage(hWndEdit, 3188 /*AEM_GETCHARSIZE*/, 3 /*AECS_POINTSIZE*/, 0);
   AkelPad.MemFree(lpLogFont);
   if (pFontName && nWeight && nFontSize)                                       ///////////////////
   {
      if (nWeight < 600)                                 ////
         nFontType = 1;
       else
         nFontType = 2;
      if (bItalic)
         nFontType += 2;
      oMask = WScript.Arguments(0);                        ////
      i = oMask;
      for (colLen=0; i!=0; ++colLen)
         i &= ~(-i);
      rowLen = (WScript.Arguments.Length - 1) / colLen;
      if (IsIntRng(1, rowLen, 1))
      {
         for (i; i < rowLen; ++i)                              ////
         {
            if  (((!(1 & oMask)) || ((1 & oMask) && (pFontName == WScript.Arguments(i * colLen + 1)))) && ((!(2 & oMask)) || ((2 & oMask) && (nFontType == WScript.Arguments(i * colLen + 1 + (1 & oMask))))) && ((!(4 & oMask)) || ((4 & oMask) && (nFontSize == WScript.Arguments(i * colLen + 1 + (1 & oMask) + ((2 & oMask) >> 1))))))
               break;
         }
         if (++i >= rowLen) i=0;
         if (1 & oMask)    pFontName = WScript.Arguments(i * colLen + 1);      ////
         if (2 & oMask)    nFontType = WScript.Arguments(i * colLen + 1 + (1 & oMask));
         if (4 & oMask)    nFontSize = WScript.Arguments(i * colLen + 1 + (1 & oMask) + ((2 & oMask) >> 1));
         if (isNaN(pFontName) && IsIntRng(1, nFontType, 1, 4) && IsIntRng(1, nFontSize, 0))
         {
            AkelPad.Font(pFontName, nFontType, nFontSize);
         }
      }
   }
}

function IsIntRng(aMod, aNum, aFrom, aTo)   //aMod: 0 - aNum is script argument namber, 1 - aNum is namber
{
   var aValue;
   if (aMod&1)
      aValue = aNum;
   else if (WScript.Arguments.length > aNum)
      aValue = +WScript.Arguments(aNum);
   if ((Math.floor(aValue) == aValue) && (aValue >= aFrom) && ((aTo === undefined) || (aValue <= aTo)))
      return true;
   return false;
}