﻿' getWords.vbs
'========================   Описание   =====================================
' Извлечение русских\английских слов\цифр из выделенного текста
' (если ничего не выделено слова извлекаются из всего текста)
'=======================   Параметры  ======================================
' 1-й параметр
'    0 - или без параметров извлекаются русские слова
'    1 -  извлекаются английские слова
'    2 -  извлекаются цифры
' 2-й параметр - длина , меньше которой слова извлекаться не будут
'    0 - извлекаются все слова
'    3 - не будут извлекаться слова меньше 3-х символов
' 3-й параметр:
'    0 - не удалять дубликаты слов
'    1 - удалять дубликаты слов
' 4-й параметр:
'    0 - не переводить в нижний регистр
'    1 - переводить в нижний регистр
' 5-й параметр:
'    сортировать по убыванию (любой 5-й параметр)
'========================   Примеры   ======================================
' -"Извлечение русских слов в выделенном" Call("Scripts::Main", 1, "getWords.vbs")
' -"Извлечение английских слов в выделенном" Call("Scripts::Main", 1, "getWords.vbs",`"1"`)

' используется Functions.vbs, который следует положить в ...AkelFiles\Plugs\Scripts\Include\

' Автор:           Аверин Андрей
' Версия:          1.5 (14.05.2011 - 08.09.2012)
' Mail:            Averin-And@yandex.ru
' Site:            http://tc-image.3dn.ru/forum/9-372-1138-16-1333628985
' Site:            http://akelpad.sourceforge.net/forum/viewtopic.php?p=15206#15206
'===========================================================================
N = 0 : K = 0 : Del = 0 : Ign = 0 : Abc = 0
With WScript
  Cnt = .Arguments.Count
  If Cnt > 0 Then
    N = .Arguments(0)
    If Cnt > 1 Then
      K = CInt(.Arguments(1))
      If Cnt > 2 Then
        Del = .Arguments(2)
        If Cnt > 3 Then
          Ign = .Arguments(3) : If Cnt > 4 Then Abc  = 1
        End If
      End If
    End If
  End If
End With

With AkelPad
  Text = .GetSelText()
  If Len(Text) = 0 Then Text = .GetTextRange(0, -1)
  If Len(Text) = 0 Then Wscript.Quit
  Call .Include("Functions.vbs")
  Select Case N
    Case 0 Text = RegExpReplace(Text, "[^а-яё\n]", Chr(32), 0, 1, 1)
    Case 1 Text = RegExpReplace(Text, "[^a-z\n]", Chr(32), 0, 1, 1)
    Case 2 Text = RegExpReplace(Text, "[\D]", Chr(32), 0, 1, 1)
  End Select
  Text = RegExpReplace(Text & Chr(32), "(" & Chr(32) & ")+", Chr(32) & Chr(32), 0, 1, 1)
  If Ign = 1 Then Text = LCase(Text)
  If K > 0 Then
    For ii = 1 To K
      point = String(ii, ".")
      Text = RegExpReplace(Text, "(" & Chr(32) & point & Chr(32) & ")+", "", 0, 1, 1)
    Next
  End If

  If Del = 1 Or Abc = 1 Then
    tArr = Split(Text, Chr(32))
    If Del = 1 Then tArr = DelDublicateArr(tArr)
    If Abc = 1 Then tArr = SelectingArrUp(tArr)
    Text = Join(tArr, Chr(13))
  Else
    Text = RegExpReplace(Text, "(" & Chr(32) & ")+", "\n", 0, 1, 1)
  End If

  If Len(Text) > 0 Then
    Call CreateNewTab
    Call SetRedraw(.GetEditWnd(), False)
    Call .ReplaceSel(Text)
    Call .SendMessage(.GetEditWnd(), 3087, False, 0)
    Call .SendMessage(.GetEditWnd(), 3079, 0, 0)
    Call .SetSel(0, 0)
    Call SetRedraw(.GetEditWnd(), True)
  Else
    CreateObject("WScript.Shell").Popup "Искомых слов не найдено!", 1, "Результат", 64
  End If
End With