﻿// http://akelpad.sourceforge.net/forum/viewtopic.php?p=28716#28716
// Description(1033): Pack/unpack of archives with 7-zip
// Description(1049): Запаковка/распаковка архивов с помощью 7-zip
// Version: 1.0 (2015.04.24)
// Author: VladSh 

// Arguments:
//    -action: [0] - pack, 1 - unpack
//    the descriptions of the other arguments see in \Include\ShowMenuEx.js
// 
// Parameters pack7zip.ini:
//    toolreg - the paths to 7-zip tool dir in Windows registry; separator: ';'
//    tooldir - the dir with 7-zip tool
//    archtype: -tzip - for zip-archives, "" or without parameter - it will created 7z-archive; it is default value which will be rewrited in a config of json-file
//    pExt    - can be used instead -pExt-argument (see ShowMenuEx.js)
// 
// Example of pack7zip.ini:
//  [Options]
//  toolreg=HKEY_CURRENT_USER\Software\7-Zip\Path;HKEY_LOCAL_MACHINE\SOFTWARE\7-Zip\Path
//  tooldir=c:\Program Files\7-Zip\
//  archtype=-tzip
//  pExt=json
// 
// Parameters *.json, or they can be set in arguments:
//    archtype - has more priority then corresponding ini parameter
//    archOptions - additional 7z-options
//    workdir  - the folder which will archived or where the archive will extracted
//    inclist  - the files list, which will be included to the archiving
//    exclist  - the files list, which will be excluded from the archiving
//    outfile  - the result file for pack or the source file for unpack
// 
// Example of one config in *.json-file for this script
//  {
//     "id": {   // id - for -pID argument
//        "name": "name (label) of this config which will showed in menu",
//        "options": {
//           "archOptions": "-spf -y",
//           "workdir":     "%a",
//           "inclist":     "%o\\pack7zip\\AkelPadSettings\\IncludeList.txt",
//           "outfile":     "d:\\Downloads\\INSTALL\\Text\\AkelPad\\AkelPadSettings.zip"
//        }
//     }
//  }
// 
// Usage:
//    -"Pack with configs dialog" Call("Scripts::Main", 1, "pack7zip.js", `-pExt="json"`)
//    -"Pack with configs dialog" Call("Scripts::Main", 1, "pack7zip.js") - same, bacause pExt=json was set in pack7zip.ini
//    -"Backup AkelPad folder" Call("Scripts::Main", 1, "pack7zip.js", `-pFile="packAkelPad.json" -pID="AkelPadFolder"`)
//    -"Unpack with configs dialog" Call("Scripts::Main", 1, "pack7zip.js", `-pExt="json" -action=1`)

var action = AkelPad.GetArgValue('action', 0);

if (! AkelPad.Include("ShowMenuEx.js")) WScript.Quit();

initIniOptions(['toolreg', 'tooldir', 'archtype']);

var toolexe = '7z.exe';
var toolpath;
if (opts['toolreg']) {
	toolpath = getToolPathReg(toolexe);
}
if (!toolpath) {
	toolpath = expandPath(opts['tooldir']) + toolexe;
	checkFilePath("7-zip", toolpath);
}

if (!initMenuParams(POS_CURSOR)) WScript.Quit();

var workdir = expandPath(opts['workdir']);
var outfile = expandPath(opts['outfile']);
var archOptions = opts['archOptions'];
var cmdline;

if (action) {
	checkFilePath("Output file", outfile);
	
	cmdline = toolpath + ' e "' + outfile + '" -o"' + workdir + '" ' + archOptions;
	
	AkelPad.Call("Log::Output", 1, cmdline, "", "", "", -1, -1);
}
else {
	checkDirPath(workdir);
	
	cmdline = toolpath + ' u ' + archOptions + ' ' + opts['archtype'] + ' "' + outfile + '"';
	
	var inclist = expandPath(opts['inclist']);
	var exclist = expandPath(opts['exclist']);
	if (inclist)
		cmdline += ' @"' + inclist + '"';
	if (exclist)
		cmdline += ' -x@"' + exclist + '"';
	
	AkelPad.Call("Log::Output", 1, cmdline, workdir, "", "", -1, -1);
}

function getToolPathReg(toolexe) {
	var result;
	var regpath = opts['toolreg'].split(';');
	for (var p in regpath) {
		try {
			result = expandPath(WshShell.RegRead(regpath[p])) + toolexe;
			if (fso.FileExists(result)) break;
		}
		catch (e) {
			if (bDebug) AkelPad.Call("Log::Output", 4, WScript.ScriptName + ": " + (e.message || e));
		}
	}
	return result;
}