﻿#ifndef __Dism_H
#define __Dism_H

#ifdef __cplusplus
extern "C" {
#endif

#define __declspec(x) __attribute__((x))
#define __unaligned __attribute__((packed))
#define DECLSPEC_IMPORT extern __declspec(dllimport)

#if defined(__x86_64__)||defined(_M_AMD64)
#define _AMD64_
typedef unsigned long long    size_t;
typedef long long			LONG_PTR;
#define __cdecl
#define __fastcall
#define __stdcall
#else
#define _X86_
typedef unsigned long	size_t;
typedef long			LONG_PTR;

#define __cdecl __attribute__((__cdecl__))
#define __fastcall __attribute__((fastcall))
#define __stdcall __attribute__((__stdcall__))
#endif

typedef size_t		ULONG_PTR, DWORD_PTR, SIZE_T, WPARAM, LPARAM;
typedef LONG_PTR    SSIZE_T;
typedef unsigned long	DWORD,*PDWORD,*LPDWORD,ULONG,*PULONG,*LPULONG,UINT,*PUINT,*LPUINT,UINT32,*PUINT32,*LPUINT32;
typedef unsigned long long	DWORD64,*PDWORD64,*LPDWORD64, UINT64,*PUINT64,*LPUINT64;
typedef long LONG,*PLONG,*LPLONG,INT,*PINT,*LPINT,INT32,*PINT32,*LPINT32;
typedef unsigned short UINT16,*PUINT16,*LPUINT16, WORD,*PWORD,*LPWORD;
typedef short INT16,*PINT16,*LPINT16;
typedef void VOID, *LPVOID, *PVOID;
typedef long HRESULT;
typedef int BOOL,*PBOOL,*LPBOOL;


#ifndef _WCHAR_T_DEFINED
typedef short wchar_t;
#define _WCHAR_T_DEFINED
#endif // !_WCHAR_T_DEFINED

typedef wchar_t WCHAR, *PWSTR,* LPWSTR,*BSTR;
typedef char CHAR, *PCHAR, *LPCHAR;

typedef const wchar_t* LPCWSTR,PCWSTR;
typedef const char* LPCSTR, PCSTR;
typedef BSTR *LPBSTR;

//GUID
typedef struct _GUID {
	unsigned long  Data1;
	unsigned short Data2;
	unsigned short Data3;
	unsigned char  Data4[8];
} GUID;

typedef GUID IID;
typedef GUID CLSID;

/* 0 == FALSE, -1 == TRUE */
typedef short VARIANT_BOOL;

#define MAX_PATH  260
#define FALSE     0
#define TRUE      1
#define NULL ((void*)0)
#define offsetof(type, field) ((size_t)&((type *)0)->field)

void *alloca(size_t size);

#if defined(__x86_64__)||defined(_M_AMD64)
#define _AMD64_
#ifndef _WIN64

typedef void *va_list;

va_list __va_start(void *fp);
void *__va_arg(va_list ap, int arg_type, int size);
va_list __va_copy(va_list src);
void __va_end(va_list ap);

#define va_start(ap, last) ((ap) = __va_start(__builtin_frame_address(0)))
#define va_arg(ap, type)                                                \
    (*(type *)(__va_arg(ap, __builtin_va_arg_types(type), sizeof(type))))
#define va_copy(dest, src) ((dest) = __va_copy(src))
#define va_end(ap) __va_end(ap)

#else /* _WIN64 */
typedef char *va_list;
#define va_start(ap,last) ap = ((char *)&(last)) + ((sizeof(last)+7)&~7)
#define va_arg(ap,type) (ap += (sizeof(type)+7)&~7, *(type *)(ap - ((sizeof(type)+7)&~7)))
#define va_copy(dest, src) (dest) = (src)
#define va_end(ap)
#endif

#else /* __i386__ */
#define _X86_
typedef char *va_list;
/* only correct for i386 */
#define va_start(ap,last) ap = ((char *)&(last)) + ((sizeof(last)+3)&~3)
#define va_arg(ap,type) (ap += (sizeof(type)+3)&~3, *(type *)(ap - ((sizeof(type)+3)&~3)))
#define va_copy(dest, src) (dest) = (src)
#define va_end(ap)
#endif

#define _CRTIMP extern
#define __CRT_INLINE extern __inline__

#define _CRT_ALIGN(x) __attribute__((aligned(x)))
#define DECLSPEC_ALIGN(x) __attribute__((aligned(x)))
#define _CRT_PACKING 8
#define __CRT_UNALIGNED
#define _CONST_RETURN

#define __CRT_STRINGIZE(_Value) #_Value
#define _CRT_STRINGIZE(_Value) __CRT_STRINGIZE(_Value)
#define __CRT_WIDE(_String) L ## _String
#define _CRT_WIDE(_String) __CRT_WIDE(_String)




//////////////////////////////////////基础Windows定义//////////////////////////////////////

#define WINAPI __stdcall


typedef void * HKEY,HANDLE;
typedef HKEY *PHKEY, *LPHKEY;
typedef HANDLE * PHANDLE, *LPHANDLE;
typedef DWORD REGSAM;

//
//  File System time stamps are represented with the following structure:
//

typedef struct _FILETIME {
	DWORD dwLowDateTime;
	DWORD dwHighDateTime;
} FILETIME, *PFILETIME, *LPFILETIME;
#define _FILETIME_


//Dism++ API 版本号 1.2
#define __DismAPIVersion__ 0x0102

////////////////////////////////////////////////////////////////
//                     枚举


typedef enum
{
	DismPackageStateUnknown = 0,
	DismPackageStateNotPresent,
	DismPackageStateUnintallRequested,
	DismPackageStateStaged,              //暂存
	DismPackageStateStaging,             //正在暂存
	DismPackageStateInstalled,           //更新已经安装
	DismPackageStateInstallRequested,    //安装挂起
	DismPackageStateSuperseded,          //该更新已经被取代
	DismPackageStatePartiallInstalled,   //部分安装
	DismPackageStateRemoved,             //已经删除
	DismPackageStatePermanent           //永久固化更新包
} DismPackageState;

typedef enum
{
	DismFeatureStateUnknown = 0,
	DismFeatureStateNotPresent,
	DismFeatureStateUnintallRequested,   //该功能已经关闭但是未生效
	DismFeatureStateDisable,             //该功能已经关闭
	DismFeatureStateStaging,
	DismFeatureStateEnable,              //该功能被启动
	DismFeatureStateEnableRequested,     //该功能已经启动，但是未生效
	DismFeatureStateSuperseded,          //该功能已经被取代
	DismFeatureStatePartiallInstalled,   //该功能部分安装
	DismFeatureStateRemoved              //该功能已经删除
} DismFeatureState;

typedef enum
{
	DismPackageFullyOfflineUnknow = 0,
	DismPackageFullyOfflineInatallable,
	DismPackageFullyOfflineNotInatallable,
} DismFullyOfflineInstallableState;



typedef enum
{
	DismDriverSinStatusUnknow = 0,
	DismDriverSinStatusUnsigned,
	DismDriverSinStatusSinged
} DismDriverSinStatus;


typedef enum
{
	DriverShowAll = 0,
	DriverShowInbox = 1,
	DriverShowOutOfBox = 2
} DriverShowEnum;


typedef enum 
{
	DismMountedImageStatusValid = 0,
	DismMountedImageStatusMounting = 1,
	DismMountedImageStatusInvalid = 2,
	DismMountedImageStatusNeedsRemount = 4
} DismMountedImageStatus;

typedef enum
{
	WimImageFile,
	VhdImageFile
}DismImageFileTpye;

//WIM或者esd文件的压缩类型
typedef enum
{
	//未知压缩类型
	Compress_Unknown = -1,

	//仅存储，不压缩文件
	Compress_None = 0,

	//此压缩方式支持WIMBOOT启动
	Compress_XpressHuffman = 1,

	//快速压缩，可以节省压缩时间并且可以减少提交占用
	Compress_Xpress = 2,

	//最大压缩，可以节省空间
	Compress_LZX = 3,

	//极限压缩，非常耗费时间，但是体积最小
	Compress_LZMS = 4,
}DismCompressTpye;


typedef enum
{
	//启动类型未知，可能是系统启动项，也可能是Dism无法识别的其他启动类型，为了安全性Dism++无法修改启动类型未知的项目
	DismServiceStartTypeUnknown = -1,
	//该服务已经关闭
	DismServiceStartTypeDisable,
	//该服务为手动启动
	DismServiceStartTypeManual,
	//该服务是自动启动
	DismServiceStartTypeAuto,
	//该服务是延迟启动，注意有_不可延迟标记的无法修改为延迟启动，会返回参数错误
	DismServiceStartTypeDelayed
}DismServiceStartType;

typedef enum
{
	//状态未知
	DismSystemStatusUnknown = -1,
	//准备就绪
	DismSystemStatusReady,
	//该系统不支持Dism++
	DismSystemStatusNotSupported,
	//找不到系统，目标目录无法访问或者路径不存在
	DismSystemStatusCannotFind,
	//挂载已经失效，需要删除
	DismSystemStatusNeedRemove,
	//请稍等
	DismSystemStatusWait
}DismSystemStatus;


typedef enum
{
	DismEnvironmentDefault = 0, //32位系统获得32位目录，64位系统获取64位路径
	DismEnvironment64Only,    //仅仅获取64位路径，对于32位系统会失败！
	DismEnvironment86Only,    //总是返回32位路径
}DismEnvironmentType;


typedef enum
{
	DismImageHealthy = 0,      //映像十分健康不需要修复
	DismImageRepairable = 1,   //映像已经受损，但是可以修复
	DismImageNonRepairable = 2 //映像已经收到致命问题，不可修复
}DismImageHealthState;

typedef enum
{
	DismSystemService,    //系统服务
	DismAppService,       //第三方应用程序
	DismDriverService,    //驱动程序
}DismServiceType;


typedef enum
{
	ProfileStatusDisabled = 0,
	ProfileStatusEnabled = 1,
	ProfileStatusApplied = 2,
	ProfileStatusMax
}ProfileStatus;

typedef enum
{
	StartupTypeUnknow = -1,

	//HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Run
	StartupTypeSystemRun,

	//HKEY_LOCAL_MACHINE\SOFTWARE\Wow6432Node\Microsoft\Windows\CurrentVersion\Run
	StartupTypeSystemRun32,

	//HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\RunOnce
	StartupTypeSystemRunOnce,

	//HKEY_LOCAL_MACHINE\SOFTWARE\Wow6432Node\Microsoft\Windows\CurrentVersion\RunOnce
	StartupTypeSystemRunOnce32,

	//HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Run
	StartupTypeUserRun,

	//HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\RunOnce
	StartupTypeUserRunOnce,

	//%SystemDirve%\ProgramData\Microsoft\Windows\Start Menu\Programs\Startup
	StartupTypeAllUsersStartupFolder,

	//%UserProfile%\AppData\Roaming\Microsoft\Windows\Start Menu\Programs\Startup
	StartupTypeCurrentUserStartupFolder,

	//HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Session Manager
	StartupTypeNativeBootExecute,

	//HKEY_USERS\DEFAULT\SOFTWARE\Microsoft\Windows\CurrentVersion\Run
	StartupTypeDefaultUserRun,

	//HKEY_USERS\DEFAULT\SOFTWARE\Microsoft\Windows\CurrentVersion\RunOnce
	StartupTypeDefaultUserRunOnce,
}StartupType;

typedef enum
{
	StartupStateRemove = -1,
	StartupStateDisable,
	StartupStateEnable,
}StartupState;

////////////////////////////////////////////////////////////////
//                      结构定义

#pragma pack(push, 1)

typedef struct _DismSystem
{
	//系统状态
	DismSystemStatus Status;

	/*
	操作系统CPU体系，可能值为：
	PROCESSOR_ARCHITECTURE_AMD64     x64体系
	PROCESSOR_ARCHITECTURE_INTEL     x86体系
	PROCESSOR_ARCHITECTURE_UNKNOWN   未知体系*/
	long Architecture;

	//在线指示
#define _联机映像      0x1     //如果为联机映像那么该标记为1 否则为0

	//存在形式
#define _本地硬盘      0x2  //映像存放于本地
#define _挂载映像      0x4  //映像是来自WIM或者VHD挂载的

	//使用的技术
#define _WIMBOOT       0x8  //映像使用了WIMBOOT技术
#define _VHD装载       0x10  //映像来自VHD装载
#define _CompactOs     0x20  //映像使用了CompactOs技术
#define _WinPE         0x40
	//用户自定义区 24~31  Dism++API可以保证不会使用这块区域，你可以自行添加新的定义
	DWORD Flags;       //Flags拥有以上组合标志
	DWORD ProductType;          //授权类型 WinNT、LanmanNT 或者 ServerNT

								//系统版本号 比如6.3.9600.17041
	UINT16 Version[4];


	wchar_t ProductName[256];    //操作系统名称
	wchar_t EditionID[256];      //系统具体版本

	wchar_t InstallationType[40];      //系统安装类型
	DWORD DefaultLanguage;      //默认显示语言
	DWORD InstallLanguage;      //系统安装语言
	wchar_t InstallLanguageFallback[256];//语言回退列表
										 //WIM XML中的Flags
	wchar_t szFlags[256];
	wchar_t RootPath[MAX_PATH];       //系统安装位置
									  //映像扩展路径，用于保存WIM路径以及VHD路径 多字符字符串
	wchar_t ExtendPath[1];
}DismSystem;

typedef struct _DismPackage
{
	DismPackageState State;
	wchar_t RestartRequired[40];

	wchar_t ReleaseType[40];
	wchar_t Identity[256];
	wchar_t Name[256];
	wchar_t Description[512];
	wchar_t ProductName[256];
	wchar_t ProductVersion[256];
	wchar_t Company[256];
	wchar_t Copyright[256];
	wchar_t SupportInformation[512];
	wchar_t InstallPackageName[256];
	wchar_t InstallLocation[256];
	wchar_t InstallClient[256];
	wchar_t InstallUserName[256];

	//暂无
	FILETIME CreationTime;
	FILETIME LastUpdateTime;
	FILETIME InstallTime;

	wchar_t FullyOfflineInstallable[256];
	wchar_t ScavengeSequence[40];

	VARIANT_BOOL IsApplicable;
}DismPackage;

typedef struct _DismFeature
{
	DismFeatureState State;
	wchar_t RestartRequired[40];
	wchar_t Name[256];
	wchar_t DisplayName[512];
	wchar_t Description[512];
	//DWORD ParentFeatureNameCount;
	wchar_t ParentFeatureName[40];
}DismFeature;

typedef struct _DismCapability
{
	DismFeatureState State;
	DWORD DownloadSize;
	DWORD InstallSize;

	wchar_t Name[256];
	wchar_t ID[256];
	wchar_t DisplayName[512];
	wchar_t Description[512];
}DismCapability;


typedef struct _DismDriver
{
	wchar_t LocaleName[0x55];
	wchar_t InfProviderName[0x104];
	wchar_t CatalogFile[0x104];
	wchar_t InfPath[0x104];
	wchar_t PublishedInfName[256];
	GUID ClassGuid;
	wchar_t ClassName[0x104];
	wchar_t ClassDescription[256];
	UINT16 Version[4];
	FILETIME Date;
	VARIANT_BOOL InBox;
	VARIANT_BOOL BootCritical;
	VARIANT_BOOL SigStatus;
}DismDriver;


typedef struct _DismMountedImage
{
	wchar_t MountDir[MAX_PATH];
	wchar_t ImagePath[MAX_PATH];
	DWORD Index;
	DismMountedImageStatus Status;
	VARIANT_BOOL ReadWritable;
}DismMountedImage;

typedef struct _DismImageInfo
{
	//系统体系
	long Architecture;

	//创建日期
	FILETIME CreationTime;

	//展开空间
	UINT64 Space;

	//系统版本号
	UINT16 Version[4];

	//////////////////////////////////////////////////
	//        你可以修改以下信息 来设置映像信息

	//映像名称
	wchar_t Name[256];

	//映像说明
	wchar_t Description[512];

	//显示名称
	wchar_t DisplayName[256];

	//显示说明
	wchar_t DisplayDescription[512];

	//映像版本标记
	wchar_t Flags[256];
}DismImageInfo;

typedef struct _DismImageFileInfo
{
	//启动下标
	int BootIndex;

	//文件类型
	DismImageFileTpye Type;

	//文件唯一标识
	GUID FileGUID;

	//压缩类型
	DismCompressTpye Compression;

	//映像数量
	DWORD ImageInfoCount;

	//映像
	DismImageInfo ImageInfo[0];
}DismImageFileInfo;

typedef struct _DismService
{
	DismServiceType Type;
	/*
	服务启动类型,可能值为
	SERVICE_AUTO_START
	SERVICE_BOOT_START
	SERVICE_DEMAND_START
	SERVICE_DISABLED
	SERVICE_SYSTEM_START
	*/
	//延迟启动
#define SERVICE_Delay_START 5
	DWORD dwStartType;

#define _系统保护 0x00000001
#define _不可延迟 0x00000002
#define _系统服务 0x00000004
	//服务Flags 拥有以上状态
	DWORD Flags;

	//服务名称
	wchar_t Name[256];

	//对应服务显示名称
	wchar_t DisplayName[256];

	//对应服务显示描述
	wchar_t Description[512];

	//对应服务路径
	wchar_t ImagePath[MAX_PATH];

	//对应服务的登录状态
	wchar_t ObjectName[256];
}DismService;


typedef struct _AppxPackage
{
	//当前结构体大小，指向下一个AppxPackage元素
	DWORD cbData;
	wchar_t FullName[256];
	wchar_t InstalledLocation[MAX_PATH];
	wchar_t Users[1];
}AppxPackage;



#pragma pack(pop)



typedef void* DismSession;


#define DISM_MSG_PROGRESS   38008     //进度信息wParam为当前完成百分比
#define DISM_MSG_PROCESS    38009     //指示该文件是否应该被捕获wParam = (PWSTR) pszFullPath   lParam = (PBOOL) pfProcessFile
#define DISM_MSG_SCANNING   38010     //扫描的文件数量与文件夹 wParam=(BOOL)IsDirector   lParam=(UINT)Count
#define DISM_MGS_RemoveInfo 37001     //指示该文件或者文件夹需要处理   wParam=(DWORD)Type    lParam=(LPCWSTR)FilePath
#define Dism_MSG_QUERY_ABORT 38030    //是否需要中断该操作？返回-1 则中断当前操作，返回S_OK那么函数正常进行 
#define DISM_MGS_AllowExclusive 39001 //指示此更新是否允请求独占   wParam=(PBOOL)pAllowExclusive

//Dism回掉函数，用于返回进度等信息dwMessageId，有以上几种消息  UserData是你传入的指针 如果函数正常进行，请返回 ERROR_SUCCESS
typedef DWORD(WINAPI *DismCallBack)(DWORD dwMessageId, WPARAM wParam, LPARAM lParam, PVOID UserData);


///////////////////////////////////////////////基础函数支持////////////////////////////////////////////////
//
//


//获取指定的注册表键值,调用后需要使用RegClose关闭
HRESULT WINAPI DismRegOpenKeyEx(DismSession Session, HKEY hKey, LPCWSTR lpSubKey, REGSAM samDesired, PHKEY phkResult);

//创建键值
HRESULT WINAPI DismRegCreateKeyEx(DismSession Session, HKEY hKey, LPCWSTR lpSubKey, REGSAM samDesired, PHKEY phkResult, LPDWORD lpdwDisposition);

//获取指定的注册表键值,调用后需要使用RegClose关闭
HRESULT WINAPI DismRegOpenKey(DismSession Session, HKEY hKey, LPCWSTR lpSubKey, PHKEY phkResult);

//转换指定的环境变量
HRESULT WINAPI DismExpandEnvironmentStrings(DismSession Session, LPCWSTR lpSrc, LPBSTR lpDst);

#define DismLogLevelSilent      0    //不输出任何信息
#define DismLogLevelFailure     1    //仅错误
#define DismLogLevelWarning     2    //错误和警告
#define DismLogLevelInformation 3    //错误、警告和信息
#define DismLogLevelDebug       4    //以上所有内容和调试输出
//写入日志
HRESULT WINAPI DismWriteLog(DWORD LogLevel, LPCWSTR LogName, LPCWSTR LogValue);

//释放Dism接口调用后的空间
HRESULT WINAPI DismFreeMemory(void* pStruct);

//根据会话获得系统信息
HRESULT WINAPI DismGetSystemInfoBySession(DismSession Session, DismSystem** Info);

//根据路径获得系统信息
HRESULT WINAPI DismGetSystemInfoByPath(LPCWSTR RootPath, DismSystem** Info);

//将指定错误代码转换为对应文本。
HRESULT WINAPI DismFormatMessage(HRESULT hr, LPBSTR ppErrorMessage);

//获取临时目录
LPCWSTR WINAPI DismGetScratchDir();

BOOL WINAPI DismUnloadRegMount(LPCWSTR RootPath);

//
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////



/////////////////////////////////////////////////////更新包命令///////////////////////////////////////////////
//
//

//添加更新包
HRESULT WINAPI DismAddPackage(DismSession Session, LPCWSTR PackageFilePath, DismCallBack CallBack, LPVOID UserData);

//删除更新包
HRESULT WINAPI DismRemovePackage(DismSession Session, LPCWSTR PackageName, DismCallBack CallBack, LPVOID UserData);

//获取更新包信息
//HRESULT WINAPI DismGetPackage(DismSession Session, LPCWSTR PackageIdentity, DismPackage** ppPackageInfo);

//获取所有更新包
HRESULT WINAPI DismGetPackages(DismSession Session, DismPackage** ppPackages, DWORD* pCount, DismCallBack CallBack, LPVOID UserData);

//
//
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////





//////////////////////////////////////////////////功能包命令/////////////////////////////////////////////////////
//

HRESULT WINAPI DismChangeFeatures(DismSession Session,
	LPCWSTR FeatureNames,  //需要关闭的功能名称
#define DismLimitAccess 0x00000001   //NT6.1无效 打开功能时不要从微软服务器中下载文件 PS：如果这样设定可能会应该不能下载到文件而打开失败
	DWORD ChangeFlags,   //关闭标志，支持以上状态
	LPCWSTR SourcePaths,  //NT6.1无效 指定启用源，在启动功能时优先从源复制文件,多个源以NULL分割
	DismCallBack CallBack, LPVOID UserData);

//获取功能状态
HRESULT WINAPI DismGetFeatures(DismSession Session, DismFeature** ppFeature, LPDWORD pCount, DismCallBack CallBack, LPVOID UserData);

//
//
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////




//////////////////////////////////////////////////系统修复命令///////////////////////////////////////////////////////
//
//

//扫描系统是否受损
HRESULT WINAPI DismScanHealth(DismSession Session, DismImageHealthState* pImageHealthState, DismCallBack CallBack, PVOID UserData);

//恢复系统受损
HRESULT WINAPI DismRestoreHealth(DismSession Session, LPCWSTR SourcePaths, DismCallBack CallBack, PVOID UserData);

//
//
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////



//////////////////////////////////////////////////可选功能///////////////////////////////////////////////////////
//
//
//仅从本地获取
#define CapabilityFlagsPackageStore 0x1
//从安装源中获取
#define CapabilityFlagsLocalSouce   0x2
//从云端获取
#define CapabilityFlagsCloud        0x4

//获取所有可选功能状态
HRESULT WINAPI DismGetCapabilities(DismSession Session, DWORD CapabilityFlags, DismCapability** ppCapabilitites, DWORD* pCount);

//删除可选功能
HRESULT WINAPI DismRemoveCapability(DismSession Session, LPCWSTR CapabilityName, DismCallBack CallBack, LPVOID UserData);

//添加可选功能
HRESULT WINAPI DismAddCapability(DismSession Session, LPCWSTR CapabilityName, DismCallBack CallBack, LPVOID UserData);
//
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////



/////////////////////////////////////////////////服务命令支持//////////////////////////////////////////////////////
//
//

//获取所有服务
HRESULT WINAPI DismGetServices(DismSession Session, DismService** ppService, DWORD *pCount, DismCallBack CallBack, LPVOID pUserData);

//删除服务
HRESULT WINAPI DismRemoveService(DismSession Session, LPCWSTR Name);

//修改服务启动类型
HRESULT WINAPI DismSetServiceStart(DismSession Session, LPCWSTR Name, DWORD StartType);

//
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////驱动包命令//////////////////////////////////////////////////////
//
//

//添加驱动包
HRESULT WINAPI DismAddDriver(DismSession Session, LPCWSTR DriverPath);

//删除驱动包
HRESULT WINAPI DismRemoveDriver(DismSession Session, LPCWSTR DriverName);

//获取所有驱动包
HRESULT WINAPI DismGetDrivers(DismSession Session, DismDriver** ppDrivers, DWORD* pCount, DriverShowEnum DriverShow, DismCallBack CallBack, LPVOID UserData);

//
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////



/////////////////////////////////////////////清理相关////////////////////////////////////////////////////////
//
//

//清理过期不需要的更新
HRESULT WINAPI DismComponentCleanup(DismSession Session, DWORD Reserved, UINT64 *CleanUpSpace, DismCallBack CallBack, LPVOID UserData);

//清理过期以及不使用的驱动
HRESULT WINAPI DismDriverCleanup(DismSession Session, DWORD Reserved, UINT64 *CleanUpSpace, DismCallBack CallBack, LPVOID UserData);

//清理不需要的Metro App
HRESULT WINAPI DismAppxsCleanup(DismSession Session, DWORD Reserved, UINT64 *CleanUpSpace, DismCallBack CallBack, LPVOID UserData);

//开启紧凑型系统
HRESULT WINAPI DismCompactOs(DismSession Session, DWORD Reserved, UINT64 *CleanUpSpace, DismCallBack CallBack, LPVOID UserData);

//使用NTFS硬链接合并相同文件，缩小系统体积
HRESULT WINAPI DismHardLinkMerge(DismSession Session, DWORD Reserved, UINT64 *CleanUpSpace, DismCallBack CallBack, LPVOID UserData);

//
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////



///////////////////////////////////////////////WIM处理命令//////////////////////////////////////////////////
//
//

HRESULT WINAPI DismGetMountedImages(DismMountedImage** ppMountedImages, DWORD* pCount);

//获取WIM、esd、VHD的文件信息
HRESULT WINAPI DismGetImageFileInfo(LPCWSTR ImageFilePath, DismImageFileInfo** ppFileInfo);

//修改WIM、esd的文件信息
HRESULT WINAPI DismSetImageFileInfo(LPCWSTR ImageFilePath, DWORD ImageIndex, DismImageInfo* pImageInfo);




#define _ExportCreate            0x00000001	//覆盖目标文件
/*
导出指定映像，当DesImageFile存在时CompressTpye将忽略
SourceImageFile：需要导出的映像路径
SourceIndex    ：需要导出映像的下标
DesImageFile   ：用于存放目标映像，如果不存在那么会使用CompressTpye指定的压缩等级创建该文件，如果该文件已经存在，那么CompressTpye参数将忽略
CompressTpye   ：压缩等级
ExportFlags    ：导出标记，可以使用以上组合
*/
HRESULT WINAPI DismExportImage(LPCWSTR SourceImageFile, DWORD SourceIndex, LPCWSTR DesImageFile, DWORD ExportFlags, DismCompressTpye CompressTpye, DismCallBack CallBack, LPVOID pUserData);

//删除WIM 文件中的映像
HRESULT WINAPI DismDeleteImage(LPCWSTR FilePath, DWORD DeleteIndex);

//将指定下标的WIM文件设置为可启动，如果indxe为-1 那么清除启动标志
HRESULT WINAPI DismSetBootImage(LPCWSTR FilePath, DWORD BootIndex);

#define _CommitAppend               0x00000001
#define _CommitVerify               0x00000002
#define _CommitNoDirAcl             0x00000010
#define _CommitNoFileAcl            0x00000020
#define _CommitNoRpFix              0x00000100

//提交挂载映像更改CommitFlags 拥有以上属性
HRESULT WINAPI DismCommitImage(LPCWSTR MountPath, DWORD CommitFlags, DismCallBack CallBack, LPVOID UserData);


#define _MountFlagReadOnly       0x00000200     //如果该标记存在那么为可写挂载，否则为只读挂载
#define _MountFlagOptimize       0x00000400
#define _MountFlagCheckIntegrity 0x00000002
//挂载指定下标映像，其中Flags拥有以上属性
HRESULT WINAPI DismMountImage(LPCWSTR ImageFilePath, DWORD MountIndex, DWORD MountFlags, LPCWSTR MountPath, DismCallBack CallBack, LPVOID UserData);


#define _ApplyFlags_Verify  0x00000002   //校验数据
#define _ApplyFlags_WIMBoot 0x00002000   //释放WIMBoot 映像
#define _ApplyFlags_Compact 0x00004000   //释放紧凑型映像
#define _ApplyFlags_WinToGo 0x10000000   //为映像启用Windows To Go
/*PublicKey 使用附加Key进行内存解密*/
HRESULT WINAPI DismApplyImage(LPCWSTR ImageFilePath, DWORD ApplyIndex, DWORD ApplyFlags, LPCWSTR ApplyPath, DismCallBack CallBack, LPVOID UserData);


//卸载指定目录的挂载映像
HRESULT WINAPI DismUnmountImage(LPCWSTR MountPath, DismCallBack CallBack, LPVOID UserData);


//解密加密的WIM文件
HRESULT WINAPI DismDecryptWimFile(LPCWSTR FilePath, LPCWSTR PublicKey, BOOL TestKey/* 如果为TRUE 那么仅测试Key能否解密此文件*/);

#define _CaptureNew                0x80000000	//总是新建文件，删除当前文件。默认情况如果文件已经存在则打开文件。
#define _CaptureSnapshot           0x40000000	//为目标产生快照，使用该标志可以捕获正在使用的文件，一般用于捕获在线系统。
#define _CaptureBootable           0x20000000	//仅WIM文件支持,将Windows PE卷映像标记为能够引导
#define _CaptureReserved           0x00000001	//仅WIM文件支持
#define _CaptureVerify             0x00000002	//仅WIM文件支持
#define _CaptureIndex              0x00000004	//仅WIM文件支持
#define _CaptureNoApply            0x00000008	//仅WIM文件支持
#define _CaptureNoDirAcl           0x00000010	//仅WIM文件支持
#define _CaptureNoFileAcl          0x00000020	//仅WIM文件支持
#define _CaptureShareWrite         0x00000040	//仅WIM文件支持
#define _CaptureFileInfo           0x00000080	//仅WIM文件支持
#define _CaptureNoRpFix            0x00000100	//仅WIM文件支持
#define _CaptureApplyCiEa          0x00001000	//仅WIM文件支持
//#define _CaptureWIMBoot            0x00002000	//仅WIM文件支持，生成的文件允许够使用 WIMBoot 配置。
/*将某个路径捕获为WIM、esd、VHD(X)文件 （esd、VHD(X)暂未支持）
注意DismCompressTpye参数仅仅WIM文件有效 而且仅仅在新建文件中发挥作用*/
HRESULT WINAPI DismCaptureImage(LPCWSTR CapturePath, LPCWSTR ImageFilePath, DismCompressTpye CompressTpye, DWORD CaptureFlags, DismCallBack CallBack, LPVOID UserData, DismImageInfo* pImageInfo);

//映像拆分
HRESULT WINAPI DismSplitFile(LPCWSTR ImageFilePath, LPCWSTR SplitFilePath, UINT64 SplitSize, DismCallBack CallBack, LPVOID UserData);

//将一个esd文件转换为ISO文件
HRESULT WINAPI DismConversionESD2ISO(LPCWSTR szWimFilePath, LPCWSTR szISOPath, DismCompressTpye CompressTpye, DismCallBack CallBack, LPVOID UserData);

//
//
//////////////////////////////////////////////////////////////////////////////////////////////////////////



//Appx支持
HRESULT WINAPI DismGetAllUsersAppx(DismSession Session, AppxPackage** ppPackages, DWORD* pcbPackages);

HRESULT WINAPI DismRemoveAppx(DismSession Session, LPCWSTR FullName);

HRESULT WINAPI DismGetProvisionedAppxs(DismSession Session, AppxPackage** ppPackages, DWORD* pcbPackages);

HRESULT WINAPI DismRemoveProvisionedAppx(DismSession Session, LPCWSTR FullName);

typedef enum
{
	//仅启动RE
	RunREOnly = -2,

	//仅对RE进行初始化配置
	InitializeRE = -1,

	//在RE中运行自定义工具（仅一次）
	RunCustomToolOnce,

	//执行系统还原（将Windows.bt中的文件移动到当前系统）
	SystemRestore,

	//保留，Dism++中暂未使用此功能。
	Reservation1,

	//在RE中运行自定义工具（持久启动项）
	RunCustomTool,

	MaxREConfigCode,
}REConfigCode;

/*RE支持
Code: 任务执行动作

BootID:  Code为 RunCustomToolOnce或者 RunCustomTool时有效。引导菜单，随机输入一个32位值，不要跟其他人冲突，用于产生引导菜单

FilePath：Code为 RunCustomToolOnce或者 RunCustomTool时有效，在RE中需要启动的文件路径

CallBack：可选，回调函数，用于输出处理进度

UserData：可选，此值将传入 回调函数的UserData产生中，供调用者使用
*/
HRESULT WINAPI WinREConfig2(REConfigCode Code, DWORD BootID, LPCWSTR FilePath, DismCallBack CallBack, LPVOID UserData);


typedef enum
{
	DismFirstBootPreSysPrep,
	DismFirstBootPostSysPrep,
	DismFirstBootPreOobe,
	DismFirstBootPostOobe,
}DismFirstBootPhase;

//IBS支持，设置首次启动运行命令
HRESULT WINAPI IbsSetFirstBootCommandLine(DismSession Session, DismFirstBootPhase Phase, LPCWSTR CommandLine);


/*AssocSupport
用于调整映像文件关联*/


HRESULT WINAPI DismAppAssociationsDefaultExport(DismSession Session, LPCWSTR FilePath);

HRESULT WINAPI DismAppAssociationsDefaultImport(DismSession Session, LPCWSTR FilePath);

HRESULT WINAPI DismAppAssociationsDefaultRemove(DismSession Session);

HRESULT WINAPI DismAppAssociationsExport(DismSession Session, LPCWSTR FilePath);

HRESULT WINAPI DismAppAssociationsImport(DismSession Session, LPCWSTR FilePath);

HRESULT WINAPI DismAppAssociationsRemove(DismSession Session);

#ifdef __cplusplus
}
#endif

#endif /* __Dism_H */
