/*
 * Decompiled with CFR 0.152.
 */
package com.af.benchafhelper.utils;

import com.af.benchafhelper.beans.ADBType;
import com.af.benchafhelper.beans.CommandResultBean;
import com.af.benchafhelper.beans.CommandRunResult;
import com.af.benchafhelper.utils.CommandManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.LinkedBlockingQueue;
import javafx.application.Platform;

public class AnalysisTask
implements Runnable {
    private LinkedBlockingQueue<CommandResultBean> resultQueue;
    private CommandManager.OnCommandResultListener listener;
    private boolean isDestroy = false;

    public AnalysisTask(LinkedBlockingQueue<CommandResultBean> resultQueue) {
        this.resultQueue = resultQueue;
    }

    public void setListener(CommandManager.OnCommandResultListener listener) {
        this.listener = listener;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            block8: while (!Thread.interrupted() && !this.isDestroy) {
                CommandResultBean resultBean = this.resultQueue.take();
                ADBType type = resultBean.getType();
                CommandRunResult runResultData = resultBean.getResultData();
                String resultData = runResultData.getCommandResultData();
                final String errorData = runResultData.getCommandErrorData();
                if (this.listener != null) {
                    this.listener.onLog(runResultData.toString());
                }
                switch (type) {
                    case TYPE_TEST_CONNECT: {
                        System.out.println("AnalysisTask:runResultData = " + runResultData.toString());
                        final ArrayList<String> devices = new ArrayList<String>();
                        if (resultData == null) break;
                        String[] split = resultData.split("\n");
                        if (split.length > 1) {
                            devices.addAll(Arrays.asList(split).subList(1, split.length));
                        }
                        if (this.listener == null) continue block8;
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                AnalysisTask.this.listener.onTestConnResult(devices);
                            }
                        });
                        break;
                    }
                    case TYPE_ACTIVATE_PULL: {
                        System.out.println("AnalysisTask:runResultData = " + runResultData.toString());
                        this.activateError(resultData, errorData);
                        break;
                    }
                    case TYPE_ACTIVATE_CHMOD: {
                        System.out.println("AnalysisTask:runResultData = " + runResultData.toString());
                        this.activateError(resultData, errorData);
                        break;
                    }
                    case TYPE_ACTIVATE_RUN: {
                        System.out.println("AnalysisTask:runResultData = " + runResultData.toString());
                        if (errorData != null && !errorData.equals("")) {
                            Platform.runLater((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    AnalysisTask.this.listener.onActivateError(errorData);
                                }
                            });
                            break;
                        }
                        if (resultData != null && !resultData.equals("") && resultData.contains("error")) {
                            Platform.runLater((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    AnalysisTask.this.listener.onActivateError("\u6fc0\u6d3b\u5931\u8d25");
                                }
                            });
                            break;
                        }
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                AnalysisTask.this.listener.onActivateResult("success");
                            }
                        });
                        continue block8;
                    }
                }
            }
            return;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void activateError(String resultData, final String errorData) {
        if (errorData != null && !errorData.equals("") && this.listener != null) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    AnalysisTask.this.listener.onActivateError(errorData);
                }
            });
        }
        if (resultData != null && !resultData.equals("") && resultData.contains("error") && this.listener != null) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    AnalysisTask.this.listener.onActivateError("\u6fc0\u6d3b\u5931\u8d25");
                }
            });
        }
    }

    public void destroy() {
        this.isDestroy = true;
    }
}

