/*
 * Decompiled with CFR 0.152.
 */
package com.af.benchafhelper.utils;

import com.af.benchafhelper.beans.CommandRequestBean;
import com.af.benchafhelper.beans.CommandResultBean;
import com.af.benchafhelper.beans.CommandRunResult;
import com.af.benchafhelper.utils.CommandUtil;
import java.io.IOException;
import java.util.concurrent.LinkedBlockingQueue;

public class CommandTask
implements Runnable {
    private LinkedBlockingQueue<CommandRequestBean> commandQueue;
    private LinkedBlockingQueue<CommandResultBean> resultQueue;
    private boolean isDestroy = false;

    public CommandTask(LinkedBlockingQueue<CommandRequestBean> commandQueue, LinkedBlockingQueue<CommandResultBean> resultQueue) {
        this.commandQueue = commandQueue;
        this.resultQueue = resultQueue;
    }

    @Override
    public void run() {
        try {
            while (!Thread.interrupted() && !this.isDestroy) {
                try {
                    CommandRequestBean requestBean = this.commandQueue.take();
                    CommandRunResult resultData = null;
                    String command = requestBean.getCommand();
                    resultData = CommandUtil.execCommand(command);
                    CommandResultBean resultBean = new CommandResultBean(requestBean.getType(), resultData);
                    this.resultQueue.put(resultBean);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void destroy() {
        this.isDestroy = true;
    }
}

