//**************************************************************************
//** modGoAnywhere by Tomixx1111 https://www.nexusmods.com/users/31974225 **
//************************************************************************** ver 1.0

class GoAnywhere
{
	const var Null		: Vector;
	var savedLocation	: Vector;
	var text 			: string;
	
	function Init()
	{
		theInput.RegisterListener (this, 'OnGaTeleport', 'GaTeleport');
		theInput.RegisterListener (this, 'OnGaSaveLocation', 'GaSaveLocation');
		theInput.RegisterListener (this, 'OnGaFriendly', 'GaFriendly');
		theInput.RegisterListener (this, 'OnGaUnlock', 'GaUnlock');
	}
	
	event OnGaTeleport (action : SInputAction)
	{
		if (IsPressed (action))
		{
			if (theGame.IsFreeCameraEnabled()) 
			thePlayer.Teleport (theGame.GetFreeCameraPosition());

			else if (savedLocation != Null) 
			thePlayer.Teleport (savedLocation);
		}
	}
	
	event OnGaSaveLocation (action : SInputAction)
	{
		if (IsPressed (action))
		{
			savedLocation = thePlayer.GetWorldPosition();
			text = GetLocStringByKeyExt ('GaLocationSaved');
			thePlayer.DisplayHudMessage (text);
		}
	}
	
	var friendly : bool;
	default friendly = false;
	
	event OnGaFriendly (action : SInputAction)
	{
		if (IsPressed (action))
		{
			if (!friendly)
			{
				((CActor)thePlayer).SetTemporaryAttitudeGroup ('q104_avallach_friendly_to_all', AGP_Default);
				friendly = true;
				text = GetLocStringByKeyExt ('GaFriendlyMode');
				thePlayer.DisplayHudMessage (text);
			}
			
			else
			{
				((CActor)thePlayer).SetTemporaryAttitudeGroup('player', AGP_Default);
				friendly = false;
				text = GetLocStringByKeyExt ('GaEnemyMode');
				thePlayer.DisplayHudMessage (text);
			}
		}
	}
	
	event OnGaUnlock (action : SInputAction)
	{
		if (IsPressed (action))
		{
			((W3NewDoor) (CEntity) thePlayer.GetDisplayTarget()).Unlock();
			text = GetLocStringByKeyExt ('GaTrying');
			thePlayer.DisplayHudMessage (text);
		}
	}
}