﻿using System;

using System.Collections.Generic;

using System.Linq;

using System.Reflection;

using System.Text;

using Harmony12;

using UnityModManagerNet;

using UnityEngine;

using UnityEngine.UI;

using UnityEngine.EventSystems;

namespace KillThemXX
{


    public static class Main

    {
        public class Settings : UnityModManager.ModSettings

        {

            public override void Save(UnityModManager.ModEntry modEntry)

            {

                UnityModManager.ModSettings.Save<Settings>(this, modEntry);

            }

            public bool beFriend = false; //是否同道
            public bool gou = true; // 是否续命
            public bool beGang = false; // 是否村民
            public bool haveSocial = false; // 是否建立关系
            public bool changeGoodness = true; // 是否更改性格
            public bool removeBad = true; // 是否解除仇恨
            public bool autoSave = false; // 是否自动救人
            public bool blockMsg = false; //是否屏蔽地区入魔信息
            public int xuLife = 10; // 续命量
            public int gouLife = 3; // 苟命量
            public float rate = 1.0f; // 除魔率
            public int[] placeIds = new int[] { -1, -1, -1 };//记录移动
            public bool[] gang = new bool[] { false, true, true };
            public bool[] goodness = new bool[] { true, true, true, true, true };
            public string[] gangValue = new string[] { "同道", "太吾村民", "其它" };
            public string[] goodnessValue = new string[] { "刚正", "仁善", "中庸", "叛逆", "唯我" };

        }


        public static bool enabled;

        public static Settings settings;

        public static UnityModManager.ModEntry.ModLogger Logger;





        public static bool Load(UnityModManager.ModEntry modEntry)

        {

            Logger = modEntry.Logger;

            settings = Settings.Load<Settings>(modEntry);

            var harmony = HarmonyInstance.Create(modEntry.Info.Id);

            harmony.PatchAll(Assembly.GetExecutingAssembly());

            modEntry.OnToggle = OnToggle;

            modEntry.OnGUI = OnGUI;

            modEntry.OnSaveGUI = OnSaveGUI;

            return true;

        }



        public static bool OnToggle(UnityModManager.ModEntry modEntry, bool value)

        {

            enabled = value;

            return true;

        }



        static void OnGUI(UnityModManager.ModEntry modEntry)

        {

            if (DateFile.instance !=null && DateFile.instance.actorsDate != null && DateFile.instance.actorsDate.ContainsKey(DateFile.instance.mianActorId))
            {
                GUILayout.BeginHorizontal("box");
                GUILayout.Label("效率（0-1）：", GUILayout.Width(100));
                float.TryParse(GUILayout.TextField(settings.rate.ToString(), GUILayout.Width(45)), out settings.rate);
                GUILayout.EndHorizontal();
                GUILayout.BeginHorizontal("box");
                if (GUILayout.Button("斩妖", GUILayout.Width(100)))
                {
                    killThemXX(getFilterList(getXXList(), settings.gang ,settings.goodness), DateFile.instance.mianActorId, Mathf.Clamp(settings.rate,0.0f,1.0f));
                }
                if (GUILayout.Button("除魔", GUILayout.Width(100)))
                {
                    saveThemXX(getFilterList(getXXList(), settings.gang,
                    settings.goodness),
                    DateFile.instance.mianActorId,
                    Mathf.Clamp(settings.rate, 0.0f, 1.0f),
                    settings.beFriend,
                    settings.beGang,
                    settings.haveSocial,
                    settings.gou,
                    settings.gouLife,
                    settings.xuLife,
                    settings.changeGoodness,
                    settings.removeBad
                    );
                   
                }
                if (GUILayout.Button("教化", GUILayout.Width(100)))
                {
                    blessThem(getFilterList(getXXList(true), settings.gang,settings.goodness ), Mathf.Clamp(settings.rate, 0.0f, 1.0f));
                }
                if (GUILayout.Button("聚拢", GUILayout.Width(100)))
                {
                    collectThem(getFilterList(getXXList(), settings.gang, settings.goodness), Mathf.Clamp(settings.rate, 0.0f, 1.0f));
                }
                GUILayout.EndHorizontal();
                GUILayout.Label("筛选人物");
                GUILayout.BeginVertical("box");
                GUILayout.Label("类型：");
                GUILayout.BeginHorizontal("box");
                for (int i = 0; i < settings.gang.Length; i++)
                {
                    settings.gang[i] = GUILayout.Toggle(settings.gang[i], settings.gangValue[i], GUILayout.Width(80));
                }
                GUILayout.EndHorizontal();
                GUILayout.Label("性格：");
                GUILayout.BeginHorizontal("box");
                for (int i = 0; i < settings.goodness.Length; i++)
                {
                    settings.goodness[i] = GUILayout.Toggle(settings.goodness[i], settings.goodnessValue[i], GUILayout.Width(45));
                }
                GUILayout.EndHorizontal();
                GUILayout.EndVertical();
                GUILayout.Label("除魔设定：");
                GUILayout.BeginVertical("box");
                settings.haveSocial = GUILayout.Toggle(settings.haveSocial, "正常模式（获得好感，关系）");
                GUILayout.BeginHorizontal("box");
                settings.beGang = GUILayout.Toggle(settings.beGang, "成为太吾村民", GUILayout.Width(100));
                settings.beFriend = GUILayout.Toggle(settings.beFriend, "成为同道", GUILayout.Width(100));
                if (GUILayout.Button("移出同道", GUILayout.Width(85)))
                {
                    releaseThem();
                }
                GUILayout.EndHorizontal();
                GUILayout.BeginHorizontal("box");
                settings.gou = GUILayout.Toggle(settings.gou, "续命，", GUILayout.Width(60));
                GUILayout.Label("当人物健康低于", GUILayout.Width(150));
                int.TryParse(GUILayout.TextField(settings.gouLife.ToString(), GUILayout.Width(30)), out settings.gouLife);
                GUILayout.Label("时，为其续命", GUILayout.Width(150));
                int.TryParse(GUILayout.TextField(settings.xuLife.ToString(), GUILayout.Width(30)), out settings.xuLife);
                GUILayout.Label("年");
                GUILayout.EndHorizontal();
                GUILayout.BeginHorizontal("box");
                settings.changeGoodness = GUILayout.Toggle(settings.changeGoodness, "重置性格（中庸）", GUILayout.Width(150));
                settings.removeBad = GUILayout.Toggle(settings.removeBad, "化解恩怨（双向）", GUILayout.Width(150));
                GUILayout.EndHorizontal();
                GUILayout.EndVertical();
                GUILayout.Label("扩展功能：");
                GUILayout.BeginHorizontal("box");
                settings.autoSave = GUILayout.Toggle(settings.autoSave, "自动除魔",GUILayout.Width(150));
                settings.blockMsg = GUILayout.Toggle(settings.blockMsg, "屏蔽地区入魔信息（测试版）", GUILayout.Width(200));
                GUILayout.EndHorizontal();
            }
            else
            {
                GUILayout.Label("存档尚未载入！");
            }


        }

        public static bool isGangNPC(int id)
        {
           int gangA = int.Parse(DateFile.instance.GetActorDate(id, 19, false));
           int gangB =  Mathf.Abs(int.Parse(DateFile.instance.GetActorDate(id, 20, false)));
            return gangA == 16 && gangB == 9;

        }
        public static bool isMainId(int id)
        {
            
            return ((DateFile.instance.mianActorId == id)||(int.Parse(DateFile.instance.GetActorDate(id,8,false))!=1));

        }
        public static bool isFamily(int id)
        {
            
           return DateFile.instance.GetFamily(true, true).Contains(id);
        }
        public static bool isXX(int id) {
            return DateFile.instance.actorsDate[id].ContainsKey(6) && DateFile.instance.actorsDate[id][6] == "1";
        }
       

        public static List<int> getXXList(bool withALL = false)
        {
            List<int> xxList = new List<int>();

            foreach (KeyValuePair<int, Dictionary<int, string>> i in DateFile.instance.actorsDate)
            {
                int npcId = i.Key;
                int npcHealth = ActorMenu.instance.Health(npcId);
                
                if (!isMainId(npcId) && (isXX(npcId) || withALL) && npcHealth>0)
                {
                    xxList.Add(npcId);
                }
            }
            if (withALL) {
                xxList.Add(DateFile.instance.mianActorId);
            }
            
            return xxList;
        }

        public static List<int> getFilterList(List<int> xxList, bool[] gang, bool[] goodness)
        {
            List<int> filterList = new List<int>();
            for (var i = 0;  i < xxList.Count; i++)
            {
                    int npcId = xxList[i];
                
                    if ((isFamily(npcId) && gang[0]) || (isGangNPC(npcId) && !isFamily(npcId) && gang[1]) || (!isGangNPC(npcId) && !isFamily(npcId) && gang[2])) // 筛选人物类型
                    {
                        int npcGoodness = int.Parse(DateFile.instance.GetActorDate(npcId, 16, false));
                    if ((npcGoodness >= 0 && npcGoodness < 125 && goodness[0])|| (npcGoodness >= 125 && npcGoodness < 375 && goodness[1])||
                        (npcGoodness >= 375 && npcGoodness < 625 && goodness[2])|| (npcGoodness >= 625 && npcGoodness < 875 && goodness[3])||
                        (npcGoodness >= 875 && goodness[4])) {
                            filterList.Add(xxList[i]);
                        }
                    }
            }
            return filterList;
        }

        public static void removeXXBuff(int npcId, int mainId, bool beFriend = false, bool beGang = false, bool changeGoodness = false, bool haveSocial = false)
        {
            DateFile.instance.SetActorXXChange(npcId, 1, true, false); // 去除入魔buff
            DateFile.instance.SetActorMood(npcId, 500); // 心情
            if (DateFile.instance.actorsDate[npcId].ContainsKey(18)) {  // 重置名声 
                DateFile.instance.actorsDate[npcId][18] = "15";
            }
            else
            {
                DateFile.instance.actorsDate[npcId].Add(18, "15");
            }
            if (beFriend && !DateFile.instance.GetFamily(true, true).Contains(npcId))
            {
                DateFile.instance.AddActorToFamily(npcId, false); // 加入队伍
            }
            if (beGang && !isGangNPC(npcId))
            {
                DateFile.instance.AddGangDate(16, 9, npcId, true); // 加入太吾村
            }
            if (changeGoodness)
            {
                if (DateFile.instance.actorsDate[npcId].ContainsKey(16)) // 改变性格
                {
                    DateFile.instance.actorsDate[npcId][16] = "380"; 
                }
                else {
                    DateFile.instance.actorsDate[npcId].Add(16, "380");
                }
            }
            if (haveSocial)
            {
                int score = 10 - Mathf.Abs(int.Parse(DateFile.instance.GetActorDate(npcId, 20, false)));
                DateFile.instance.AddSocial(mainId, npcId, 307);

                DateFile.instance.ChangeFavor(npcId, 15000, true, false);
                if (int.Parse(DateFile.instance.actorsDate[npcId][3])<40000) {
                    DateFile.instance.actorsDate[npcId][3] = "40000";
                }
                
                DateFile.instance.AddActorScore(103, 90 + score * score * 10);
                PeopleLifeAI.instance.AISetMassage(114, npcId, DateFile.instance.mianPartId, DateFile.instance.mianPlaceId, new int[]
                {
                     mainId
                }, -1, true);
                // 建立关系
            }
        }
        public static void removeBadGuys(int npcId)
        {
            List<int> badSocialA = DateFile.instance.GetActorSocial(npcId, 401, false); // 小仇
            List<int> badSocialB = DateFile.instance.GetActorSocial(npcId, 402, false); // 大恨
            for (int i = 0; i < badSocialA.Count; i++)
            {
                int badGuy = badSocialA[i];
                if (DateFile.instance.GetActorSocial(badGuy, 401, false).Contains(npcId))
                {
                    DateFile.instance.RemoveActorSocial(badGuy, npcId, 401);
                }
                DateFile.instance.RemoveActorSocial(npcId, badGuy, 401);
            }
            for (int i = 0; i < badSocialB.Count; i++)
            {
                int badGuy = badSocialB[i];
                if (DateFile.instance.GetActorSocial(badGuy, 402, false).Contains(npcId))
                {
                    DateFile.instance.RemoveActorSocial(badGuy, npcId, 402);
                }
                DateFile.instance.RemoveActorSocial(npcId, badGuy, 402);
            }
        }

        public static void gouMyLife(int npcId, int xuLife)
        {
            DateFile.instance.actorsDate[npcId][13] = (int.Parse(DateFile.instance.actorsDate[npcId][13]) + xuLife).ToString(); // 加生命上限
            DateFile.instance.actorsDate[npcId][12] = DateFile.instance.actorsDate[npcId][13]; // 回复健康
        }

        public static void saveThemXX(List<int> xxList, int mainId, float rate = 0.5f, bool beFriend = false, bool beGang = false, bool haveSocial = false, bool gou = false, int gouLife = 2, int xuLife = 0,
            bool changeGoodness = true, bool removeBad = false)
        {
            int npcNum = (int)(xxList.Count * rate);
            for (var i = 0; i < npcNum; i++)
            {
                int npcId = xxList[i];
                removeXXBuff(npcId, mainId, beFriend, beGang, changeGoodness, haveSocial);
                if (gou && DateFile.instance.actorsDate[npcId].ContainsKey(12) && DateFile.instance.actorsDate[npcId].ContainsKey(13) && 
                    ((int.Parse(DateFile.instance.actorsDate[npcId][12])<gouLife) || ((int.Parse(DateFile.instance.actorsDate[npcId][13]) % 100) < gouLife)))
                {
                    gouMyLife(xxList[i], xuLife);
                }
                if (removeBad)
                {
                    removeBadGuys(npcId);
                }
            }
            UIDate.instance.UpdateManpower();
        }

        public static void killThemXX(List<int> xxList, int mainId, float rate)
        {
            int npcNum = (int)(xxList.Count * rate);
            for (var i = 0; i < npcNum; i++)
            {
                int npcId = xxList[i];
                removeXXBuff(npcId, mainId);
                if (DateFile.instance.actorsDate[npcId].ContainsKey(12))
                {
                    DateFile.instance.actorsDate[npcId][12] = "1";
                }
                else {
                    DateFile.instance.actorsDate[npcId].Add(12, "1");
                }
            }
        }

        public static void releaseThem() {
            List<int> familyList = DateFile.instance.GetFamily(false, false);
            for (int i = 0;i<familyList.Count;i++) {
                int npcId = familyList[i];
                if (!isGangNPC(npcId)&&!isMainId(npcId)) {
                    DateFile.instance.actorFamilyDate.Remove(npcId); // 释放NPC
                    //DateFile.instance.actorsDate[npcId].Remove(27);
                    DateFile.instance.MoveToPlace(DateFile.instance.mianPartId, DateFile.instance.mianPlaceId, npcId, false);
                }
            }
            UIDate.instance.UpdateManpower();
        }

        public static void blessThem(List<int> xxList, float rate)
        {
            int npcNum = (int)(xxList.Count * rate);
            for (var i = 0; i < npcNum; i++)
            {
                DateFile.instance.SetActorXXChange(xxList[i], -25, false, false); // 石牢
            }
        }

        public static List<int> getXXListFromPlace(int mainPartId,int mainPlaceId) {
            List<int> xxListFromPlace = DateFile.instance.HaveActor(mainPartId, mainPlaceId, false, false, true, false);
            List<int> xxList = new List<int>();
            for (int i = 0;i<xxListFromPlace.Count;i++) {
                int npcId = xxListFromPlace[i];
                if (!isMainId(npcId)) // 去掉副本NPC
                {
                    xxList.Add(npcId);
                }
            }
            return xxList;
        }

        public static void collectThem(List<int> xxList,float rate) {
            int npcNum = (int)(xxList.Count * rate);
            for (var i = 0; i < npcNum; i++)
            {
                DateFile.instance.MoveToPlace(DateFile.instance.mianPartId, DateFile.instance.mianPlaceId, xxList[i], false); // 移动NPC到当前位置
            }
           
        }

        public static bool isMoved(int partId, int placeId, int worldId)
        {

            return ((settings.placeIds[0] != placeId) && ((settings.placeIds[0] = placeId) > -1)) ||
                ((settings.placeIds[1] != partId) && ((settings.placeIds[1] = partId) > -1))||
                ((settings.placeIds[2] != worldId) && ((settings.placeIds[2] = worldId) > -1));

        }

        [HarmonyPatch(typeof(WorldMapSystem), "ShowChoosePlaceMenu")]
        static class WorldMapSystem_ShowChoosePlaceMenu_Pached
        {
            private static void Postfix() {
                int partId = DateFile.instance.mianPartId;
                int placeId = DateFile.instance.mianPlaceId;
                int worldId = DateFile.instance.mianWorldId;
                if (settings.autoSave&&isMoved(placeId,partId,worldId)) {
                    saveThemXX(getFilterList(getXXListFromPlace(partId, placeId), settings.gang,
                    settings.goodness),
                    DateFile.instance.mianActorId,
                    Mathf.Clamp(settings.rate, 0.0f, 1.0f),
                    settings.beFriend,
                    settings.beGang,
                    settings.haveSocial,
                    settings.gou,
                    settings.gouLife,
                    settings.xuLife,
                    settings.changeGoodness,
                    settings.removeBad
                    );
                }
            } 

        }

        [HarmonyPatch(typeof(PeopleLifeAI), "DoTrunAIChange")]
        static class PeopleLifeAI_TrunChange_Pached
        {
            private static void Postfix()
            {
                if (settings.blockMsg) {
                    List<int[]> _newEventsList = new List<int[]>();
                    int eventsNum = PeopleLifeAI.instance.aiTrunEvents.Count;
                    for (int i = 0; i < eventsNum; i++)
                    {
                        if (!(PeopleLifeAI.instance.aiTrunEvents[i].Contains<int>(248) && PeopleLifeAI.instance.aiTrunEvents[i][0] == 248))
                        {
                            _newEventsList.Add(PeopleLifeAI.instance.aiTrunEvents[i]);
                        }
                    }
                    PeopleLifeAI.instance.aiTrunEvents = _newEventsList;
                }
            }

        }

        static void OnSaveGUI(UnityModManager.ModEntry modEntry)

        {

            settings.Save(modEntry);

        }

    }

}
