-- MySQL dump 10.13  Distrib 5.6.24, for Win64 (x86_64)
--
-- Host: localhost    Database: smartbox
-- ------------------------------------------------------
-- Server version	5.6.24

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `crd_area`
--

DROP TABLE IF EXISTS `crd_area`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `crd_area` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `no` varchar(255) NOT NULL DEFAULT '' COMMENT '区域编号',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT '区域名称',
  `type` int(255) NOT NULL DEFAULT '0' COMMENT '区域类型',
  `parentid` bigint(20) NOT NULL DEFAULT '0' COMMENT '父区域ID',
  `remark` varchar(255) NOT NULL DEFAULT '' COMMENT '备注',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COMMENT='区域表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `crd_area`
--

LOCK TABLES `crd_area` WRITE;
/*!40000 ALTER TABLE `crd_area` DISABLE KEYS */;
/*!40000 ALTER TABLE `crd_area` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `crd_areaparkingplacestatistics`
--

DROP TABLE IF EXISTS `crd_areaparkingplacestatistics`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `crd_areaparkingplacestatistics` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `areano` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '区域编号',
  `areaname` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '区域名称',
  `totalparkingplace` int(255) NOT NULL DEFAULT '0' COMMENT '总车位数',
  `remainparkingplace` int(255) NOT NULL DEFAULT '0' COMMENT '剩余车位数',
  `isschedule` int(255) NOT NULL DEFAULT '0' COMMENT '是否为全局区域 ',
  `updatetime` datetime NOT NULL DEFAULT '1970-01-01 00:00:00' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='车位区域表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `crd_areaparkingplacestatistics`
--

LOCK TABLES `crd_areaparkingplacestatistics` WRITE;
/*!40000 ALTER TABLE `crd_areaparkingplacestatistics` DISABLE KEYS */;
INSERT INTO `crd_areaparkingplacestatistics` VALUES (1,'10000','整体区域',0,0,1,'2017-08-07 21:39:59');
/*!40000 ALTER TABLE `crd_areaparkingplacestatistics` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `crd_areaplace_device_relationship`
--

DROP TABLE IF EXISTS `crd_areaplace_device_relationship`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `crd_areaplace_device_relationship` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `areano` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '区域编号',
  `deviceid` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '设备ID',
  PRIMARY KEY (`id`),
  KEY `index_areano` (`areano`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `crd_areaplace_device_relationship`
--

LOCK TABLES `crd_areaplace_device_relationship` WRITE;
/*!40000 ALTER TABLE `crd_areaplace_device_relationship` DISABLE KEYS */;
/*!40000 ALTER TABLE `crd_areaplace_device_relationship` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `crd_credential`
--

DROP TABLE IF EXISTS `crd_credential`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `crd_credential` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `no` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '凭证编号',
  `type` int(255) NOT NULL DEFAULT '5' COMMENT '凭证类型',
  `personid` bigint(20) NOT NULL DEFAULT '0' COMMENT '车主ID',
  `state` int(255) NOT NULL DEFAULT '0' COMMENT '状态',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='凭证表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `crd_credential`
--

LOCK TABLES `crd_credential` WRITE;
/*!40000 ALTER TABLE `crd_credential` DISABLE KEYS */;
/*!40000 ALTER TABLE `crd_credential` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `crd_device`
--

DROP TABLE IF EXISTS `crd_device`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `crd_device` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `deviceid` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '设备ID',
  `parentdeviceid` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '父设备ID',
  `devicetype` int(11) NOT NULL DEFAULT '0' COMMENT '设备类型',
  `devicename` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '设备名称',
  `mac` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT 'mac地址',
  `ipaddr` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT 'ip地址',
  `gateway` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '网关',
  `hasinit` int(11) NOT NULL DEFAULT '0' COMMENT '是否已初始化',
  `mask` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '''255.225.255.0''' COMMENT '子网掩码',
  `entrytype` int(11) NOT NULL DEFAULT '1' COMMENT '入出口类型',
  `isdebugmode` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否为调试模式',
  `macno` bigint(20) NOT NULL DEFAULT '0' COMMENT '机号',
  `sn` bigint(20) NOT NULL DEFAULT '0' COMMENT '设备序号，如50107',
  `company` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '公司名称，如“捷顺”',
  `model` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '产品型号，如JSTC1601',
  `hardwareversion` varchar(10) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '硬件版本，如a.b.cd',
  `softwareversion` varchar(10) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '软件版本，如a.b.cd',
  `nameplatedna` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '铭牌dna信息',
  `manufacturer` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '生产厂家，如“捷顺科技”',
  `productdate` datetime NOT NULL DEFAULT '1970-01-01 00:00:00' COMMENT '生产日期，如2016-04-13 14:36:39',
  `deviceclass` bigint(20) NOT NULL DEFAULT '0' COMMENT '0 – 普通设备，无需PSAM主卡、PSAM认证卡(无需签名认证）;1–需签名认证的核心设备，需PSAM主卡和PSAM认证卡;2–发行器JSPJ1614B，仅需要PSAM主卡和CPU认证卡;3–授权机',
  `registerid` int(11) NOT NULL DEFAULT '0' COMMENT '注册ID',
  `cpuid` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '设备CPUID',
  `activatestate` int(11) NOT NULL DEFAULT '0' COMMENT '设备激活状态，默认为未激活',
  `signfile` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '签名文件名称',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='设备表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `crd_device`
--

LOCK TABLES `crd_device` WRITE;
/*!40000 ALTER TABLE `crd_device` DISABLE KEYS */;
/*!40000 ALTER TABLE `crd_device` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `crd_device_area_relationship`
--

DROP TABLE IF EXISTS `crd_device_area_relationship`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `crd_device_area_relationship` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `areaid` bigint(20) NOT NULL DEFAULT '0' COMMENT '区域ID',
  `deviceid` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '设备ID',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='区域设备关系表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `crd_device_area_relationship`
--

LOCK TABLES `crd_device_area_relationship` WRITE;
/*!40000 ALTER TABLE `crd_device_area_relationship` DISABLE KEYS */;
/*!40000 ALTER TABLE `crd_device_area_relationship` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `crd_deviceparam`
--

DROP TABLE IF EXISTS `crd_deviceparam`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `crd_deviceparam` (
  `id` bigint(255) NOT NULL AUTO_INCREMENT,
  `deviceid` varchar(255) COLLATE utf8_unicode_ci NOT NULL COMMENT '设备ID',
  `paramname` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '参数名称',
  `paramvalue` text COLLATE utf8_unicode_ci NOT NULL COMMENT '参数值',
  `syncflag` int(255) NOT NULL DEFAULT '0' COMMENT '是否已同步标志',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `crd_deviceparam`
--

LOCK TABLES `crd_deviceparam` WRITE;
/*!40000 ALTER TABLE `crd_deviceparam` DISABLE KEYS */;
/*!40000 ALTER TABLE `crd_deviceparam` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `crd_infopublish`
--

DROP TABLE IF EXISTS `crd_infopublish`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `crd_infopublish` (
  `id` bigint(255) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `infoId` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '信息ID',
  `deviceId` bigint(20) NOT NULL DEFAULT '0' COMMENT '设备ID',
  `infoType` int(11) NOT NULL DEFAULT '0' COMMENT '发布信息类型(可扩充)：0：文件1：通知信息',
  `infoContent` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '文本内容（当发布类型为文本时须提供）',
  `filePath` text COLLATE utf8_unicode_ci NOT NULL COMMENT '	文件url路径（当发布类型为文件时须提供）多个文件时以”；”分割',
  `to` int(11) NOT NULL DEFAULT '0' COMMENT '要发布到的终端设备类型0:由终端自己选择（不指定时自选择）1:LCD2:LED大屏3:LED小屏',
  `startDate` datetime NOT NULL DEFAULT '1970-01-01 00:00:00' COMMENT '有效期开始',
  `endDate` datetime NOT NULL DEFAULT '1970-01-01 00:00:00' COMMENT '	有效期结束',
  `infoMode` int(11) NOT NULL DEFAULT '0' COMMENT '	播放(显示)模式(此字段可扩展，目前只支持两种播放模式)0：循环播放1：时间段播放',
  `loopStartTime` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '每日循环播放开始时间，格式化为HH:mm',
  `loopCount` int(11) NOT NULL DEFAULT '0' COMMENT '循环播放次数（循环播放模式下此字段必须）0：无限次数其他：播放指定的次数',
  `periods` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '每日有效播放时段（时间段播放模式下此字段必须）',
  `weeks` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '启用的星期',
  `operateType` int(11) NOT NULL DEFAULT '0' COMMENT '状态',
  `opttime` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '插表时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `crd_infopublish`
--

LOCK TABLES `crd_infopublish` WRITE;
/*!40000 ALTER TABLE `crd_infopublish` DISABLE KEYS */;
/*!40000 ALTER TABLE `crd_infopublish` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `crd_infopublishfile`
--

DROP TABLE IF EXISTS `crd_infopublishfile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `crd_infopublishfile` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `filename` varchar(255) NOT NULL DEFAULT '' COMMENT '待删除文件名',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `crd_infopublishfile`
--

LOCK TABLES `crd_infopublishfile` WRITE;
/*!40000 ALTER TABLE `crd_infopublishfile` DISABLE KEYS */;
/*!40000 ALTER TABLE `crd_infopublishfile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `crd_organization`
--

DROP TABLE IF EXISTS `crd_organization`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `crd_organization` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `no` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '组织编号',
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '组织名称',
  `parentid` bigint(20) NOT NULL DEFAULT '0' COMMENT '组织父ID',
  `type` int(255) NOT NULL COMMENT '组织类型',
  `status` int(255) NOT NULL DEFAULT '0' COMMENT '组织状态',
  `remark` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '备注',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `crd_organization`
--

LOCK TABLES `crd_organization` WRITE;
/*!40000 ALTER TABLE `crd_organization` DISABLE KEYS */;
/*!40000 ALTER TABLE `crd_organization` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `crd_organization_area_relationship`
--

DROP TABLE IF EXISTS `crd_organization_area_relationship`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `crd_organization_area_relationship` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `organizationid` bigint(20) NOT NULL DEFAULT '0' COMMENT '组织ID',
  `areaid` bigint(20) NOT NULL DEFAULT '0' COMMENT '区域ID',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='组织区域关系表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `crd_organization_area_relationship`
--

LOCK TABLES `crd_organization_area_relationship` WRITE;
/*!40000 ALTER TABLE `crd_organization_area_relationship` DISABLE KEYS */;
/*!40000 ALTER TABLE `crd_organization_area_relationship` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `crd_outenterdevice`
--

DROP TABLE IF EXISTS `crd_outenterdevice`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `crd_outenterdevice` (
  `outenterid` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `deviceid` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`deviceid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `crd_outenterdevice`
--

LOCK TABLES `crd_outenterdevice` WRITE;
/*!40000 ALTER TABLE `crd_outenterdevice` DISABLE KEYS */;
/*!40000 ALTER TABLE `crd_outenterdevice` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `crd_person`
--

DROP TABLE IF EXISTS `crd_person`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `crd_person` (
  `ID` bigint(255) NOT NULL AUTO_INCREMENT,
  `No` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '用户编号',
  `Name` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '用户姓名',
  `Sex` int(11) NOT NULL DEFAULT '0' COMMENT '性别 0 女  1 男',
  `IdentityType` int(20) NOT NULL DEFAULT '0' COMMENT '证件类型',
  `IdentityNo` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '证件编号',
  `CellPhoneNo` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '手机号码',
  `TelHome` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '家庭电话',
  `Email` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '电子邮件',
  `RoomNo` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '房号',
  `Address` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '地址',
  `Photo` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '人像路径',
  `Remark` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '备注',
  `Pwd` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '用户密码',
  `OptDate` datetime NOT NULL DEFAULT '1970-01-01 00:00:00' COMMENT '操作时间',
  `ServiceKey` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '服务密码',
  `CurKey` int(11) NOT NULL DEFAULT '0' COMMENT '上次密钥',
  `LastKey` int(11) NOT NULL DEFAULT '0' COMMENT '本次密钥',
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `crd_person`
--

LOCK TABLES `crd_person` WRITE;
/*!40000 ALTER TABLE `crd_person` DISABLE KEYS */;
INSERT INTO `crd_person` VALUES (1,'1','临时车主',0,0,'111111111111111111','88888888888','666666666666','789852753951@outlook.com','0','深圳','','','','2017-06-20 16:55:58','',0,0);
/*!40000 ALTER TABLE `crd_person` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `crd_person_device_relationship`
--

DROP TABLE IF EXISTS `crd_person_device_relationship`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `crd_person_device_relationship` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `personid` int(255) NOT NULL DEFAULT '0' COMMENT '人员ID',
  `deviceid` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '设备ID',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='人员设备关系表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `crd_person_device_relationship`
--

LOCK TABLES `crd_person_device_relationship` WRITE;
/*!40000 ALTER TABLE `crd_person_device_relationship` DISABLE KEYS */;
/*!40000 ALTER TABLE `crd_person_device_relationship` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `crd_person_organization_relationship`
--

DROP TABLE IF EXISTS `crd_person_organization_relationship`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `crd_person_organization_relationship` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `organizationid` bigint(20) NOT NULL DEFAULT '0' COMMENT '组织ID',
  `personid` bigint(20) NOT NULL DEFAULT '0' COMMENT '人员ID',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `crd_person_organization_relationship`
--

LOCK TABLES `crd_person_organization_relationship` WRITE;
/*!40000 ALTER TABLE `crd_person_organization_relationship` DISABLE KEYS */;
/*!40000 ALTER TABLE `crd_person_organization_relationship` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `crd_projectinfo`
--

DROP TABLE IF EXISTS `crd_projectinfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `crd_projectinfo` (
  `no` varchar(200) NOT NULL DEFAULT '' COMMENT '项目编码',
  `name` varchar(200) NOT NULL DEFAULT '' COMMENT '项目名称',
  `companyname` varchar(200) NOT NULL DEFAULT '' COMMENT '企业名称',
  `contractno` varchar(200) NOT NULL DEFAULT '' COMMENT '合同号',
  `district` varchar(200) NOT NULL DEFAULT '' COMMENT '所在地',
  `address` varchar(200) NOT NULL DEFAULT '' COMMENT '地址',
  `phone` varchar(200) NOT NULL DEFAULT '' COMMENT '联系电话',
  `contact` varchar(200) NOT NULL DEFAULT '' COMMENT '联系人',
  `logo` varchar(200) NOT NULL DEFAULT '' COMMENT '项目LOGO 路径',
  PRIMARY KEY (`no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `crd_projectinfo`
--

LOCK TABLES `crd_projectinfo` WRITE;
/*!40000 ALTER TABLE `crd_projectinfo` DISABLE KEYS */;
/*!40000 ALTER TABLE `crd_projectinfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `crd_specialvehicle`
--

DROP TABLE IF EXISTS `crd_specialvehicle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `crd_specialvehicle` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `parkid` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `ownername` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '特权车主' COMMENT '车主姓名',
  `plate` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '车牌号码',
  `starttime` datetime NOT NULL DEFAULT '1970-01-01 00:00:00' COMMENT '开始时间',
  `endtime` datetime NOT NULL DEFAULT '1970-01-01 00:00:00' COMMENT '截止时间',
  `type` int(255) NOT NULL DEFAULT '0' COMMENT '黑、白、灰名单',
  `reason` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '原因',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `crd_specialvehicle`
--

LOCK TABLES `crd_specialvehicle` WRITE;
/*!40000 ALTER TABLE `crd_specialvehicle` DISABLE KEYS */;
/*!40000 ALTER TABLE `crd_specialvehicle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `crd_vehicle`
--

DROP TABLE IF EXISTS `crd_vehicle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `crd_vehicle` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `no` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '车牌号',
  `personid` bigint(20) NOT NULL DEFAULT '0' COMMENT '车主ID',
  `brand` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '车辆品牌',
  `color` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '车辆颜色',
  `picture` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '车辆照片',
  `status` int(255) NOT NULL DEFAULT '0' COMMENT '车辆状态',
  `optdate` datetime NOT NULL DEFAULT '1970-01-01 00:00:00' COMMENT '操作时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='车辆信息表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `crd_vehicle`
--

LOCK TABLES `crd_vehicle` WRITE;
/*!40000 ALTER TABLE `crd_vehicle` DISABLE KEYS */;
/*!40000 ALTER TABLE `crd_vehicle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `crd_virtualslot`
--

DROP TABLE IF EXISTS `crd_virtualslot`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `crd_virtualslot` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `mealid` int(255) NOT NULL DEFAULT '0' COMMENT '套餐ID',
  `startdate` datetime NOT NULL DEFAULT '1970-01-01 00:00:00' COMMENT '开始时间',
  `enddate` datetime NOT NULL DEFAULT '1970-01-01 00:00:00' COMMENT '截止时间',
  `personid` bigint(20) NOT NULL DEFAULT '0' COMMENT '车主ID',
  `vehiclecount` int(11) NOT NULL DEFAULT '1' COMMENT '车位数',
  `stopusing` int(11) NOT NULL DEFAULT '0' COMMENT '删除标记  如果是1则为删除',
  `stopdate` datetime NOT NULL DEFAULT '1970-01-01 00:00:00' COMMENT '停止时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='虚拟车位表（车场服务）';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `crd_virtualslot`
--

LOCK TABLES `crd_virtualslot` WRITE;
/*!40000 ALTER TABLE `crd_virtualslot` DISABLE KEYS */;
/*!40000 ALTER TABLE `crd_virtualslot` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `finance_bill`
--

DROP TABLE IF EXISTS `finance_bill`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `finance_bill` (
  `id` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `enterid` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '入场记录ID',
  `intime` datetime NOT NULL DEFAULT '1970-01-01 00:00:00' COMMENT '入场时间',
  `chargedeviceid` bigint(20) NOT NULL DEFAULT '0' COMMENT '收费设备ID',
  `chargedevicename` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '中央收费盒子' COMMENT '收费设备名称',
  `feestime` datetime NOT NULL DEFAULT '1970-01-01 00:00:00' COMMENT '费用产生时间',
  `createtime` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '订单创建时间',
  `ordertype` int(255) NOT NULL DEFAULT '0' COMMENT '订单类型 0 普通账单  1 云支付账单',
  `status` int(255) NOT NULL DEFAULT '0' COMMENT '订单状态 0 已准备好 1 已支付  2 已取消',
  `paytime` datetime NOT NULL DEFAULT '1970-01-01 00:00:00' COMMENT '支付时间',
  `setmealid` int(255) NOT NULL DEFAULT '0' COMMENT '套餐ID',
  `setmealname` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '套餐名称',
  `fees` float(20,2) NOT NULL DEFAULT '0.00' COMMENT '计费金额',
  `benefit` float(20,2) NOT NULL DEFAULT '0.00' COMMENT '优惠金额',
  `derate` float(20,2) NOT NULL DEFAULT '0.00' COMMENT '滚动减免金额',
  `accountreceivable` float(20,2) NOT NULL DEFAULT '0.00' COMMENT '应收金额',
  `paid` float(20,2) NOT NULL DEFAULT '0.00' COMMENT '已支付金额',
  `actualpaid` float(20,2) NOT NULL DEFAULT '0.00' COMMENT '实付金额',
  `exchanged` float(20,2) NOT NULL DEFAULT '0.00' COMMENT '找零金额',
  `paytypename` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '付款方式',
  `chargetype` int(11) NOT NULL DEFAULT '0' COMMENT '收费类型',
  `remark` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '备注',
  `operatorid` bigint(20) NOT NULL DEFAULT '0' COMMENT '收费员ID',
  `operatorname` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '收费员姓名',
  `operatorno` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '收费员编号',
  `workstationip` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '收费工作站电脑IP',
  `replacededuct` int(11) NOT NULL DEFAULT '0' COMMENT '代扣标识（0：无代扣，1：支付宝代扣）',
  `appuserid` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT 'APP用户ID，支付宝代扣时必须提供',
  `credentialno` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '凭证编号',
  `credentialtype` int(11) NOT NULL DEFAULT '0' COMMENT '凭证类型',
  `voucherpicpath` varchar(255) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '优惠券等抓拍的图片路径',
  PRIMARY KEY (`id`),
  UNIQUE KEY `index_billid` (`id`) USING BTREE,
  KEY `index_feestime` (`feestime`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `finance_bill`
--

LOCK TABLES `finance_bill` WRITE;
/*!40000 ALTER TABLE `finance_bill` DISABLE KEYS */;
/*!40000 ALTER TABLE `finance_bill` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `finance_chargingstandard_details`
--

DROP TABLE IF EXISTS `finance_chargingstandard_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `finance_chargingstandard_details` (
  `sealid` int(20) NOT NULL COMMENT '套餐ID',
  `vehicletype` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '车辆类型',
  `slottype` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '车位类型',
  `param` text COLLATE utf8_unicode_ci NOT NULL COMMENT '套餐收费标准参数',
  `absolveminute` int(255) NOT NULL DEFAULT '0' COMMENT '超时滞留时间 ',
  PRIMARY KEY (`sealid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='收费标准从表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `finance_chargingstandard_details`
--

LOCK TABLES `finance_chargingstandard_details` WRITE;
/*!40000 ALTER TABLE `finance_chargingstandard_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `finance_chargingstandard_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `finance_chargingstandard_master`
--

DROP TABLE IF EXISTS `finance_chargingstandard_master`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `finance_chargingstandard_master` (
  `feeno` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '收费标准编号',
  `feename` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '收费标准名称',
  `parktype` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '停车场类型',
  `areatype` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '分区类型，如  一类区域、二类区域',
  `configfilepath` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '配置文件url',
  `script` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '脚本 目前暂不使用',
  PRIMARY KEY (`feeno`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='收费标准主表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `finance_chargingstandard_master`
--

LOCK TABLES `finance_chargingstandard_master` WRITE;
/*!40000 ALTER TABLE `finance_chargingstandard_master` DISABLE KEYS */;
/*!40000 ALTER TABLE `finance_chargingstandard_master` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `finance_chargingstandard_monthdelay`
--

DROP TABLE IF EXISTS `finance_chargingstandard_monthdelay`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `finance_chargingstandard_monthdelay` (
  `monthenddate` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `onemonthfee` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `onedayfee` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `extentmonthfee` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='月租车延期收费标准表 盒子端暂不使用';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `finance_chargingstandard_monthdelay`
--

LOCK TABLES `finance_chargingstandard_monthdelay` WRITE;
/*!40000 ALTER TABLE `finance_chargingstandard_monthdelay` DISABLE KEYS */;
/*!40000 ALTER TABLE `finance_chargingstandard_monthdelay` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `finance_coupon`
--

DROP TABLE IF EXISTS `finance_coupon`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `finance_coupon` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `no` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '优惠券编号',
  `createtime` datetime NOT NULL DEFAULT '1970-01-01 00:00:00' COMMENT '创建时间',
  `discounttype` int(255) NOT NULL DEFAULT '0' COMMENT '折扣类型 0 减免金额 1 减免小时 2 减免百分比',
  `discountvalue` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '优惠值',
  `state` int(255) NOT NULL DEFAULT '0' COMMENT '优惠券状态 0 未使用 1 已使用 2 已作废',
  `startdate` datetime NOT NULL DEFAULT '1970-01-01 00:00:00' COMMENT '有效开始时间',
  `enddate` datetime NOT NULL DEFAULT '1970-01-01 00:00:00' COMMENT '有效截止时间',
  `lockflag` int(255) NOT NULL DEFAULT '0' COMMENT '是否已锁定  1已锁定  0未锁定',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `finance_coupon`
--

LOCK TABLES `finance_coupon` WRITE;
/*!40000 ALTER TABLE `finance_coupon` DISABLE KEYS */;
/*!40000 ALTER TABLE `finance_coupon` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `finance_discount`
--

DROP TABLE IF EXISTS `finance_discount`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `finance_discount` (
  `discountno` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '折扣编号',
  `enterid` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0' COMMENT '入场记录ID',
  `credentialno` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '凭证编号',
  `discounttype` int(255) NOT NULL DEFAULT '0' COMMENT '优惠类型 0免金额 1免小时 2免百分比',
  `discountvalue` int(8) NOT NULL DEFAULT '0' COMMENT '优惠值',
  `storeno` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '商户编号',
  `storename` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '商户名称',
  `createtime` datetime NOT NULL DEFAULT '1970-01-01 00:00:00' COMMENT '创建时间',
  `state` int(255) NOT NULL DEFAULT '0' COMMENT '状态',
  `usedtime` datetime NOT NULL DEFAULT '1970-01-01 00:00:00' COMMENT '使用时间',
  `parkid` int(11) NOT NULL DEFAULT '0',
  `way` int(11) NOT NULL DEFAULT '0' COMMENT '打折方式 0云打折 1优惠券打折',
  PRIMARY KEY (`discountno`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `finance_discount`
--

LOCK TABLES `finance_discount` WRITE;
/*!40000 ALTER TABLE `finance_discount` DISABLE KEYS */;
/*!40000 ALTER TABLE `finance_discount` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `finance_discountpolicy`
--

DROP TABLE IF EXISTS `finance_discountpolicy`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `finance_discountpolicy` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8 NOT NULL DEFAULT '' COMMENT '策略名称',
  `discounttype` int(20) NOT NULL DEFAULT '0' COMMENT '优惠类型',
  `discountvalue` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '优惠值',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `finance_discountpolicy`
--

LOCK TABLES `finance_discountpolicy` WRITE;
/*!40000 ALTER TABLE `finance_discountpolicy` DISABLE KEYS */;
/*!40000 ALTER TABLE `finance_discountpolicy` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `finance_paytype`
--

DROP TABLE IF EXISTS `finance_paytype`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `finance_paytype` (
  `id` bigint(20) NOT NULL,
  `paytypename` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '支付方式名称',
  `description` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '描述',
  `witholdflag` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否启用',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `finance_paytype`
--

LOCK TABLES `finance_paytype` WRITE;
/*!40000 ALTER TABLE `finance_paytype` DISABLE KEYS */;
INSERT INTO `finance_paytype` VALUES (1,'支付宝','支付宝',1),(2,'微信','微信',0),(3,'银联','银联',0),(4,'捷顺通支付','捷顺通支付',0),(5,'捷顺通卡支付','捷顺通卡支付',0),(6,'中行','中行',0),(7,'招行','招行',0),(8,'工行','工行',0),(9,'建行','建行',0),(10,'民生银行','民生银行',0),(11,'银联卡','银联卡',0),(12,'捷物管现金','捷物管现金',0),(13,'现金','现金',0),(14,'深圳通','深圳通',0),(15,'苏州通','苏州通',0),(16,'京翼通','京翼通',0),(17,'南京市民卡','南京市民卡',0),(18,'羊城通','羊城通',0),(19,'中山通','中山通',0),(20,'东莞通','东莞通',0),(21,'其它','其它',0),(22,'捷顺金科','捷顺金科',0),(23,'翼支付','翼支付',0),(24,'易付宝','易付宝',0),(25,'智车宝','智车宝',0),(26,'线下银联卡POS付款','线下银联卡POS付款',0),(27,'云代扣','云代扣',1),(28,'优惠减免','优惠减免',0);
/*!40000 ALTER TABLE `finance_paytype` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `finance_usediscount`
--

DROP TABLE IF EXISTS `finance_usediscount`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `finance_usediscount` (
  `id` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `billid` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0' COMMENT '账单Id',
  `discountno` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '优惠编号',
  `discountway` int(11) NOT NULL DEFAULT '0' COMMENT '优惠种类 0 App打折 1线上卡券 2线下优惠券',
  `discounttype` int(11) NOT NULL DEFAULT '0' COMMENT '优惠类型 0 优惠金额 1减免小时 2 减免百分比',
  `discountvalue` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '优惠值',
  `operatorno` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '操作员编号',
  `usetime` datetime NOT NULL DEFAULT '1970-01-01 00:00:00' COMMENT '使用时间',
  `operatorname` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '操作员姓名',
  `remark` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '备注',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `finance_usediscount`
--

LOCK TABLES `finance_usediscount` WRITE;
/*!40000 ALTER TABLE `finance_usediscount` DISABLE KEYS */;
INSERT INTO `finance_usediscount` VALUES ('E53610B200000002','1','65781947a4c14cfc8ca9636e0e593f02',0,0,5.00,'9998','2017-06-28 11:26:09','a','保存打折记录');
/*!40000 ALTER TABLE `finance_usediscount` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `opt_duty`
--

DROP TABLE IF EXISTS `opt_duty`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `opt_duty` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `dutyname` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '班次名称',
  `starttime` datetime NOT NULL DEFAULT '1970-01-01 00:00:00' COMMENT '班次开始时间',
  `endtime` datetime NOT NULL DEFAULT '1970-01-01 00:00:00' COMMENT '班次截止时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `opt_duty`
--

LOCK TABLES `opt_duty` WRITE;
/*!40000 ALTER TABLE `opt_duty` DISABLE KEYS */;
/*!40000 ALTER TABLE `opt_duty` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `opt_dutyshift`
--

DROP TABLE IF EXISTS `opt_dutyshift`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `opt_dutyshift` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `operatorid` int(255) NOT NULL DEFAULT '0' COMMENT '操作员Id',
  `operatorname` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '操作员名称',
  `offdutytime` datetime NOT NULL DEFAULT '1970-01-01 00:00:00' COMMENT '下班时间',
  `ondutytime` datetime NOT NULL DEFAULT '1970-01-01 00:00:00' COMMENT '上班时间',
  `ondutyoperatorid` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0' COMMENT '当班操作员Id',
  `ondutyoperatorname` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '上班操作员姓名',
  `charging` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '应收金额',
  `discount` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '优惠金额 ',
  `accountreceivable` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '应收金额',
  `change` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '找零金额',
  `imprestreceived` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '备用金接收数量',
  `imprestgived` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '备用金交接数量',
  `remark` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '备注',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `opt_dutyshift`
--

LOCK TABLES `opt_dutyshift` WRITE;
/*!40000 ALTER TABLE `opt_dutyshift` DISABLE KEYS */;
/*!40000 ALTER TABLE `opt_dutyshift` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `opt_modules`
--

DROP TABLE IF EXISTS `opt_modules`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `opt_modules` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `moduleNo` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '模块编号',
  `modulename` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '模块名称',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `opt_modules`
--

LOCK TABLES `opt_modules` WRITE;
/*!40000 ALTER TABLE `opt_modules` DISABLE KEYS */;
INSERT INTO `opt_modules` VALUES (1,'100','取消开闸'),(2,'101','查看报表'),(3,'102','恢复出厂设置'),(4,'103','查看收费金额'),(5,'104','版本升级'),(6,'105','免费放行'),(7,'106','调试模式'),(8,'107','允许登录'),(9,'108','设置向导');
/*!40000 ALTER TABLE `opt_modules` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `opt_onduty`
--

DROP TABLE IF EXISTS `opt_onduty`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `opt_onduty` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `operatorid` bigint(20) NOT NULL DEFAULT '0' COMMENT '操作员ID',
  `ondutytime` datetime NOT NULL DEFAULT '1970-01-01 00:00:00' COMMENT '上班时间',
  `total` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '总收费金额',
  `workstationip` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '工作站IP',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `opt_onduty`
--

LOCK TABLES `opt_onduty` WRITE;
/*!40000 ALTER TABLE `opt_onduty` DISABLE KEYS */;
/*!40000 ALTER TABLE `opt_onduty` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `opt_operator`
--

DROP TABLE IF EXISTS `opt_operator`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `opt_operator` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `no` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '操作员编号',
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '操作员姓名',
  `password` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '操作员密码',
  `logged` int(255) NOT NULL DEFAULT '0' COMMENT '是否已登录',
  `logintime` datetime NOT NULL DEFAULT '1970-01-01 00:00:00' COMMENT '登录时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `opt_operator`
--

LOCK TABLES `opt_operator` WRITE;
/*!40000 ALTER TABLE `opt_operator` DISABLE KEYS */;
INSERT INTO `opt_operator` VALUES (1,'9999','超级管理员','B69591589C7C9BF4',0,'1970-01-01 00:00:00');
/*!40000 ALTER TABLE `opt_operator` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `opt_operator_role_relationship`
--

DROP TABLE IF EXISTS `opt_operator_role_relationship`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `opt_operator_role_relationship` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `operatorid` bigint(20) NOT NULL DEFAULT '0' COMMENT '操作员ID',
  `roleid` bigint(20) NOT NULL DEFAULT '0' COMMENT '角色ID',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `opt_operator_role_relationship`
--

LOCK TABLES `opt_operator_role_relationship` WRITE;
/*!40000 ALTER TABLE `opt_operator_role_relationship` DISABLE KEYS */;
INSERT INTO `opt_operator_role_relationship` VALUES (1,1,999999);
/*!40000 ALTER TABLE `opt_operator_role_relationship` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `opt_role`
--

DROP TABLE IF EXISTS `opt_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `opt_role` (
  `id` bigint(20) NOT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '角色名称',
  `remark` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '备注',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `opt_role`
--

LOCK TABLES `opt_role` WRITE;
/*!40000 ALTER TABLE `opt_role` DISABLE KEYS */;
INSERT INTO `opt_role` VALUES (1,'管理员',''),(2,'调试员',''),(3,'财务1',''),(4,'财务2',''),(5,'运维人员',''),(6,'保安队长',''),(7,'收费保安',''),(999999,'超级管理员','盒子内置所有权限');
/*!40000 ALTER TABLE `opt_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `opt_role_modules_relationship`
--

DROP TABLE IF EXISTS `opt_role_modules_relationship`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `opt_role_modules_relationship` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `modulesid` bigint(20) NOT NULL DEFAULT '0' COMMENT '模块ID',
  `roleid` bigint(20) NOT NULL DEFAULT '0' COMMENT '角色ID',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=72 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `opt_role_modules_relationship`
--

LOCK TABLES `opt_role_modules_relationship` WRITE;
/*!40000 ALTER TABLE `opt_role_modules_relationship` DISABLE KEYS */;
INSERT INTO `opt_role_modules_relationship` VALUES (1,100,1),(2,101,1),(3,103,1),(4,105,1),(5,106,1),(6,107,1),(7,108,1),(8,100,7),(9,101,7),(10,103,7),(11,105,7),(12,107,7),(13,108,7),(14,100,5),(15,101,5),(16,102,5),(17,103,5),(18,104,5),(19,105,5),(20,107,5),(21,108,5),(22,100,999999),(23,101,999999),(24,102,999999),(25,103,999999),(26,104,999999),(27,105,999999),(28,106,999999),(29,107,999999),(30,108,999999);
/*!40000 ALTER TABLE `opt_role_modules_relationship` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `opt_view_operator`
--

DROP TABLE IF EXISTS `opt_view_operator`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `opt_view_operator` (
  `id` bigint(20) DEFAULT NULL,
  `no` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `logged` int(255) DEFAULT NULL,
  `logintime` datetime DEFAULT NULL,
  `Total` decimal(8,2) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `opt_view_operator`
--

LOCK TABLES `opt_view_operator` WRITE;
/*!40000 ALTER TABLE `opt_view_operator` DISABLE KEYS */;
/*!40000 ALTER TABLE `opt_view_operator` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `park_dasextendcard`
--

DROP TABLE IF EXISTS `park_dasextendcard`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `park_dasextendcard` (
  `sealid` int(255) NOT NULL DEFAULT '0' COMMENT '套餐ID',
  `title` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '尊称',
  `sealnameplay` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '套餐名称',
  `needhello` int(11) NOT NULL DEFAULT '1' COMMENT '是否报尊称',
  `needcarnum` int(11) NOT NULL DEFAULT '1' COMMENT '是否报车牌',
  `area` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '区域',
  PRIMARY KEY (`sealid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `park_dasextendcard`
--

LOCK TABLES `park_dasextendcard` WRITE;
/*!40000 ALTER TABLE `park_dasextendcard` DISABLE KEYS */;
INSERT INTO `park_dasextendcard` VALUES (54,'尊敬的','临时用户A',0,0,'深圳');
/*!40000 ALTER TABLE `park_dasextendcard` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `park_dasextendholiday`
--

DROP TABLE IF EXISTS `park_dasextendholiday`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `park_dasextendholiday` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `hello` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '节假日日祝语',
  `starttime` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '节假日起始时间',
  `endtime` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '节假日结束时间',
  `holidayname` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '节假日名称',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `park_dasextendholiday`
--

LOCK TABLES `park_dasextendholiday` WRITE;
/*!40000 ALTER TABLE `park_dasextendholiday` DISABLE KEYS */;
INSERT INTO `park_dasextendholiday` VALUES (1,'元旦节快乐','01-01','01-01','元旦');
/*!40000 ALTER TABLE `park_dasextendholiday` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `park_displayandsounddata`
--

DROP TABLE IF EXISTS `park_displayandsounddata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `park_displayandsounddata` (
  `changingid` int(10) NOT NULL,
  `defaultsound` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '默认语音',
  `sound` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '语音播报的内容',
  `led1displaydata` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT 'LED1信息显示屏显示的内容',
  `led2displaydata` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT 'LED2信息显示屏显示的内容',
  `customlcddata` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `scenedesc` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '情景描述',
  `lcdlogofile` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT 'lcd屏logo url',
  `lcdbackgroundfile` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT 'lcd背景图url',
  `createtime` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`changingid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `park_displayandsounddata`
--

LOCK TABLES `park_displayandsounddata` WRITE;
/*!40000 ALTER TABLE `park_displayandsounddata` DISABLE KEYS */;
INSERT INTO `park_displayandsounddata` VALUES (3,'车牌校正中，请稍等。。 ','车牌校正中，请稍等。。 ','{14}(br)车牌校正中(br)请稍等','车牌校正中(br)请稍等','车牌校正中，请稍等。。 ','当刷卡成功后，车牌识别错误或没有识别到','','','2017-11-01 09:11:21'),(4,'请重新刷凭证','请重新刷凭证','{14}(br){15}(br)请重新刷凭证','{15}(br)请重新刷卡','请重新刷卡','当车牌识别验证成功后，卡验证失败 （下位机找不到银联卡入场记录的时候）','','','2017-11-01 09:11:21'),(5,'临时车辆请取卡,固定车辆请刷卡,访客请扫描二维码','临时车辆请取卡,固定车辆请刷卡,访客请扫描二维码','','','临时车辆请取卡,固定车辆请刷卡,访客请扫描二维码','大车场入口，小车场入口，系统配置成压地感读卡，地感提示','','','2017-11-01 09:11:21'),(7,'{a}{b}{c}{d}欢迎光临','{a}{b}{c}{d}欢迎光临','{14}(br){15}(br)欢迎光临','{15}(br)欢迎光临','{a}{b}{c}{d}欢迎光临','大车场入口和小车场入口刷卡，临时卡和储值卡','','','2017-11-01 09:11:21'),(8,'{a}{b}{c}{d}，您已预约，欢迎光临','{a}{b}{c}{d}，您已预约，欢迎光临','{14}(br){15}(br)欢迎光临','{15}(br)欢迎光临','{a}{b}{c}{d}，您已预约，欢迎光临','大车场入口和小车场入口刷二维码，访客','','','2017-11-01 09:11:21'),(9,'请刷卡','请刷卡','{14}(br){15}(br)请刷卡','{15}(br)请刷卡','请刷卡','请刷卡','','','2017-11-01 09:11:21'),(14,'临时车辆请交卡交费,固定车辆请刷卡,访客请扫描二维码','临时车辆请交卡交费,固定车辆请刷卡,访客请扫描二维码','','','临时车辆请交卡交费,固定车辆请刷卡,访客请扫描二维码','大车场出口，小车场出口，中央收费机出口，系统配置成压地感读卡，地感提示','','','2017-11-01 09:11:21'),(16,'一路顺风','一路顺风','{14}(br){15}(br)停车时长{11}(br)一路顺风','{15}(br)一路顺风','一路顺风',' 临时卡出场','','','2017-11-01 09:11:21'),(20,'一路顺风','一路顺风','{14}(br){15}(br)停车时长{11}(br)一路顺风','{15}(br)一路顺风','一路顺风','1 储值卡刷卡，小车场出口 ；2临时卡，小车场出口；3 临时卡且收费为0，大车场出口，中央收费机，中央收费机出口','','','2017-11-01 09:11:21'),(24,'{a}{b}{c}{d}欢迎回家，凭证可用日期{0}天，请尽快延期','{a}{b}{c}{d}欢迎回家，凭证可用日期{0}天，请尽快延期','{14}(br){15}(br)欢迎回家(br)凭证可用{0}天','{15}(br)凭证可用{0}天','{a}{b}{c}{d}欢迎回家，凭证可用日期{0}天，请尽快延期','在月卡可用日期少于X天时，月卡入场','','','2017-11-01 09:11:21'),(25,'{a}{b}{c}{d}欢迎回家，凭证已过期{0}天，请尽快延期','{a}{b}{c}{d}欢迎回家，凭证已过期{0}天，请尽快延期','{14}(br){15}(br)欢迎回家(br)凭证已过期{0}天','{15}(br)凭证已过期{0}天','{a}{b}{c}{d}欢迎回家，凭证已过期{0}天，请尽快延期','在月卡已经超期时（但允许进入），月卡入场','','','2017-11-01 09:11:21'),(27,'一路平安，凭证可用日期{0}天，请尽快延期','一路平安，凭证可用日期{0}天，请尽快延期','{14}(br){15}(br)一路平安(br)凭证可用日期{0}天','{15}(br)凭证可用日期{0}天','一路平安，凭证可用日期{0}天，请尽快延期','在月卡可用日期少于X天时，月卡出场','','','2017-11-01 09:11:21'),(28,'一路平安，凭证已过期{0}天，请尽快延期','一路平安，凭证已过期{0}天，请尽快延期','{14}(br){15}(br)一路平安(br)凭证已过期{0}天','{15}(br)凭证已过期{0}天','一路平安，凭证已过期{0}天，请尽快延期','在月卡已经超期时（但允许进入），月卡出场','','','2017-11-01 09:11:21'),(29,'凭证已过期，请与管理处联系','凭证已过期，请与管理处联系','{14}(br)凭证已过期(br)请与管理处联系','凭证已过期(br)请与管理处联系','凭证已过期，请与管理处联系','在月卡已经超过最大的超期阈值时（不允许进入），月卡出场 且系统配置月卡不转临时卡，2免费卡过期','','','2017-11-01 09:11:21'),(30,'{a}{b}{c}{d}欢迎光临,凭证余额{5}元,请尽快充值','{a}{b}{c}{d}欢迎光临,凭证余额{5}元,请尽快充值','{14}(br){15}(br)欢迎光临(br)凭证余额{5}元','{15}(br)凭证余额{5}元','{a}{b}{c}{d}欢迎光临,凭证余额{5}元,请尽快充值','储值卡（包括，银联临时卡，捷顺通）入场，余额少于一定阀值时','','','2017-11-01 09:11:21'),(33,'凭证余额不足,未交费请回收费处交费或充值后再出场','凭证余额不足,未交费请回收费处交费或充值后再出场','{14}(br){15}(br)未交费(br)凭证余额不足','{15}(br)凭证余额不足','凭证余额不足,未交费请回收费处交费或充值后再出场','刷卡后，卡内余额不足，在场内外标志不是已收费的情况','','','2017-11-01 09:11:21'),(35,'此用户已入场','此用户已入场','{14}(br)(br)此用户已入场','{14}(br)此用户已入场','此用户已入场','(系统配置月卡一位多车，可以入场)已经有车辆入场，再次入场 （不区分卡类的再次入场）','','','2017-11-01 09:11:21'),(40,'此用户已出场','此用户已出场','{14}(br)(br)此用户已出场','{14}(br)此用户已出场','此用户已出场','(系统配置月卡一位多车，可以入场)月卡再次出场(不区分卡类)','','','2017-11-01 09:11:21'),(45,'车位数少于{13}个,禁止该套餐车辆入场','车位数少于{13}个,禁止该套餐车辆入场','车场满位(br)(br)请等待车辆离场','{14}(br)车场满位','车位数少于{13}个,禁止此类车辆入场','满位时，车位数少于当前卡类的限制（不同卡类限制数量不一样）','','','2017-11-01 09:11:21'),(49,'请交费{4}元,停车时长{11}','请交费{4}元,停车时长{11}','{14}(br){15}(br)停车时长{11}(br)请交费{4}元','{15}(br)请交费{4}元','请交费{4}元,停车时长{11}','临时卡(非IC ID月卡转临时卡)刷卡出场提示','','','2017-11-01 09:11:21'),(51,'本次停车费{1}元，优惠{3}元，请交费{4}元,停车时长{11}','本次停车费{1}元，优惠{3}元，请交费{4}元,停车时长{11}','本次停车费{1}元(br)优惠{3}元(br)停车时长{11}(br)请交费{4}元','{15}(br)请交费{4}元','本次停车费{1}元，优惠{3}元，请交费{4}元,停车时长{11}','启用消费打折的情况下（优惠金额）','','','2017-11-01 09:11:21'),(54,'您未交费，请到收费处交费或使用手机App交费','您未交费，请到收费处交费或使用手机App交费','{14}(br){15}(br)未交费(br)请到收费处交费','{15}(br)请到收费处交费','您未交费，请到收费处交费','临时卡（包括月临卡），未交费提示 自动模式(无人值守)','','','2017-11-01 09:11:21'),(55,'您已超时，请回收费处补费或使用手机App交费','您已超时，请回收费处补费或使用手机App交费','{14}(br){15}(br)已超时(br)请回收费处补费','{15}(br)请回收费处补费','您已超时，请回收费处补费','临时卡（包括月临卡），已经交费提示 自动模式(无人值守)','','','2017-11-01 09:11:21'),(64,'城市通用户未到启用时间','城市通用户未到启用时间','{14}(br)(br)系统禁止通行','{14}(br)系统禁止通行','城市通用户未到启用时间','城市通用户未到启用时间,不能转临时卡,禁止入场(在刷卡模式下出现)','','','2017-11-01 09:11:21'),(65,'{a}{b}{c}{d}欢迎回家，凭证未到启用时间转为临时套餐','{a}{b}{c}{d}欢迎回家，凭证未到启用时间转为临时套餐','{14}(br){15}(br)欢迎回家(br)凭证未到启用时间转为临时套餐','{15}(br)凭证未到启用时间转为临时套餐','凭证未到启用时间转为临时套餐','凭证未到启用时间转为临时套餐','','','2017-11-01 09:11:21'),(68,'凭证无权限','凭证无权限','{14}(br)(br)凭证无权限','{14}(br)凭证无权限','凭证无权限','刷卡时密钥认证失败','','','2017-11-01 09:11:21'),(69,'凭证已注销','凭证已注销','{14}(br)(br)凭证已注销','{14}(br)凭证已注销','凭证已注销','(ID卡或IC卡ID模式)已注销卡片','','','2017-11-01 09:11:21'),(70,'凭证已挂失','凭证已挂失','{14}(br)(br)凭证已挂失','{14}(br)凭证已挂失','凭证已挂失','卡片已挂失','','','2017-11-01 09:11:21'),(78,'收费标准无效','收费标准无效','{14}(br)(br)收费标准无效','{14}(br)收费标准无效','收费标准无效','收费时，没有加载收费标准','','','2017-11-01 09:11:21'),(85,'{a}{b}{c}{d}欢迎光临，凭证余额{5}元','{a}{b}{c}{d}欢迎光临，凭证余额{5}元','{14}(br){15}(br)欢迎光临(br){5}','{15}(br)欢迎光临','{a}{b}{c}{d}欢迎光临，凭证余额{5}元','储值卡入场，未到余额报警','','','2017-11-01 09:11:21'),(86,'一路顺风，本次收费{4}元,余额{5}元,停车时长{11}','一路顺风，本次收费{4}元,余额{5}元,停车时长{11}','{14}(br)停车时长{11}(br)此次收费{4}元(br)余额{5}元','此次收费{4}元(br)余额{5}元','一路顺风，本次收费{4}元,余额{5}元,停车时长{11}','储值卡出场，未到余额报警','','','2017-11-01 09:11:21'),(87,'{a}{b}{c}{d}欢迎回家，凭证可用日期{0}天','{a}{b}{c}{d}欢迎回家，凭证可用日期{0}天','{14}(br){15}(br)欢迎回家(br)凭证可用{0}天','欢迎回家(br)凭证可用{0}天','{a}{b}{c}{d}欢迎回家，凭证可用日期{0}天','月卡入场，大车场入口，未到报警天数','','','2017-11-01 09:11:21'),(88,'一路平安，凭证可用日期{0}天','一路平安，凭证可用日期{0}天','{14}(br){15}(br)一路平安(br)凭证可用日期{0}天','一路平安(br)凭证可用日期{0}天','一路平安，凭证可用日期{0}天','月卡出场，大车场出口，中央收费机出口，未到报警天数','','','2017-11-01 09:11:21'),(89,'固定车辆，请到出口刷卡','固定车辆，请到出口刷卡','','','固定车辆,请到出口刷卡','月卡刷卡，位置在中央收费机','','','2017-11-01 09:11:21'),(90,'云支付成功','云支付成功','{14}(br)(br)云支付成功','(br)云支付成功','云支付成功','云支付成功后放行','','','2017-11-01 09:11:21'),(91,'凭证余额不足,已超时请回收费处补费或充值后再出场','凭证余额不足,已超时请回收费处补费或充值后再出场','{14}(br){15}(br){11}(br)已超时,请补费','{15}(br)已超时,请补费','凭证余额不足,已超时请回收费处补费或充值后再出场','中央收费点交费后，卡类标志已收费，超时余额不足','','','2017-11-01 09:11:21'),(92,'凭证余额不足,请交费{4}元,谢谢,停车时长{11}','凭证余额不足,请交费{4}元,谢谢,停车时长{11}','{14}(br){15}(br)停车时长{11}(br)请交费{4}元','{15}(br)请交费{4}元','凭证余额不足,请交费{4}元,谢谢,停车时长{11}','出口余额不足','','','2017-11-01 09:11:21'),(93,'捷顺科技欢迎您！','捷顺科技欢迎您！','','','','LCD显示的欢迎语。界面可以定制','','','2017-11-01 09:11:21'),(95,'请交费{4}元,停车时长{11},请在交费后{12}分钟内出场','请交费{4}元,停车时长{11},请在交费后{12}分钟内出场','{14}(br){15}(br)请交费{4}元','{15}(br)请交费{4}元','请交费{4}元,停车时长{11},请在交费后{12}分钟内出场','临时卡（非月临卡）出场时，在中央收费机，提示交费','','','2017-11-01 09:11:21'),(96,'凭证余额不足,请交费{1}元,停车时长{11},请在交费后{12}分钟内出场','凭证余额不足,请交费{1}元,停车时长{11},请在交费后{12}分钟内出场','{14}(br)停车时长{11}(br)请在{12}分钟内离场','停车时长{11}(br)请在{12}分钟内离场','凭证余额不足,请交费{1}元,停车时长{11},请在交费后{12}分钟内出场','储值卡出场时余额不足，在中央收费机，提示交费','','','2017-11-01 09:11:21'),(97,'套餐过期,请交费{4}元,停车时长{11},请在交费后{12}分钟内出场','套餐过期,请交费{4}元,停车时长{11},请在交费后{12}分钟内出场','{14}(br)停车时长{11}(br)请在{12}分钟内离场','停车时长{11}(br)请在{12}分钟内离场','套餐过期,请交费{4}元,停车时长{11},请在交费后{12}分钟内出场','月临卡，出场时，在中央收费机，提示交费','','','2017-12-08 13:02:22'),(98,'套餐过期,请交费{4}元','套餐过期,请交费{4}元','{14}(br){15}(br)停车时长{11}(br)请交费{4}元','{15}(br)请交费{4}元','{a}{b}{c}{d}套餐过期,请交费{4}元','月临卡，出场时，在大车场出口，中央收费机出口，提示交费','','','2017-12-08 13:10:35'),(99,'捷顺停车(br)为您服务','捷顺停车(br)为您服务','','','','LCD显示的欢迎语。界面可以定制，上位机处理发送的LCD内容与语音内容一致','','','2017-11-01 09:11:21'),(100,'请等待I-Cloud H 控制机启动完成','请等待I-Cloud H 控制机启动完成','','','','','','','2017-11-01 09:11:21'),(102,'一路顺风','一路顺风','{14}(br){15}(br)停车时长{11}(br)一路顺风','{15}(br)一路顺风','一路顺风','储值卡，现金支付后，开闸语音','','','2017-11-01 09:11:21'),(103,'凭证有效期{0}天','凭证有效期{0}天','{14}(br)(br)凭证有效期{0}天','{14}(br)凭证有效期{0}天','凭证有效期{0}天','中央收费定点刷月卡不算‘出入场记录’','','','2017-11-01 09:11:21'),(104,'一路顺风，剩余免费时间{10}分钟','一路顺风，剩余免费时间{10}分钟','{14}(br){15}(br)一路顺风(br)请在{10}分钟内离场','{15}(br)一路顺风','一路顺风，剩余免费时间{10}分钟','中央收费定点开闸','','','2017-11-01 09:11:21'),(106,'对不起！系统禁止通行','对不起！系统禁止通行','{14}(br)(br)系统禁止通行','{14}(br)系统禁止通行','对不起！系统禁止通行','黑名单禁止通行（入场，出场）','','','2017-11-01 09:11:21'),(108,'{a}贵宾车辆{d}，请通行','{a}贵宾车辆{d}，请通行','{14}(br){15}(br)请通行','{15}(br)请通行','{a}贵宾车辆{d}，请通行','白名单通行（入场）','','','2017-11-01 09:11:21'),(109,'{a}贵宾车辆{d}，一路平安','{a}贵宾车辆{d}，一路平安','{14}(br){15}(br)一路平安','{15}(br)一路平安','{a}贵宾车辆{d}，一路平安','白名单通行（出场）','','','2017-11-01 09:11:21'),(110,'{a}{b}{c}{d}您已过期,请场内延期','{a}{b}{c}{d}您已过期,请场内延期','{14}(br){15}(br)请场内延期','{15}(br)请场内延期','{a}{b}{c}{d}您已过期,请场内延期','当系统配置为月卡过期禁止出场时，月卡过期 入场','','','2017-11-01 09:11:21'),(111,'此卡已补卡','此卡已补卡','{14}(br)(br)此卡已补卡','{14}(br)此卡已补卡','此卡已补卡','此卡已补卡','','','2017-11-01 09:11:21'),(112,'您的车位已用完，请交费{4}元,停车时长{11}','您的车位已用完，请交费{4}元,停车时长{11}','{14}(br){15}(br)停车时长{11}(br)请交费{4}元','{15}(br)请交费{4}元','您的车位已用完，请交费{4}元,停车时长{11}','车位数受限卡，车位用完，出场收费','','','2017-11-01 09:11:21'),(113,'车场满位，车位数已到此用户限制','车场满位，车位数已到此用户限制','{14}(br){15}(br)车场满位(br)','{15}(br)车场满位(br)','车场满位，车位数已到此用户限制','车场满位，车位数已到此卡限制','','','2017-11-01 09:11:21'),(114,'{a}{b}{c}{d}欢迎回家，凭证过期转为临时套餐','{a}{b}{c}{d}欢迎回家，凭证过期转为临时套餐','{14}(br){15}(br)欢迎回家(br)凭证过期转为临时套餐','{15}(br)凭证过期转为临时套餐','{a}{b}{c}{d}欢迎回家，凭证过期转为临时套餐','月卡过期转临时卡','','','2017-11-01 09:11:21'),(117,'{a}{b}{c}{d}您的车位已用完，将转临时套餐','{a}{b}{c}{d}您的车位已用完，将转临时套餐','{14}(br){15}(br)您的车位已用完(br)将转临时套餐','您的车位已用完(br)将转临时套餐','{a}{b}{c}{d}您的车位已用完，将转临时套餐','车位数受限卡，车位用完','','','2017-11-01 09:11:21'),(118,'车位数受限用户，车位用完，禁止入场','车位数受限用户，车位用完，禁止入场','{14}(br){15}(br)您的车位已用完(br)','{15}(br)您的车位已用完','车位数受限用户，车位用完，禁止入场','车位数受限卡，车位用完，禁止入场','','','2017-11-01 09:11:21'),(120,'剩余免费时间{10}分钟，请尽快出场','剩余免费时间{10}分钟，请尽快出场','{14}(br){15}(br)请在{10}分钟内离场','{15}(br)请在{10}分钟内离场','剩余免费时间{10}分钟，请尽快出场','1、中央收费定点,应收为0，且为（‘储值卡或临时卡’）此类记录不算‘出入场记录’2、储值卡已被下位机截断，上位机不能播报，临时卡可以','','','2017-11-01 09:11:21'),(122,'一路顺风，本次交费{4}元，余额{5}元，请尽快充值','一路顺风，本次交费{4}元，余额{5}元，请尽快充值','{14}(br)停车时长{11}(br)此次收费{4}元(br)余额{5}元','此次收费{4}元(br)余额{5}元','一路顺风，本次交费{4}元，余额{5}元，请尽快充值','储值卡上扣款 出场 余额低于阀值预警','','','2017-11-01 09:11:21'),(125,'凭证已锁定，请先解锁','凭证已锁定，请先解锁','{14}(br)凭证已锁定(br)请先解锁','凭证已锁定(br)请先解锁','凭证已锁定，请先解锁','','','','2017-11-01 09:11:21'),(129,'您的车辆违规停放，请遵守停放规则','您的车辆违规停放，请遵守停放规则','','','您的车辆违规停放，请遵守停放规则','月卡出场，检测到【月卡车占用临时车位（超时未入小车场）】','','','2017-11-01 09:11:21'),(130,'您的车辆违规停放，请遵守停放规则，您的凭证已过期','您的车辆违规停放，请遵守停放规则，您的凭证已过期','','','您的车辆违规停放，请遵守停放规则，您的凭证已过期','月卡出场，检测到【月卡车占用临时车位（超时未入小车场）】','','','2017-11-01 09:11:21'),(131,'欢迎回家','欢迎回家','{14}(br){15}(br)欢迎回家','{15}(br)欢迎回家','欢迎回家','道闸常开','','','2017-11-01 09:11:21'),(132,'欢迎光临','欢迎光临','{14}(br){15}(br)欢迎光临','{15}(br)欢迎光临','欢迎光临','道闸常开','','','2017-11-01 09:11:21'),(133,'一路平安','一路平安','{14}(br){15}(br)一路平安','{15}(br)一路平安','一路平安','道闸常开','','','2017-11-01 09:11:21'),(134,'一路顺风','一路顺风','{14}(br){15}(br){11}(br)一路顺风','{15}(br)一路顺风','一路顺风','道闸常开','','','2017-11-01 09:11:21'),(135,'一路顺风，凭证余额{5}元','一路顺风，凭证余额{5}元','{14}(br)停车时长{11}(br)此次收费{4}元(br)余额{5}元','此次收费{4}元(br)余额{5}元','一路顺风，凭证余额{5}元','储值卡出小车场','','','2017-11-01 09:11:21'),(136,'贵宾车辆，欢迎光临','贵宾车辆，欢迎光临','{14}(br){15}(br)欢迎光临(br)贵宾车辆','{15}(br)欢迎光临','贵宾车辆，欢迎光临','贵宾车入场','','','2017-11-01 09:11:21'),(137,'凭证未到启用时间，禁止入场','凭证未到启用时间，禁止入场','{14}(br){15}(br)凭证未到启用时间','{15}(br)凭证未到启用时间','凭证未到启用时间，禁止入场','月租套餐未到起始时间入场','','','2017-11-01 09:11:21'),(138,'脱机超时出场，请交费{4}元','脱机超时出场，请交费{4}元','{14}(br){15}(br)超时出场请交费{4}元','{15}(br)超时出场请交费{4}元','脱机超时出场，请交费{4}元','中央交费后脱机超时出场','','','2017-11-01 09:11:21'),(139,'脱机正常出场，请交费{4}元','脱机正常出场，请交费{4}元','{14}(br){15}(br)脱机出场请交费{4}元','{15}(br)脱机出场请交费{4}元','脱机正常出场，请交费{4}元','脱机出场交费','','','2017-11-01 09:11:21'),(140,'{a}分享用户{c}{d}未到分享时间，将按临时套餐收费','{a}分享用户{c}{d}未到分享时间，将按临时套餐收费','{14}(br){15}(br)未到分享时间，将按临时套餐收费','{15}(br)未到分享时间，将按临时套餐收费','{a}{b}{c}{d}未到分享时间，将按临时套餐收费','分享用户提前入场','','','2017-11-01 09:11:21'),(141,'{a}分享用户{c}{d}欢迎光临','{a}分享用户{c}{d}欢迎光临','{14}(br){15}(br)欢迎光临','{15}(br)欢迎光临','{a}分享用户{c}{d}欢迎光临','分享用户正常入场','','','2017-11-01 09:11:21'),(142,'{a}分享用户{c}{d}一路平安','{a}分享用户{c}{d}一路平安','{14}(br){15}(br)一路平安','{15}(br)一路平安','{a}分享用户{c}{d}一路平安','分享用户正常大出场出场','','','2017-11-01 09:11:21'),(143,'{a}分享用户{c}{d}您的分享已超时，请交费{4}元','{a}分享用户{c}{d}您的分享已超时，请交费{4}元','{14}(br){15}(br)您的分享已超时,请交费{4}元','{15}(br)您的分享已超时,请交费{4}元','{a}分享用户{c}{d}您的分享已超时,请交费{4}元','分享用户大出场超时交费','','','2017-11-01 09:11:21'),(144,'{a}分享用户{c}{d}您的分享已超时，请到收费处交费','{a}分享用户{c}{d}您的分享已超时，请到收费处交费','{14}(br){15}(br)您的分享已超时,请交费{4}元','{15}(br)您的分享已超时,请交费{4}元','{a}分享用户{c}{d}您的分享已超时，请到收费处交费','分享用户中央收费出超时交费','','','2017-11-01 09:11:21'),(145,'分享时段内，无需交费','分享时段内，无需交费','{14}(br){15}(br)分享时段内，无需交费','{15}(br)分享时段内，无需交费','分享时段内，无需交费','分享用户中央收费定点分享时段内','','','2017-11-01 09:11:21'),(146,'尊敬的预定用户,欢迎光临,您已预定{20}车位,请尽快入场','尊敬的预定用户,欢迎光临,您已预定{20}车位,请尽快入场','{14}(br){15}(br)欢迎光临(br)预定{20}车位','欢迎光临(br)预定{20}车位','尊敬的预定用户,欢迎光临,您已预定{20}车位,请尽快入场','预定用户,如果有确定的预定车位。','','','2017-11-01 09:11:21'),(147,'尊敬的预定用户，欢迎光临','尊敬的预定用户，欢迎光临','{14}(br){15}(br)欢迎光临','{15}(br)欢迎光临','尊敬的预定用户，欢迎光临','预定用户正常入场','','','2017-11-01 09:11:21'),(148,'尊敬的预定用户，一路平安','尊敬的预定用户，一路平安','{14}(br){15}(br)一路平安','{15}(br)一路平安','尊敬的预定用户，一路平安','预定用户正常出场','','','2017-11-01 09:11:21'),(149,'开闸失败，请联系管理员','开闸失败，请联系管理员','{14}(br) 开闸失败(br)请联系管理员',' 开闸失败(br)请联系管理员','开闸失败，请联系管理员','开闸失败，语音提示','','','2017-11-01 09:11:21'),(150,'套餐有效时段外，禁止通行','套餐有效时段外，禁止通行','{14}(br){15}(br)套餐有效时段外(br)禁止通行','套餐有效时段外(br)禁止通行','','套餐非有效时段内入场','','','2017-11-16 09:15:23'),(151,'月租套餐在有效时段外，将按临时套餐收费','月租套餐在有效时段外，将按临时套餐收费','{14}(br){15}(br)套餐有效时段外(br)将按临时套餐收费','套餐有效时段外(br)将按临时套餐收费','','非有效时段，月租用户入场，判定对应的临时车此时可以入场 语音提示','','','2017-12-04 08:15:24'),(152,'月租套餐在有效时段外，请交费{4}元，停车时长{11}','月租套餐在有效时段外，请交费{4}元，停车时长{11}','{14}(br){11}(br)月租套餐有效时段外(br)请交费{4}元','月租套餐有效时段外(br)请交费{4}元','','非有效时段产生费用，月租用户出场，提示交费','','','2017-11-01 09:11:21'),(153,'脱机未找到场内记录，请与管理员联系','脱机未找到场内记录，请与管理员联系','{15}(br)请与管理员联系','{15}(br)请与管理员联系','','脱机出场未查询到入场记录，由管理员确认费用以人工放行','','','2017-12-04 01:58:00'),(154,'脱机未找到场内记录，允许免费通行','脱机未找到场内记录，允许免费通行','{15}(br)免费通行','{15}(br)免费通行','','脱机出场未查询到入场记录，由管理员免费放行 ','','','2017-12-04 01:58:04'),(155,'凭证下载信息状态错误','凭证下载信息状态错误','凭证下载信息状态错误','凭证下载信息状态错误','','凭证下载信息状态错误','','','2017-11-01 09:11:21'),(156,'控制器安全认证失败','控制器安全认证失败','控制器安全认证失败','控制器安全认证失败','','下位机进入车场应用前，PSAM卡认证失败/控制器安全认证失败','','','2017-11-01 09:11:21'),(157,'入场时间不合法','入场时间不合法','入场时间不合法','入场时间不合法','','脱机出场时的时间 早于 查询到的入场记录中的入场时间','','','2017-11-01 09:11:21'),(158,'车辆未在本通道授权','车辆未在本通道授权','车辆未在本通道授权','车辆未在本通道授权','','设置参数为未发行凭证通行，后来脱机情况下，未发行的凭证到来','','','2017-11-01 09:11:21'),(159,'车辆未解锁,请与管理员联系','车辆未解锁,请与管理员联系','车辆未解锁，请与管理员联系','车辆未解锁，请与管理员联系','','脱机出场场内车设置了锁定，出场时未解锁，与管理员联系','','','2017-11-01 09:11:21'),(160,'已脱机，分享用户请与管理员联系','已脱机，分享用户请与管理员联系','已脱机，分享用户请与管理员联系','已脱机，分享用户请与管理员联系','','分享车辆+收费+脱机,提示联系管理员','','','2017-11-01 09:11:21'),(161,'一路顺风，此用户余额{5}元','一路顺风，此用户余额{5}元','{14}(br){11}(br)一路顺风，费用{4}元(br)余额{5}元','一路顺风，费用{4}元(br)余额{5}元','一路顺风，此用户余额{5}元','储值车用户在小车场出口出场','','','2017-11-01 09:11:21'),(162,'贵宾车辆，请直接出场','贵宾车辆，请直接出场','','','','VIP用户在中央缴费点刷卡(在刷卡模式下出现)','','','2017-11-01 09:11:21'),(163,'访客车辆，欢迎光临','访客车辆，欢迎光临',' {14}(br){15}(br)欢迎光临','{15}(br)欢迎光临','','大车场入口和小车场入口刷二维码，访客','','','2017-12-14 05:46:56'),(164,'未找到场内记录，固定收费{4}元','未找到场内记录，固定收费{4}元','{14}(br){15}(br)请交费{4}元','{15}(br)请交费{4}元','未找到场内记录，固定收费{4}元','固定收费，不播报停车时长','','','2017-12-26 07:17:05'),(165,'未找到场内记录，请与管理员联系','未找到场内记录，请与管理员联系','{14}(br){15}(br)请与管理员联系','{15}(br)请与管理员联系','未找到场内记录，请与管理员联系','出口无人值守，未匹配场内记录，语音提示','','','2017-11-14 11:13:21'),(166,'请稍候','请稍候','请稍候','请稍候','请稍候','入口确认开闸或者月租车出口确认开闸，未点击确认开闸前播报语音','','','2018-01-11 07:56:03'),(560,'上午好','上午好','上午好','上午好','上午好','问候语','','','2017-11-01 09:11:21'),(561,'下午好','下午好','下午好','下午好','下午好','问候语','','','2017-11-01 09:11:21'),(562,'晚上好','晚上好','晚上好','晚上好','晚上好','问候语','','','2017-11-01 09:11:21'),(565,'中午好','中午好','中午好','中午好','中午好','问候语','','','2017-11-01 09:11:21');
/*!40000 ALTER TABLE `park_displayandsounddata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `park_enterrecord`
--

DROP TABLE IF EXISTS `park_enterrecord`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `park_enterrecord` (
  `id` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '记录ID',
  `boxid` bigint(255) NOT NULL DEFAULT '0' COMMENT '盒子ID',
  `credentialno` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '凭证编号',
  `credentialtype` int(11) NOT NULL DEFAULT '0' COMMENT '凭证类型',
  `plate` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '车牌',
  `originalplate` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `entertime` datetime NOT NULL DEFAULT '1970-01-01 00:00:00' COMMENT '入场时间',
  `enterdeviceid` bigint(255) NOT NULL DEFAULT '0' COMMENT '入场设备ID',
  `enterouttype` int(11) NOT NULL DEFAULT '1' COMMENT '入场设备类型',
  `eventtype` int(11) NOT NULL DEFAULT '1' COMMENT '事件类型',
  `enterdevicename` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '入场设备名称',
  `personid` bigint(20) NOT NULL DEFAULT '0' COMMENT '凭证持有者ID',
  `personno` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '凭证持有者编号',
  `personname` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '凭证持有者姓名',
  `mealid` int(11) NOT NULL DEFAULT '54' COMMENT '套餐ID，默认临时卡A',
  `setmealname` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '套餐名',
  `operatorid` bigint(255) NOT NULL DEFAULT '0' COMMENT '操作员ID',
  `operatorno` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '操作员编号',
  `operatorname` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '操作员姓名',
  `enterpicture` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '入场图片路径',
  `optdate` datetime NOT NULL DEFAULT '1970-01-01 00:00:00' COMMENT '操作时间',
  `remark` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '备注信息',
  `wasgone` int(11) NOT NULL DEFAULT '0' COMMENT '已出场标志',
  `uploadedtonewg3` int(11) NOT NULL DEFAULT '0' COMMENT '是否上传中心',
  `placeshareflag` int(11) NOT NULL DEFAULT '0' COMMENT '是否车位分享记录',
  `shareorderid` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '车位分享订单ID',
  `extendflag` int(11) NOT NULL DEFAULT '0' COMMENT '下位机上传的是否已开闸的标志',
  `offlineflag` int(11) NOT NULL DEFAULT '0' COMMENT '脱机标志',
  `userid` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '代扣平台下发用户编号',
  `issignatory` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '是否允许代扣',
  `PlateColor` int(11) NOT NULL DEFAULT '0' COMMENT '车牌颜色',
  `Logo` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '车标',
  `VehicleColor` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0' COMMENT '车颜色',
  `CredibleDegree` int(11) NOT NULL DEFAULT '0' COMMENT '车牌可信度',
  `isbookslot` int(11) NOT NULL DEFAULT '0' COMMENT '是否为车位预定用户 0表示否 1表示是',
  PRIMARY KEY (`id`),
  UNIQUE KEY `index_enterid` (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `park_enterrecord`
--

LOCK TABLES `park_enterrecord` WRITE;
/*!40000 ALTER TABLE `park_enterrecord` DISABLE KEYS */;
/*!40000 ALTER TABLE `park_enterrecord` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `park_eventregister`
--

DROP TABLE IF EXISTS `park_eventregister`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `park_eventregister` (
  `id` varchar(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT 'ID',
  `context` varchar(1024) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '信息上报的内容',
  `registertime` datetime NOT NULL DEFAULT '1970-01-01 00:00:00' COMMENT '信息上报的时间',
  `operatorid` bigint(255) NOT NULL DEFAULT '0' COMMENT '操作员ID',
  `eventtype` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '事件类型',
  `eventimagepath` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '信息上报抓拍的图片路径',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `park_eventregister`
--

LOCK TABLES `park_eventregister` WRITE;
/*!40000 ALTER TABLE `park_eventregister` DISABLE KEYS */;
/*!40000 ALTER TABLE `park_eventregister` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `park_exceptionenterrecord`
--

DROP TABLE IF EXISTS `park_exceptionenterrecord`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `park_exceptionenterrecord` (
  `id` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '记录ID',
  `boxid` bigint(255) NOT NULL DEFAULT '0' COMMENT '盒子ID',
  `credentialno` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '凭证编号',
  `credentialtype` int(11) NOT NULL DEFAULT '0' COMMENT '凭证类型',
  `plate` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '车牌',
  `originalplate` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `entertime` datetime NOT NULL DEFAULT '1970-01-01 00:00:00' COMMENT '入场时间',
  `enterdeviceid` bigint(255) NOT NULL DEFAULT '0' COMMENT '入场设备ID',
  `enterouttype` int(255) NOT NULL DEFAULT '1' COMMENT '入场设备类型',
  `eventtype` int(11) NOT NULL DEFAULT '1' COMMENT '事件类型',
  `enterdevicename` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '入场设备名称',
  `personid` bigint(20) NOT NULL DEFAULT '0' COMMENT '凭证持有者ID',
  `personno` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '凭证持有者编号',
  `personname` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '凭证持有者姓名',
  `mealid` int(11) NOT NULL DEFAULT '54' COMMENT '套餐ID，默认临时卡A',
  `setmealname` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '套餐名',
  `operatorid` bigint(255) NOT NULL DEFAULT '0' COMMENT '操作员ID',
  `operatorno` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '操作员编号',
  `operatorname` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '操作员姓名',
  `enterpicture` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '入场图片路径',
  `optdate` datetime NOT NULL DEFAULT '1970-01-01 00:00:00' COMMENT '操作时间',
  `remark` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '备注信息',
  `wasgone` int(11) NOT NULL DEFAULT '0' COMMENT '已出场标志',
  `uploadedtonewg3` int(11) NOT NULL DEFAULT '0' COMMENT '是否上传中心',
  `placeshareflag` int(255) NOT NULL DEFAULT '0' COMMENT '是否车位分享记录',
  `shareorderid` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '车位分享订单ID',
  `extendflag` int(255) NOT NULL DEFAULT '0' COMMENT '下位机上传的是否已开闸的标志',
  `offlineflag` int(11) NOT NULL DEFAULT '0' COMMENT '脱机标志',
  `userid` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '代扣平台下发用户编号',
  `issignatory` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '是否允许代扣',
  `PlateColor` int(11) NOT NULL DEFAULT '0' COMMENT '车牌颜色',
  `Logo` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '车标',
  `VehicleColor` int(11) NOT NULL DEFAULT '0' COMMENT '车颜色',
  `CredibleDegree` int(11) NOT NULL DEFAULT '0' COMMENT '车牌可信度',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `park_exceptionenterrecord`
--

LOCK TABLES `park_exceptionenterrecord` WRITE;
/*!40000 ALTER TABLE `park_exceptionenterrecord` DISABLE KEYS */;
/*!40000 ALTER TABLE `park_exceptionenterrecord` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `park_inportinfo`
--

DROP TABLE IF EXISTS `park_inportinfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `park_inportinfo` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `CredentialType` int(11) NOT NULL DEFAULT '0',
  `CredentialNo` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `DeviceId` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `EventTime` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `Status` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `park_inportinfo`
--

LOCK TABLES `park_inportinfo` WRITE;
/*!40000 ALTER TABLE `park_inportinfo` DISABLE KEYS */;
/*!40000 ALTER TABLE `park_inportinfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `park_manualoperationrecord`
--

DROP TABLE IF EXISTS `park_manualoperationrecord`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `park_manualoperationrecord` (
  `id` bigint(255) NOT NULL DEFAULT '0' COMMENT 'ID',
  `reason` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '人工放行的原因',
  `deviceid` bigint(255) NOT NULL DEFAULT '0' COMMENT '设备ID',
  `devicetype` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '设备类型',
  `devicename` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '设备名称',
  `macno` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT 'mac地址',
  `opentime` date NOT NULL DEFAULT '1970-01-01' COMMENT '放行时间',
  `picturepath` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '抓拍的图片路径',
  `operatorid` bigint(255) NOT NULL DEFAULT '0' COMMENT '操作员ID',
  `operatorname` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '操作员姓名',
  `plate` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '车牌号码',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `park_manualoperationrecord`
--

LOCK TABLES `park_manualoperationrecord` WRITE;
/*!40000 ALTER TABLE `park_manualoperationrecord` DISABLE KEYS */;
/*!40000 ALTER TABLE `park_manualoperationrecord` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `park_notmotorvehiclepassrecord`
--

DROP TABLE IF EXISTS `park_notmotorvehiclepassrecord`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `park_notmotorvehiclepassrecord` (
  `id` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `reason` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '放行原因',
  `operatorid` bigint(255) NOT NULL DEFAULT '0' COMMENT '操作员ID',
  `operatorno` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '操作员编号',
  `operatorname` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '操作员姓名',
  `deviceid` bigint(255) NOT NULL DEFAULT '0' COMMENT '设备ID',
  `devicename` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '设备ID',
  `passtime` datetime NOT NULL DEFAULT '1970-01-01 00:00:00' COMMENT '放行时间',
  `notmotorvehicletype` int(11) NOT NULL DEFAULT '0' COMMENT '非机动车类型',
  `picpath` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '图片路径',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `park_notmotorvehiclepassrecord`
--

LOCK TABLES `park_notmotorvehiclepassrecord` WRITE;
/*!40000 ALTER TABLE `park_notmotorvehiclepassrecord` DISABLE KEYS */;
INSERT INTO `park_notmotorvehiclepassrecord` VALUES ('006E0DBD2800000C','',1,'9999','admin',0,'H入口148','2017-06-26 10:15:02',5,'20170626/park/25250300/101501_BJ.jpg;'),('006E0DBD2800000D','',1,'9999','admin',0,'H出口149','2017-06-26 10:15:16',5,'20170626/park/20010900/101515_BJ.jpg;'),('006E0DBD2800000E','',1,'9999','admin',0,'H入口148','2017-06-26 10:15:36',5,'20170626/park/25250300/101535_BJ.jpg;'),('006E0DBD2800000F','',1,'9999','admin',0,'H出口149','2017-06-26 10:15:48',5,'20170626/park/20010900/101547_BJ.jpg;');
/*!40000 ALTER TABLE `park_notmotorvehiclepassrecord` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `park_outrecord`
--

DROP TABLE IF EXISTS `park_outrecord`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `park_outrecord` (
  `id` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '记录ID',
  `boxid` bigint(255) NOT NULL DEFAULT '0' COMMENT '盒子ID',
  `enterrecordid` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0' COMMENT '入场记录ID',
  `credentialno` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '凭证编号',
  `credentialtype` int(11) NOT NULL DEFAULT '0' COMMENT '凭证类型',
  `plate` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '车牌号码',
  `originalplate` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `operatorid` bigint(20) NOT NULL DEFAULT '0' COMMENT '操作员ID',
  `operatorno` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '操作员编号',
  `operatorname` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '操作员姓名',
  `outdeviceid` bigint(255) NOT NULL DEFAULT '0' COMMENT '出场设备ID',
  `enterouttype` int(11) NOT NULL DEFAULT '0' COMMENT '出场设备类型',
  `eventtype` int(11) NOT NULL DEFAULT '1' COMMENT '事件类型',
  `outdevicename` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '出场设备名称',
  `outtime` datetime NOT NULL DEFAULT '1970-01-01 00:00:00' COMMENT '出场时间',
  `outpicture` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '出场图片路径',
  `personid` bigint(255) NOT NULL DEFAULT '0' COMMENT '凭证持有者ID',
  `personno` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '凭证持有者编号',
  `personname` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '凭证持有者姓名',
  `mealid` int(11) NOT NULL DEFAULT '54' COMMENT '套餐ID，默认临时卡A',
  `setmealname` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '套餐名',
  `opttime` datetime NOT NULL DEFAULT '1970-01-01 00:00:00' COMMENT '操作时间',
  `remark` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '备注',
  `accountreceivable` float(20,2) NOT NULL DEFAULT '0.00' COMMENT '应收金额',
  `charging` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0' COMMENT '找零金额',
  `uploadedtonewg3` int(11) NOT NULL DEFAULT '0' COMMENT '是否上传中心',
  `extendflag` int(11) NOT NULL DEFAULT '0' COMMENT '下位机上传的是否已经开闸标志',
  `offlineflag` int(11) NOT NULL DEFAULT '0' COMMENT '是否脱机标志',
  `PlateColor` int(11) NOT NULL DEFAULT '0' COMMENT '车牌颜色',
  `Logo` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '车标',
  `VehicleColor` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0' COMMENT '车颜色',
  `CredibleDegree` int(11) NOT NULL DEFAULT '0' COMMENT '车牌可信度',
  `allDerate` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0' COMMENT '滚动减免金额总和',
  `allBenefit` float(20,2) NOT NULL DEFAULT '0.00' COMMENT '优惠金额总和',
  `allCharge` float(20,2) NOT NULL DEFAULT '0.00' COMMENT '总收费金额（Fees）',
  PRIMARY KEY (`id`),
  UNIQUE KEY `index_outid` (`id`) USING BTREE,
  KEY `index_enterid` (`enterrecordid`) USING BTREE,
  KEY `index_outtime` (`outtime`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `park_outrecord`
--

LOCK TABLES `park_outrecord` WRITE;
/*!40000 ALTER TABLE `park_outrecord` DISABLE KEYS */;
/*!40000 ALTER TABLE `park_outrecord` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `park_placeshare`
--

DROP TABLE IF EXISTS `park_placeshare`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `park_placeshare` (
  `id` bigint(255) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `shareorderid` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '车位分享的订单ID',
  `plate` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '车牌号码',
  `startdate` datetime NOT NULL DEFAULT '1970-01-01 00:00:00' COMMENT '车位分享的起始日期',
  `enddate` datetime NOT NULL DEFAULT '1970-01-01 00:00:00' COMMENT '车位分享的截止日期',
  `starttime` datetime NOT NULL DEFAULT '1970-01-01 00:00:00' COMMENT '车位分享的起始时间',
  `endtime` datetime NOT NULL DEFAULT '1970-01-01 00:00:00' COMMENT '车位分享的截止时间',
  `sharerule` int(11) NOT NULL DEFAULT '0' COMMENT '车位分享规则',
  `status` int(11) NOT NULL DEFAULT '0' COMMENT '是否已被使用',
  `createtime` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '订单创建时间',
  `remark` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '备注',
  `bufferminutes` int(11) NOT NULL DEFAULT '0' COMMENT '缓冲时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `park_placeshare`
--

LOCK TABLES `park_placeshare` WRITE;
/*!40000 ALTER TABLE `park_placeshare` DISABLE KEYS */;
/*!40000 ALTER TABLE `park_placeshare` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `park_platelock`
--

DROP TABLE IF EXISTS `park_platelock`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `park_platelock` (
  `id` bigint(255) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `message` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '信息',
  `plate` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '车牌号码',
  `personno` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '人员编号',
  `status` int(11) NOT NULL DEFAULT '0' COMMENT '是否锁定',
  `optdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '操作时间',
  `enterrecordid` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '入场记录ID',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `park_platelock`
--

LOCK TABLES `park_platelock` WRITE;
/*!40000 ALTER TABLE `park_platelock` DISABLE KEYS */;
INSERT INTO `park_platelock` VALUES (1,'1','吉CV0592','1',0,'2017-11-14 12:16:55','');
/*!40000 ALTER TABLE `park_platelock` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `park_processimage`
--

DROP TABLE IF EXISTS `park_processimage`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `park_processimage` (
  `ID` int(11) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `recordid` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0' COMMENT '记录ID',
  `waterstring` varchar(255) COLLATE utf8_unicode_ci NOT NULL COMMENT '水印内容',
  `picpath` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `status` int(11) NOT NULL DEFAULT '0' COMMENT '处理的状态值0表示未处理1表示已处理',
  `trytimes` int(11) NOT NULL DEFAULT '0' COMMENT '尝试打水印的次数，最多尝试3次',
  `opttime` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '时间戳',
  PRIMARY KEY (`ID`),
  KEY `index_status` (`status`),
  KEY `index_trytimes` (`trytimes`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `park_processimage`
--

LOCK TABLES `park_processimage` WRITE;
/*!40000 ALTER TABLE `park_processimage` DISABLE KEYS */;
/*!40000 ALTER TABLE `park_processimage` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `park_requestbuffer`
--

DROP TABLE IF EXISTS `park_requestbuffer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `park_requestbuffer` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `recordid` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '记录ID',
  `enterouttype` int(11) NOT NULL DEFAULT '1' COMMENT '出入口类型',
  `jsondata` text COLLATE utf8_unicode_ci NOT NULL COMMENT '下位机上传的json数据',
  `processflag` int(11) NOT NULL DEFAULT '0' COMMENT '缓存数据是否已处理',
  `deviceid` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '设备ID',
  `opttime` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '记录插入的时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `park_requestbuffer`
--

LOCK TABLES `park_requestbuffer` WRITE;
/*!40000 ALTER TABLE `park_requestbuffer` DISABLE KEYS */;
/*!40000 ALTER TABLE `park_requestbuffer` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `park_simulatereadcard`
--

DROP TABLE IF EXISTS `park_simulatereadcard`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `park_simulatereadcard` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `deviceid` bigint(20) NOT NULL DEFAULT '0' COMMENT '设备ID',
  `credentialtype` int(11) NOT NULL DEFAULT '163' COMMENT '凭证类型',
  `credentialno` varchar(255) NOT NULL DEFAULT '' COMMENT '凭证号码',
  `opttime` datetime NOT NULL DEFAULT '1970-01-01 00:00:00' COMMENT '中心下发时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `park_simulatereadcard`
--

LOCK TABLES `park_simulatereadcard` WRITE;
/*!40000 ALTER TABLE `park_simulatereadcard` DISABLE KEYS */;
/*!40000 ALTER TABLE `park_simulatereadcard` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `park_systemevent`
--

DROP TABLE IF EXISTS `park_systemevent`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `park_systemevent` (
  `recordid` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `credentialtype` int(11) NOT NULL DEFAULT '163' COMMENT '凭证类型',
  `credentialno` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '凭证编号',
  `sealid` int(11) NOT NULL DEFAULT '0' COMMENT '套餐ID',
  `sealname` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '套餐名称',
  `deviceid` bigint(20) NOT NULL DEFAULT '0' COMMENT '设备ID',
  `eventtime` datetime NOT NULL DEFAULT '1970-01-01 00:00:00' COMMENT '事件时间',
  `eventtype` int(11) NOT NULL DEFAULT '0' COMMENT '事件类型',
  `operatorno` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '操作员编号',
  `picturefilepath` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '图片路径',
  `remark` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '备注',
  PRIMARY KEY (`recordid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COMMENT='系统事件表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `park_systemevent`
--

LOCK TABLES `park_systemevent` WRITE;
/*!40000 ALTER TABLE `park_systemevent` DISABLE KEYS */;
/*!40000 ALTER TABLE `park_systemevent` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Temporary view structure for view `park_view_querytempfees`
--

DROP TABLE IF EXISTS `park_view_querytempfees`;
/*!50001 DROP VIEW IF EXISTS `park_view_querytempfees`*/;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
/*!50001 CREATE VIEW `park_view_querytempfees` AS SELECT 
 1 AS `id`,
 1 AS `enterid`,
 1 AS `outid`,
 1 AS `intime`,
 1 AS `feestime`,
 1 AS `createtime`,
 1 AS `ordertype`,
 1 AS `status`,
 1 AS `paytime`,
 1 AS `setmealid`,
 1 AS `setmealname`,
 1 AS `fees`,
 1 AS `benefit`,
 1 AS `derate`,
 1 AS `accountreceivable`,
 1 AS `paid`,
 1 AS `actualpaid`,
 1 AS `exchanged`,
 1 AS `paytypename`,
 1 AS `chargetype`,
 1 AS `remark`,
 1 AS `operatorid`,
 1 AS `operatorname`,
 1 AS `operatorno`,
 1 AS `workstationip`,
 1 AS `plate`,
 1 AS `chargedevicename`,
 1 AS `entertime`,
 1 AS `enterdeviceid`,
 1 AS `enterdevicename`,
 1 AS `enterpicture`,
 1 AS `outtime`,
 1 AS `outdeviceid`,
 1 AS `outdevicename`,
 1 AS `outpicture`*/;
SET character_set_client = @saved_cs_client;

--
-- Temporary view structure for view `park_view_querythroughout`
--

DROP TABLE IF EXISTS `park_view_querythroughout`;
/*!50001 DROP VIEW IF EXISTS `park_view_querythroughout`*/;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
/*!50001 CREATE VIEW `park_view_querythroughout` AS SELECT 
 1 AS `outid`,
 1 AS `plate`,
 1 AS `operatorid`,
 1 AS `operatorname`,
 1 AS `outdeviceid`,
 1 AS `enterouttype`,
 1 AS `outdevicename`,
 1 AS `outtime`,
 1 AS `outpicture`,
 1 AS `accountreceivable`,
 1 AS `enterid`,
 1 AS `entertime`,
 1 AS `enterdeviceid`,
 1 AS `enterdevicename`,
 1 AS `enterpicture`,
 1 AS `setmealid`,
 1 AS `setmealname`,
 1 AS `personname`,
 1 AS `PayTypeName`,
 1 AS `Fees`,
 1 AS `Benefit`,
 1 AS `eventtype`*/;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `park_vippassrecord`
--

DROP TABLE IF EXISTS `park_vippassrecord`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `park_vippassrecord` (
  `id` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0' COMMENT 'ID',
  `plate` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '车牌',
  `enterouttype` int(11) NOT NULL DEFAULT '1' COMMENT '出入口类型',
  `operatorid` bigint(255) NOT NULL DEFAULT '0' COMMENT '操作员ID',
  `operatorname` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '操作员姓名',
  `deviceid` bigint(255) NOT NULL DEFAULT '0' COMMENT '设备ID',
  `devicename` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '设备名称',
  `eventtime` datetime NOT NULL DEFAULT '1970-01-01 00:00:00' COMMENT '通行时间',
  `picturepath` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '图片路径',
  `personname` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '凭证持有人姓名',
  `optdate` datetime NOT NULL DEFAULT '1970-01-01 00:00:00' COMMENT '操作时间',
  `remark` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '备注',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `park_vippassrecord`
--

LOCK TABLES `park_vippassrecord` WRITE;
/*!40000 ALTER TABLE `park_vippassrecord` DISABLE KEYS */;
/*!40000 ALTER TABLE `park_vippassrecord` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sync_center_download`
--

DROP TABLE IF EXISTS `sync_center_download`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sync_center_download` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `recvdata` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL COMMENT '从中心获取的数据集',
  `downloadtime` datetime NOT NULL DEFAULT '1970-01-01 00:00:00' COMMENT '获取到数据的时间',
  `nextstartindex` bigint(20) NOT NULL DEFAULT '0' COMMENT '下一次取数据开始索引',
  `processindex` int(11) NOT NULL DEFAULT '0' COMMENT '当前缓存数据处理索引',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COMMENT='从中心获取数据的中间表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sync_center_download`
--

LOCK TABLES `sync_center_download` WRITE;
/*!40000 ALTER TABLE `sync_center_download` DISABLE KEYS */;
/*!40000 ALTER TABLE `sync_center_download` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sync_center_downloadprocess`
--

DROP TABLE IF EXISTS `sync_center_downloadprocess`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sync_center_downloadprocess` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `downloadid` bigint(20) NOT NULL DEFAULT '0' COMMENT '从中心获取后存入临时表的id',
  `serviceid` varchar(255) NOT NULL DEFAULT '' COMMENT '协议命令字',
  `jsondata` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL COMMENT '协议字符串',
  `status` int(11) NOT NULL DEFAULT '0' COMMENT '处理状态1成功，2失败',
  `processtime` datetime NOT NULL DEFAULT '1970-01-01 00:00:00' COMMENT '处理时间',
  `datatype` int(11) NOT NULL DEFAULT '0' COMMENT '数据类型0基础数据1出入场数据2脱机出入场数据',
  `remark` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL COMMENT '备注，表明失败原因',
  PRIMARY KEY (`id`),
  KEY `index_datatype` (`datatype`) USING BTREE,
  KEY `index_status` (`status`) USING BTREE,
  KEY `index_processtime` (`processtime`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COMMENT='处理从中心获取的数据';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sync_center_downloadprocess`
--

LOCK TABLES `sync_center_downloadprocess` WRITE;
/*!40000 ALTER TABLE `sync_center_downloadprocess` DISABLE KEYS */;
/*!40000 ALTER TABLE `sync_center_downloadprocess` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sync_center_history`
--

DROP TABLE IF EXISTS `sync_center_history`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sync_center_history` (
  `newid` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '表主键（递增ID）',
  `oldid` bigint(20) NOT NULL DEFAULT '0' COMMENT '原中间表ID',
  `businessid` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0' COMMENT '业务表对应ID',
  `servicetype` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '协议类型',
  `request` text COLLATE utf8_unicode_ci NOT NULL COMMENT '请求Json字符串',
  `optdate` datetime NOT NULL DEFAULT '1970-01-01 00:00:00' COMMENT '存入中间表的时间',
  `senddate` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '发送成功时间',
  `failedcount` bigint(255) NOT NULL DEFAULT '0' COMMENT '失败次数',
  `datatype` int(11) NOT NULL DEFAULT '0' COMMENT '数据类型0基础数据1出入场数据2脱机出入场数据',
  PRIMARY KEY (`newid`),
  KEY `index_id` (`newid`) USING BTREE,
  KEY `index_optdate` (`optdate`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='发送至中心数据的历史表（发送成功后移至此';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sync_center_history`
--

LOCK TABLES `sync_center_history` WRITE;
/*!40000 ALTER TABLE `sync_center_history` DISABLE KEYS */;
/*!40000 ALTER TABLE `sync_center_history` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sync_center_middle`
--

DROP TABLE IF EXISTS `sync_center_middle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sync_center_middle` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '自动递增ID',
  `businessid` varchar(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `servicetype` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '协议类型',
  `request` text COLLATE utf8_unicode_ci NOT NULL COMMENT '请求Json字符串',
  `optdate` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '插入中间表时间',
  `failedcount` bigint(255) unsigned NOT NULL DEFAULT '0' COMMENT '失败次数',
  `sendtime` datetime NOT NULL DEFAULT '1970-01-01 00:00:00' COMMENT '最近一次的发送时间',
  `datatype` int(11) NOT NULL DEFAULT '0' COMMENT '数据类型0基础数据1出入场数据2脱机出入场数据',
  PRIMARY KEY (`id`),
  KEY `index_id` (`id`) USING BTREE,
  KEY `index_optdate` (`optdate`) USING BTREE,
  KEY `index_failcount` (`failedcount`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='发送至中心的中间表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sync_center_middle`
--

LOCK TABLES `sync_center_middle` WRITE;
/*!40000 ALTER TABLE `sync_center_middle` DISABLE KEYS */;
/*!40000 ALTER TABLE `sync_center_middle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sync_controller_blackplatesheet`
--

DROP TABLE IF EXISTS `sync_controller_blackplatesheet`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sync_controller_blackplatesheet` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `deviceid` bigint(255) unsigned NOT NULL DEFAULT '0' COMMENT '控制机ID',
  `jsondata` text COLLATE utf8_unicode_ci NOT NULL COMMENT '请求Json字符串',
  `deleteflag` int(255) NOT NULL DEFAULT '0' COMMENT '是删除还是增加标记',
  `status` int(255) NOT NULL DEFAULT '0' COMMENT '发送状态（0是失败 1为成功）',
  `optdate` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '插入中间表时间',
  `failedcount` int(11) DEFAULT '0' COMMENT '发送失败次数',
  PRIMARY KEY (`id`),
  KEY `index_deviceid` (`deviceid`) USING BTREE,
  KEY `index_status` (`status`) USING BTREE,
  KEY `index_deleteflag` (`deleteflag`) USING BTREE,
  KEY `index_optdate` (`optdate`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='发车牌黑名单协议给控制器的中间表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sync_controller_blackplatesheet`
--

LOCK TABLES `sync_controller_blackplatesheet` WRITE;
/*!40000 ALTER TABLE `sync_controller_blackplatesheet` DISABLE KEYS */;
/*!40000 ALTER TABLE `sync_controller_blackplatesheet` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sync_controller_chargerecord`
--

DROP TABLE IF EXISTS `sync_controller_chargerecord`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sync_controller_chargerecord` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `deviceid` bigint(255) unsigned NOT NULL DEFAULT '0' COMMENT '设备ID',
  `jsondata` text COLLATE utf8_unicode_ci NOT NULL COMMENT '请求Json字符串',
  `deleteflag` int(255) NOT NULL DEFAULT '0' COMMENT '增加还是删除标记',
  `status` int(255) unsigned NOT NULL DEFAULT '0' COMMENT '发送状态0是失败1是成功',
  `optdate` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '插入中间表时间',
  `failedcount` int(11) NOT NULL DEFAULT '0' COMMENT '发送失败次数',
  PRIMARY KEY (`id`),
  KEY `index_deviceid` (`deviceid`) USING BTREE,
  KEY `index_deleteflag` (`deleteflag`) USING BTREE,
  KEY `index_status` (`status`) USING BTREE,
  KEY `index_failedcount` (`failedcount`) USING BTREE,
  KEY `index_optdate` (`optdate`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='发送给控制机的收费记录中间表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sync_controller_chargerecord`
--

LOCK TABLES `sync_controller_chargerecord` WRITE;
/*!40000 ALTER TABLE `sync_controller_chargerecord` DISABLE KEYS */;
/*!40000 ALTER TABLE `sync_controller_chargerecord` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sync_controller_chargingstandard`
--

DROP TABLE IF EXISTS `sync_controller_chargingstandard`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sync_controller_chargingstandard` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `deviceid` bigint(255) unsigned NOT NULL DEFAULT '0' COMMENT '设备ID',
  `jsondata` text COLLATE utf8_unicode_ci NOT NULL COMMENT '请求Json字符串',
  `deleteflag` int(255) NOT NULL DEFAULT '0' COMMENT '增加删除标记',
  `status` int(255) NOT NULL DEFAULT '0' COMMENT '发送状态0失败1成功',
  `optdate` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '插入中间表时间',
  `failedcount` int(11) NOT NULL DEFAULT '0' COMMENT '发送失败次数',
  PRIMARY KEY (`id`),
  KEY `index_deviceid` (`deviceid`) USING BTREE,
  KEY `index_deleteflag` (`deleteflag`) USING BTREE,
  KEY `index_status` (`status`) USING BTREE,
  KEY `index_failescount` (`failedcount`) USING BTREE,
  KEY `index_optdate` (`optdate`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='收费标准中间表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sync_controller_chargingstandard`
--

LOCK TABLES `sync_controller_chargingstandard` WRITE;
/*!40000 ALTER TABLE `sync_controller_chargingstandard` DISABLE KEYS */;
/*!40000 ALTER TABLE `sync_controller_chargingstandard` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sync_controller_chargingstandardparam`
--

DROP TABLE IF EXISTS `sync_controller_chargingstandardparam`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sync_controller_chargingstandardparam` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `deviceid` bigint(255) unsigned NOT NULL DEFAULT '0' COMMENT '设备ID',
  `jsondata` text COLLATE utf8_unicode_ci NOT NULL COMMENT '请求Json字符串',
  `deleteflag` int(255) NOT NULL DEFAULT '0' COMMENT '增加删除标记',
  `status` int(255) NOT NULL DEFAULT '0' COMMENT '发送状态0失败1成功',
  `optdate` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '插入中间表时间',
  `failedcount` int(11) NOT NULL DEFAULT '0' COMMENT '发送失败次数',
  PRIMARY KEY (`id`),
  KEY `index_deviceid` (`deviceid`) USING BTREE,
  KEY `index_deletefalg` (`deleteflag`) USING BTREE,
  KEY `index_status` (`status`) USING BTREE,
  KEY `index_failedcount` (`failedcount`) USING BTREE,
  KEY `index_optdate` (`optdate`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='套餐收费标准中间表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sync_controller_chargingstandardparam`
--

LOCK TABLES `sync_controller_chargingstandardparam` WRITE;
/*!40000 ALTER TABLE `sync_controller_chargingstandardparam` DISABLE KEYS */;
/*!40000 ALTER TABLE `sync_controller_chargingstandardparam` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sync_controller_credential`
--

DROP TABLE IF EXISTS `sync_controller_credential`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sync_controller_credential` (
  `id` bigint(255) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `deviceid` bigint(255) unsigned NOT NULL DEFAULT '0' COMMENT '设备ID',
  `jsondata` text COLLATE utf8_unicode_ci NOT NULL COMMENT '请求Json字符串',
  `deleteflag` int(255) NOT NULL DEFAULT '0' COMMENT '删除标记0增加1删除',
  `status` int(255) NOT NULL DEFAULT '0' COMMENT '发送状态0失败1成功',
  `optdate` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '插入中间表时间',
  `failedcount` int(11) NOT NULL DEFAULT '0' COMMENT '发送失败次数',
  PRIMARY KEY (`id`),
  KEY `index_deviceid` (`deviceid`) USING BTREE,
  KEY `index_deleteflag` (`deleteflag`) USING BTREE,
  KEY `index_status` (`status`) USING BTREE,
  KEY `index_failedcount` (`failedcount`) USING BTREE,
  KEY `index_optdate` (`optdate`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='车场卡中间表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sync_controller_credential`
--

LOCK TABLES `sync_controller_credential` WRITE;
/*!40000 ALTER TABLE `sync_controller_credential` DISABLE KEYS */;
/*!40000 ALTER TABLE `sync_controller_credential` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sync_controller_debugmode`
--

DROP TABLE IF EXISTS `sync_controller_debugmode`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sync_controller_debugmode` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `deviceid` bigint(255) unsigned NOT NULL DEFAULT '0' COMMENT '设备ID',
  `jsondata` varchar(1000) COLLATE utf8_unicode_ci NOT NULL COMMENT '请求Json字符串',
  `status` int(255) NOT NULL DEFAULT '0' COMMENT '发送状态0失败1成功',
  `optdate` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '插入中间表时间',
  `DeleteFlag` int(11) NOT NULL DEFAULT '0' COMMENT '0 请求进入调试模式 1请求退出调试模式',
  `failedcount` int(11) NOT NULL DEFAULT '0' COMMENT '发送失败次数',
  PRIMARY KEY (`id`),
  KEY `index_deviceid` (`deviceid`) USING BTREE,
  KEY `index_status` (`status`) USING BTREE,
  KEY `index_deleteflag` (`DeleteFlag`) USING BTREE,
  KEY `index_failedcount` (`failedcount`) USING BTREE,
  KEY `index_optdate` (`optdate`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='调试模式参数中间表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sync_controller_debugmode`
--

LOCK TABLES `sync_controller_debugmode` WRITE;
/*!40000 ALTER TABLE `sync_controller_debugmode` DISABLE KEYS */;
/*!40000 ALTER TABLE `sync_controller_debugmode` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sync_controller_devicerelationchange`
--

DROP TABLE IF EXISTS `sync_controller_devicerelationchange`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sync_controller_devicerelationchange` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `deviceid` bigint(255) unsigned NOT NULL DEFAULT '0' COMMENT '设备ID',
  `jsondata` text COLLATE utf8_unicode_ci NOT NULL COMMENT '请求Json字符串',
  `status` int(255) NOT NULL DEFAULT '0' COMMENT '发送状态0失败1成功',
  `optdate` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '插入中间表时间',
  `failedcount` int(11) NOT NULL DEFAULT '0' COMMENT '发送失败次数',
  PRIMARY KEY (`id`),
  KEY `index_deviceid` (`deviceid`) USING BTREE,
  KEY `index_status` (`status`) USING BTREE,
  KEY `index_failedcount` (`failedcount`) USING BTREE,
  KEY `index_optdate` (`optdate`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='LED参数中间表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sync_controller_devicerelationchange`
--

LOCK TABLES `sync_controller_devicerelationchange` WRITE;
/*!40000 ALTER TABLE `sync_controller_devicerelationchange` DISABLE KEYS */;
/*!40000 ALTER TABLE `sync_controller_devicerelationchange` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sync_controller_enterrecord`
--

DROP TABLE IF EXISTS `sync_controller_enterrecord`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sync_controller_enterrecord` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `deviceid` bigint(255) unsigned NOT NULL DEFAULT '0' COMMENT '设备id',
  `jsondata` text COLLATE utf8_unicode_ci NOT NULL COMMENT '请求json字符串',
  `deleteflag` int(255) NOT NULL DEFAULT '0' COMMENT '删除标记0增加1删除',
  `status` int(255) NOT NULL DEFAULT '0' COMMENT '发送状态0失败1成功',
  `optdate` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '插入中间表时间',
  `failedcount` int(11) NOT NULL DEFAULT '0' COMMENT '发送失败次数',
  PRIMARY KEY (`id`),
  KEY `index_deviceid` (`deviceid`) USING BTREE,
  KEY `index_deleteflag` (`deleteflag`) USING BTREE,
  KEY `index_status` (`status`) USING BTREE,
  KEY `index_failedcount` (`failedcount`) USING BTREE,
  KEY `index_optdate` (`optdate`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='入场纪录中间表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sync_controller_enterrecord`
--

LOCK TABLES `sync_controller_enterrecord` WRITE;
/*!40000 ALTER TABLE `sync_controller_enterrecord` DISABLE KEYS */;
/*!40000 ALTER TABLE `sync_controller_enterrecord` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sync_controller_gateparam`
--

DROP TABLE IF EXISTS `sync_controller_gateparam`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sync_controller_gateparam` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `deviceid` bigint(255) unsigned NOT NULL DEFAULT '0' COMMENT '设备ID',
  `jsondata` text COLLATE utf8_unicode_ci NOT NULL COMMENT '请求Json字符串',
  `status` int(255) NOT NULL DEFAULT '0' COMMENT '发送状态0失败1成功',
  `optdate` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '插入中间表时间',
  `failedcount` int(11) NOT NULL DEFAULT '0' COMMENT '发送失败次数',
  PRIMARY KEY (`id`),
  KEY `index_deviceid` (`deviceid`) USING BTREE,
  KEY `index_status` (`status`) USING BTREE,
  KEY `index_failedcount` (`failedcount`) USING BTREE,
  KEY `index_optdate` (`optdate`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='道闸参数中间表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sync_controller_gateparam`
--

LOCK TABLES `sync_controller_gateparam` WRITE;
/*!40000 ALTER TABLE `sync_controller_gateparam` DISABLE KEYS */;
/*!40000 ALTER TABLE `sync_controller_gateparam` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sync_controller_infopublish`
--

DROP TABLE IF EXISTS `sync_controller_infopublish`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sync_controller_infopublish` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `deviceid` bigint(255) unsigned NOT NULL DEFAULT '0' COMMENT '设备ID',
  `jsondata` text COLLATE utf8_unicode_ci NOT NULL COMMENT '请求Json字符串',
  `status` int(255) NOT NULL DEFAULT '0' COMMENT '发送状态0失败1成功',
  `optdate` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '插入中间表时间',
  `failedcount` int(11) DEFAULT '0' COMMENT '发送失败次数',
  PRIMARY KEY (`id`),
  KEY `index_deviceid` (`deviceid`) USING BTREE,
  KEY `index_status` (`status`) USING BTREE,
  KEY `index_failedcount` (`failedcount`) USING BTREE,
  KEY `index_optdate` (`optdate`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='信息发布中间表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sync_controller_infopublish`
--

LOCK TABLES `sync_controller_infopublish` WRITE;
/*!40000 ALTER TABLE `sync_controller_infopublish` DISABLE KEYS */;
/*!40000 ALTER TABLE `sync_controller_infopublish` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sync_controller_ledparam`
--

DROP TABLE IF EXISTS `sync_controller_ledparam`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sync_controller_ledparam` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `deviceid` bigint(255) unsigned NOT NULL DEFAULT '0' COMMENT '设备ID',
  `jsondata` text COLLATE utf8_unicode_ci NOT NULL COMMENT '请求Json字符串',
  `status` int(255) NOT NULL DEFAULT '0' COMMENT '发送状态0失败1成功',
  `optdate` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '插入中间表时间',
  `failedcount` int(11) NOT NULL DEFAULT '0' COMMENT '发送失败次数',
  PRIMARY KEY (`id`),
  KEY `index_deviceid` (`deviceid`) USING BTREE,
  KEY `index_status` (`status`) USING BTREE,
  KEY `index_failedcount` (`failedcount`) USING BTREE,
  KEY `index_optdate` (`optdate`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='LED参数中间表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sync_controller_ledparam`
--

LOCK TABLES `sync_controller_ledparam` WRITE;
/*!40000 ALTER TABLE `sync_controller_ledparam` DISABLE KEYS */;
/*!40000 ALTER TABLE `sync_controller_ledparam` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sync_controller_offlinedisplayandsoundparam`
--

DROP TABLE IF EXISTS `sync_controller_offlinedisplayandsoundparam`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sync_controller_offlinedisplayandsoundparam` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `deviceid` bigint(255) NOT NULL DEFAULT '0' COMMENT '设备ID',
  `jsondata` text COLLATE utf8_unicode_ci NOT NULL COMMENT '请求Json字符串',
  `status` int(255) NOT NULL DEFAULT '0' COMMENT '发送状态0失败1成功',
  `optdate` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '插入中间表时间',
  `failedcount` int(11) NOT NULL DEFAULT '0' COMMENT '发送失败次数',
  PRIMARY KEY (`id`),
  KEY `index_deviceid` (`deviceid`) USING BTREE,
  KEY `index_status` (`status`) USING BTREE,
  KEY `index_failedcount` (`failedcount`) USING BTREE,
  KEY `index_optdate` (`optdate`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='脱机语音Led参数中间表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sync_controller_offlinedisplayandsoundparam`
--

LOCK TABLES `sync_controller_offlinedisplayandsoundparam` WRITE;
/*!40000 ALTER TABLE `sync_controller_offlinedisplayandsoundparam` DISABLE KEYS */;
/*!40000 ALTER TABLE `sync_controller_offlinedisplayandsoundparam` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sync_controller_operator`
--

DROP TABLE IF EXISTS `sync_controller_operator`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sync_controller_operator` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `deviceid` bigint(255) unsigned NOT NULL DEFAULT '0' COMMENT '设备ID',
  `jsondata` text COLLATE utf8_unicode_ci NOT NULL COMMENT '请求Json字符串',
  `deleteflag` int(255) NOT NULL DEFAULT '0' COMMENT '增加删除标记0增加1删除',
  `status` int(255) NOT NULL DEFAULT '0' COMMENT '发送状态0失败1成功',
  `optdate` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '插入中间表时间',
  `failedcount` int(11) NOT NULL DEFAULT '0' COMMENT '发送失败次数',
  PRIMARY KEY (`id`),
  KEY `index_deviceid` (`deviceid`) USING BTREE,
  KEY `index_deleteflag` (`deleteflag`) USING BTREE,
  KEY `index_status` (`status`) USING BTREE,
  KEY `index_failedcount` (`failedcount`) USING BTREE,
  KEY `index_optdate` (`optdate`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='操作员上班中间表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sync_controller_operator`
--

LOCK TABLES `sync_controller_operator` WRITE;
/*!40000 ALTER TABLE `sync_controller_operator` DISABLE KEYS */;
/*!40000 ALTER TABLE `sync_controller_operator` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sync_controller_outrecord`
--

DROP TABLE IF EXISTS `sync_controller_outrecord`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sync_controller_outrecord` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `deviceid` bigint(255) unsigned NOT NULL DEFAULT '0' COMMENT '设备ID',
  `jsondata` text COLLATE utf8_unicode_ci NOT NULL COMMENT '请求Json字符串',
  `deleteflag` int(255) NOT NULL DEFAULT '0' COMMENT '增加删除标记0增加1删除',
  `status` int(255) NOT NULL DEFAULT '0' COMMENT '发送状态0失败1成功',
  `optdate` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '插入中间表时间',
  `failedcount` int(11) NOT NULL DEFAULT '0' COMMENT '发送失败次数',
  PRIMARY KEY (`id`),
  KEY `index_deviceid` (`deviceid`) USING BTREE,
  KEY `index_deleteflag` (`deleteflag`) USING BTREE,
  KEY `index_status` (`status`) USING BTREE,
  KEY `index_failedcount` (`failedcount`) USING BTREE,
  KEY `index_optdate` (`optdate`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='出场记录中间表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sync_controller_outrecord`
--

LOCK TABLES `sync_controller_outrecord` WRITE;
/*!40000 ALTER TABLE `sync_controller_outrecord` DISABLE KEYS */;
/*!40000 ALTER TABLE `sync_controller_outrecord` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sync_controller_param`
--

DROP TABLE IF EXISTS `sync_controller_param`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sync_controller_param` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `deviceid` bigint(255) unsigned NOT NULL DEFAULT '0' COMMENT '设备id',
  `serviceid` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '协议类型',
  `status` int(255) NOT NULL DEFAULT '0' COMMENT '发送状态0失败1成功',
  `optdate` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '插入中间表时间',
  PRIMARY KEY (`id`),
  KEY `index_deviceid` (`deviceid`) USING BTREE,
  KEY `index_status` (`status`) USING BTREE,
  KEY `index_optdate` (`optdate`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='设备参数中间表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sync_controller_param`
--

LOCK TABLES `sync_controller_param` WRITE;
/*!40000 ALTER TABLE `sync_controller_param` DISABLE KEYS */;
/*!40000 ALTER TABLE `sync_controller_param` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sync_controller_parkplaceshare`
--

DROP TABLE IF EXISTS `sync_controller_parkplaceshare`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sync_controller_parkplaceshare` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `deviceid` bigint(255) unsigned NOT NULL DEFAULT '0' COMMENT '设备ID',
  `jsondata` text COLLATE utf8_unicode_ci NOT NULL COMMENT '请求Json字符串',
  `deleteflag` int(255) NOT NULL DEFAULT '0' COMMENT '增加删除标记0增加1删除',
  `status` int(255) NOT NULL DEFAULT '0' COMMENT '发送状态0失败1成功',
  `optdate` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '插入中间表时间',
  `failedcount` int(11) NOT NULL DEFAULT '0' COMMENT '发送失败次数',
  PRIMARY KEY (`id`),
  KEY `index_deviceid` (`deviceid`) USING BTREE,
  KEY `index_deleteflag` (`deleteflag`) USING BTREE,
  KEY `index_status` (`status`) USING BTREE,
  KEY `index_failedcount` (`failedcount`) USING BTREE,
  KEY `index_optdate` (`optdate`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sync_controller_parkplaceshare`
--

LOCK TABLES `sync_controller_parkplaceshare` WRITE;
/*!40000 ALTER TABLE `sync_controller_parkplaceshare` DISABLE KEYS */;
/*!40000 ALTER TABLE `sync_controller_parkplaceshare` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sync_controller_platelock`
--

DROP TABLE IF EXISTS `sync_controller_platelock`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sync_controller_platelock` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `deviceid` bigint(255) unsigned NOT NULL DEFAULT '0' COMMENT '设备ID',
  `jsondata` text COLLATE utf8_unicode_ci NOT NULL COMMENT '请求Json字符串',
  `deleteflag` int(255) NOT NULL DEFAULT '0' COMMENT '增加删除标记0增加1删除',
  `status` int(255) NOT NULL DEFAULT '0' COMMENT '发送状态0失败1成功',
  `optdate` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '插入中间表时间',
  `failedcount` int(11) NOT NULL DEFAULT '0' COMMENT '发送失败次数',
  PRIMARY KEY (`id`),
  KEY `index_deviceid` (`deviceid`) USING BTREE,
  KEY `index_deleteflag` (`deleteflag`) USING BTREE,
  KEY `index_status` (`status`) USING BTREE,
  KEY `index_failedcount` (`failedcount`) USING BTREE,
  KEY `index_optdate` (`optdate`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='车牌锁定中间表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sync_controller_platelock`
--

LOCK TABLES `sync_controller_platelock` WRITE;
/*!40000 ALTER TABLE `sync_controller_platelock` DISABLE KEYS */;
/*!40000 ALTER TABLE `sync_controller_platelock` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sync_controller_setmeal`
--

DROP TABLE IF EXISTS `sync_controller_setmeal`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sync_controller_setmeal` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `deviceid` bigint(255) unsigned NOT NULL DEFAULT '0' COMMENT '设备id',
  `jsondata` text COLLATE utf8_unicode_ci NOT NULL COMMENT '请求json字符串',
  `deleteflag` int(255) NOT NULL DEFAULT '0' COMMENT '删除标记0增加1删除',
  `status` int(255) NOT NULL DEFAULT '0' COMMENT '发送状态0失败1成功',
  `optdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '插入中间表时间',
  `failedcount` int(11) NOT NULL DEFAULT '0' COMMENT '发送失败次数',
  PRIMARY KEY (`id`),
  KEY `index_deviceid` (`deviceid`) USING BTREE,
  KEY `index_deleteflag` (`deleteflag`) USING BTREE,
  KEY `index_status` (`status`) USING BTREE,
  KEY `index_failedcount` (`failedcount`) USING BTREE,
  KEY `index_optdate` (`optdate`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='套餐中间表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sync_controller_setmeal`
--

LOCK TABLES `sync_controller_setmeal` WRITE;
/*!40000 ALTER TABLE `sync_controller_setmeal` DISABLE KEYS */;
/*!40000 ALTER TABLE `sync_controller_setmeal` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sync_controller_slotbook`
--

DROP TABLE IF EXISTS `sync_controller_slotbook`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sync_controller_slotbook` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT ' 自动递增ID',
  `deviceid` bigint(255) unsigned NOT NULL DEFAULT '0' COMMENT '设备ID',
  `jsondata` text COLLATE utf8_unicode_ci NOT NULL COMMENT '请求Json字符串',
  `deleteflag` int(255) NOT NULL DEFAULT '0' COMMENT '增加删除标记0增加1删除',
  `status` int(255) NOT NULL DEFAULT '0' COMMENT '发送状态0失败1成功',
  `optdate` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '插入中间表时间',
  `failedcount` int(11) NOT NULL DEFAULT '0' COMMENT '发送失败次数',
  PRIMARY KEY (`id`),
  KEY `index_deviceid` (`deviceid`) USING BTREE,
  KEY `index_deleteflag` (`deleteflag`) USING BTREE,
  KEY `index_status` (`status`) USING BTREE,
  KEY `index_failedcount` (`failedcount`) USING BTREE,
  KEY `index_optdate` (`optdate`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='车位预定中间表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sync_controller_slotbook`
--

LOCK TABLES `sync_controller_slotbook` WRITE;
/*!40000 ALTER TABLE `sync_controller_slotbook` DISABLE KEYS */;
/*!40000 ALTER TABLE `sync_controller_slotbook` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sync_controller_specialvehicle`
--

DROP TABLE IF EXISTS `sync_controller_specialvehicle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sync_controller_specialvehicle` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `deviceid` bigint(255) unsigned NOT NULL DEFAULT '0' COMMENT '设备ID',
  `jsondata` text COLLATE utf8_unicode_ci NOT NULL COMMENT '请求Json字符串',
  `deleteflag` int(255) NOT NULL DEFAULT '0' COMMENT '增加删除标记0增加1删除',
  `status` int(20) NOT NULL DEFAULT '0' COMMENT '发送状态0失败1成功',
  `optdate` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '插入中间表时间',
  `failedcount` int(11) NOT NULL DEFAULT '0' COMMENT '发送失败次数',
  PRIMARY KEY (`id`),
  KEY `index_deviceid` (`deviceid`) USING BTREE,
  KEY `index_deleteflag` (`deleteflag`) USING BTREE,
  KEY `index_status` (`status`) USING BTREE,
  KEY `index_failedcount` (`failedcount`) USING BTREE,
  KEY `index_optdate` (`optdate`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='车牌名单中间表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sync_controller_specialvehicle`
--

LOCK TABLES `sync_controller_specialvehicle` WRITE;
/*!40000 ALTER TABLE `sync_controller_specialvehicle` DISABLE KEYS */;
/*!40000 ALTER TABLE `sync_controller_specialvehicle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sync_controller_subchannelset`
--

DROP TABLE IF EXISTS `sync_controller_subchannelset`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sync_controller_subchannelset` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `deviceid` bigint(255) unsigned NOT NULL DEFAULT '0' COMMENT '设备ID',
  `jsondata` text COLLATE utf8_unicode_ci NOT NULL COMMENT '请求Json字符串',
  `status` int(255) NOT NULL DEFAULT '0' COMMENT '发送状态0失败1成功',
  `optdate` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '插入中间表时间',
  `failedcount` int(11) NOT NULL DEFAULT '0' COMMENT '发送失败次数',
  PRIMARY KEY (`id`),
  KEY `index_deviceid` (`deviceid`) USING BTREE,
  KEY `index_status` (`status`) USING BTREE,
  KEY `index_failedcount` (`failedcount`) USING BTREE,
  KEY `index_optdate` (`optdate`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='子设备通道中间表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sync_controller_subchannelset`
--

LOCK TABLES `sync_controller_subchannelset` WRITE;
/*!40000 ALTER TABLE `sync_controller_subchannelset` DISABLE KEYS */;
/*!40000 ALTER TABLE `sync_controller_subchannelset` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sync_controller_vistorcredential`
--

DROP TABLE IF EXISTS `sync_controller_vistorcredential`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sync_controller_vistorcredential` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `deviceid` bigint(255) unsigned NOT NULL DEFAULT '0' COMMENT '设备ID',
  `jsondata` text COLLATE utf8_unicode_ci NOT NULL COMMENT '请求Json字符串',
  `deleteflag` int(255) NOT NULL DEFAULT '0' COMMENT '增加删除标记0增加1删除',
  `status` int(255) NOT NULL DEFAULT '0' COMMENT '发送状态0失败1成功',
  `optdate` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '插入中间表时间',
  `failedcount` int(11) NOT NULL DEFAULT '0' COMMENT '发送失败次数',
  PRIMARY KEY (`id`),
  KEY `index_device` (`deviceid`) USING BTREE,
  KEY `index_deleteflag` (`deleteflag`) USING BTREE,
  KEY `index_status` (`status`) USING BTREE,
  KEY `index_failedcount` (`failedcount`) USING BTREE,
  KEY `index_optdate` (`optdate`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='访客凭证中间表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sync_controller_vistorcredential`
--

LOCK TABLES `sync_controller_vistorcredential` WRITE;
/*!40000 ALTER TABLE `sync_controller_vistorcredential` DISABLE KEYS */;
/*!40000 ALTER TABLE `sync_controller_vistorcredential` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sys_boxinformation`
--

DROP TABLE IF EXISTS `sys_boxinformation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sys_boxinformation` (
  `id` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `ip` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '盒子IP',
  `mask` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '盒子掩码',
  `gateway` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '盒子网关',
  `mac` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '盒子mac',
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '盒子名字',
  `systemver` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '程序版本',
  `databasever` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '数据库版本',
  `compiletime` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '编译时间',
  `customer` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '客户名称',
  `hardwareversion` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '硬件版本',
  `model` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '型号',
  `orderid` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '订单ID',
  `summary` varchar(1024) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '版本特性',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sys_boxinformation`
--

LOCK TABLES `sys_boxinformation` WRITE;
/*!40000 ALTER TABLE `sys_boxinformation` DISABLE KEYS */;
INSERT INTO `sys_boxinformation` VALUES ('3221227520','192.168.0.1','255.255.255.0','192.168.0.1','00:50:56:C0:00:08','盒子','V1.0.0','V1.0.0','','','-','JSMC-1102','','版本特性：\r\n1、盒子化智能终端，创新车场新模式\r\n2、标准化车行智能终端盒子，告别PC，免安装，免实施，一键链云，快速交付等新应用；\r\n3、接口丰富，强大的可扩展性\r\n4、具有多种类型接口，皆为防呆化设计，车场设备可全部直连盒子接口，可满足多种应用扩展。\r\n5、以停车收费角色为中心的操作驾驶舱终端，易上手，好管理；以收费员角色核心操作业务的车辆监控，通行管理为主操作驾驶舱，同时兼顾上下班、交班、信息上报等贴身业务。同时还针对常用功能提供快捷操作按钮，大大减轻工作负担。\r\n6、本地，中心计费多种停车算费模式，脱机缴费快无忧；改变以往依赖系统中心的多线程处理能力和网络能力，系统脱机时仍不影响算费处理。\r\n7、三步快速向导搞定调试，屌丝也变大咖；只需通过车场盒子快速向导，进行设备联网信息，连接中心，设备关联三步即可完成车子盒子调试进行正常运行；无需专业技能，傻瓜式应用向导，屌丝转身变大咖。\r\n8、端到端标准化组网，实施更方便；生产完毕出厂时已预设组网IP，嵌入式操作系统，支持网内IP化设备搜索匹配并自动建立连接，完成设备注册并初始化启用。\r\n9、一键调试、一键联网：现场设备连接后，调试人员通过“一键调试”可以实现系统与现场设备之间的自动握手、自动识别、自动认证连接，并且实现通讯自检，并生成调试记录，在前端系统部署调试完成后，通过“一键入云”可自动适配连接到云端管理平台，完成各数据接口的自检，并生成调试记录。\r\n10、一键升级，不再愁：改变以往设备升级需要专业知识，操作复杂且需要花费较长时间，实现根据需要，一键完成设备升级；\r\n智能化设备运维，快捷省心！\r\n\r\n\r\n');
/*!40000 ALTER TABLE `sys_boxinformation` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sys_devicelist`
--

DROP TABLE IF EXISTS `sys_devicelist`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sys_devicelist` (
  `id` bigint(20) NOT NULL DEFAULT '0' COMMENT '设备ID',
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '设备名字',
  `ip` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '设备IP',
  `devicetype` int(8) NOT NULL DEFAULT '0' COMMENT '设备类型',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sys_devicelist`
--

LOCK TABLES `sys_devicelist` WRITE;
/*!40000 ALTER TABLE `sys_devicelist` DISABLE KEYS */;
/*!40000 ALTER TABLE `sys_devicelist` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sys_devicestatistics`
--

DROP TABLE IF EXISTS `sys_devicestatistics`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sys_devicestatistics` (
  `deviceid` bigint(20) NOT NULL DEFAULT '0' COMMENT '设备ID',
  `devicename` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '设备名字',
  `runningtime` int(8) NOT NULL DEFAULT '0',
  `totalrunningtime` int(8) NOT NULL DEFAULT '0',
  `maintainancetimes` int(8) NOT NULL DEFAULT '0',
  `upgradetimes` int(8) NOT NULL DEFAULT '0',
  `offlinetimes` int(8) NOT NULL DEFAULT '0',
  `version` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`deviceid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sys_devicestatistics`
--

LOCK TABLES `sys_devicestatistics` WRITE;
/*!40000 ALTER TABLE `sys_devicestatistics` DISABLE KEYS */;
/*!40000 ALTER TABLE `sys_devicestatistics` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sys_deviceupdatestate`
--

DROP TABLE IF EXISTS `sys_deviceupdatestate`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sys_deviceupdatestate` (
  `id` bigint(20) NOT NULL,
  `deviceid` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `oldversion` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `newversion` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `operatorno` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `operatorname` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `updatestarttime` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `successfulflag` int(8) NOT NULL DEFAULT '0',
  `updatesuccesstime` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sys_deviceupdatestate`
--

LOCK TABLES `sys_deviceupdatestate` WRITE;
/*!40000 ALTER TABLE `sys_deviceupdatestate` DISABLE KEYS */;
/*!40000 ALTER TABLE `sys_deviceupdatestate` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sys_event`
--

DROP TABLE IF EXISTS `sys_event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sys_event` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `eventId` varchar(255) NOT NULL DEFAULT '' COMMENT '事件ID',
  `deviceId` bigint(20) NOT NULL DEFAULT '0' COMMENT '设备ID',
  `deviceName` varchar(255) NOT NULL DEFAULT '' COMMENT '设备名称',
  `deviceType` int(11) NOT NULL DEFAULT '0' COMMENT '设备类型',
  `eventType` int(11) NOT NULL DEFAULT '0' COMMENT '事件类型',
  `eventTime` datetime NOT NULL DEFAULT '1970-01-01 00:00:00' COMMENT '事件时间',
  `eventLevel` int(11) NOT NULL DEFAULT '0' COMMENT '事件级别',
  `eventContent` varchar(255) NOT NULL DEFAULT '' COMMENT '事件内容',
  `sourceDeviceId` bigint(20) NOT NULL DEFAULT '0' COMMENT '原始设备',
  `credentialType` int(11) NOT NULL DEFAULT '0' COMMENT '证件类型',
  `credentialNo` varchar(255) NOT NULL DEFAULT '' COMMENT '凭证编号',
  `operatorNo` varchar(255) NOT NULL DEFAULT '' COMMENT '操作员编号',
  `operatorName` varchar(255) NOT NULL DEFAULT '' COMMENT '操作员姓名',
  `picFilePath` varchar(255) NOT NULL DEFAULT '' COMMENT '图片路径',
  `videoFilePath` varchar(255) NOT NULL DEFAULT '' COMMENT '视频路径',
  `remark` varchar(255) NOT NULL DEFAULT '' COMMENT '备注',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sys_event`
--

LOCK TABLES `sys_event` WRITE;
/*!40000 ALTER TABLE `sys_event` DISABLE KEYS */;
/*!40000 ALTER TABLE `sys_event` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sys_httpparam`
--

DROP TABLE IF EXISTS `sys_httpparam`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sys_httpparam` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `uploadserverurl` varchar(500) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `downloadserverurl` varchar(500) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `username` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `password` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `photodir` varchar(500) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `logdir` varchar(500) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `updatedir` varchar(500) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `adfiledir` varchar(500) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sys_httpparam`
--

LOCK TABLES `sys_httpparam` WRITE;
/*!40000 ALTER TABLE `sys_httpparam` DISABLE KEYS */;
/*!40000 ALTER TABLE `sys_httpparam` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sys_idcapture_config`
--

DROP TABLE IF EXISTS `sys_idcapture_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sys_idcapture_config` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `ip` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `port` int(8) NOT NULL DEFAULT '0',
  `account` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `password` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `channelid` int(8) NOT NULL DEFAULT '0',
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sys_idcapture_config`
--

LOCK TABLES `sys_idcapture_config` WRITE;
/*!40000 ALTER TABLE `sys_idcapture_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `sys_idcapture_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sys_log`
--

DROP TABLE IF EXISTS `sys_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sys_log` (
  `id` char(32) COLLATE utf8_unicode_ci NOT NULL COMMENT '唯一Id',
  `deviceid` bigint(20) NOT NULL DEFAULT '0' COMMENT '设备ID',
  `devicename` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '设备名称',
  `logLevel` int(11) NOT NULL DEFAULT '0' COMMENT '日志级别',
  `eventTime` datetime NOT NULL DEFAULT '1970-01-01 00:00:00' COMMENT '操作时间',
  `operatorNo` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '操作员编号',
  `operatorName` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '操作员姓名',
  `moudle` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '模块名称',
  `content` varchar(4000) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '日志内容',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sys_log`
--

LOCK TABLES `sys_log` WRITE;
/*!40000 ALTER TABLE `sys_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `sys_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sys_loudspeaker_config`
--

DROP TABLE IF EXISTS `sys_loudspeaker_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sys_loudspeaker_config` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `starttime1` varchar(10) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `endtime1` varchar(10) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `starttime2` varchar(10) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `endtime2` varchar(10) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `talkip1` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `talkport1` int(8) NOT NULL DEFAULT '0',
  `talkip2` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `talkport2` int(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sys_loudspeaker_config`
--

LOCK TABLES `sys_loudspeaker_config` WRITE;
/*!40000 ALTER TABLE `sys_loudspeaker_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `sys_loudspeaker_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sys_parkinfo`
--

DROP TABLE IF EXISTS `sys_parkinfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sys_parkinfo` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `parkno` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `posid` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '捷顺通pos编号',
  `shopcode` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `iscloudpay` int(11) NOT NULL DEFAULT '0',
  `cloudpaylink` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `netpointcode` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '网点编号',
  `entrancelink` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '入场码链接',
  `exitlink` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '支付码',
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sys_parkinfo`
--

LOCK TABLES `sys_parkinfo` WRITE;
/*!40000 ALTER TABLE `sys_parkinfo` DISABLE KEYS */;
/*!40000 ALTER TABLE `sys_parkinfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sys_passagerule_details`
--

DROP TABLE IF EXISTS `sys_passagerule_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sys_passagerule_details` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `mealid` bigint(20) NOT NULL DEFAULT '0',
  `name` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `nickname` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `type` int(8) NOT NULL DEFAULT '0',
  `passbarrieropen` int(8) NOT NULL DEFAULT '0',
  `openbarriertype` int(8) NOT NULL DEFAULT '0',
  `fullnumber` int(8) NOT NULL DEFAULT '0',
  `enterwherefull` int(8) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sys_passagerule_details`
--

LOCK TABLES `sys_passagerule_details` WRITE;
/*!40000 ALTER TABLE `sys_passagerule_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `sys_passagerule_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sys_passagerule_master`
--

DROP TABLE IF EXISTS `sys_passagerule_master`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sys_passagerule_master` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `monthcredentialenteroutmode` int(8) NOT NULL DEFAULT '0',
  `tempcredentialenteroutmode` int(8) NOT NULL DEFAULT '0',
  `freecredentialenteroutmode` int(8) NOT NULL DEFAULT '0',
  `recogniseprecision` int(8) NOT NULL DEFAULT '0',
  `expiredaction` int(8) NOT NULL DEFAULT '0',
  `bufferdays` int(8) NOT NULL DEFAULT '0',
  `alarmdays` int(8) NOT NULL DEFAULT '0',
  `psamcardmode` int(8) NOT NULL DEFAULT '0',
  `valuecardwarning` int(8) NOT NULL DEFAULT '0',
  `CompareFailProcessMode` int(8) NOT NULL DEFAULT '1' COMMENT '出口比对失败放行规则 不收费 1 收固定费用 2',
  `CompareFailProcessCharge` int(8) NOT NULL DEFAULT '0' COMMENT '出口比对失败固定收费 ',
  `MonthCarStayViolatedTime` int(8) NOT NULL DEFAULT '0' COMMENT '小车场月租车在大停车场停放时间超过指定时间视为违规，单位分钟',
  `TempCarStayViolatedMoney` int(8) NOT NULL DEFAULT '0' COMMENT '临停车在大停车场停车金额超过指定额度视为违规，精确到分',
  `TempCarQuickExit` int(8) NOT NULL DEFAULT '1' COMMENT '临时车快速出场，0 不启用 1 启用 默认启用',
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sys_passagerule_master`
--

LOCK TABLES `sys_passagerule_master` WRITE;
/*!40000 ALTER TABLE `sys_passagerule_master` DISABLE KEYS */;
/*!40000 ALTER TABLE `sys_passagerule_master` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sys_restart`
--

DROP TABLE IF EXISTS `sys_restart`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sys_restart` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `weekinfo` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `period` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `optdate` datetime NOT NULL DEFAULT '1970-01-01 00:00:00' COMMENT '重启过的日期',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sys_restart`
--

LOCK TABLES `sys_restart` WRITE;
/*!40000 ALTER TABLE `sys_restart` DISABLE KEYS */;
/*!40000 ALTER TABLE `sys_restart` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sys_setmeal`
--

DROP TABLE IF EXISTS `sys_setmeal`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sys_setmeal` (
  `id` bigint(20) NOT NULL DEFAULT '0',
  `defaultname` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `nickname` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `type` int(255) NOT NULL DEFAULT '0',
  `weekinfo` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `effectivetime` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `stopusing` int(11) NOT NULL DEFAULT '0' COMMENT '是否启用',
  `externpriod` text COLLATE utf8_unicode_ci NOT NULL COMMENT '扩展时段',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sys_setmeal`
--

LOCK TABLES `sys_setmeal` WRITE;
/*!40000 ALTER TABLE `sys_setmeal` DISABLE KEYS */;
INSERT INTO `sys_setmeal` VALUES (1,'白名单/特权车','白名单/特权车',0,'True;True;True;True;True;True;True;','00:00-23:59',0,''),(47,'月租用户H','月租用户H',1,'True;True;True;True;True;True;True;','00:00-23:59',0,''),(50,'月租用户A','月租用户A',1,'True;True;True;True;True;True;True;','00:00-23:59',0,''),(54,'临时用户A','临时用户A',2,'True;True;True;True;True;True;True;','00:00-23:59',0,''),(55,'临时用户B','临时用户B',2,'True;True;True;True;True;True;True;','00:00-23:59',0,''),(56,'临时用户C','临时用户C',2,'True;True;True;True;True;True;True;','00:00-23:59',0,''),(57,'临时用户D','临时用户D',2,'True;True;True;True;True;True;True;','00:00-23:59',0,''),(59,'月租用户B','月租用户B',1,'True;True;True;True;True;True;True;','00:00-23:59',0,''),(60,'月租用户C','月租用户C',1,'True;True;True;True;True;True;True;','00:00-23:59',0,''),(61,'月租用户D','月租用户D',1,'True;True;True;True;True;True;True;','00:00-23:59',0,''),(62,'免费用户B','免费用户B',3,'True;True;True;True;True;True;True;','00:00-23:59',0,''),(63,'月租用户F','月租用户F',1,'True;True;True;True;True;True;True;','00:00-23:59',0,''),(64,'月租用户E','月租用户E',1,'True;True;True;True;True;True;True;','00:00-23:59',0,''),(65,'免费用户A','免费用户A',3,'True;True;True;True;True;True;True;','00:00-23:59',0,''),(66,'免费用户C','免费用户C',3,'True;True;True;True;True;True;True;','00:00-23:59',1,''),(67,'免费用户D','免费用户D',3,'True;True;True;True;True;True;True;','00:00-23:59',1,''),(68,'月租用户G','月租用户G',1,'True;True;True;True;True;True;True;','00:00-23:59',0,''),(69,'临时用户E','临时用户E',2,'True;True;True;True;True;True;True;','00:00-23:59',0,''),(70,'临时用户F','临时用户F',2,'True;True;True;True;True;True;True;','00:00-23:59',0,''),(71,'临时用户G','临时用户G',2,'True;True;True;True;True;True;True;','00:00-23:59',0,''),(72,'临时用户H','临时用户H',2,'True;True;True;True;True;True;True;','00:00-23:59',0,'');
/*!40000 ALTER TABLE `sys_setmeal` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sys_setmeal_fixtotemp`
--

DROP TABLE IF EXISTS `sys_setmeal_fixtotemp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sys_setmeal_fixtotemp` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `fixsetmealid` int(8) NOT NULL DEFAULT '0',
  `tempsetmealid` int(8) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sys_setmeal_fixtotemp`
--

LOCK TABLES `sys_setmeal_fixtotemp` WRITE;
/*!40000 ALTER TABLE `sys_setmeal_fixtotemp` DISABLE KEYS */;
/*!40000 ALTER TABLE `sys_setmeal_fixtotemp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sys_setting`
--

DROP TABLE IF EXISTS `sys_setting`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sys_setting` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `key` varchar(500) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `value` varchar(500) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `Remark` varchar(500) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '备注',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sys_setting`
--

LOCK TABLES `sys_setting` WRITE;
/*!40000 ALTER TABLE `sys_setting` DISABLE KEYS */;
INSERT INTO `sys_setting` VALUES (2,'SerialNumber','0',''),(3,'finance_bill','0',''),(4,'finance_usediscount','0',''),(5,'StartTime','2017-07-19 20:24:12',''),(6,'CenterUrl','http://192.168.0.1:8090',''),(7,'NextStartIndex','0',''),(8,'CalFeeUrl','http://192.168.0.1:8099',''),(9,'platePre','京,沪,粤,津,黑,辽,青,蒙,吉,陕,甘,宁,新,藏,贵,豫,云,渝,皖,闽,湘,鄂,浙,苏,晋,琼,黔,鲁,桂,川,冀,赣,港,澳,台,军,警,未,使,WJ,民航,机场',''),(10,'plateSuffix','学,港,澳',''),(11,'CenterIP','192.168.0.1','');
/*!40000 ALTER TABLE `sys_setting` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sys_slotbook`
--

DROP TABLE IF EXISTS `sys_slotbook`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sys_slotbook` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `bookid` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `plate` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `slotno` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `deadtime` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `message` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `status` int(8) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sys_slotbook`
--

LOCK TABLES `sys_slotbook` WRITE;
/*!40000 ALTER TABLE `sys_slotbook` DISABLE KEYS */;
/*!40000 ALTER TABLE `sys_slotbook` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sys_slotsdisplayer_config`
--

DROP TABLE IF EXISTS `sys_slotsdisplayer_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sys_slotsdisplayer_config` (
  `displayertype` varchar(10) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `direction` int(8) NOT NULL DEFAULT '0',
  `displaystyle` int(8) NOT NULL DEFAULT '0',
  `content` varchar(500) COLLATE utf8_unicode_ci NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sys_slotsdisplayer_config`
--

LOCK TABLES `sys_slotsdisplayer_config` WRITE;
/*!40000 ALTER TABLE `sys_slotsdisplayer_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `sys_slotsdisplayer_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sys_subchannel`
--

DROP TABLE IF EXISTS `sys_subchannel`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sys_subchannel` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `deviceid` bigint(20) NOT NULL DEFAULT '0' COMMENT '设备ID (接收命令的ID)',
  `subdeviceid` bigint(20) NOT NULL DEFAULT '0' COMMENT '内部IP设备的设备ID',
  `submacb` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '内部IP设备的Macb',
  `subdevicetype` int(11) NOT NULL DEFAULT '0' COMMENT '内部IP设备类型',
  `subchannel` int(11) NOT NULL DEFAULT '0' COMMENT '内部IP设备的通道号',
  `subdeviceip` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '内部Ip设备的IP地址',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='3.5.17　子通道配置信息 ';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sys_subchannel`
--

LOCK TABLES `sys_subchannel` WRITE;
/*!40000 ALTER TABLE `sys_subchannel` DISABLE KEYS */;
/*!40000 ALTER TABLE `sys_subchannel` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sys_subdevicesippool`
--

DROP TABLE IF EXISTS `sys_subdevicesippool`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sys_subdevicesippool` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `deviceid` bigint(20) NOT NULL DEFAULT '0' COMMENT '设备Id',
  `ippool` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT 'Ip池',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sys_subdevicesippool`
--

LOCK TABLES `sys_subdevicesippool` WRITE;
/*!40000 ALTER TABLE `sys_subdevicesippool` DISABLE KEYS */;
/*!40000 ALTER TABLE `sys_subdevicesippool` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sys_updatebacklog`
--

DROP TABLE IF EXISTS `sys_updatebacklog`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sys_updatebacklog` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `opttime` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `oldver` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `newver` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `devicepackageurl` varchar(500) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sys_updatebacklog`
--

LOCK TABLES `sys_updatebacklog` WRITE;
/*!40000 ALTER TABLE `sys_updatebacklog` DISABLE KEYS */;
/*!40000 ALTER TABLE `sys_updatebacklog` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sys_updateevent`
--

DROP TABLE IF EXISTS `sys_updateevent`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sys_updateevent` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `eventtime` datetime NOT NULL DEFAULT '1970-01-01 00:00:00' COMMENT '发生事件',
  `operatorid` int(8) NOT NULL DEFAULT '0' COMMENT '操作员Id',
  `oldversion` varchar(500) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '老版本',
  `newversion` varchar(500) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '新版本',
  `url` varchar(500) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '升级包下载地址',
  `step` int(8) NOT NULL DEFAULT '0' COMMENT '步骤',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sys_updateevent`
--

LOCK TABLES `sys_updateevent` WRITE;
/*!40000 ALTER TABLE `sys_updateevent` DISABLE KEYS */;
/*!40000 ALTER TABLE `sys_updateevent` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sys_videodisplayrules`
--

DROP TABLE IF EXISTS `sys_videodisplayrules`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sys_videodisplayrules` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `ipaddress` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `displayindex` int(8) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sys_videodisplayrules`
--

LOCK TABLES `sys_videodisplayrules` WRITE;
/*!40000 ALTER TABLE `sys_videodisplayrules` DISABLE KEYS */;
/*!40000 ALTER TABLE `sys_videodisplayrules` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `vm_appointment`
--

DROP TABLE IF EXISTS `vm_appointment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `vm_appointment` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `appointmentNo` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '访客编号',
  `personno` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '人员编号',
  `visitorid` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0' COMMENT '访客ID',
  `visitorname` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '访客姓名',
  `visitortype` int(255) NOT NULL DEFAULT '0' COMMENT '访客类型',
  `credentialno` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '凭证编号',
  `credentialtype` int(255) NOT NULL DEFAULT '0' COMMENT '凭证类型',
  `cardfaceno` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '卡面号',
  `plate` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '车牌号码',
  `identityno` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '证件号码',
  `identitytype` int(255) NOT NULL DEFAULT '0' COMMENT '证件类型',
  `sex` int(255) NOT NULL DEFAULT '0' COMMENT '性别',
  `telephone` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '手机号码',
  `visitreason` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '访问缘由',
  `bookingtime` datetime NOT NULL DEFAULT '1970-01-01 00:00:00' COMMENT '预定时间',
  `starttime` datetime NOT NULL DEFAULT '1970-01-01 00:00:00' COMMENT '开始时间',
  `endtime` datetime NOT NULL DEFAULT '1970-01-01 00:00:00' COMMENT '结束时间',
  `week` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '星期重复',
  `weekstarttime` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '星期开始时间HH：mm',
  `weekendtime` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '星期结束时间HH：mm',
  `registerType` int(11) NOT NULL DEFAULT '0' COMMENT '登记类型',
  `sealid` int(11) NOT NULL DEFAULT '0' COMMENT '套餐ID',
  `followcount` int(11) NOT NULL DEFAULT '0' COMMENT '随行人数',
  `photopath` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '图片地址',
  `status` int(255) NOT NULL DEFAULT '0' COMMENT '状态（0正常1撤销2已入场）',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='访客预约表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `vm_appointment`
--

LOCK TABLES `vm_appointment` WRITE;
/*!40000 ALTER TABLE `vm_appointment` DISABLE KEYS */;
/*!40000 ALTER TABLE `vm_appointment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `vm_record`
--

DROP TABLE IF EXISTS `vm_record`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `vm_record` (
  `id` bigint(255) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `visitorid` bigint(255) NOT NULL DEFAULT '0' COMMENT '访客ID',
  `enterid` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '入场记录ID',
  `personname` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '被访人姓名',
  `personno` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '被访人编号',
  `visitorname` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '访客姓名',
  `visitortype` int(255) NOT NULL DEFAULT '0' COMMENT '访客类型',
  `credentialno` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '凭证编号',
  `credentialtype` int(255) NOT NULL DEFAULT '0' COMMENT '凭证类型',
  `plate` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '车牌号码',
  `identityno` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '证件号码',
  `identitytype` int(255) NOT NULL DEFAULT '0' COMMENT '证件类型',
  `sex` int(255) NOT NULL DEFAULT '0' COMMENT '性别',
  `telephone` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '手机号码',
  `visitreason` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '来访缘由',
  `followcount` int(255) unsigned NOT NULL DEFAULT '0' COMMENT '随行人数',
  `visittime` datetime NOT NULL DEFAULT '1970-01-01 00:00:00' COMMENT '访问时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='访客记录表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `vm_record`
--

LOCK TABLES `vm_record` WRITE;
/*!40000 ALTER TABLE `vm_record` DISABLE KEYS */;
/*!40000 ALTER TABLE `vm_record` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Final view structure for view `park_view_querytempfees`
--

/*!50001 DROP VIEW IF EXISTS `park_view_querytempfees`*/;
/*!50001 SET @saved_cs_client          = @@character_set_client */;
/*!50001 SET @saved_cs_results         = @@character_set_results */;
/*!50001 SET @saved_col_connection     = @@collation_connection */;
/*!50001 SET character_set_client      = utf8 */;
/*!50001 SET character_set_results     = utf8 */;
/*!50001 SET collation_connection      = utf8_general_ci */;
/*!50001 CREATE ALGORITHM=UNDEFINED */
/*!50013 DEFINER=`root`@`127.0.0.1` SQL SECURITY DEFINER */
/*!50001 VIEW `park_view_querytempfees` AS select `a`.`id` AS `id`,`a`.`enterid` AS `enterid`,`b`.`id` AS `outid`,`a`.`intime` AS `intime`,`a`.`feestime` AS `feestime`,`a`.`createtime` AS `createtime`,`a`.`ordertype` AS `ordertype`,`a`.`status` AS `status`,`a`.`paytime` AS `paytime`,`a`.`setmealid` AS `setmealid`,`a`.`setmealname` AS `setmealname`,`a`.`fees` AS `fees`,`a`.`benefit` AS `benefit`,`a`.`derate` AS `derate`,`a`.`accountreceivable` AS `accountreceivable`,`a`.`paid` AS `paid`,`a`.`actualpaid` AS `actualpaid`,`a`.`exchanged` AS `exchanged`,`a`.`paytypename` AS `paytypename`,`a`.`chargetype` AS `chargetype`,`a`.`remark` AS `remark`,`a`.`operatorid` AS `operatorid`,`a`.`operatorname` AS `operatorname`,`a`.`operatorno` AS `operatorno`,`a`.`workstationip` AS `workstationip`,`a`.`credentialno` AS `plate`,`a`.`chargedevicename` AS `chargedevicename`,`c`.`entertime` AS `entertime`,`c`.`enterdeviceid` AS `enterdeviceid`,`c`.`enterdevicename` AS `enterdevicename`,`c`.`enterpicture` AS `enterpicture`,`b`.`outtime` AS `outtime`,`b`.`outdeviceid` AS `outdeviceid`,`b`.`outdevicename` AS `outdevicename`,`b`.`outpicture` AS `outpicture` from ((`finance_bill` `a` left join `park_outrecord` `b` on(((`a`.`enterid` = `b`.`enterrecordid`) and (`a`.`feestime` <= `b`.`outtime`)))) left join `park_enterrecord` `c` on((`a`.`enterid` = `c`.`id`))) where ((`a`.`enterid` <> 0) and (`a`.`replacededuct` = 0)) union select `a`.`id` AS `id`,`a`.`enterid` AS `enterid`,`b`.`id` AS `outid`,`a`.`intime` AS `intime`,`a`.`feestime` AS `feestime`,`a`.`createtime` AS `createtime`,`a`.`ordertype` AS `ordertype`,`a`.`status` AS `status`,`a`.`paytime` AS `paytime`,`a`.`setmealid` AS `setmealid`,`a`.`setmealname` AS `setmealname`,`a`.`fees` AS `fees`,`a`.`benefit` AS `benefit`,`a`.`derate` AS `derate`,`a`.`accountreceivable` AS `accountreceivable`,`a`.`paid` AS `paid`,`a`.`actualpaid` AS `actualpaid`,`a`.`exchanged` AS `exchanged`,`a`.`paytypename` AS `paytypename`,`a`.`chargetype` AS `chargetype`,`a`.`remark` AS `remark`,`a`.`operatorid` AS `operatorid`,`a`.`operatorname` AS `operatorname`,`a`.`operatorno` AS `operatorno`,`a`.`workstationip` AS `workstationip`,`a`.`credentialno` AS `plate`,`a`.`chargedevicename` AS `chargedevicename`,'' AS `entertime`,'' AS `enterdeviceid`,'' AS `enterdevicename`,'' AS `enterpicture`,`b`.`outtime` AS `outtime`,`b`.`outdeviceid` AS `outdeviceid`,`b`.`outdevicename` AS `outdevicename`,`b`.`outpicture` AS `outpicture` from (`finance_bill` `a` left join `park_outrecord` `b` on((`a`.`feestime` <= `b`.`outtime`))) where ((`a`.`enterid` = 0) and (`a`.`replacededuct` = 0)) */;
/*!50001 SET character_set_client      = @saved_cs_client */;
/*!50001 SET character_set_results     = @saved_cs_results */;
/*!50001 SET collation_connection      = @saved_col_connection */;

--
-- Final view structure for view `park_view_querythroughout`
--

/*!50001 DROP VIEW IF EXISTS `park_view_querythroughout`*/;
/*!50001 SET @saved_cs_client          = @@character_set_client */;
/*!50001 SET @saved_cs_results         = @@character_set_results */;
/*!50001 SET @saved_col_connection     = @@collation_connection */;
/*!50001 SET character_set_client      = utf8 */;
/*!50001 SET character_set_results     = utf8 */;
/*!50001 SET collation_connection      = utf8_general_ci */;
/*!50001 CREATE ALGORITHM=UNDEFINED */
/*!50013 DEFINER=`root`@`127.0.0.1` SQL SECURITY DEFINER */
/*!50001 VIEW `park_view_querythroughout` AS select `a`.`id` AS `outid`,`a`.`plate` AS `plate`,`a`.`operatorid` AS `operatorid`,`a`.`operatorname` AS `operatorname`,`a`.`outdeviceid` AS `outdeviceid`,`a`.`enterouttype` AS `enterouttype`,`a`.`outdevicename` AS `outdevicename`,`a`.`outtime` AS `outtime`,`a`.`outpicture` AS `outpicture`,`a`.`accountreceivable` AS `accountreceivable`,`b`.`id` AS `enterid`,`b`.`entertime` AS `entertime`,`b`.`enterdeviceid` AS `enterdeviceid`,`b`.`enterdevicename` AS `enterdevicename`,`b`.`enterpicture` AS `enterpicture`,`a`.`mealid` AS `setmealid`,`a`.`setmealname` AS `setmealname`,`a`.`personname` AS `personname`,_utf8'现金' AS `PayTypeName`,`a`.`allCharge` AS `Fees`,`a`.`allBenefit` AS `Benefit`,`a`.`eventtype` AS `eventtype` from (`park_outrecord` `a` left join `park_enterrecord` `b` on((`a`.`enterrecordid` = `b`.`id`))) */;
/*!50001 SET character_set_client      = @saved_cs_client */;
/*!50001 SET character_set_results     = @saved_cs_results */;
/*!50001 SET collation_connection      = @saved_col_connection */;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2018-01-30 10:58:12
