﻿SET FOREIGN_KEY_CHECKS=0;
ALTER TABLE `crd_area` ENGINE=InnoDB,
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_unicode_ci,
ROW_FORMAT=Compact;
ALTER TABLE `crd_infopublishfile` DEFAULT CHARACTER SET=utf8 COLLATE=utf8_unicode_ci;
ALTER TABLE `crd_projectinfo` DEFAULT CHARACTER SET=utf8 COLLATE=utf8_unicode_ci;
ALTER TABLE `park_simulatereadcard` DEFAULT CHARACTER SET=utf8 COLLATE=utf8_unicode_ci;
ALTER TABLE `park_systemevent` DEFAULT CHARACTER SET=utf8 COLLATE=utf8_unicode_ci;
ALTER TABLE `sync_center_downloadprocess` DEFAULT CHARACTER SET=utf8 COLLATE=utf8_unicode_ci;

DROP TABLE IF EXISTS `sync_controller_record`;
CREATE TABLE `sync_controller_record` (
`id`  bigint(20) NOT NULL AUTO_INCREMENT COMMENT '自增ID' ,
`serviceid`  varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '协议命令字' ,
`deviceid`  bigint(255) UNSIGNED NOT NULL DEFAULT 0 COMMENT '设备id' ,
`jsondata`  text CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL COMMENT '请求json字符串' ,
`status`  int(255) NOT NULL DEFAULT 0 COMMENT '发送状态0失败1成功' ,
`optdate`  timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '插入中间表时间' ,
`failedcount`  int(11) NOT NULL DEFAULT 0 COMMENT '发送失败次数' ,
PRIMARY KEY (`id`, `failedcount`),
INDEX `index_deviceid` (`deviceid`) USING BTREE ,
INDEX `index_status` (`status`) USING BTREE ,
INDEX `index_failedcount` (`failedcount`) USING BTREE ,
INDEX `index_optdate` (`optdate`) USING BTREE 
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_unicode_ci
ROW_FORMAT=Compact
;

DROP TABLE IF EXISTS `sys_videodisplayrules`;
CREATE TABLE `sys_videodisplayrules` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '控制机名称',
  `ipaddress` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '控制机IP地址',
  `displayindex` int(8) NOT NULL DEFAULT '1' COMMENT '视频口显示索引',
  `masterid` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '控制机ID',
  `cameraip` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '摄像头IP',
  `channel` int(11) NOT NULL DEFAULT '0' COMMENT '通道号',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

DROP TABLE IF EXISTS `opt_view_operator`;
DROP TABLE IF EXISTS `sync_center_download`;
DROP TABLE IF EXISTS `sync_controller_chargerecord`;
DROP TABLE IF EXISTS `sync_controller_enterrecord`;
DROP TABLE IF EXISTS `sync_controller_outrecord`;
DROP VIEW IF EXISTS `park_view_querytempfees`;
DROP VIEW IF EXISTS  `park_view_querythroughout`;
SET FOREIGN_KEY_CHECKS=1;

SET FOREIGN_KEY_CHECKS=0;
DROP PROCEDURE IF EXISTS Del_idx;
DELIMITER $$
CREATE PROCEDURE `Del_idx`(IN p_tablename varchar(200), IN p_idxname VARCHAR(200))
BEGIN
DECLARE str VARCHAR(250);
SET @str=CONCAT('drop index ',p_idxname,' on ',p_tablename);
SELECT count(*) INTO @cnt FROM information_schema.statistics WHERE TABLE_NAME=p_tablename AND INDEX_NAME=p_idxname;
IF @cnt >0 then 
PREPARE stmt FROM @str;
EXECUTE stmt ;
END IF;
END $$

DELIMITER ;

CALL Del_idx('crd_credential', 'index_credentialid');
CALL Del_idx('crd_person', 'index_personid');
CALL Del_idx('crd_virtualslot', 'index_virtualslotid');
CALL Del_idx('crd_virtualslot', 'index_virtualslotpersonid');
CALL Del_idx('park_requestbuffer', 'index_requestbufferrecordid');

CREATE UNIQUE INDEX `index_credentialid` ON `crd_credential`(`id`) USING BTREE ;
CREATE UNIQUE INDEX `index_personid` ON `crd_person`(`ID`) USING BTREE ;
CREATE UNIQUE INDEX `index_virtualslotid` ON `crd_virtualslot`(`id`) USING BTREE ;
CREATE INDEX `index_virtualslotpersonid` ON `crd_virtualslot`(`personid`) USING BTREE ;
CREATE UNIQUE INDEX `index_requestbufferrecordid` ON `park_requestbuffer`(`recordid`) USING BTREE ;

SET FOREIGN_KEY_CHECKS=1;

-- update sys_boxinformation set systemver='V1.0.2',databasever='V1.0.2';