<?php
load()->model('module');


function refund_order_can_refund($module, $tid) {
    global $_W;
    $paylog = pdo_get('core_paylog', array('uniacid' => $_W['uniacid'], 'tid' => $tid, 'module' => $module));
    if (empty($paylog)) {
        return error(1, '订单不存在');
    }
    if ($paylog['status'] != 1) {
        return error(1, '此订单还未支付成功不可退款');
    }
    $refund_amount = pdo_getcolumn('core_refundlog', array('uniacid' => $_W['uniacid'], 'status' => 1, 'uniontid' => $paylog['uniontid']), 'SUM(fee)');
    if ($refund_amount >= $paylog['card_fee']) {
        return error(1, '订单已退款成功');
    }
    return true;
}


function refund_create_order($tid, $module, $fee = 0, $reason = '拼团失败') {


    global $_W;
    $order_can_refund = refund_order_can_refund($module, $tid);
    if (is_error($order_can_refund)) {
        return $order_can_refund;
    }
    $module_info = module_fetch($module);
    $moduleid =  empty($module_info['mid']) ? '000000' : sprintf("%06d", $module_info['mid']);
    $refund_uniontid = date('YmdHis') . $moduleid . random(8,1);
    $paylog = pdo_get('core_paylog', array('uniacid' => $_W['uniacid'], 'tid' => $tid, 'module' => $module));
    $refund = array (
        'uniacid' => $_W['uniacid'],
        'uniontid' => $paylog['uniontid'],
        'fee' => empty($fee) ? $paylog['card_fee'] : $fee,
        'status' => 0,
        'refund_uniontid' => $refund_uniontid,
        'reason' => $reason
    );
    pdo_insert('core_refundlog', $refund);
    return pdo_insertid();
}


function refund($refund_id,$record_id,$mod) {
    global $_W;
    $refundlog = pdo_get('core_refundlog', array('id' => $refund_id));
    $paylog = pdo_get('core_paylog', array('uniacid' => $_W['uniacid'], 'uniontid' => $refundlog['uniontid']));

    $refund_param = reufnd_wechat_build($refund_id);
    $response = wxpay_refund($refund_param);
    unlink(ATTACHMENT_ROOT . $_W['uniacid'] . '_wechat_refund_all.pem');
    if (is_error($response)) {
        pdo_update('core_refundlog', array('status' => '-1'), array('id' => $refund_id));
        return $response;
    } else {
        if($mod == 'groupbuy'){
            pdo_update('ypuk_kjb_grouprecord', array('refund' => '1'), array('id' => $record_id));
            return $response;
        }else{
            return 'ok';
        }

    }
}



function reufnd_wechat_build($refund_id) {
    global $_W;
    $setting = uni_setting_load('payment', $_W['uniacid']);

    $refund_setting = $setting['payment']['wechat_refund'];
    if ($refund_setting['switch'] != 1) {
        return error(1, '未开启微信退款功能！');
    }
    if (empty($refund_setting['key']) || empty($refund_setting['cert'])) {
        return error(1, '缺少微信证书！');
    }

    $refundlog = pdo_get('core_refundlog', array('id' => $refund_id));
    $paylog = pdo_get('core_paylog', array('uniacid' => $_W['uniacid'], 'uniontid' => $refundlog['uniontid']));
    $account = uni_fetch($_W['uniacid']);
    $refund_param = array(
        'appid' => $account['key'],
        'mch_id' => $setting['payment']['wechat']['mchid'],
        'out_trade_no' => $refundlog['uniontid'],
        'out_refund_no' => $refundlog['refund_uniontid'],
        'total_fee' => $paylog['card_fee'] * 100,
        'refund_fee' => $refundlog['fee'] * 100,
        'nonce_str' => random(8),
        'refund_desc' => $refundlog['reason']
    );


    $cert = authcode($refund_setting['cert'], 'DECODE');

    $key = authcode($refund_setting['key'], 'DECODE');
    file_put_contents(ATTACHMENT_ROOT . $_W['uniacid'] . '_wechat_refund_all.pem', $cert . $key);
    return $refund_param;
}

function wxpay_refund($params) {
    global $_W;
    $params['sign'] = wxpay_bulidSign($params);
    $result = wxpay_requestApi('https://api.mch.weixin.qq.com/secapi/pay/refund', $params, array(CURLOPT_SSLCERT => ATTACHMENT_ROOT . $_W['uniacid'] . '_wechat_refund_all.pem'));
    return $result;
}

function wxpay_bulidSign($params) {
    global $_W;
    $setting = uni_setting_load('payment', $_W['uniacid']);
    unset($params['sign']);
    ksort($params);
    $string = wxpay_array2url($params);
    $string = $string . "&key=".$setting['payment']['wechat']['signkey'];
    $string = md5($string);
    $result = strtoupper($string);

    return $result;
}
function wxpay_array2url($params) {
    $str = '';
    $ignore = array('coupon_refund_fee', 'coupon_refund_count');
    foreach($params as $key => $val) {
        if((empty($val) || is_array($val)) && !in_array($key, $ignore)) {
            continue;
        }
        $str .= "{$key}={$val}&";
    }
    $str = trim($str, '&');
    return $str;
}
function wxpay_requestApi($url, $params, $extra = array()) {
    load()->func('communication');
    $xml = array2xml($params);
    $response = ihttp_request($url, $xml, $extra);
    if(is_error($response)) {
        return $response;
    }
    $result = wxpay_parseResult($response['content']);
    return $result;
}
function wxpay_parseResult($result) {
    if(substr($result, 0 , 5) != "<xml>"){
        return $result;
    }
    $result = json_decode(json_encode(isimplexml_load_string($result, 'SimpleXMLElement', LIBXML_NOCDATA)), true);
    if(!is_array($result)) {
        return error(-1, 'xml结构错误');
    }
    if((isset($result['return_code']) && $result['return_code'] != 'SUCCESS') || ($result['err_code'] == 'ERROR' && !empty($result['err_code_des']))) {
        $msg = empty($result['return_msg']) ? $result['err_code_des'] : $result['return_msg'];
        return error(-1, $msg);
    }
    if(wxpay_bulidSign($result) != $result['sign']) {
        return error(-1, '验证签名出错');
    }
    return $result;
}
