<?php

defined('IN_IA') or exit('Access Denied');
define('YPUK_KJB', 'ypuk_kjb');
define('YPUK_KJB_RES', '../addons/' . YPUK_KJB . "/");
require_once IA_ROOT . '/addons/' . YPUK_KJB . '/dbconfig.class.php';
class Ypuk_KjbModuleSite extends WeModuleSite
{
    public $acid;
    public static $KJ_STATUS_WKS = 0;
    public static $KJ_STATUS_ZC = 1;
    public static $KJ_STATUS_JS = 2;
    public static $KJ_STATUS_XD = 3;
    public static $KJ_STATUS_GM = 4;
    public static $KJ_STATUS_YFH = 5;
    public static $KJ_STATUS_YWC = 6;
    public static $KJ_STATUS_YTK = 9;
    public static $TIP_DIALOG = 1;
    public static $TIP_U_FIRST = 2;
    public static $TIP_U_ALREADY = 3;
    public static $TIP_RANK = 4;
    public static $TIP_FK_FIRST = 5;
    public static $TIP_FK_ALREADY = 6;
    public $Setting;
    public function __construct()
    {
        global $_W;
        $servername = trim($_SERVER['SERVER_NAME']);
        $verifyurl = file_get_contents('https://127.0.0.1/kjb_check.php?domain=' . $servername);
        if (!empty($verifyurl)) {
            load()->classs('cloudapi');
            $api = new CloudApi();
            $result = $api->get('site', 'module');
            if (!empty($result)) {
                if ($result['errno'] && $result['errno'] > 0) {
                    die;
                }
                if ($result['trade'] == 0 && $result['development'] == 0) {
                    die;
                }
            }
        }
        $indexcount = pdo_fetchcolumn('SELECT COUNT(*) FROM ' . tablename(DBCONFIG::$TABLE_KJB_ACTIVITYINDEX));
        if ($indexcount == 0) {
            $kanjialist = pdo_fetchall("SELECT * FROM " . tablename(DBCONFIG::$TABLE_KJB_ACTIVITY) . "  ORDER BY createtime DESC, id DESC");
            if (!empty($kanjialist)) {
                foreach ($kanjialist as $key => $val) {
                    $data = array('weid' => $val['weid'], 'aid' => $val['id'], 'type' => $val['type'], 'catid' => $val['catid'], 'businessid' => $val['businessid'], 'starttime' => $val['starttime'], 'endtime' => $val['endtime'], 'createtime' => $val['createtime'], 'recommend' => $val['recommend'], 'status' => $val['status'], 'activitytype' => 1, 'stock' => $val['stock']);
                    pdo_insert(DBCONFIG::$TABLE_KJB_ACTIVITYINDEX, $data);
                }
            }
            $panicbuylist = pdo_fetchall("SELECT * FROM " . tablename(DBCONFIG::$TABLE_KJB_PANICBUY) . "  ORDER BY createtime DESC, id DESC");
            if (!empty($panicbuylist)) {
                foreach ($panicbuylist as $key => $val) {
                    $data = array('weid' => $val['weid'], 'aid' => $val['id'], 'type' => $val['type'], 'catid' => $val['catid'], 'businessid' => $val['businessid'], 'starttime' => $val['starttime'], 'endtime' => $val['endtime'], 'createtime' => $val['createtime'], 'recommend' => $val['recommend'], 'status' => $val['status'], 'activitytype' => 2, 'stock' => $val['stock']);
                    pdo_insert(DBCONFIG::$TABLE_KJB_ACTIVITYINDEX, $data);
                }
            }
            $groupbuylist = pdo_fetchall("SELECT * FROM " . tablename(DBCONFIG::$TABLE_KJB_GROUPBUY) . "  ORDER BY createtime DESC, id DESC");
            if (!empty($groupbuylist)) {
                foreach ($groupbuylist as $key => $val) {
                    $data = array('weid' => $val['weid'], 'aid' => $val['id'], 'type' => $val['type'], 'catid' => $val['catid'], 'businessid' => $val['businessid'], 'starttime' => $val['starttime'], 'endtime' => $val['endtime'], 'createtime' => $val['createtime'], 'recommend' => $val['recommend'], 'status' => $val['status'], 'activitytype' => 3, 'stock' => $val['stock']);
                    pdo_insert(DBCONFIG::$TABLE_KJB_ACTIVITYINDEX, $data);
                }
            }
        }
    }
    public function doWebActivity()
    {
        global $_W, $_GPC;
        $operation = !empty($_GPC['op']) ? $_GPC['op'] : 'display';
        $id = $_GPC['id'];
        if ($operation == 'display') {
            $pindex = max(1, intval($_GPC['page']));
            $psize = 20;
            $list = pdo_fetchall("SELECT * FROM " . tablename(DBCONFIG::$TABLE_KJB_ACTIVITY) . " WHERE weid =:weid  ORDER BY createtime DESC, id DESC LIMIT " . ($pindex - 1) * $psize . ',' . $psize, array(':weid' => $this->weid));
            foreach ($list as $key => $val) {
                if ($val['pic']) {
                    $list[$key]['pic'] = unserialize($val['pic']);
                    $list[$key]['pic'] = tomedia($list[$key]['pic'][0]);
                }
                if ($val['catid']) {
                    $catinfo = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_CATEGORY) . "WHERE weid='{$_W['weid']}' AND id='{$val['catid']}'");
                    $list[$key]['catname'] = $catinfo['name'];
                }
            }
            $total = pdo_fetchcolumn('SELECT COUNT(*) FROM ' . tablename(DBCONFIG::$TABLE_KJB_ACTIVITY) . " WHERE weid =:weid ", array(':weid' => $this->weid));
            $pager = pagination($total, $pindex, $psize);
        } else {
            if ($operation == 'post') {
                $category = pdo_fetchall("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_CATEGORY) . " WHERE weid = '{$_W['weid']}' AND enabled=1 AND type=1");
                $businesses = pdo_fetchall("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_BUSINESS) . "WHERE weid = :weid", array(':weid' => $_W['weid']));
                if (!empty($id)) {
                    $activity = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_ACTIVITY) . "WHERE weid='{$_W['weid']}' AND id='{$id}'");
                    $activity['poster'] = tomedia('/ypuk_kjb/activity_' . $id . '_1_' . $_W['weid'] . '.jpg');
                    $activity['starttime'] = date("Y-m-d  H:i", $activity['starttime']);
                    $activity['endtime'] = date("Y-m-d  H:i", $activity['endtime']);
                    $activity['intro'] = htmlspecialchars_decode($activity['intro']);
                    if ($activity['pic']) {
                        $activity['pic'] = unserialize($activity['pic']);
                    }
                    if ($activity['businessid'] != 0) {
                        $businessinfo = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_BUSINESS) . "WHERE weid='{$_W['weid']}' AND id='{$activity['businessid']}'");
                        $activity['businessname'] = $businessinfo['name'];
                    }
                    $rule_items = unserialize($activity['bargain_rule']);
                    if (!empty($activity['joinqun_setting'])) {
                        $joinqun_data = unserialize($activity['joinqun_setting']);
                    }
                }
                if ($_W['ispost']) {
                    if ($_GPC['type'] == 1 && empty($_GPC['vpassword'])) {
                        message('活动类型为服务类时请配置核销密码', referer(), 'warning');
                    }
                    $bargain_rules = array();
                    $rule_ids = $_GPC['rule_id'];
                    $rule_prices = $_GPC['rule_pice'];
                    $rule_start = $_GPC['rule_start'];
                    $rule_end = $_GPC['rule_end'];
                    if (is_array($rule_ids)) {
                        foreach ($rule_ids as $key => $value) {
                            $d = array('rule_pice' => $rule_prices[$key], 'rule_start' => $rule_start[$key], 'rule_end' => $rule_end[$key]);
                            $bargain_rules[] = $d;
                        }
                    }
                    if (!empty($_GPC['mappoint'])) {
                        $longitude = $_GPC['mappoint']['lng'];
                        $latitude = $_GPC['mappoint']['lat'];
                    } else {
                        $longitude = 0;
                        $latitude = 0;
                    }
                    if ($_GPC['businessid'] && $_GPC['businessid'] != 'no') {
                        $businessid = $_GPC['businessid'];
                    } else {
                        $businessid = '';
                    }
                    $joinqun = array('joinqun_icon' => $_GPC['joinqun_icon'], 'joinqun_title' => $_GPC['joinqun_title'], 'joinqun_desc' => $_GPC['joinqun_desc'], 'joinqun_tips_type' => $_GPC['joinqun_tips_type'], 'joinqun_tips_img' => $_GPC['joinqun_tips_img'], 'joinqun_tips_text' => $_GPC['joinqun_tips_text']);
                    $data = array('weid' => $_W['weid'], 'title' => $_GPC['title'], 'type' => $_GPC['type'], 'starttime' => strtotime($_GPC['starttime']), 'endtime' => strtotime($_GPC['endtime']), 'stock' => $_GPC['stock'], 'oldprice' => $_GPC['oldprice'], 'lowprice' => $_GPC['lowprice'], 'pic' => serialize($_GPC['pic']), 'freight' => $_GPC['freight'], 'intro' => htmlspecialchars($_GPC['intro']), 'pay_type' => $_GPC['pay_type'], 'opbuy' => $_GPC['opbuy'], 'opbuy_price' => $_GPC['opbuy_price'], 'goodmodel' => $_GPC['goodmodel'], 'allowcity' => $_GPC['allowcity'], 'bargain_rule' => serialize($bargain_rules), 'createtime' => TIMESTAMP, 'friend_help_limit' => $_GPC['friend_help_limit'], 'vpassword' => $_GPC['vpassword'], 'viewnum_min' => $_GPC['viewnum_min'], 'bargainnum_min' => $_GPC['bargainnum_min'], 'helpnum_min' => $_GPC['helpnum_min'], 'catid' => $_GPC['catid'], 'recommend' => $_GPC['recommend'], 'validity' => empty($_GPC['validity']) ? 0 : strtotime($_GPC['validity']), 'business_name' => $_GPC['business_name'], 'business_address' => $_GPC['business_address'], 'business_tel' => $_GPC['business_tel'], 'business_time' => $_GPC['business_time'], 'business_longitude' => $longitude, 'business_latitude' => $latitude, 'status' => $_GPC['status'], 'businessid' => $businessid, 'share_detailtitle' => $_GPC['share_detailtitle'], 'share_bargaintitle' => $_GPC['share_bargaintitle'], 'sharepic' => $_GPC['sharepic'], 'joinqun_setting' => serialize($joinqun), 'joinqun_open' => $_GPC['joinqun_open'], 'bargain_time' => $_GPC['bargain_time']);
                    if (empty($id)) {
                        pdo_insert(DBCONFIG::$TABLE_KJB_ACTIVITY, $data);
                        $aid = pdo_insertid();
                        $indexdata = array('weid' => $_W['weid'], 'aid' => $aid, 'type' => $_GPC['type'], 'catid' => $_GPC['catid'], 'businessid' => $businessid, 'starttime' => strtotime($_GPC['starttime']), 'endtime' => strtotime($_GPC['endtime']), 'createtime' => TIMESTAMP, 'stock' => $_GPC['stock'], 'recommend' => $_GPC['recommend'], 'status' => $_GPC['status'], 'activitytype' => 1);
                        pdo_insert(DBCONFIG::$TABLE_KJB_ACTIVITYINDEX, $indexdata);
                        message('添加成功', referer(), 'success');
                    } else {
                        pdo_update(DBCONFIG::$TABLE_KJB_ACTIVITY, $data, array('id' => $id));
                        $indexdata = array('weid' => $_W['weid'], 'aid' => $id, 'type' => $_GPC['type'], 'catid' => $_GPC['catid'], 'businessid' => $businessid, 'starttime' => strtotime($_GPC['starttime']), 'endtime' => strtotime($_GPC['endtime']), 'createtime' => TIMESTAMP, 'stock' => $_GPC['stock'], 'recommend' => $_GPC['recommend'], 'status' => $_GPC['status']);
                        pdo_update(DBCONFIG::$TABLE_KJB_ACTIVITYINDEX, $indexdata, array('aid' => $id, 'activitytype' => 1));
                        message('更新成功', referer(), 'success');
                    }
                }
            } else {
                if ($operation == 'delete') {
                    $id = $_GPC['id'];
                    pdo_delete(DBCONFIG::$TABLE_KJB_ORDER, array("aid" => $id, "type" => 1));
                    pdo_delete(DBCONFIG::$TABLE_KJB_ACTIVITYINDEX, array("aid" => $id, "activitytype" => 1));
                    pdo_delete(DBCONFIG::$TABLE_KJB_RECORD, array("aid" => $id));
                    pdo_delete(DBCONFIG::$TABLE_KJB_BARGAIN, array("aid" => $id));
                    pdo_delete(DBCONFIG::$TABLE_KJB_ACTIVITY, array('id' => $id));
                    message('删除成功！', referer(), 'success');
                }
            }
        }
        include $this->template("activity_manage");
    }
    public function doWebGroupBuy()
    {
        global $_W, $_GPC;
        $operation = !empty($_GPC['op']) ? $_GPC['op'] : 'display';
        $id = $_GPC['id'];
        if ($operation == 'display') {
            $pindex = max(1, intval($_GPC['page']));
            $psize = 20;
            $list = pdo_fetchall("SELECT * FROM " . tablename(DBCONFIG::$TABLE_KJB_GROUPBUY) . " WHERE weid =:weid  ORDER BY createtime DESC, id DESC LIMIT " . ($pindex - 1) * $psize . ',' . $psize, array(':weid' => $this->weid));
            foreach ($list as $key => $val) {
                if ($val['pic']) {
                    $list[$key]['pic'] = unserialize($val['pic']);
                    $list[$key]['pic'] = tomedia($list[$key]['pic'][0]);
                }
                if ($val['catid']) {
                    $catinfo = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_CATEGORY) . "WHERE weid='{$_W['weid']}' AND id='{$val['catid']}'");
                    $list[$key]['catname'] = $catinfo['name'];
                }
            }
            $total = pdo_fetchcolumn('SELECT COUNT(*) FROM ' . tablename(DBCONFIG::$TABLE_KJB_GROUPBUY) . " WHERE weid =:weid ", array(':weid' => $this->weid));
            $pager = pagination($total, $pindex, $psize);
        } else {
            if ($operation == 'post') {
                $category = pdo_fetchall("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_CATEGORY) . " WHERE weid = '{$_W['weid']}' AND enabled=1 AND type=3");
                $businesses = pdo_fetchall("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_BUSINESS) . "WHERE weid = :weid", array(':weid' => $_W['weid']));
                if (!empty($id)) {
                    $activity = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_GROUPBUY) . "WHERE weid='{$_W['weid']}' AND id='{$id}'");
                    $activity['poster'] = tomedia('/ypuk_kjb/activity_' . $id . '_3_' . $_W['weid'] . '.jpg');
                    $activity['starttime'] = date("Y-m-d  H:i", $activity['starttime']);
                    $activity['endtime'] = date("Y-m-d  H:i", $activity['endtime']);
                    $activity['intro'] = htmlspecialchars_decode($activity['intro']);
                    if ($activity['pic']) {
                        $activity['pic'] = unserialize($activity['pic']);
                    }
                    if ($activity['businessid'] != 0) {
                        $businessinfo = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_BUSINESS) . "WHERE weid='{$_W['weid']}' AND id='{$activity['businessid']}'");
                        $activity['businessname'] = $businessinfo['name'];
                    }
                    if (!empty($activity['joinqun_setting'])) {
                        $joinqun_data = unserialize($activity['joinqun_setting']);
                    }
                }
                if ($_W['ispost']) {
                    if ($_GPC['type'] == 1 && empty($_GPC['vpassword'])) {
                        message('活动类型为服务类时请配置核销密码', referer(), 'warning');
                    }
                    if (!empty($_GPC['mappoint'])) {
                        $longitude = $_GPC['mappoint']['lng'];
                        $latitude = $_GPC['mappoint']['lat'];
                    } else {
                        $longitude = 0;
                        $latitude = 0;
                    }
                    if ($_GPC['businessid'] && $_GPC['businessid'] != 'no') {
                        $businessid = $_GPC['businessid'];
                    } else {
                        $businessid = '';
                    }
                    if ($_GPC['buyopen'] == 1 && empty($_GPC['buyprice'])) {
                        message('开启直接购买功能时，请填写直接购买价格', referer(), 'warning');
                    }
                    if ($_GPC['pay_type'] == 2) {
                        if (empty($_GPC['ol_groupprice'])) {
                            message('支付类型为线上预付线下尾款时，请填写线上支付金额', referer(), 'warning');
                        } else {
                            $ofl_groupprice = $_GPC['groupprice'] - $_GPC['ol_groupprice'];
                        }
                        if ($_GPC['buyopen'] == 1 && empty($_GPC['ol_buyprice'])) {
                            message('支付类型为线上预付线下尾款，且开启直接购买时，请填写线上支付金额', referer(), 'warning');
                        } else {
                            $ofl_buyprice = $_GPC['buyprice'] - $_GPC['ol_buyprice'];
                        }
                    }
                    $joinqun = array('joinqun_icon' => $_GPC['joinqun_icon'], 'joinqun_title' => $_GPC['joinqun_title'], 'joinqun_desc' => $_GPC['joinqun_desc'], 'joinqun_tips_type' => $_GPC['joinqun_tips_type'], 'joinqun_tips_img' => $_GPC['joinqun_tips_img'], 'joinqun_tips_text' => $_GPC['joinqun_tips_text']);
                    $data = array('weid' => $_W['weid'], 'title' => $_GPC['title'], 'type' => $_GPC['type'], 'starttime' => strtotime($_GPC['starttime']), 'endtime' => strtotime($_GPC['endtime']), 'stock' => $_GPC['stock'], 'oldprice' => $_GPC['oldprice'], 'groupprice' => $_GPC['groupprice'], 'pic' => serialize($_GPC['pic']), 'freight' => $_GPC['freight'], 'intro' => htmlspecialchars($_GPC['intro']), 'pay_type' => $_GPC['pay_type'], 'buyopen' => $_GPC['buyopen'], 'buyprice' => $_GPC['buyprice'], 'goodmodel' => $_GPC['goodmodel'], 'allowcity' => $_GPC['allowcity'], 'ol_groupprice' => $_GPC['ol_groupprice'], 'ofl_groupprice' => $ofl_groupprice, 'ol_buyprice' => $_GPC['ol_buyprice'], 'ofl_buyprice' => $ofl_buyprice, 'createtime' => TIMESTAMP, 'grouptime' => empty($_GPC['grouptime']) ? 12 : $_GPC['grouptime'], 'group_success_limit' => $_GPC['group_success_limit'], 'vpassword' => $_GPC['vpassword'], 'viewnum_min' => $_GPC['viewnum_min'], 'groupnum_min' => $_GPC['groupnum_min'], 'helpnum_min' => $_GPC['helpnum_min'], 'catid' => $_GPC['catid'], 'recommend' => $_GPC['recommend'], 'validity' => empty($_GPC['validity']) ? 0 : strtotime($_GPC['validity']), 'status' => $_GPC['status'], 'businessid' => $businessid, 'share_detailtitle' => $_GPC['share_detailtitle'], 'share_bargaintitle' => $_GPC['share_bargaintitle'], 'sharepic' => $_GPC['sharepic'], 'joinqun_setting' => serialize($joinqun), 'joinqun_open' => $_GPC['joinqun_open']);
                    if (empty($id)) {
                        pdo_insert(DBCONFIG::$TABLE_KJB_GROUPBUY, $data);
                        $aid = pdo_insertid();
                        $indexdata = array('weid' => $_W['weid'], 'aid' => $aid, 'type' => $_GPC['type'], 'catid' => $_GPC['catid'], 'businessid' => $businessid, 'starttime' => strtotime($_GPC['starttime']), 'endtime' => strtotime($_GPC['endtime']), 'createtime' => TIMESTAMP, 'stock' => $_GPC['stock'], 'recommend' => $_GPC['recommend'], 'status' => $_GPC['status'], 'activitytype' => 3);
                        pdo_insert(DBCONFIG::$TABLE_KJB_ACTIVITYINDEX, $indexdata);
                        message('添加成功', referer(), 'success');
                    } else {
                        pdo_update(DBCONFIG::$TABLE_KJB_GROUPBUY, $data, array('id' => $id));
                        $indexdata = array('weid' => $_W['weid'], 'aid' => $id, 'type' => $_GPC['type'], 'catid' => $_GPC['catid'], 'businessid' => $businessid, 'starttime' => strtotime($_GPC['starttime']), 'endtime' => strtotime($_GPC['endtime']), 'createtime' => TIMESTAMP, 'stock' => $_GPC['stock'], 'recommend' => $_GPC['recommend'], 'status' => $_GPC['status']);
                        pdo_update(DBCONFIG::$TABLE_KJB_ACTIVITYINDEX, $indexdata, array('aid' => $id, 'activitytype' => 3));
                        message('更新成功', referer(), 'success');
                    }
                }
            } else {
                if ($operation == 'delete') {
                    $id = $_GPC['id'];
                    pdo_delete(DBCONFIG::$TABLE_KJB_ORDER, array("aid" => $id, "type" => 3));
                    pdo_delete(DBCONFIG::$TABLE_KJB_ACTIVITYINDEX, array("aid" => $id, "activitytype" => 3));
                    pdo_delete(DBCONFIG::$TABLE_KJB_GROUPRECORD, array("aid" => $id));
                    pdo_delete(DBCONFIG::$TABLE_KJB_GROUP, array("aid" => $id));
                    pdo_delete(DBCONFIG::$TABLE_KJB_GROUPBUY, array('id' => $id));
                    message('删除成功！', referer(), 'success');
                }
            }
        }
        include $this->template("groupbuy_manage");
    }
    public function doWebGroupbuyOrderList()
    {
        global $_W, $_GPC;
        $operation = !empty($_GPC['op']) ? $_GPC['op'] : 'display';
        $aid = $_GPC['aid'];
        if ($operation == 'display') {
            $activity = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_GROUPBUY) . "WHERE weid='{$_W['weid']}' AND id='{$aid}'");
            $gid = $_GPC['gid'];
            if (empty($activity)) {
                message("拼团活动删除或不存在");
            }
            $keyword = $_GPC['keyword'];
            $where = '';
            $params = array(':aid' => $aid);
            if (!empty($keyword)) {
                $where .= ' and (order_no like :keyword) or (tel like :keyword)';
                $params[':keyword'] = "%{$keyword}%";
            }
            if (!empty($gid)) {
                $where .= ' and gid = :gid ';
                $params[':gid'] = $gid;
            }
            if ($_GPC['status'] != 0) {
                $where .= ' and status =:status';
                $params[':status'] = $_GPC['status'];
            }
            $status = $_GPC['status'];
            $order_time_get = $_GPC['order_time'];
            $starttime = empty($order_time_get['start']) ? strtotime('-1 month') : strtotime($order_time_get['start']);
            $endtime = empty($order_time_get['end']) ? TIMESTAMP : strtotime($order_time_get['end']);
            $where .= ' and createtime >=:starttime and createtime <=:endtime';
            $params[':starttime'] = $starttime;
            $params[':endtime'] = $endtime;
            $order_time = array('start' => date("Y-m-d H:i", $starttime), 'end' => date("Y-m-d H:i", $endtime));
            $pindex = max(1, intval($_GPC['page']));
            $psize = 20;
            $list = pdo_fetchall("SELECT * FROM " . tablename(DBCONFIG::$TABLE_KJB_ORDER) . " WHERE aid =:aid " . $where . " AND type=3 ORDER BY createtime DESC, id DESC LIMIT " . ($pindex - 1) * $psize . ',' . $psize, $params);
            foreach ($list as $key => $val) {
                $list[$key]['pay_price'] = $val['total_price'];
                if ($val['pay_type'] == 2) {
                    if ($val['oporder'] == 1) {
                        $list[$key]['total_price'] = $activity['buyprice'] + $activity['freight'];
                    }
                    if ($val['oporder'] == 0) {
                        $list[$key]['total_price'] = $activity['groupprice'] + $activity['freight'];
                    }
                }
            }
            $total = pdo_fetchcolumn('SELECT COUNT(*) FROM ' . tablename(DBCONFIG::$TABLE_KJB_ORDER) . " WHERE aid =:aid AND type=3 " . $where, $params);
            $pager = pagination($total, $pindex, $psize);
        } else {
            if ($operation == 'delete') {
                $id = $_GPC['id'];
                pdo_delete(DBCONFIG::$TABLE_KJB_ORDER, array("id" => $id));
                message('删除成功！', $this->createWebUrl('GroupbuyOrderList', array('aid' => $aid)), 'success');
            }
        }
        include $this->template("groupbuy_order_list");
    }
    public function doWebGroupbuyOrderDetail()
    {
        global $_W, $_GPC;
        $aid = $_GPC['aid'];
        $oid = $_GPC['oid'];
        $order = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_ORDER) . "WHERE weid='{$_W['weid']}' AND id='{$oid}' AND type=3");
        $activity = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_GROUPBUY) . "WHERE weid='{$_W['weid']}' AND id='{$aid}'");
        $order['pay_price'] = $order['total_price'];
        if ($order['pay_type'] == 2) {
            if ($order['oporder'] == 1) {
                $order['total_price'] = $activity['buyprice'] + $activity['freight'];
            }
            if ($order['oporder'] == 0) {
                $order['total_price'] = $activity['groupprice'] + $activity['freight'];
            }
        }
        include $this->template("groupbuy_order_detail");
    }
    public function doWebGroup()
    {
        global $_W, $_GPC;
        load()->model('mc');
        $operation = !empty($_GPC['op']) ? $_GPC['op'] : 'display';
        if ($operation == 'display') {
            $aid = $_GPC['aid'];
            $activity = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_GROUPBUY) . "WHERE weid='{$_W['weid']}' AND id='{$aid}'");
            if (empty($activity)) {
                message("拼团活动删除或不存在");
            }
            $uid = $_GPC['uid'];
            $where = '';
            $params = array(':aid' => $aid);
            if (!empty($uid)) {
                $where .= ' and (uid = :uid)';
                $params[':uid'] = "{$uid}";
            }
            $pindex = max(1, intval($_GPC['page']));
            $psize = 20;
            $list = pdo_fetchall("SELECT * FROM " . tablename(DBCONFIG::$TABLE_KJB_GROUP) . " WHERE aid =:aid " . $where . "  ORDER BY createtime DESC, id DESC LIMIT " . ($pindex - 1) * $psize . ',' . $psize, $params);
            foreach ($list as $key => $val) {
                $userInfo = mc_fansinfo($val['uid'], $_W['acid'], $_W['uniacid']);
                $list[$key]['nickname'] = $userInfo['nickname'];
                $list[$key]['avatar'] = $userInfo['avatar'];
                if ($val['status'] == 1) {
                    $list[$key]['statustext'] = '待支付';
                }
                if ($val['status'] == 1 && TIMESTAMP > $val['endtime']) {
                    $list[$key]['statustext'] = '拼团失败';
                }
                if ($val['status'] == 1 && TIMESTAMP < $val['endtime']) {
                    $list[$key]['statustext'] = '拼团中';
                }
                if ($val['status'] == 2) {
                    $list[$key]['statustext'] = '已成功';
                }
                $list[$key]['grouprecordnum'] = pdo_fetchcolumn("SELECT COUNT(*) FROM" . tablename(DBCONFIG::$TABLE_KJB_GROUPRECORD) . "WHERE weid='{$_W['weid']}' AND gid='{$val['id']} AND paystatus=1'");
            }
            $total = pdo_fetchcolumn('SELECT COUNT(*) FROM ' . tablename(DBCONFIG::$TABLE_KJB_GROUP) . " WHERE aid =:aid  " . $where, $params);
            $pager = pagination($total, $pindex, $psize);
        } else {
            if ($operation == 'delete') {
                $id = $_GPC['id'];
                pdo_delete(DBCONFIG::$TABLE_KJB_ORDER, array("gid" => $id));
                pdo_delete(DBCONFIG::$TABLE_KJB_GROUPRECORD, array("gid" => $id));
                pdo_delete(DBCONFIG::$TABLE_KJB_GROUP, array("id" => $id));
                message('删除成功！', referer(), 'success');
            }
        }
        include $this->template("group_list");
    }
    public function doWebGroupRecord()
    {
        global $_W, $_GPC;
        $operation = !empty($_GPC['op']) ? $_GPC['op'] : 'display';
        $gid = $_GPC['gid'];
        $aid = $_GPC['aid'];
        $keyword = $_GPC['keywords'];
        $where = '';
        $params = array(':gid' => $gid);
        if (!empty($keyword)) {
            $where .= ' and f.nickname like :nickname';
            $params[':nickname'] = "%{$keyword}%";
        }
        if (!empty($_GPC['uid'])) {
            $where .= ' and f.uid=:uid';
            $params[':uid'] = $_GPC['uid'];
        }
        $group = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_GROUP) . "WHERE weid='{$_W['weid']}' AND id='{$gid}'");
        if ($operation == 'display') {
            $pindex = max(1, intval($_GPC['page']));
            $psize = 20;
            $list = pdo_fetchall("select * from " . tablename(DBCONFIG::$TABLE_KJB_GROUPRECORD) . " f where f.gid=:gid " . $where . " order by f.createtime desc LIMIT " . ($pindex - 1) * $psize . ',' . $psize, $params);
            foreach ($list as $key => $val) {
                $userInfo = mc_fansinfo($val['uid'], $_W['acid'], $_W['uniacid']);
                $list[$key]['nickname'] = $userInfo['nickname'];
                $list[$key]['avatar'] = $userInfo['avatar'];
                if ($group['status'] == 2) {
                    $orderinfo = pdo_fetch("SELECT id FROM" . tablename(DBCONFIG::$TABLE_KJB_ORDER) . "WHERE weid='{$_W['weid']}' AND order_no='{$val['order_no']}' AND gid={$val['gid']}");
                    $list[$key]['oid'] = $orderinfo['id'];
                }
            }
            $total = pdo_fetchcolumn('SELECT COUNT(*) FROM ' . tablename(DBCONFIG::$TABLE_KJB_GROUPRECORD) . " f where f.gid=:gid  " . $where, $params);
            $pager = pagination($total, $pindex, $psize);
        } elseif ($operation == 'delete') {
            $id = $_GPC['id'];
            pdo_delete(DBCONFIG::$TABLE_KJB_GROUPRECORD, array('id' => $id));
            message('删除成功！', referer(), 'success');
        }
        include $this->template('group_record');
    }
    public function doWebPanicBuy()
    {
        global $_W, $_GPC;
        $operation = !empty($_GPC['op']) ? $_GPC['op'] : 'display';
        $id = $_GPC['id'];
        if ($operation == 'display') {
            $pindex = max(1, intval($_GPC['page']));
            $psize = 20;
            $list = pdo_fetchall("SELECT * FROM " . tablename(DBCONFIG::$TABLE_KJB_PANICBUY) . " WHERE weid =:weid  ORDER BY createtime DESC, id DESC LIMIT " . ($pindex - 1) * $psize . ',' . $psize, array(':weid' => $this->weid));
            foreach ($list as $key => $val) {
                if ($val['pic']) {
                    $list[$key]['pic'] = unserialize($val['pic']);
                    $list[$key]['pic'] = tomedia($list[$key]['pic'][0]);
                }
                if ($val['catid']) {
                    $catinfo = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_CATEGORY) . "WHERE weid='{$_W['weid']}' AND id='{$val['catid']}'");
                    $list[$key]['catname'] = $catinfo['name'];
                }
            }
            $total = pdo_fetchcolumn('SELECT COUNT(*) FROM ' . tablename(DBCONFIG::$TABLE_KJB_PANICBUY) . " WHERE weid =:weid ", array(':weid' => $this->weid));
            $pager = pagination($total, $pindex, $psize);
        } else {
            if ($operation == 'post') {
                $category = pdo_fetchall("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_CATEGORY) . " WHERE weid = '{$_W['weid']}' AND enabled=1 AND type=2");
                $businesses = pdo_fetchall("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_BUSINESS) . "WHERE weid = :weid", array(':weid' => $_W['weid']));
                if (!empty($id)) {
                    $activity = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_PANICBUY) . "WHERE weid='{$_W['weid']}' AND id='{$id}'");
                    $activity['poster'] = tomedia('/ypuk_kjb/activity_' . $id . '_2_' . $_W['weid'] . '.jpg');
                    $activity['starttime'] = date("Y-m-d  H:i", $activity['starttime']);
                    $activity['endtime'] = date("Y-m-d  H:i", $activity['endtime']);
                    $activity['intro'] = htmlspecialchars_decode($activity['intro']);
                    if ($activity['pic']) {
                        $activity['pic'] = unserialize($activity['pic']);
                    }
                    if ($activity['businessid'] != 0) {
                        $businessinfo = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_BUSINESS) . "WHERE weid='{$_W['weid']}' AND id='{$activity['businessid']}'");
                        $activity['businessname'] = $businessinfo['name'];
                    }
                    if (!empty($activity['joinqun_setting'])) {
                        $joinqun_data = unserialize($activity['joinqun_setting']);
                    }
                }
                if ($_W['ispost']) {
                    if ($_GPC['type'] == 1 && empty($_GPC['vpassword'])) {
                        message('活动类型为服务类时请配置核销密码', referer(), 'warning');
                    }
                    if ($_GPC['businessid'] && $_GPC['businessid'] != 'no') {
                        $businessid = $_GPC['businessid'];
                    } else {
                        $businessid = '';
                    }
                    $joinqun = array('joinqun_icon' => $_GPC['joinqun_icon'], 'joinqun_title' => $_GPC['joinqun_title'], 'joinqun_desc' => $_GPC['joinqun_desc'], 'joinqun_tips_type' => $_GPC['joinqun_tips_type'], 'joinqun_tips_img' => $_GPC['joinqun_tips_img'], 'joinqun_tips_text' => $_GPC['joinqun_tips_text']);
                    $data = array('weid' => $_W['weid'], 'title' => $_GPC['title'], 'starttime' => strtotime($_GPC['starttime']), 'endtime' => strtotime($_GPC['endtime']), 'stock' => $_GPC['stock'], 'type' => $_GPC['type'], 'oldprice' => $_GPC['oldprice'], 'nowprice' => $_GPC['nowprice'], 'pic' => serialize($_GPC['pic']), 'freight' => $_GPC['freight'], 'intro' => htmlspecialchars($_GPC['intro']), 'pay_type' => $_GPC['pay_type'], 'goodmodel' => $_GPC['goodmodel'], 'allowcity' => $_GPC['allowcity'], 'createtime' => TIMESTAMP, 'buynum_min' => $_GPC['buynum_min'], 'vpassword' => $_GPC['vpassword'], 'viewnum_min' => $_GPC['viewnum_min'], 'allowbuy_limit' => empty($_GPC['allowbuy_limit']) ? 1 : $_GPC['allowbuy_limit'], 'catid' => $_GPC['catid'], 'recommend' => $_GPC['recommend'], 'validity' => empty($_GPC['validity']) ? 0 : strtotime($_GPC['validity']), 'status' => $_GPC['status'], 'businessid' => $businessid, 'share_detailtitle' => $_GPC['share_detailtitle'], 'share_bargaintitle' => $_GPC['share_bargaintitle'], 'sharepic' => $_GPC['sharepic'], 'joinqun_setting' => serialize($joinqun), 'joinqun_open' => $_GPC['joinqun_open']);
                    if (empty($id)) {
                        pdo_insert(DBCONFIG::$TABLE_KJB_PANICBUY, $data);
                        $aid = pdo_insertid();
                        $indexdata = array('weid' => $_W['weid'], 'aid' => $aid, 'type' => $_GPC['type'], 'catid' => $_GPC['catid'], 'businessid' => $businessid, 'starttime' => strtotime($_GPC['starttime']), 'endtime' => strtotime($_GPC['endtime']), 'createtime' => TIMESTAMP, 'stock' => $_GPC['stock'], 'recommend' => $_GPC['recommend'], 'status' => $_GPC['status'], 'activitytype' => 2);
                        pdo_insert(DBCONFIG::$TABLE_KJB_ACTIVITYINDEX, $indexdata);
                        message('添加成功', referer(), 'success');
                    } else {
                        pdo_update(DBCONFIG::$TABLE_KJB_PANICBUY, $data, array('id' => $id));
                        $indexdata = array('weid' => $_W['weid'], 'aid' => $id, 'type' => $_GPC['type'], 'catid' => $_GPC['catid'], 'businessid' => $businessid, 'starttime' => strtotime($_GPC['starttime']), 'endtime' => strtotime($_GPC['endtime']), 'createtime' => TIMESTAMP, 'stock' => $_GPC['stock'], 'recommend' => $_GPC['recommend'], 'status' => $_GPC['status']);
                        pdo_update(DBCONFIG::$TABLE_KJB_ACTIVITYINDEX, $indexdata, array('aid' => $id, 'activitytype' => 2));
                        message('更新成功', referer(), 'success');
                    }
                }
            } else {
                if ($operation == 'delete') {
                    $id = $_GPC['id'];
                    pdo_delete(DBCONFIG::$TABLE_KJB_ORDER, array("aid" => $id, "type" => 2));
                    pdo_delete(DBCONFIG::$TABLE_KJB_ACTIVITYINDEX, array("aid" => $id, "activitytype" => 2));
                    pdo_delete(DBCONFIG::$TABLE_KJB_PANICBUY, array('id' => $id));
                    message('删除成功！', referer(), 'success');
                }
            }
        }
        include $this->template("panicbuy_manage");
    }
    public function doWebPanicbuyOrderList()
    {
        global $_W, $_GPC;
        $operation = !empty($_GPC['op']) ? $_GPC['op'] : 'display';
        $aid = $_GPC['aid'];
        if ($operation == 'display') {
            $activity = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_PANICBUY) . "WHERE weid='{$_W['weid']}' AND id='{$aid}'");
            if (empty($activity)) {
                message("抢购活动删除或不存在");
            }
            $keyword = $_GPC['keyword'];
            $where = '';
            $params = array(':aid' => $aid);
            if (!empty($keyword)) {
                $where .= ' and (order_no like :keyword) or (tel like :keyword)';
                $params[':keyword'] = "%{$keyword}%";
            }
            if ($_GPC['status'] != 0) {
                $where .= ' and status =:status';
                $params[':status'] = $_GPC['status'];
            }
            $status = $_GPC['status'];
            $order_time_get = $_GPC['order_time'];
            $starttime = empty($order_time_get['start']) ? strtotime('-1 month') : strtotime($order_time_get['start']);
            $endtime = empty($order_time_get['end']) ? TIMESTAMP : strtotime($order_time_get['end']);
            $where .= ' and createtime >=:starttime and createtime <=:endtime';
            $params[':starttime'] = $starttime;
            $params[':endtime'] = $endtime;
            $order_time = array('start' => date("Y-m-d H:i", $starttime), 'end' => date("Y-m-d H:i", $endtime));
            $pindex = max(1, intval($_GPC['page']));
            $psize = 20;
            $list = pdo_fetchall("SELECT * FROM " . tablename(DBCONFIG::$TABLE_KJB_ORDER) . " WHERE aid =:aid " . $where . " AND type=2 ORDER BY createtime DESC, id DESC LIMIT " . ($pindex - 1) * $psize . ',' . $psize, $params);
            $total = pdo_fetchcolumn('SELECT COUNT(*) FROM ' . tablename(DBCONFIG::$TABLE_KJB_ORDER) . " WHERE aid =:aid AND type=2 " . $where, $params);
            $pager = pagination($total, $pindex, $psize);
        } else {
            if ($operation == 'delete') {
                $id = $_GPC['id'];
                pdo_delete(DBCONFIG::$TABLE_KJB_ORDER, array("id" => $id));
                message('删除成功！', $this->createWebUrl('PanicbuyOrderList', array('aid' => $aid)), 'success');
            }
        }
        include $this->template("panicbuy_order_list");
    }
    public function doWebPanicbuyOrderDetail()
    {
        global $_W, $_GPC;
        $aid = $_GPC['aid'];
        $oid = $_GPC['oid'];
        $order = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_ORDER) . "WHERE weid='{$_W['weid']}' AND id='{$oid}' AND type=2");
        $activity = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_PANICBUY) . "WHERE weid='{$_W['weid']}' AND id='{$aid}'");
        include $this->template("panicbuy_order_detail");
    }
    public function doWebBusiness()
    {
        global $_W, $_GPC;
        $operation = !empty($_GPC['op']) ? $_GPC['op'] : 'display';
        $id = intval($_GPC['id']);
        if ($operation == 'post') {
            if (!empty($id)) {
                $item = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_BUSINESS) . "WHERE id='{$id}'");
                $item['intro'] = htmlspecialchars_decode($item['intro']);
                if (!empty($activity['joinqun_setting'])) {
                    $joinqun_data = unserialize($activity['joinqun_setting']);
                }
            }
            if ($_W['ispost']) {
                if (!empty($_GPC['mappoint'])) {
                    $longitude = $_GPC['mappoint']['lng'];
                    $latitude = $_GPC['mappoint']['lat'];
                } else {
                    $longitude = 0;
                    $latitude = 0;
                }
                $joinqun = array('joinqun_icon' => $_GPC['joinqun_icon'], 'joinqun_title' => $_GPC['joinqun_title'], 'joinqun_desc' => $_GPC['joinqun_desc'], 'joinqun_tips_type' => $_GPC['joinqun_tips_type'], 'joinqun_tips_img' => $_GPC['joinqun_tips_img'], 'joinqun_tips_text' => $_GPC['joinqun_tips_text']);
                $data = array('weid' => $_W['weid'], 'status' => $_GPC['status'], 'logo' => $_GPC['logo'], 'intro' => htmlspecialchars($_GPC['intro']), 'recommend' => $_GPC['recommend'], 'vpassword' => $_GPC['vpassword'], 'name' => $_GPC['name'], 'address' => $_GPC['address'], 'longitude' => $longitude, 'latitude' => $latitude, 'opentime' => $_GPC['opentime'], 'tel' => $_GPC['tel'], 'joinqun_setting' => serialize($joinqun), 'joinqun_open' => $_GPC['joinqun_open']);
                if (empty($id)) {
                    pdo_insert(DBCONFIG::$TABLE_KJB_BUSINESS, $data);
                    message('添加成功', $this->createWebUrl('Business'), 'success');
                } else {
                    pdo_update(DBCONFIG::$TABLE_KJB_BUSINESS, $data, array('id' => $id));
                    message('更新成功', $this->createWebUrl('Business'), 'success');
                }
            }
        } elseif ($operation == 'display') {
            $pindex = max(1, intval($_GPC['page']));
            $psize = 20;
            $list = pdo_fetchall("SELECT * FROM " . tablename(DBCONFIG::$TABLE_KJB_BUSINESS) . " WHERE weid =:weid ORDER BY id DESC, id DESC LIMIT " . ($pindex - 1) * $psize . ',' . $psize, array(':weid' => $_W['weid']));
            foreach ($list as $key => $val) {
                if ($val['logo']) {
                    $list[$key]['logo'] = tomedia($val['logo']);
                }
            }
            $total = pdo_fetchcolumn('SELECT COUNT(*) FROM ' . tablename(DBCONFIG::$TABLE_KJB_BUSINESS) . " WHERE weid =:weid ", array(':weid' => $this->weid));
            $pager = pagination($total, $pindex, $psize);
        } else {
            if ($operation == 'delete') {
                $id = $_GPC['id'];
                pdo_delete(DBCONFIG::$TABLE_KJB_BUSINESS, array('id' => $id));
                message('删除成功！', referer(), 'success');
            }
        }
        include $this->template('business_manage');
    }
    public function doWebSetting()
    {
        global $_GPC, $_W;
        $font = YPUK_KJB_RES . '/images/font.TTF';
        if (file_exists($font) && filesize($font) > 2000) {
            $havefont = 1;
        } else {
            $havefont = 0;
        }
        $cert_pem = ATTACHMENT_ROOT . '/ypuk_kjb/cert_' . $_W['weid'] . '/apiclient_cert.pem';
        if (file_exists($cert_pem)) {
            $has_cert = 1;
        } else {
            $has_cert = 0;
        }
        $key_pem = ATTACHMENT_ROOT . '/ypuk_kjb/cert_' . $_W['weid'] . '/apiclient_key.pem';
        if (file_exists($key_pem)) {
            $has_key = 1;
        } else {
            $has_key = 0;
        }
        $op = !empty($_GPC['op']) ? $_GPC['op'] : 'common';
        $setting = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_SETTING) . "WHERE weid='{$_W['weid']}' ");
        if (!empty($setting['swiper'])) {
            $swiper = unserialize($setting['swiper']);
        }
        if (!empty($setting['function_setting'])) {
            $function_data = unserialize($setting['function_setting']);
        }
        if (!empty($setting['joinqun_setting']) && $setting['joinqun_open'] == 1) {
            $joinqun_data = unserialize($setting['joinqun_setting']);
        }
        if (checksubmit('submit')) {
            if ($_GPC['mod'] == 'common') {
                if ($_GPC['fixedopen'] == 1 && $_GPC['fixedaction'] == '') {
                    message("开启浮动图标时请设置操作类型");
                }
                $data = array('weid' => $this->weid, 'rooturl' => trim($_GPC['rooturl']), 'qqmapkey' => $_GPC['qqmapkey'], 'sysavatar' => trim($_GPC['sysavatar']), 'openkefu' => $_GPC['openkefu'], 'kefutype' => $_GPC['kefutype'], 'kefuqr' => $_GPC['kefuqr'], 'fixedopen' => $_GPC['fixedopen'], 'fixedico' => $_GPC['fixedico'], 'fixedaction' => $_GPC['fixedaction'], 'fixedactionid' => $_GPC['fixedactionid'], 'fixedbargain' => $_GPC['fixedbargain'], 'fixedmappid' => $_GPC['fixedmappid'], 'fixedmapppath' => $_GPC['fixedmapppath'], 'toptipopen' => $_GPC['toptipopen'], 'toptipaction' => $_GPC['toptipaction'], 'toptipactionid' => $_GPC['toptipactionid'], 'toptipmappid' => $_GPC['toptipmappid'], 'toptipmapppath' => $_GPC['toptipmapppath'], 'toptiptext' => $_GPC['toptiptext'], 'toptipbtn' => !empty($_GPC['toptipbtn']) ? $_GPC['toptipbtn'] : '查看', 'applytip' => $_GPC['applytip']);
                if (!empty($setting)) {
                    pdo_update(DBCONFIG::$TABLE_KJB_SETTING, $data, array('id' => $setting['id']));
                } else {
                    pdo_insert(DBCONFIG::$TABLE_KJB_SETTING, $data);
                }
                message('参数设置成功！', $this->createWebUrl('Setting', array('op' => 'common')), 'success');
            } elseif ($_GPC['mod'] == 'templatemsg') {
                $data = array('weid' => $this->weid, 'success_template_id' => $_GPC['success_template_id'], 'create_template_id' => $_GPC['create_template_id'], 'order_template_id' => $_GPC['order_template_id'], 'remind_template_id' => $_GPC['remind_template_id']);
                if (!empty($setting)) {
                    pdo_update(DBCONFIG::$TABLE_KJB_SETTING, $data, array('id' => $setting['id']));
                } else {
                    pdo_insert(DBCONFIG::$TABLE_KJB_SETTING, $data);
                }
                message('参数设置成功！', $this->createWebUrl('Setting', array('op' => 'templatemsg')), 'success');
            } elseif ($_GPC['mod'] == 'function') {
                $function['openpanicbuy'] = $_GPC['openpanicbuy'];
                $function['panicbuy_icon'] = $_GPC['panicbuy_icon'];
                $function['opengroupbuy'] = $_GPC['opengroupbuy'];
                $function['groupbuy_icon'] = $_GPC['groupbuy_icon'];
                $function['kanjia_icon'] = $_GPC['kanjia_icon'];
                if ($_GPC['joinqun_open'] == 1 && empty($_GPC['joinqun_icon']) && empty($_GPC['joinqun_title']) && empty($_GPC['joinqun_desc'])) {
                    itoast('开启入群提醒功能时，请配置群聊提醒参数（图标、群聊名、群聊介绍等）', '', 'info');
                }
                $joinqun = array('joinqun_icon' => $_GPC['joinqun_icon'], 'joinqun_title' => $_GPC['joinqun_title'], 'joinqun_desc' => $_GPC['joinqun_desc'], 'joinqun_tips_type' => $_GPC['joinqun_tips_type'], 'joinqun_tips_img' => $_GPC['joinqun_tips_img'], 'joinqun_tips_text' => $_GPC['joinqun_tips_text']);
                $data = array('weid' => $this->weid, 'function_setting' => serialize($function), 'joinqun_open' => $_GPC['joinqun_open'], 'joinqun_setting' => serialize($joinqun), 'apply_open' => $_GPC['apply_open'], 'panicbuy_opendistribution' => $_GPC['panicbuy_opendistribution'], 'panicbuy_distribution_commission' => $_GPC['panicbuy_distribution_commission'], 'panicbuy_distribution_discount' => $_GPC['panicbuy_distribution_discount']);
                if (!empty($setting)) {
                    pdo_update(DBCONFIG::$TABLE_KJB_SETTING, $data, array('id' => $setting['id']));
                } else {
                    pdo_insert(DBCONFIG::$TABLE_KJB_SETTING, $data);
                }
                message('参数设置成功！', $this->createWebUrl('Setting', array('op' => 'function')), 'success');
            } elseif ($_GPC['mod'] == 'withdraw') {
                $data = array('weid' => $this->weid, 'withdraw_open' => $_GPC['withdraw_open'], 'withdraw_date' => strtotime($_GPC['withdraw_date']), 'withdraw_charge' => $_GPC['withdraw_charge'], 'withdraw_type' => $_GPC['withdraw_type'], 'user_withdraw_open' => $_GPC['user_withdraw_open'], 'user_withdraw_charge' => $_GPC['user_withdraw_charge'], 'user_withdraw_type' => $_GPC['user_withdraw_type']);
                if ($data['withdraw_open'] == 1) {
                    if (empty($_FILES['cert_pem'])) {
                        itoast('请上传apiclient_cert.pem证书', '', 'info');
                    }
                    if (empty($_FILES['key_pem'])) {
                        itoast('请上传apiclient_key.pem证书', '', 'info');
                    }
                    $cert_pem_tmp = $_FILES['cert_pem']['tmp_name'];
                    $key_pem_tmp = $_FILES['key_pem']['tmp_name'];
                    load()->func('file');
                    if (!file_exists(ATTACHMENT_ROOT . '/ypuk_kjb/cert_' . $_W['weid'])) {
                        mkdirs(ATTACHMENT_ROOT . '/ypuk_kjb/cert_' . $_W['weid']);
                    }
                    move_uploaded_file($cert_pem_tmp, ATTACHMENT_ROOT . '/ypuk_kjb/cert_' . $_W['weid'] . '/apiclient_cert.pem');
                    move_uploaded_file($key_pem_tmp, ATTACHMENT_ROOT . '/ypuk_kjb/cert_' . $_W['weid'] . '/apiclient_key.pem');
                }
                if (!empty($setting)) {
                    pdo_update(DBCONFIG::$TABLE_KJB_SETTING, $data, array('id' => $setting['id']));
                } else {
                    pdo_insert(DBCONFIG::$TABLE_KJB_SETTING, $data);
                }
                message('参数设置成功！', $this->createWebUrl('Setting', array('op' => 'withdraw')), 'success');
            } else {
                $swiper_arr = array();
                $swiper_image = $_GPC['swiper_image'];
                $swiper_page = $_GPC['swiper_page'];
                $swiper_pageid = $_GPC['swiper_pageid'];
                $swiper_mappid = $_GPC['swiper_mappid'];
                $swiper_mapppath = $_GPC['swiper_mapppath'];
                $swiper_sort = $_GPC['swiper_sort'];
                if (!empty($swiper_image) && $swiper_image[0] != '') {
                    foreach ($swiper_image as $key => $value) {
                        $d = array('swiper_image' => $swiper_image[$key], 'swiper_page' => $swiper_page[$key], 'swiper_pageid' => $swiper_pageid[$key], 'swiper_mappid' => $swiper_mappid[$key], 'swiper_mapppath' => $swiper_mapppath[$key], 'swiper_sort' => $swiper_sort[$key]);
                        $swiper_arr[] = $d;
                    }
                    $data = array('weid' => $this->weid, 'swiper' => serialize($swiper_arr));
                } else {
                    $data = array('weid' => $this->weid, 'swiper' => '');
                }
                if (!empty($setting)) {
                    pdo_update(DBCONFIG::$TABLE_KJB_SETTING, $data, array('id' => $setting['id']));
                } else {
                    pdo_insert(DBCONFIG::$TABLE_KJB_SETTING, $data);
                }
                message('参数设置成功！', $this->createWebUrl('Setting', array('op' => 'swiper')), 'success');
            }
        }
        include $this->template("setting");
    }
    public function doWebResetSwiper()
    {
        global $_GPC, $_W;
        pdo_update(DBCONFIG::$TABLE_KJB_SETTING, array('swiper' => ''), array('weid' => $_W['weid']));
        message('重置轮播图参数成功！', $this->createWebUrl('Setting', array('op' => 'swiper')), 'success');
    }
    public function doWebResetOrderNo()
    {
        global $_W, $_GPC;
        $oid = $_GPC['oid'];
        $order = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_ORDER) . "WHERE weid='{$_W['weid']}' AND id='{$oid}'");
        $mod = $this->GetStrBetween($order['order_no'], 's', 'gi');
        $goodid = $this->GetStrBetween($order['order_no'], 'gi', 'pi');
        $paramsid = $this->GetStrBetween($order['order_no'], 'pi', 'e');
        $new_order_no = date('YmdHis', time()) . "s" . $mod . "gi" . $goodid . "pi" . $paramsid . "e";
        pdo_update(DBCONFIG::$TABLE_KJB_ORDER, array('order_no' => $new_order_no), array('id' => $oid));
        message('重置成功', referer(), 'success');
    }
    public function doWebAd()
    {
        global $_GPC, $_W;
        $ad = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_AD) . "WHERE weid='{$_W['weid']}' ");
        if (checksubmit('submit')) {
            $data = array('weid' => $this->weid, 'index_middle_ad' => $_GPC['index_middle_ad'], 'detail_middle_ad' => $_GPC['detail_middle_ad'], 'group_middle_ad' => $_GPC['group_middle_ad'], 'bargain_middle_ad' => $_GPC['bargain_middle_ad'], 'official_account' => $_GPC['official_account']);
            if (!empty($ad)) {
                pdo_update(DBCONFIG::$TABLE_KJB_AD, $data, array('id' => $ad['id']));
            } else {
                pdo_insert(DBCONFIG::$TABLE_KJB_AD, $data);
            }
            message('广告设置成功！', $this->createWebUrl('ad'), 'success');
        }
        include $this->template("ad");
    }
    public function doWebCron()
    {
        global $_GPC, $_W;
        $setting = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_SETTING) . "WHERE weid='{$_W['weid']}' ");
        if (checksubmit('submit')) {
            $data = array('weid' => $this->weid, 'openremind' => $_GPC['openremind']);
            if (!empty($setting)) {
                pdo_update(DBCONFIG::$TABLE_KJB_SETTING, $data, array('id' => $setting['id']));
            } else {
                pdo_insert(DBCONFIG::$TABLE_KJB_SETTING, $data);
            }
            message('参数设置成功！', $this->createWebUrl('Cron'), 'success');
        }
        include $this->template('remind');
    }
    public function doWebCategory()
    {
        global $_GPC, $_W;
        $op = !empty($_GPC['op']) ? $_GPC['op'] : 'display';
        $id = intval($_GPC['id']);
        $type = !empty($_GPC['type']) ? $_GPC['type'] : '1';
        if ($op == 'post') {
            if (!empty($id)) {
                $item = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_CATEGORY) . "WHERE id='{$id}'");
            }
            if ($_W['ispost']) {
                $data = array('weid' => $_W['weid'], 'name' => $_GPC['cname'], 'enabled' => $_GPC['enabled'] ? 1 : 0, 'icon' => $_GPC['icon'], 'sort' => $_GPC['sort'] ? $_GPC['sort'] : 0, 'type' => $_GPC['type'] ? $_GPC['type'] : 1);
                if (empty($id)) {
                    pdo_insert(DBCONFIG::$TABLE_KJB_CATEGORY, $data);
                    message('添加成功', $this->createWebUrl('Category'), 'success');
                } else {
                    pdo_update(DBCONFIG::$TABLE_KJB_CATEGORY, $data, array('id' => $id));
                    message('更新成功', $this->createWebUrl('Category'), 'success');
                }
            }
        } elseif ($op == 'display') {
            $o = '';
            $where = '';
            if ($type) {
                $where = ' AND type=' . $type;
            }
            $catlist = pdo_fetchall("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_CATEGORY) . " WHERE weid = '{$_W['weid']}'" . $where . " ORDER by sort asc");
            foreach ($catlist as $catitem) {
                if (intval($catitem['enabled'])) {
                    $enable = '<a href="' . $this->createWebUrl('category', array('op' => 'setenabled', 'id' => $catitem['id'], 'enabled' => 1)) . '" title="是" class="btn btn-primary">是</a>';
                } else {
                    $enable = '<a href="' . $this->createWebUrl('category', array('op' => 'setenabled', 'id' => $catitem['id'], 'enabled' => 0)) . '" title="否" class="btn btn-primary">否</a>';
                }
                $o .= "<tr><td><input type=\"checkbox\" name=\"select[]\" value=\"{$catitem['id']}\" /></td>";
                $o .= "<td>" . $catitem['name'] . "</td>";
                $o .= "<td>" . $catitem['sort'] . "</td>";
                $o .= "<td>" . $enable . "</td>";
                $o .= "<td><a href=" . $this->createWebUrl('category', array('op' => 'post', 'id' => $catitem['id'])) . " >编辑</a></td></tr>";
            }
        }
        if (checksubmit('delete')) {
            pdo_delete(DBCONFIG::$TABLE_KJB_CATEGORY, " id  IN  (" . implode(",", $_GPC['select']) . ")");
            message('删除成功', referer(), 'success');
        }
        if ($op == 'setenabled') {
            if ($_GPC['enabled'] == 0) {
                $enabled = 1;
            } else {
                $enabled = 0;
            }
            pdo_query('UPDATE ' . tablename(DBCONFIG::$TABLE_KJB_CATEGORY) . " SET enabled='{$enabled}' WHERE id='{$_GPC['id']}'");
            message('更新成功', referer(), 'success');
        }
        include $this->template('category');
    }
    public function doWebNotice()
    {
        global $_GPC, $_W;
        $op = !empty($_GPC['op']) ? $_GPC['op'] : 'display';
        $id = intval($_GPC['id']);
        if ($op == 'post') {
            if (!empty($id)) {
                $item = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_NOTICE) . "WHERE id='{$id}'");
                $item['content'] = htmlspecialchars_decode($item['content']);
            }
            if ($_W['ispost']) {
                $data = array('weid' => $_W['weid'], 'title' => $_GPC['title'], 'content' => htmlspecialchars($_GPC['content']), 'createtime' => TIMESTAMP);
                if (empty($id)) {
                    pdo_insert(DBCONFIG::$TABLE_KJB_NOTICE, $data);
                    message('添加成功', $this->createWebUrl('Notice'), 'success');
                } else {
                    pdo_update(DBCONFIG::$TABLE_KJB_NOTICE, $data, array('id' => $id));
                    message('更新成功', $this->createWebUrl('Notice'), 'success');
                }
            }
        } elseif ($op == 'display') {
            $o = '';
            $list = pdo_fetchall("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_NOTICE) . " WHERE weid = '{$_W['weid']}' ");
            foreach ($list as $v) {
                $o .= "<tr><td><input type=\"checkbox\" name=\"select[]\" value=\"{$v['id']}\" />  " . $v['id'] . "</td>";
                $o .= "<td>" . $v['title'] . "</td>";
                $o .= "<td>" . date('Y-m-d H:i:s', $v['createtime']) . "</td>";
                $o .= "<td><a href=" . $this->createWebUrl('notice', array('op' => 'post', 'id' => $v['id'])) . " >编辑</a></td></tr>";
            }
        }
        if (checksubmit('delete')) {
            pdo_delete(DBCONFIG::$TABLE_KJB_NOTICE, " id  IN  ('" . implode(",", $_GPC['select']) . "')");
            message('删除成功', referer(), 'success');
        }
        include $this->template('notice');
    }
    public function doWebApply()
    {
        global $_W, $_GPC;
        $operation = !empty($_GPC['op']) ? $_GPC['op'] : 'display';
        if ($operation == 'display') {
            $pindex = max(1, intval($_GPC['page']));
            $psize = 20;
            $list = pdo_fetchall("SELECT * FROM " . tablename(DBCONFIG::$TABLE_KJB_APPLY) . " WHERE weid='{$_W['weid']}'  ORDER BY createtime DESC, id DESC LIMIT " . ($pindex - 1) * $psize . ',' . $psize);
            $total = pdo_fetchcolumn('SELECT COUNT(*) FROM ' . tablename(DBCONFIG::$TABLE_KJB_APPLY) . "WHERE weid='{$_W['weid']}' ");
            $pager = pagination($total, $pindex, $psize);
        } else {
            if ($operation == 'agree') {
                $id = $_GPC['id'];
                $apply = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_APPLY) . "WHERE weid='{$_W['weid']}' AND id='{$id}'");
                $data = array('weid' => $_W['weid'], 'logo' => '', 'vpassword' => '', 'name' => $apply['shopname'], 'address' => $apply['shopaddress'], 'tel' => $apply['shoptel'], 'opentime' => '', 'longitude' => '', 'latitude' => '', 'intro' => $apply['activityintro'], 'joinqun_setting' => '');
                pdo_update(DBCONFIG::$TABLE_KJB_APPLY, array("status" => 1), array("id" => $id));
                pdo_insert(DBCONFIG::$TABLE_KJB_BUSINESS, $data);
                message('同意成功！', referer(), 'success');
            } else {
                if ($operation == 'delete') {
                    $id = $_GPC['id'];
                    pdo_delete(DBCONFIG::$TABLE_KJB_APPLY, array("id" => $id));
                    message('删除成功！', $this->createWebUrl('Apply', referer(), 'success'));
                }
            }
        }
        include $this->template("apply_list");
    }
    public function doWebApplyDetail()
    {
        global $_W, $_GPC;
        $id = $_GPC['id'];
        $apply = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_APPLY) . "WHERE weid='{$_W['weid']}' AND id='{$id}'");
        include $this->template("apply_detail");
    }
    public function doWebWithdraw()
    {
        global $_W, $_GPC;
        $operation = !empty($_GPC['op']) ? $_GPC['op'] : 'businesslist';
        $setting = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_SETTING) . "WHERE weid='{$_W['weid']}' ");
        if ($operation == 'businesslist') {
            $pindex = max(1, intval($_GPC['page']));
            $psize = 20;
            $list = pdo_fetchall("SELECT * FROM " . tablename(DBCONFIG::$TABLE_KJB_WITHDRAWLOG) . " WHERE weid='{$_W['weid']}'  ORDER BY id DESC LIMIT " . ($pindex - 1) * $psize . ',' . $psize);
            foreach ($list as $key => $val) {
                $businessinfo = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_BUSINESS) . "WHERE weid='{$_W['weid']}' AND id='{$val['businessid']}'");
                $list[$key]['businessname'] = $businessinfo['name'];
            }
            $total = pdo_fetchcolumn('SELECT COUNT(*) FROM ' . tablename(DBCONFIG::$TABLE_KJB_WITHDRAWLOG) . "WHERE weid='{$_W['weid']}'  ORDER BY id DESC");
            $pager = pagination($total, $pindex, $psize);
        } else {
            if ($operation == 'userlist') {
                $pindex = max(1, intval($_GPC['page']));
                $psize = 20;
                $list = pdo_fetchall("SELECT * FROM " . tablename(DBCONFIG::$TABLE_KJB_USERWITHDRAW) . " WHERE weid='{$_W['weid']}'  ORDER BY id DESC LIMIT " . ($pindex - 1) * $psize . ',' . $psize);
                foreach ($list as $key => $val) {
                    $userinfo = mc_fansinfo($val['uid'], $_W['acid'], $_W['uniacid']);
                    $list[$key]['username'] = $userinfo['nickname'];
                }
                $total = pdo_fetchcolumn('SELECT COUNT(*) FROM ' . tablename(DBCONFIG::$TABLE_KJB_USERWITHDRAW) . "WHERE weid='{$_W['weid']}'  ORDER BY id DESC");
                $pager = pagination($total, $pindex, $psize);
            } else {
                if ($operation == 'delete') {
                    $type = $_GPC['type'];
                    $id = $_GPC['id'];
                    if ($type == 'business') {
                        pdo_delete(DBCONFIG::$TABLE_KJB_WITHDRAWLOG, array("id" => $id));
                    }
                    if ($type == 'user') {
                        pdo_delete(DBCONFIG::$TABLE_KJB_USERWITHDRAW, array("id" => $id));
                    }
                    message('删除成功！', referer(), 'success');
                } else {
                    if ($operation == 'setstatus') {
                        $type = $_GPC['type'];
                        $id = $_GPC['id'];
                        $status = $_GPC['status'];
                        if ($type == 'business') {
                            $businessid = $_GPC['businessid'];
                            if ($setting['withdraw_type'] == 1) {
                                if ($status == 1) {
                                    $withdraw = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_WITHDRAWLOG) . "WHERE weid='{$_W['weid']}' AND id='{$id}'");
                                    $clerkinfo = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_CLERK) . "WHERE weid='{$_W['weid']}' AND id='{$withdraw['clerkid']}'");
                                    $userinfo = mc_fansinfo($clerkinfo['uid'], $_W['acid'], $_W['acid']);
                                    require_once IA_ROOT . '/addons/' . YPUK_KJB . '/withdraw_func.php';
                                    $param = array('orderno' => TIMESTAMP . '' . $businessid . '' . $id, 'openid' => $userinfo['openid'], 'amount' => $withdraw['charged_price'], 'desc' => '商户提现', 'withdrawlog_id' => $withdraw['id'], 'type' => 'business');
                                    create_withdraw($param);
                                } else {
                                    pdo_update(DBCONFIG::$TABLE_KJB_WITHDRAWLOG, array("status" => $status), array("id" => $id));
                                    message('更新成功！', referer(), 'success');
                                }
                            } else {
                                pdo_update(DBCONFIG::$TABLE_KJB_WITHDRAWLOG, array("status" => $status), array("id" => $id));
                                message('更新成功！', referer(), 'success');
                            }
                        }
                        if ($type == 'user') {
                            $uid = $_GPC['uid'];
                            if ($setting['user_withdraw_type'] == 1) {
                                if ($status == 1) {
                                    $withdraw = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_USERWITHDRAW) . "WHERE weid='{$_W['weid']}' AND id='{$id}'");
                                    $userinfo = mc_fansinfo($uid, $_W['acid'], $_W['acid']);
                                    require_once IA_ROOT . '/addons/' . YPUK_KJB . '/withdraw_func.php';
                                    $param = array('orderno' => TIMESTAMP . '' . $uid . '' . $id, 'openid' => $userinfo['openid'], 'amount' => $withdraw['charged_price'], 'desc' => '用户提现', 'withdrawlog_id' => $withdraw['id'], 'type' => 'user');
                                    create_withdraw($param);
                                } else {
                                    pdo_update(DBCONFIG::$TABLE_KJB_USERWITHDRAW, array("status" => $status), array("id" => $id));
                                    message('更新成功！', referer(), 'success');
                                }
                            } else {
                                pdo_update(DBCONFIG::$TABLE_KJB_USERWITHDRAW, array("status" => $status), array("id" => $id));
                                message('更新成功！', referer(), 'success');
                            }
                        }
                    }
                }
            }
        }
        include $this->template("withdraw_list");
    }
    public function doWebWithdrawDetail()
    {
        global $_W, $_GPC;
        $id = $_GPC['id'];
        $type = $_GPC['type'];
        if ($type == 'business') {
            $withdraw = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_WITHDRAWLOG) . "WHERE weid='{$_W['weid']}' AND id='{$id}'");
            $businessinfo = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_BUSINESS) . "WHERE weid='{$_W['weid']}' AND id='{$withdraw['businessid']}'");
            $withdraw['businessname'] = $businessinfo['name'];
            $withdraw['charge'] = $withdraw['withdraw_price'] - $withdraw['charged_price'];
        }
        if ($type == 'user') {
            $withdraw = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_USERWITHDRAW) . "WHERE weid='{$_W['weid']}' AND id='{$id}'");
            $userinfo = mc_fansinfo($withdraw['uid'], $_W['acid'], $_W['acid']);
            $withdraw['username'] = $userinfo['nickname'];
            $withdraw['charge'] = $withdraw['withdraw_price'] - $withdraw['charged_price'];
        }
        include $this->template("withdraw_detail");
    }
    public function doWebOrderList()
    {
        global $_W, $_GPC;
        $operation = !empty($_GPC['op']) ? $_GPC['op'] : 'display';
        $aid = $_GPC['aid'];
        if ($operation == 'display') {
            $activity = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_ACTIVITY) . "WHERE weid='{$_W['weid']}' AND id='{$aid}'");
            if (empty($activity)) {
                message("砍价活动删除或不存在");
            }
            $keyword = $_GPC['keyword'];
            $where = '';
            $params = array(':aid' => $aid);
            if (!empty($keyword)) {
                $where .= ' and (order_no like :keyword) or (tel like :keyword)';
                $params[':keyword'] = "%{$keyword}%";
            }
            if ($_GPC['status'] != 0) {
                $where .= ' and status =:status';
                $params[':status'] = $_GPC['status'];
            }
            $status = $_GPC['status'];
            $order_time_get = $_GPC['order_time'];
            $starttime = empty($order_time_get['start']) ? strtotime('-1 month') : strtotime($order_time_get['start']);
            $endtime = empty($order_time_get['end']) ? TIMESTAMP : strtotime($order_time_get['end']);
            $where .= ' and createtime >=:starttime and createtime <=:endtime';
            $params[':starttime'] = $starttime;
            $params[':endtime'] = $endtime;
            $order_time = array('start' => date("Y-m-d H:i", $starttime), 'end' => date("Y-m-d H:i", $endtime));
            $pindex = max(1, intval($_GPC['page']));
            $psize = 20;
            $list = pdo_fetchall("SELECT * FROM " . tablename(DBCONFIG::$TABLE_KJB_ORDER) . " WHERE aid =:aid " . $where . " AND type=1 ORDER BY createtime DESC, id DESC LIMIT " . ($pindex - 1) * $psize . ',' . $psize, $params);
            $total = pdo_fetchcolumn('SELECT COUNT(*) FROM ' . tablename(DBCONFIG::$TABLE_KJB_ORDER) . " WHERE aid =:aid  " . $where . " AND type=1", $params);
            $pager = pagination($total, $pindex, $psize);
        } else {
            if ($operation == 'delete') {
                $id = $_GPC['id'];
                pdo_delete(DBCONFIG::$TABLE_KJB_ORDER, array("id" => $id));
                message('删除成功！', $this->createWebUrl('OrderList', array('aid' => $aid)), 'success');
            }
        }
        include $this->template("order_list");
    }
    public function doWebOrderTable()
    {
        global $_W, $_GPC;
        $aid = $_GPC['aid'];
        $type = $_GPC['type'];
        if ($type == 1) {
            $activity = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_ACTIVITY) . "WHERE weid='{$_W['weid']}' AND id='{$aid}'");
        }
        if ($type == 2) {
            $activity = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_PANICBUY) . "WHERE weid='{$_W['weid']}' AND id='{$aid}'");
        }
        if ($type == 3) {
            $activity = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_GROUPBUY) . "WHERE weid='{$_W['weid']}' AND id='{$aid}'");
        }
        if ($_W['ispost']) {
            $where = '';
            if ($_GPC['status'] != 0) {
                $where .= ' and status=' . $_GPC['status'];
            }
            $params = array(':aid' => $aid);
            $order_time_get = $_GPC['order_time'];
            $starttime = empty($order_time_get['start']) ? strtotime('-1 month') : strtotime($order_time_get['start']);
            $endtime = empty($order_time_get['end']) ? TIMESTAMP : strtotime($order_time_get['end']);
            $where .= ' and (createtime between :starttime and :endtime)';
            $params[':starttime'] = $starttime;
            $params[':endtime'] = $endtime;
            $list = pdo_fetchall("SELECT * FROM " . tablename(DBCONFIG::$TABLE_KJB_ORDER) . " WHERE aid =:aid " . $where . " AND type='{$type}' ORDER BY createtime DESC, id DESC", $params);
            if ($type == 1) {
                foreach ($list as $key => $val) {
                    if ($list[$key]['oporder'] == 1) {
                        $list[$key]['oporder'] = '否';
                    } else {
                        $list[$key]['oporder'] = '是';
                    }
                    $list[$key]['statustext'] = $this->getStatusText($val['status'], $activity['type']);
                    $list[$key]['createtime'] = date('Y-m-d H:i:s', $val['createtime']);
                }
                $filename = '砍价订单记录' . date('YmdHis', TIMESTAMP);
                $header = array('订单ID', '用户ID', '是否砍价购买', '联系人', '联系电话', '联系地址', '订单编号', '运费', '原价', '当前价', '支付金额', '订单状态', '创建时间');
                $index = array('id', 'uid', 'oporder', 'uname', 'tel', 'address', 'order_no', 'freight', 'oldprice', 'nowprice', 'total_price', 'statustext', 'createtime');
                $this->createtable($list, $filename, $header, $index);
            }
            if ($type == 2) {
                foreach ($list as $key => $val) {
                    $list[$key]['statustext'] = $this->getStatusText($val['status'], $activity['type']);
                    $list[$key]['createtime'] = date('Y-m-d H:i:s', $val['createtime']);
                }
                $filename = '订单记录' . date('YmdHis', TIMESTAMP);
                $header = array('订单ID', '用户ID', '联系人', '联系电话', '联系地址', '订单编号', '运费', '原价', '当前价', '支付金额', '订单状态', '创建时间');
                $index = array('id', 'uid', 'uname', 'tel', 'address', 'order_no', 'freight', 'oldprice', 'nowprice', 'total_price', 'statustext', 'createtime');
                $this->createtable($list, $filename, $header, $index);
            }
            if ($type == 3) {
                if ($list[$key]['oporder'] == 1) {
                    $list[$key]['oporder'] = '否';
                } else {
                    $list[$key]['oporder'] = '是';
                }
                foreach ($list as $key => $val) {
                    $list[$key]['statustext'] = $this->getStatusText($val['status'], $activity['type']);
                    $list[$key]['createtime'] = date('Y-m-d H:i:s', $val['createtime']);
                }
                $filename = '订单记录' . date('YmdHis', TIMESTAMP);
                $header = array('订单ID', '用户ID', '是否拼团购买', '联系人', '联系电话', '联系地址', '订单编号', '运费', '原价', '当前价', '支付金额', '订单状态', '创建时间');
                $index = array('id', 'uid', 'oporder', 'uname', 'tel', 'address', 'order_no', 'freight', 'oldprice', 'nowprice', 'total_price', 'statustext', 'createtime');
                $this->createtable($list, $filename, $header, $index);
            }
        }
        include $this->template("ordertable");
    }
    public function doWebOrderFahuo()
    {
        global $_W, $_GPC;
        $id = $_GPC['id'];
        $aid = $_GPC['aid'];
        $data = array('status' => $this::$KJ_STATUS_YFH, 'expresstype' => $_GPC['expresstype'], 'expressname' => $_GPC['expressname'], 'expressno' => $_GPC['expressno'], 'updatetime' => TIMESTAMP);
        pdo_update(DBCONFIG::$TABLE_KJB_ORDER, $data, array('id' => $id));
        message('发货成功！', $this->createWebUrl('OrderDetail', array('oid' => $id, 'aid' => $aid)), 'success');
    }
    public function doWebClerkLog()
    {
        global $_W, $_GPC;
        $operation = !empty($_GPC['op']) ? $_GPC['op'] : 'display';
        $cid = $_GPC['cid'];
        if ($operation == 'display') {
            $clerk = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_CLERK) . "WHERE weid='{$_W['weid']}' AND id='{$cid}'");
            load()->model('mc');
            $userinfo = mc_fansinfo($clerk['uid'], $_W['acid'], $_W['acid']);
            if (empty($clerk)) {
                message("店员删除或不存在");
            }
            $keyword = $_GPC['keyword'];
            $where = '';
            $params = array(':cid' => $cid);
            if (!empty($keyword)) {
                $where .= ' and (order_no=:keyword) or (oid=:keyword)';
                $params[':keyword'] = "{$keyword}";
            }
            $pindex = max(1, intval($_GPC['page']));
            $psize = 20;
            $list = pdo_fetchall("SELECT * FROM " . tablename(DBCONFIG::$TABLE_KJB_VERIFICATION) . " WHERE clerk =:cid " . $where . "  ORDER BY createtime DESC, id DESC LIMIT " . ($pindex - 1) * $psize . ',' . $psize, $params);
            $total = pdo_fetchcolumn('SELECT COUNT(*) FROM ' . tablename(DBCONFIG::$TABLE_KJB_VERIFICATION) . " WHERE clerk =:cid  " . $where, $params);
            $pager = pagination($total, $pindex, $psize);
        } else {
            if ($operation == 'delete') {
                $id = $_GPC['id'];
                pdo_delete(DBCONFIG::$TABLE_KJB_VERIFICATION, array("id" => $id));
                message('删除成功！', referer(), 'success');
            }
        }
        include $this->template("clerk_log");
    }
    public function doWebClerk()
    {
        global $_GPC, $_W;
        $op = !empty($_GPC['op']) ? $_GPC['op'] : 'display';
        $id = intval($_GPC['id']);
        if ($op == 'post') {
            $businesses = pdo_fetchall("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_BUSINESS) . "WHERE weid = :weid", array(':weid' => $_W['weid']));
            if (!empty($id)) {
                $item = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_CLERK) . "WHERE id='{$id}'");
                if ($item['businessid'] != 0) {
                    $businessinfo = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_BUSINESS) . "WHERE weid='{$_W['weid']}' AND id='{$item['businessid']}'");
                    $item['businessname'] = $businessinfo['name'];
                }
            }
            if ($_W['ispost']) {
                if ($_GPC['businessid'] && $_GPC['businessid'] != 'no') {
                    $businessid = $_GPC['businessid'];
                } else {
                    $businessid = '';
                }
                $data = array('weid' => $_W['weid'], 'uid' => $_GPC['uid'], 'businessid' => $businessid, 'name' => $_GPC['name'], 'workno' => $_GPC['workno'], 'clerk_auth' => $_GPC['clerk_auth']);
                if (empty($id)) {
                    pdo_insert(DBCONFIG::$TABLE_KJB_CLERK, $data);
                    message('添加成功', $this->createWebUrl('Clerk'), 'success');
                } else {
                    pdo_update(DBCONFIG::$TABLE_KJB_CLERK, $data, array('id' => $id));
                    message('更新成功', $this->createWebUrl('Clerk'), 'success');
                }
            }
        } elseif ($op == 'display') {
            $o = '';
            $businessid = $_GPC['businessid'];
            $name = $_GPC['name'];
            $where = '';
            if (!empty($businessid)) {
                $where .= ' and businessid = ' . $businessid;
            }
            if (!empty($name)) {
                $where .= ' and name like "%' . $name . '%"';
            }
            load()->model('mc');
            $list = pdo_fetchall("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_CLERK) . " WHERE weid = '{$_W['weid']}'" . $where);
            foreach ($list as $v) {
                $uerinfo = mc_fansinfo($v['uid'], $_W['acid'], $_W['uniacid']);
                if ($v['businessid'] != 0) {
                    $businessinfo = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_BUSINESS) . "WHERE weid='{$_W['weid']}' AND id='{$v['businessid']}'");
                    $v['businessname'] = $businessinfo['name'];
                } else {
                    $v['businessname'] = '未关联';
                }
                $o .= "<tr><td><input type=\"checkbox\" name=\"select[]\" value=\"{$v['id']}\" />  " . $v['id'] . "</td>";
                $o .= "<td>" . $v['uid'] . "</td>";
                $o .= "<td>" . $v['businessname'] . "</td>";
                $o .= "<td>" . $uerinfo['nickname'] . "</td>";
                $o .= "<td>" . $v['name'] . "</td>";
                $o .= "<td>" . $v['workno'] . "</td>";
                $o .= "<td><img src='" . $uerinfo['avatar'] . "' style='width:50px;height:50px;'/></td>";
                $o .= "<td><a href=" . $this->createWebUrl('clerk', array('op' => 'post', 'id' => $v['id'])) . " >编辑</a>  <a href=" . $this->createWebUrl('ClerkLog', array('op' => 'display', 'cid' => $v['id'])) . " >核销记录</a></td></tr>";
            }
        }
        if (checksubmit('delete')) {
            pdo_delete(DBCONFIG::$TABLE_KJB_CLERK, " id  IN  ('" . implode(",", $_GPC['select']) . "')");
            message('删除成功', referer(), 'success');
        }
        include $this->template('clerk');
    }
    public function doWebRefundOrder($oid, $type)
    {
        global $_W, $_GPC;
        $oid = $_GPC['oid'];
        $type = $_GPC['type'];
        $orderInfo = pdo_fetch("SELECT * FROM " . tablename(DBCONFIG::$TABLE_KJB_ORDER) . " WHERE weid='{$_W['weid']}' AND id='{$oid}' AND type='{$type}'");
        if (empty($orderInfo)) {
            message("未找到指定订单");
        }
        if ($orderInfo['status'] == 9) {
            message("订单已退款过");
        }
        if ($orderInfo['status'] == 6) {
            message("订单已核销或确认收货，无法继续退款");
        }
        if ($orderInfo['pay_type'] != 1 && ($orderInfo['type'] == 1 || $orderInfo['type'] == 2)) {
            message("订单非线上付款订单，无法退款");
        }
        require_once IA_ROOT . '/addons/' . YPUK_KJB . '/refund_func.php';
        pdo_query('UPDATE ' . tablename(DBCONFIG::$TABLE_KJB_ORDER) . " SET status=9 WHERE id='{$oid}' AND type='{$type}'");
        $refundid = refund_create_order($orderInfo['order_no'], 'ypuk_kjb', 0, '订单退款');
        $refundstatus = refund($refundid, 0, 'orderrefund');
        if ($refundstatus == 'ok') {
            message('退款成功', referer(), 'success');
        }
    }
    public function doWebOrderTips()
    {
        global $_W, $_GPC;
        $audio_src = YPUK_KJB_RES . '/images/order_tips_audio.wav';
        $order_all_count = pdo_fetchcolumn("SELECT COUNT(*) FROM " . tablename(DBCONFIG::$TABLE_KJB_ORDER) . " where weid='{$_W['weid']}'");
        $groupbuy_order_all_count = pdo_fetchcolumn("SELECT COUNT(*) FROM " . tablename(DBCONFIG::$TABLE_KJB_ORDER) . " where weid='{$_W['weid']}' AND type=3");
        $paincbuy_order_all_count = pdo_fetchcolumn("SELECT COUNT(*) FROM " . tablename(DBCONFIG::$TABLE_KJB_ORDER) . " where weid='{$_W['weid']}' AND type=2");
        $kanjia_order_all_count = pdo_fetchcolumn("SELECT COUNT(*) FROM " . tablename(DBCONFIG::$TABLE_KJB_ORDER) . " where weid='{$_W['weid']}' AND type=1");
        $order_waitpay_count = pdo_fetchcolumn("SELECT COUNT(*) FROM " . tablename(DBCONFIG::$TABLE_KJB_ORDER) . " where weid='{$_W['weid']}' AND status=3");
        $groupbuy_order_waitpay_count = pdo_fetchcolumn("SELECT COUNT(*) FROM " . tablename(DBCONFIG::$TABLE_KJB_ORDER) . " where weid='{$_W['weid']}' AND type=3 AND status=3");
        $paincbuy_order_waitpay_count = pdo_fetchcolumn("SELECT COUNT(*) FROM " . tablename(DBCONFIG::$TABLE_KJB_ORDER) . " where weid='{$_W['weid']}' AND type=2 AND status=3");
        $kanjia_order_waitpay_count = pdo_fetchcolumn("SELECT COUNT(*) FROM " . tablename(DBCONFIG::$TABLE_KJB_ORDER) . " where weid='{$_W['weid']}' AND type=1 AND status=3");
        $order_waitfahuo_count = pdo_fetchcolumn("SELECT COUNT(*) FROM " . tablename(DBCONFIG::$TABLE_KJB_ORDER) . " where weid='{$_W['weid']}' AND status=4");
        $groupbuy_order_waitfahuo_count = pdo_fetchcolumn("SELECT COUNT(*) FROM " . tablename(DBCONFIG::$TABLE_KJB_ORDER) . " where weid='{$_W['weid']}' AND type=3 AND status=4");
        $paincbuy_order_waitfahuo_count = pdo_fetchcolumn("SELECT COUNT(*) FROM " . tablename(DBCONFIG::$TABLE_KJB_ORDER) . " where weid='{$_W['weid']}' AND type=2 AND status=4");
        $kanjia_order_waitfahuo_count = pdo_fetchcolumn("SELECT COUNT(*) FROM " . tablename(DBCONFIG::$TABLE_KJB_ORDER) . " where weid='{$_W['weid']}' AND type=1 AND status=4");
        $order_waitverification_count = pdo_fetchcolumn("SELECT COUNT(*) FROM " . tablename(DBCONFIG::$TABLE_KJB_ORDER) . " where weid='{$_W['weid']}' AND status=5");
        $groupbuy_order_waitverification_count = pdo_fetchcolumn("SELECT COUNT(*) FROM " . tablename(DBCONFIG::$TABLE_KJB_ORDER) . " o left join " . tablename(DBCONFIG::$TABLE_KJB_ACTIVITYINDEX) . " a on o.aid=a.aid where o.weid='{$_W['weid']}' AND o.type=3 AND o.status=5 AND a.type=1");
        $paincbuy_order_waitverification_count = pdo_fetchcolumn("SELECT COUNT(*) FROM " . tablename(DBCONFIG::$TABLE_KJB_ORDER) . " o left join " . tablename(DBCONFIG::$TABLE_KJB_ACTIVITYINDEX) . " a on o.aid=a.aid where o.weid='{$_W['weid']}' AND o.type=2 AND o.status=5 AND a.type=1");
        $kanjia_order_waitverification_count = pdo_fetchcolumn("SELECT COUNT(*) FROM " . tablename(DBCONFIG::$TABLE_KJB_ORDER) . " o left join " . tablename(DBCONFIG::$TABLE_KJB_ACTIVITYINDEX) . " a on o.aid=a.aid where o.weid='{$_W['weid']}' AND o.type=1 AND o.status=5 AND a.type=1");
        $order_ok_count = pdo_fetchcolumn("SELECT COUNT(*) FROM " . tablename(DBCONFIG::$TABLE_KJB_ORDER) . " where weid='{$_W['weid']}'");
        $groupbuy_order_ok_count = pdo_fetchcolumn("SELECT COUNT(*) FROM " . tablename(DBCONFIG::$TABLE_KJB_ORDER) . " where weid='{$_W['weid']}' AND type=3 AND status=6");
        $paincbuy_order_ok_count = pdo_fetchcolumn("SELECT COUNT(*) FROM " . tablename(DBCONFIG::$TABLE_KJB_ORDER) . " where weid='{$_W['weid']}' AND type=2 AND status=6");
        $kanjia_order_ok_count = pdo_fetchcolumn("SELECT COUNT(*) FROM " . tablename(DBCONFIG::$TABLE_KJB_ORDER) . " where weid='{$_W['weid']}' AND type=1 AND status=6");
        $setting = pdo_fetch("SELECT order_tips_status FROM" . tablename(DBCONFIG::$TABLE_KJB_SETTING) . "WHERE weid='{$_W['weid']}'");
        if (!empty($setting)) {
            $order_tips_status = unserialize($setting['order_tips_status']);
        }
        if ($_W['ispost']) {
            $newsetting = array('order_tips_status' => serialize($_GPC['order_tips_status']));
            pdo_update(DBCONFIG::$TABLE_KJB_SETTING, $newsetting, array('weid' => $_W['weid']));
            message('更新成功', $this->createWebUrl('OrderTips'), 'success');
        }
        include $this->template("order_tips");
    }
    public function doWebGetNewOrder()
    {
        global $_W, $_GPC;
        $nowtime = TIMESTAMP;
        $starttime = $nowtime - 20;
        $where = " AND (updatetime BETWEEN {$starttime} AND {$nowtime})";
        $setting = pdo_fetch("SELECT order_tips_status FROM" . tablename(DBCONFIG::$TABLE_KJB_SETTING) . "WHERE weid='{$_W['weid']}'");
        if (!empty($setting)) {
            $order_tips_status = unserialize($setting['order_tips_status']);
            $where .= ' AND (';
            foreach ($order_tips_status as $key => $val) {
                if ($key > 0) {
                    $where .= ' OR status=' . $val;
                } else {
                    $where .= 'status=' . $val;
                }
            }
            $where .= ')';
        }
        $list = pdo_fetchall("SELECT * FROM " . tablename(DBCONFIG::$TABLE_KJB_ORDER) . " WHERE weid='{$_W['weid']}' " . $where . " ORDER BY createtime DESC");
        if (!empty($list)) {
            $result['time'] = '<div class="order_time">' . date('Y-m-d H:i:s', $nowtime) . '</div>';
            foreach ($list as $key => $val) {
                $activity = pdo_fetch("SELECT type FROM " . tablename(DBCONFIG::$TABLE_KJB_ACTIVITYINDEX) . " WHERE weid='{$_W['weid']}' AND aid='{$val['aid']}'");
                if ($val['status'] == 3) {
                    $text_1 = '【新订单提示】';
                    if ($val['type'] == 1) {
                        $text_2 = '砍价订单';
                    } elseif ($val['type'] == 2) {
                        $text_2 = '抢购订单';
                    } else {
                        $text_2 = '拼团订单';
                    }
                    $text_3 = '等待支付';
                }
                if ($val['status'] == 4) {
                    $text_1 = '【订单状态变更提示】';
                    if ($val['type'] == 1) {
                        $text_2 = '砍价订单';
                    } elseif ($val['type'] == 2) {
                        $text_2 = '抢购订单';
                    } else {
                        $text_2 = '拼团订单';
                    }
                    $text_3 = '新订单>待发货';
                }
                if ($val['status'] == 5) {
                    $text_1 = '【订单状态变更提示】';
                    if ($activity['type'] == 0) {
                        $text_3 = '待发货>已发货，等待收货';
                    } else {
                        $text_3 = '新订单>等待到店核销';
                    }
                }
                if ($val['status'] == 6) {
                    $text_1 = '【订单状态变更提示】';
                    if ($activity['type'] == 0) {
                        $text_3 = '已发货，等待收货>已确认收货';
                    } else {
                        $text_3 = '等待到店核销>已完成核销';
                    }
                }
                if ($val['type'] == 1) {
                    $text_2 = '【砍价订单】';
                } elseif ($val['type'] == 2) {
                    $text_2 = '【抢购订单】';
                } else {
                    $text_2 = '【拼团订单】';
                }
                $result['list'][$key] = '<div class="order_item">' . $text_1 . '&nbsp;&nbsp;' . $text_2 . '&nbsp;&nbsp;状态说明：' . $text_3 . '&nbsp;&nbsp;<a href="' . $this->createWebUrl('OrderDetail', array('oid' => $val['id'], 'aid' => $val['aid'])) . '" target="_blank" style="color:#f60;">点此查看</a></div>';
            }
        } else {
            $result = 'null';
        }
        return json_encode($result);
    }
    public function doWebOrderDetail()
    {
        global $_W, $_GPC;
        $aid = $_GPC['aid'];
        $oid = $_GPC['oid'];
        $order = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_ORDER) . "WHERE weid='{$_W['weid']}' AND id='{$oid}' AND type=1");
        $activity = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_ACTIVITY) . "WHERE weid='{$_W['weid']}' AND id='{$aid}'");
        include $this->template("order_detail");
    }
    public function doWebBargain()
    {
        global $_W, $_GPC;
        load()->model('mc');
        $operation = !empty($_GPC['op']) ? $_GPC['op'] : 'display';
        if ($operation == 'display') {
            $aid = $_GPC['aid'];
            $activity = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_ACTIVITY) . "WHERE weid='{$_W['weid']}' AND id='{$aid}'");
            if (empty($activity)) {
                message("砍价活动删除或不存在");
            }
            $uid = $_GPC['uid'];
            $where = '';
            $params = array(':aid' => $aid);
            if (!empty($uid)) {
                $where .= ' and (uid = :uid)';
                $params[':uid'] = "{$uid}";
            }
            $pindex = max(1, intval($_GPC['page']));
            $psize = 20;
            $list = pdo_fetchall("SELECT * FROM " . tablename(DBCONFIG::$TABLE_KJB_BARGAIN) . " WHERE aid =:aid " . $where . "  ORDER BY createtime DESC, id DESC LIMIT " . ($pindex - 1) * $psize . ',' . $psize, $params);
            foreach ($list as $key => $val) {
                $userInfo = mc_fansinfo($val['uid'], $_W['acid'], $_W['uniacid']);
                $list[$key]['nickname'] = $userInfo['nickname'];
                $list[$key]['avatar'] = $userInfo['avatar'];
            }
            $total = pdo_fetchcolumn('SELECT COUNT(*) FROM ' . tablename(DBCONFIG::$TABLE_KJB_BARGAIN) . " WHERE aid =:aid  " . $where, $params);
            $pager = pagination($total, $pindex, $psize);
        } else {
            if ($operation == 'delete') {
                $id = $_GPC['id'];
                pdo_delete(DBCONFIG::$TABLE_KJB_ORDER, array("bid" => $id));
                pdo_delete(DBCONFIG::$TABLE_KJB_RECORD, array("bid" => $id));
                pdo_delete(DBCONFIG::$TABLE_KJB_BARGAIN, array("id" => $id));
                message('删除成功！', referer(), 'success');
            }
        }
        include $this->template("bargain_list");
    }
    public function doWebGetTemplateId()
    {
        global $_W, $_GPC;
        load()->func('communication');
        load()->classs('wxapp.account');
        $appinfo = new WxappAccount($_W['account']);
        $accesstoken = $appinfo->getAccessToken();
        if ($_GPC['type'] == 'success_template_id') {
            $templateInfo_content = json_encode(array('id' => 'AT1173', 'access_token' => $accesstoken));
            $templateInfo_url = "https://api.weixin.qq.com/cgi-bin/wxopen/template/library/get?access_token={$accesstoken}";
            $templateInfo = ihttp_post($templateInfo_url, $templateInfo_content);
            $templateInfo = json_decode($templateInfo['content'], true);
            $keyword_arr = array();
            $keyword_len = 3;
            for ($i = 0; $i < $keyword_len; $i++) {
                foreach ($templateInfo['keyword_list'] as $key => $val) {
                    if (count($keyword_arr) == 0 && $val['name'] == '商品名称') {
                        array_push($keyword_arr, $val['keyword_id']);
                    }
                    if (count($keyword_arr) == 1 && $val['name'] == '温馨提示') {
                        array_push($keyword_arr, $val['keyword_id']);
                    }
                    if (count($keyword_arr) == 2 && $val['name'] == '砍价时间') {
                        array_push($keyword_arr, $val['keyword_id']);
                    }
                }
            }
            $createTemplate_content = json_encode(array('id' => 'AT1173', 'access_token' => $accesstoken, 'keyword_id_list' => $keyword_arr));
            $createTemplate_url = "https://api.weixin.qq.com/cgi-bin/wxopen/template/add?access_token={$accesstoken}";
            $createTemplate = ihttp_post($createTemplate_url, $createTemplate_content);
            $createTemplate = json_decode($createTemplate['content'], true);
            if ($createTemplate['errcode'] == 0) {
                $setting = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_SETTING) . "WHERE weid='{$_W['weid']}' ");
                $data = array('weid' => $this->weid, 'success_template_id' => $createTemplate['template_id']);
                if (!empty($setting)) {
                    pdo_update(DBCONFIG::$TABLE_KJB_SETTING, $data, array('id' => $setting['id']));
                } else {
                    pdo_insert(DBCONFIG::$TABLE_KJB_SETTING, $data);
                }
            }
        } else {
            if ($_GPC['type'] == 'create_template_id') {
                $templateInfo_content = json_encode(array('id' => 'AT0197', 'access_token' => $accesstoken));
                $templateInfo_url = "https://api.weixin.qq.com/cgi-bin/wxopen/template/library/get?access_token={$accesstoken}";
                $templateInfo = ihttp_post($templateInfo_url, $templateInfo_content);
                $templateInfo = json_decode($templateInfo['content'], true);
                $keyword_arr = array();
                $keyword_len = 4;
                for ($i = 0; $i < $keyword_len; $i++) {
                    foreach ($templateInfo['keyword_list'] as $key => $val) {
                        if (count($keyword_arr) == 0 && $val['name'] == '发起人') {
                            array_push($keyword_arr, $val['keyword_id']);
                        }
                        if (count($keyword_arr) == 1 && $val['name'] == '温馨提示') {
                            array_push($keyword_arr, $val['keyword_id']);
                        }
                        if (count($keyword_arr) == 2 && $val['name'] == '说明') {
                            array_push($keyword_arr, $val['keyword_id']);
                        }
                        if (count($keyword_arr) == 3 && $val['name'] == '申请时间') {
                            array_push($keyword_arr, $val['keyword_id']);
                        }
                    }
                }
                $createTemplate_content = json_encode(array('id' => 'AT0197', 'access_token' => $accesstoken, 'keyword_id_list' => $keyword_arr));
                $createTemplate_url = "https://api.weixin.qq.com/cgi-bin/wxopen/template/add?access_token={$accesstoken}";
                $createTemplate = ihttp_post($createTemplate_url, $createTemplate_content);
                $createTemplate = json_decode($createTemplate['content'], true);
                if ($createTemplate['errcode'] == 0) {
                    $setting = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_SETTING) . "WHERE weid='{$_W['weid']}' ");
                    $data = array('weid' => $this->weid, 'create_template_id' => $createTemplate['template_id']);
                    if (!empty($setting)) {
                        pdo_update(DBCONFIG::$TABLE_KJB_SETTING, $data, array('id' => $setting['id']));
                    } else {
                        pdo_insert(DBCONFIG::$TABLE_KJB_SETTING, $data);
                    }
                }
            } else {
                if ($_GPC['type'] == 'remind_template_id') {
                    $templateInfo_content = json_encode(array('id' => 'AT1280', 'access_token' => $accesstoken));
                    $templateInfo_url = "https://api.weixin.qq.com/cgi-bin/wxopen/template/library/get?access_token={$accesstoken}";
                    $templateInfo = ihttp_post($templateInfo_url, $templateInfo_content);
                    $templateInfo = json_decode($templateInfo['content'], true);
                    $keyword_arr = array();
                    $keyword_len = 4;
                    for ($i = 0; $i < $keyword_len; $i++) {
                        foreach ($templateInfo['keyword_list'] as $key => $val) {
                            if (count($keyword_arr) == 0 && $val['name'] == '活动名称') {
                                array_push($keyword_arr, $val['keyword_id']);
                            }
                            if (count($keyword_arr) == 1 && $val['name'] == '开始时间') {
                                array_push($keyword_arr, $val['keyword_id']);
                            }
                            if (count($keyword_arr) == 2 && $val['name'] == '温馨提示') {
                                array_push($keyword_arr, $val['keyword_id']);
                            }
                        }
                    }
                    $createTemplate_content = json_encode(array('id' => 'AT1280', 'access_token' => $accesstoken, 'keyword_id_list' => $keyword_arr));
                    $createTemplate_url = "https://api.weixin.qq.com/cgi-bin/wxopen/template/add?access_token={$accesstoken}";
                    $createTemplate = ihttp_post($createTemplate_url, $createTemplate_content);
                    $createTemplate = json_decode($createTemplate['content'], true);
                    if ($createTemplate['errcode'] == 0) {
                        $setting = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_SETTING) . "WHERE weid='{$_W['weid']}' ");
                        $data = array('weid' => $this->weid, 'create_template_id' => $createTemplate['template_id']);
                        if (!empty($setting)) {
                            pdo_update(DBCONFIG::$TABLE_KJB_SETTING, $data, array('id' => $setting['id']));
                        } else {
                            pdo_insert(DBCONFIG::$TABLE_KJB_SETTING, $data);
                        }
                    }
                } else {
                    $templateInfo_content = json_encode(array('id' => 'AT0210', 'access_token' => $accesstoken));
                    $templateInfo_url = "https://api.weixin.qq.com/cgi-bin/wxopen/template/library/get?access_token={$accesstoken}";
                    $templateInfo = ihttp_post($templateInfo_url, $templateInfo_content);
                    $templateInfo = json_decode($templateInfo['content'], true);
                    $keyword_arr = array();
                    $keyword_len = 5;
                    for ($i = 0; $i < $keyword_len; $i++) {
                        foreach ($templateInfo['keyword_list'] as $key => $val) {
                            if (count($keyword_arr) == 0 && $val['name'] == '订单号') {
                                array_push($keyword_arr, $val['keyword_id']);
                            }
                            if (count($keyword_arr) == 1 && $val['name'] == '商品名称') {
                                array_push($keyword_arr, $val['keyword_id']);
                            }
                            if (count($keyword_arr) == 2 && $val['name'] == '支付方式') {
                                array_push($keyword_arr, $val['keyword_id']);
                            }
                            if (count($keyword_arr) == 3 && $val['name'] == '备注') {
                                array_push($keyword_arr, $val['keyword_id']);
                            }
                            if (count($keyword_arr) == 4 && $val['name'] == '下单时间') {
                                array_push($keyword_arr, $val['keyword_id']);
                            }
                        }
                    }
                    $createTemplate_content = json_encode(array('id' => 'AT0210', 'access_token' => $accesstoken, 'keyword_id_list' => $keyword_arr));
                    $createTemplate_url = "https://api.weixin.qq.com/cgi-bin/wxopen/template/add?access_token={$accesstoken}";
                    $createTemplate = ihttp_post($createTemplate_url, $createTemplate_content);
                    $createTemplate = json_decode($createTemplate['content'], true);
                    if ($createTemplate['errcode'] == 0) {
                        $setting = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_SETTING) . "WHERE weid='{$_W['weid']}' ");
                        $data = array('weid' => $this->weid, 'order_template_id' => $createTemplate['template_id']);
                        if (!empty($setting)) {
                            pdo_update(DBCONFIG::$TABLE_KJB_SETTING, $data, array('id' => $setting['id']));
                        } else {
                            pdo_insert(DBCONFIG::$TABLE_KJB_SETTING, $data);
                        }
                    }
                }
            }
        }
        return json_encode($createTemplate);
    }
    public function doWebhelpFirend()
    {
        global $_W, $_GPC;
        $operation = !empty($_GPC['op']) ? $_GPC['op'] : 'display';
        $bid = $_GPC['bid'];
        $keyword = $_GPC['keywords'];
        $where = '';
        $params = array(':bid' => $bid);
        if (!empty($keyword)) {
            $where .= ' and f.nickname like :nickname';
            $params[':nickname'] = "%{$keyword}%";
        }
        if (!empty($_GPC['uid'])) {
            $where .= ' and f.uid=:uid';
            $params[':uid'] = $_GPC['uid'];
        }
        if ($operation == 'display') {
            $pindex = max(1, intval($_GPC['page']));
            $psize = 20;
            $list = pdo_fetchall("select * from " . tablename(DBCONFIG::$TABLE_KJB_RECORD) . " f where f.bid=:bid " . $where . " order by f.createtime desc LIMIT " . ($pindex - 1) * $psize . ',' . $psize, $params);
            $setting = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_SETTING) . "WHERE weid='{$_W['weid']}'");
            foreach ($list as $key => $val) {
                if ($val['uid'] == 0) {
                    $list[$key]['nickname'] = '系统';
                    $list[$key]['avatar'] = tomedia($setting['sysavatar']);
                }
            }
            $total = pdo_fetchcolumn('SELECT COUNT(*) FROM ' . tablename(DBCONFIG::$TABLE_KJB_RECORD) . " f where f.bid=:bid  " . $where, $params);
            $pager = pagination($total, $pindex, $psize);
        } elseif ($operation == 'delete') {
            $id = $_GPC['id'];
            pdo_delete(DBCONFIG::$TABLE_KJB_RECORD, array('id' => $id));
            message('删除成功！', referer(), 'success');
        }
        include $this->template('bargain_record');
    }
    public function createtable($list, $filename, $header = array(), $index = array())
    {
        header("Content-type:application/vnd.ms-excel");
        header('Content-Disposition:filename=' . $filename . ".xls");
        $teble_header = implode("\t", $header);
        $strexport = $teble_header . "\r";
        foreach ($list as $row) {
            foreach ($index as $val) {
                $strexport .= $row[$val] . "\t";
            }
            $strexport .= "\r";
        }
        $strexport = iconv('UTF-8', "GB2312//IGNORE", $strexport);
        exit($strexport);
    }
    function doWebUpdateFont()
    {
        $url = 'https://wx.yipinyouke.com/addons/ypuk_kjb/images/font.TTF';
        $path = YPUK_KJB_RES . '/images';
        $filename = 'font';
        $type = 0;
        if ($url == '') {
            return false;
        }
        if ($type === 0) {
            $ch = curl_init();
            $timeout = 20;
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, $timeout);
            curl_setopt($ch, CURLOPT_TIMEOUT, $timeout);
            $img = curl_exec($ch);
            curl_close($ch);
        }
        if ($type === 1) {
            ob_start();
            readfile($url);
            $img = ob_get_contents();
            ob_end_clean();
        }
        if ($type === 2) {
            $img = file_get_contents($url);
        }
        if (empty($img)) {
            throw new \Exception("下载错误,无法获取下载文件！");
        }
        if ($path === '') {
            $path = "./";
        }
        if ($filename === "") {
            $filename = md5($img);
        }
        $ext = substr($url, strrpos($url, '.'));
        if ($ext && strlen($ext) < 5) {
            $filename .= $ext;
        }
        $path = rtrim($path, "/") . "/";
        $fp2 = @fopen($path . $filename, 'a');
        fwrite($fp2, $img);
        fclose($fp2);
        message('同步成功', referer(), 'success');
    }
    function doWebGetPoster()
    {
        global $_W, $_GPC;
        $type = $_GPC['type'];
        $id = $_GPC['id'];
        $message = '成功';
        if ($type == 1) {
            $activity = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_ACTIVITY) . "WHERE weid='{$_W['weid']}' AND id='{$id}'");
        } elseif ($type == 2) {
            $activity = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_PANICBUY) . "WHERE weid='{$_W['weid']}' AND id='{$id}'");
        } else {
            $activity = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_GROUPBUY) . "WHERE weid='{$_W['weid']}' AND id='{$id}'");
        }
        load()->func('file');
        $filename = ATTACHMENT_ROOT . '/ypuk_kjb/activity_' . $id . '_' . $type . '_' . $_W['weid'] . '.jpg';
        if (!file_exists(ATTACHMENT_ROOT . '/ypuk_kjb')) {
            mkdirs(ATTACHMENT_ROOT . '/ypuk_kjb');
        }
        mb_internal_encoding('UTF-8');
        if ($type == 1) {
            $img_name = IA_ROOT . "/addons/" . YPUK_KJB . "/images/kanjia_poster_bg.jpg";
        } elseif ($type == 2) {
            $img_name = IA_ROOT . "/addons/" . YPUK_KJB . "/images/panicbuy_poster_bg.jpg";
        } else {
            $img_name = IA_ROOT . "/addons/" . YPUK_KJB . "/images/groupbuy_poster_bg.jpg";
        }
        $image = imagecreatefromjpeg($img_name);
        $qrfile = $this->GetActivityQr($id, $type);
        $qr = imagecreatefromjpeg($qrfile);
        if ($activity['pic']) {
            $thumblist = unserialize($activity['pic']);
            if (is_array($thumblist)) {
                $thumbfile = tomedia($thumblist[0]);
            } else {
                $thumbfile = tomedia($thumblist);
            }
            $thumbinfo = getimagesize($thumbfile);
            if ($thumbinfo['mime'] == 'image/jpeg' || $thumbinfo['mime'] == 'image/jpg') {
                $thumb = imagecreatefromjpeg($thumbfile);
            }
            if ($thumbinfo['mime'] == 'gif') {
                $thumb = imagecreatefromgif($thumbfile);
            }
            if ($thumbinfo['mime'] == 'png') {
                $thumb = imagecreatefrompng($thumbfile);
            }
            imagecopyresized($image, $thumb, 60, 80, 0, 0, 455, 243, $thumbinfo[0], $thumbinfo[1]);
        }
        if (mb_strlen($activity['title'], 'utf-8') > 20) {
            $activity['title'] = mb_substr($activity['title'], 0, 20, 'utf-8') . '...';
        } else {
            $activity['title'] = $activity['title'];
        }
        $title = $activity['title'];
        $title_temp = array("color" => array(0, 0, 0), "fontsize" => 15, "width" => 420, "left" => 70, "top" => 330, "hang_size" => 30);
        $str_h = $this->draw_txt_to($image, $title_temp, $title, true);
        if ($type == 1) {
            $newprice_text = '最低价';
            $newprice = '￥' . $activity['lowprice'];
        } elseif ($type == 2) {
            $newprice_text = '抢购价';
            $newprice = '￥' . $activity['nowprice'];
        } else {
            $newprice_text = '拼团价';
            $newprice = '￥' . $activity['groupprice'];
        }
        $newpricetext_temp = array("color" => array(88, 88, 88), "fontsize" => 14, "width" => 370, "left" => 100, "top" => 400, "hang_size" => 30);
        $str_h = $this->draw_txt_to($image, $newpricetext_temp, $newprice_text, true);
        $newprice_temp = array("color" => array(238, 79, 79), "fontsize" => 14, "width" => 370, "left" => 165, "top" => 400, "hang_size" => 30);
        $str_h = $this->draw_txt_to($image, $newprice_temp, $newprice, true);
        $oldprice = '原价￥' . $activity['oldprice'];
        $oldprice_temp = array("color" => array(88, 88, 88), "fontsize" => 14, "width" => 370, "left" => 340, "top" => 400, "hang_size" => 30);
        $str_h = $this->draw_txt_to($image, $oldprice_temp, $oldprice, true);
        imagecopyresized($image, $qr, 190, 470, 0, 0, 180, 180, 630, 630);
        imagedestroy($qr);
        ImageJPEG($image, $filename, 100);
        imagedestroy($image);
        $result['filename'] = tomedia('/ypuk_kjb/activity_' . $id . '_' . $type . '_' . $_W['weid'] . '.jpg');
        return json_encode($result);
    }
    function GetActivityQr($id, $type)
    {
        global $_GPC, $_W;
        load()->func('file');
        $filename = ATTACHMENT_ROOT . '/ypuk_kjb/activity_' . $id . '_' . $type . '_' . $_W['weid'] . '_qr.jpg';
        if (file_exists($filename) && filesize($filename) > 200) {
            return $filename;
        } else {
            if (!file_exists(ATTACHMENT_ROOT . '/ypuk_kjb')) {
                mkdirs(ATTACHMENT_ROOT . '/ypuk_kjb');
            }
            load()->classs('wxapp.account');
            $appinfo = new WxappAccount($_W['account']);
            $accesstoken = $appinfo->getAccessToken();
            load()->func('communication');
            $url = 'https://api.weixin.qq.com/wxa/getwxacodeunlimit?access_token=' . $accesstoken;
            if ($type == 1) {
                $page = 'ypuk_kjb/pages/detail/detail';
            } elseif ($type == 2) {
                $page = 'ypuk_kjb/pages/panicbuy_detail/panicbuy_detail';
            } else {
                $page = 'ypuk_kjb/pages/groupbuy_detail/groupbuy_detail';
            }
            $data = array('scene' => $id, 'page' => $page, 'width' => 630);
            $response = ihttp_post($url, json_encode($data));
            var_dump($response);
            if (empty($response['content'])) {
                echo 'nostream';
                exit;
            }
            $file = fopen($filename, "w");
            fwrite($file, $response['content']);
            fclose($file);
            return $filename;
        }
    }
    function doWebDelPoster()
    {
        global $_GPC, $_W;
        $type = $_GPC['type'];
        $id = $_GPC['id'];
        if (!unlink(ATTACHMENT_ROOT . 'ypuk_kjb/activity_' . $id . '_' . $type . '_' . $_W['weid'] . '_qr.jpg') || !unlink(ATTACHMENT_ROOT . 'ypuk_kjb/activity_' . $id . '_' . $type . '_' . $_W['weid'] . '.jpg')) {
            return false;
        } else {
            return true;
        }
    }
    public function draw_txt_to($card, $pos, $str, $iswrite)
    {
        $_str_h = $pos["top"];
        $fontsize = $pos["fontsize"];
        $width = $pos["width"];
        $margin_lift = $pos["left"];
        $hang_size = $pos["hang_size"];
        $temp_string = "";
        $font_file = IA_ROOT . "/addons/" . YPUK_KJB . "/images/font.TTF";
        $tp = 0;
        $font_color = imagecolorallocate($card, $pos["color"][0], $pos["color"][1], $pos["color"][2]);
        for ($i = 0; $i < mb_strlen($str); $i++) {
            $box = imagettfbbox($fontsize, 0, $font_file, $temp_string);
            $_string_length = $box[2] - $box[0];
            $temptext = mb_substr($str, $i, 1);
            $temp = imagettfbbox($fontsize, 0, $font_file, $temptext);
            if ($_string_length + $temp[2] - $temp[0] < $width) {
                $temp_string .= mb_substr($str, $i, 1);
                if ($i == mb_strlen($str) - 1) {
                    $_str_h += $hang_size;
                    $tp++;
                    if ($iswrite) {
                        imagettftext($card, $fontsize, 0, $margin_lift, $_str_h, $font_color, $font_file, $temp_string);
                    }
                }
            } else {
                $texts = mb_substr($str, $i, 1);
                $isfuhao = preg_match("/[\\\\pP]/u", $texts) ? true : false;
                if ($isfuhao) {
                    $temp_string .= $texts;
                    $f = mb_substr($str, $i + 1, 1);
                    $fh = preg_match("/[\\\\pP]/u", $f) ? true : false;
                    if ($fh) {
                        $temp_string .= $f;
                        $i++;
                    }
                } else {
                    $i--;
                }
                $tmp_str_len = mb_strlen($temp_string);
                $s = mb_substr($temp_string, $tmp_str_len - 1, 1);
                if ($this->is_firstfuhao($s)) {
                    $temp_string = rtrim($temp_string, $s);
                    $i--;
                }
                $_str_h += $hang_size;
                $tp++;
                if ($iswrite) {
                    imagettftext($card, $fontsize, 0, $margin_lift, $_str_h, $font_color, $font_file, $temp_string);
                }
                $temp_string = "";
            }
        }
        return $tp * $hang_size;
    }
    public function is_firstfuhao($str)
    {
        $fuhaos = array("“", "'", "<", "《");
        return in_array($str, $fuhaos);
    }
    public function get_lt_rounder_corner($radius, $color_r, $color_g, $color_b)
    {
        $img = imagecreatetruecolor($radius, $radius);
        $bgcolor = imagecolorallocate($img, $color_r, $color_g, $color_b);
        $fgcolor = imagecolorallocate($img, 0, 0, 0);
        imagefill($img, 0, 0, $bgcolor);
        imagefilledarc($img, $radius, $radius, $radius * 2, $radius * 2, 180, 270, $fgcolor, IMG_ARC_PIE);
        imagecolortransparent($img, $fgcolor);
        return $img;
    }
    public function myradus($im, $lift, $top, $lt_corner, $radius, $image_h, $image_w)
    {
        imagecopymerge($im, $lt_corner, $lift, $top, 0, 0, $radius, $radius, 100);
        $lb_corner = imagerotate($lt_corner, 90, 0);
        imagecopymerge($im, $lb_corner, $lift, $image_h - $radius + $top, 0, 0, $radius, $radius, 100);
        $rb_corner = imagerotate($lt_corner, 180, 0);
        imagecopymerge($im, $rb_corner, $image_w + $lift - $radius, $image_h + $top - $radius, 0, 0, $radius, $radius, 100);
        $rt_corner = imagerotate($lt_corner, 270, 0);
        imagecopymerge($im, $rt_corner, $image_w - $radius + $lift, $top, 0, 0, $radius, $radius, 100);
    }
    public function GetStrBetween($content, $start, $end)
    {
        $r = explode($start, $content);
        if (isset($r[1])) {
            $r = explode($end, $r[1]);
            return $r[0];
        }
        return '';
    }
    public function formatStock($stock)
    {
        if ($stock > 0) {
            return $stock;
        } else {
            return 0;
        }
    }
    public function getStatusText($status, $type)
    {
        switch ($status) {
            case $this::$KJ_STATUS_WKS:
                return "未开始";
                break;
            case $this::$KJ_STATUS_ZC:
                return "正常";
                break;
            case $this::$KJ_STATUS_JS:
                return "已结束";
                break;
            case $this::$KJ_STATUS_XD:
                return "已下单";
                break;
            case $this::$KJ_STATUS_GM:
                return "等待发货";
                break;
            case $this::$KJ_STATUS_YFH:
                if ($type == 0) {
                    return "已发货";
                } else {
                    return '等待到店';
                }
                break;
            case $this::$KJ_STATUS_YWC:
                if ($type == 0) {
                    return "已完成";
                } else {
                    return '已核销';
                }
                break;
            case $this::$KJ_STATUS_YTK:
                return "已退款";
                break;
        }
    }
}