<?php

defined('IN_IA') or exit('Access Denied');
define('YPUK_KJB', 'ypuk_kjb');
define('YPUK_KJB_RES', '../addons/' . YPUK_KJB . "/");
require_once IA_ROOT . '/addons/' . YPUK_KJB . '/dbconfig.class.php';
class Ypuk_kjbModuleWxapp extends WeModuleWxapp
{
    public static $KJ_STATUS_WKS = 0;
    public static $KJ_STATUS_ZC = 1;
    public static $KJ_STATUS_JS = 2;
    public static $KJ_STATUS_XD = 3;
    public static $KJ_STATUS_GM = 4;
    public static $KJ_STATUS_YFH = 5;
    public static $KJ_STATUS_YWC = 6;
    public static $KJ_STATUS_YGQ = 7;
    public static $KJ_STATUS_YTK = 9;
    public static $DEFAULT_AVATAR = '../../resource/images/default_avatar.png';
    public static $TIP_DIALOG = 1;
    public static $TIP_U_FIRST = 2;
    public static $TIP_U_ALREADY = 3;
    public static $TIP_RANK = 4;
    public static $TIP_FK_FIRST = 5;
    public static $TIP_FK_ALREADY = 6;
    public $Setting;
    public $attachment_root;
    public function __construct()
    {
        global $_W;
        $setting = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_SETTING) . "WHERE weid='{$_W['weid']}'");
        $this->attachment_root = $setting['rooturl'] . 'attachment/';
        $this->qqmapkey = $setting['qqmapkey'];
        if (empty($setting['openremind']) || $setting['openremind'] == 0) {
            $this->openremind = 0;
        } else {
            $this->openremind = 1;
        }
    }
    public function doPageList()
    {
        global $_GPC, $_W;
        $message = '成功';
        load()->model('mc');
        $mod = $_GPC['tab'];
        $uid = $_GPC['uid'];
        $setting = pdo_fetch("SELECT function_setting FROM " . tablename(DBCONFIG::$TABLE_KJB_SETTING) . " WHERE weid='{$_W['weid']}'");
        if (!empty($setting['function_setting'])) {
            $function_data = unserialize($setting['function_setting']);
        }
        if (!empty($setting['function_setting']) && ($function_data['openpanicbuy'] == 1 || $function_data['opengroupbuy'] == 1)) {
            if ($_GPC['version'] == '4.2') {
                $pindex = max(1, intval($_GPC['page']));
                $psize = 10;
                $where = ' ';
                if ($mod == 'now') {
                    $where = ' AND starttime<' . TIMESTAMP . ' AND endtime>' . TIMESTAMP . ' AND stock>0';
                }
                if ($mod == 'ready') {
                    $where = ' AND starttime>' . TIMESTAMP . ' AND endtime>' . TIMESTAMP . ' AND stock>0';
                }
                $list = pdo_fetchall("SELECT * FROM " . tablename(DBCONFIG::$TABLE_KJB_ACTIVITYINDEX) . " WHERE weid='{$_W['weid']}' AND status=0 " . $where . " ORDER BY createtime DESC, id DESC LIMIT " . ($pindex - 1) * $psize . ',' . $psize);
                foreach ($list as $key => $val) {
                    if ($val['activitytype'] == 1) {
                        $activity = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_ACTIVITY) . "WHERE weid='{$_W['weid']}' AND id='{$val['aid']}'");
                        $list[$key] = $activity;
                        $bargainnum = pdo_fetchcolumn('SELECT COUNT(*) FROM ' . tablename(DBCONFIG::$TABLE_KJB_BARGAIN) . " WHERE weid='{$_W['weid']}' AND aid='{$val['aid']}'");
                        $list[$key]['bargainnum'] = $activity['bargainnum_min'] + $bargainnum;
                        $userlist = pdo_fetchall("SELECT * FROM " . tablename(DBCONFIG::$TABLE_KJB_BARGAIN) . " WHERE weid='{$_W['weid']}' AND aid='{$val['aid']}' ORDER BY createtime DESC, id DESC LIMIT 0,7");
                        $avatar_arr = array();
                        foreach ($userlist as $ukey => $uval) {
                            $userinfo = mc_fansinfo($uval['uid'], $_W['acid'], $_W['uniacid']);
                            if ($userinfo['avatar']) {
                                array_push($avatar_arr, $userinfo['avatar']);
                            } else {
                                array_push($avatar_arr, $this::$DEFAULT_AVATAR);
                            }
                        }
                        $list[$key]['avatar'] = $avatar_arr;
                    } elseif ($val['activitytype'] == 2) {
                        $activity = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_PANICBUY) . "WHERE weid='{$_W['weid']}' AND id='{$val['aid']}'");
                        $list[$key] = $activity;
                        $buynum = pdo_fetchcolumn('SELECT COUNT(*) FROM ' . tablename(DBCONFIG::$TABLE_KJB_ORDER) . " WHERE weid='{$_W['weid']}' AND aid='{$val['aid']}' AND type=2");
                        $list[$key]['buynum'] = $activity['buynum_min'] + $buynum;
                        $userlist = pdo_fetchall("SELECT * FROM " . tablename(DBCONFIG::$TABLE_KJB_ORDER) . " WHERE weid='{$_W['weid']}' AND aid='{$val['aid']}' AND type=2 ORDER BY createtime DESC, id DESC LIMIT 0,7");
                        $avatar_arr = array();
                        foreach ($userlist as $ukey => $uval) {
                            $userinfo = mc_fansinfo($uval['uid'], $_W['acid'], $_W['uniacid']);
                            if ($userinfo['avatar']) {
                                array_push($avatar_arr, $userinfo['avatar']);
                            } else {
                                array_push($avatar_arr, $this::$DEFAULT_AVATAR);
                            }
                        }
                        $list[$key]['avatar'] = $avatar_arr;
                    } else {
                        $activity = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_GROUPBUY) . "WHERE weid='{$_W['weid']}' AND id='{$val['aid']}'");
                        $list[$key] = $activity;
                        $groupnum = pdo_fetchcolumn('SELECT COUNT(*) FROM ' . tablename(DBCONFIG::$TABLE_KJB_GROUP) . " WHERE weid='{$_W['weid']}' AND aid='{$val['id']}'");
                        $list[$key]['groupnum'] = $activity['groupnum_min'] + $groupnum;
                        $userlist = pdo_fetchall("SELECT * FROM " . tablename(DBCONFIG::$TABLE_KJB_GROUPRECORD) . " WHERE weid='{$_W['weid']}' AND aid='{$val['aid']}' ORDER BY createtime DESC, id DESC LIMIT 0,7");
                        $avatar_arr = array();
                        foreach ($userlist as $ukey => $uval) {
                            $userinfo = mc_fansinfo($uval['uid'], $_W['acid'], $_W['uniacid']);
                            if ($userinfo['avatar']) {
                                array_push($avatar_arr, $userinfo['avatar']);
                            } else {
                                array_push($avatar_arr, $this::$DEFAULT_AVATAR);
                            }
                        }
                        $list[$key]['avatar'] = $avatar_arr;
                    }
                    if (TIMESTAMP < $activity['starttime']) {
                        $list[$key]['status'] = $this::$KJ_STATUS_WKS;
                        if ($activity['starttime'] - TIMESTAMP < 86400 * 6 && $this->openremind == 1) {
                            $remind = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_REMIND) . "WHERE weid='{$_W['weid']}' AND uid='{$uid}' AND aid='{$val['aid']}' AND type='{$val['activitytype']}'");
                            if (empty($remind)) {
                                $list[$key]['remind'] = 1;
                            } else {
                                $list[$key]['remind'] = 2;
                            }
                        } else {
                            $list[$key]['remind'] = 0;
                        }
                    } elseif (TIMESTAMP > $val['endtime']) {
                        $list[$key]['status'] = $this::$KJ_STATUS_JS;
                    } else {
                        $list[$key]['status'] = $this::$KJ_STATUS_ZC;
                    }
                    $activity['pic'] = unserialize($activity['pic']);
                    $list[$key]['pic'] = tomedia($activity['pic'][0]);
                    $list[$key]['stock'] = $this->formatStock($activity['stock']);
                }
                $result = $list;
            } else {
                $pindex = max(1, intval($_GPC['page']));
                $psize = 3;
                $where = ' AND starttime<' . TIMESTAMP . ' AND endtime>' . TIMESTAMP . ' AND stock>0';
                $kanjia_list = pdo_fetchall("SELECT * FROM " . tablename(DBCONFIG::$TABLE_KJB_ACTIVITY) . " WHERE weid='{$_W['weid']}' AND status=0 " . $where . " ORDER BY createtime DESC, id DESC LIMIT " . ($pindex - 1) * $psize . ',' . $psize);
                foreach ($kanjia_list as $key => $val) {
                    if (TIMESTAMP < $val['starttime']) {
                        $kanjia_list[$key]['status'] = $this::$KJ_STATUS_WKS;
                        if ($val['starttime'] - TIMESTAMP < 86400 * 6 && $this->openremind == 1) {
                            $remind = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_REMIND) . "WHERE weid='{$_W['weid']}' AND uid='{$uid}' AND aid='{$val['id']}' AND type=1");
                            if (empty($remind)) {
                                $kanjia_list[$key]['remind'] = 1;
                            } else {
                                $kanjia_list[$key]['remind'] = 2;
                            }
                        } else {
                            $kanjia_list[$key]['remind'] = 0;
                        }
                    } elseif (TIMESTAMP > $val['endtime']) {
                        $kanjia_list[$key]['status'] = $this::$KJ_STATUS_JS;
                    } else {
                        $kanjia_list[$key]['status'] = $this::$KJ_STATUS_ZC;
                    }
                    $bargainnum = pdo_fetchcolumn('SELECT COUNT(*) FROM ' . tablename(DBCONFIG::$TABLE_KJB_BARGAIN) . " WHERE weid='{$_W['weid']}' AND aid='{$val['id']}'");
                    $kanjia_list[$key]['bargainnum'] = $val['bargainnum_min'] + $bargainnum;
                    $userlist = pdo_fetchall("SELECT * FROM " . tablename(DBCONFIG::$TABLE_KJB_BARGAIN) . " WHERE weid='{$_W['weid']}' AND aid='{$val['id']}' ORDER BY createtime DESC, id DESC LIMIT 0,7");
                    $avatar_arr = array();
                    foreach ($userlist as $ukey => $uval) {
                        $userinfo = mc_fansinfo($uval['uid'], $_W['acid'], $_W['uniacid']);
                        if ($userinfo['avatar']) {
                            array_push($avatar_arr, $userinfo['avatar']);
                        } else {
                            array_push($avatar_arr, $this::$DEFAULT_AVATAR);
                        }
                    }
                    $kanjia_list[$key]['endtime'] = date('y-m-d', $val['endtime']);
                    $kanjia_list[$key]['starttime'] = date('y-m-d', $val['starttime']);
                    $kanjia_list[$key]['avatar'] = $avatar_arr;
                    $val['pic'] = unserialize($val['pic']);
                    $kanjia_list[$key]['pic'] = tomedia($val['pic'][0]);
                }
                $panicbuy_list = pdo_fetchall("SELECT * FROM " . tablename(DBCONFIG::$TABLE_KJB_PANICBUY) . " WHERE weid='{$_W['weid']}' AND status=0 " . $where . " ORDER BY createtime DESC, id DESC LIMIT " . ($pindex - 1) * $psize . ',' . $psize);
                foreach ($panicbuy_list as $key => $val) {
                    if (TIMESTAMP < $val['starttime']) {
                        $panicbuy_list[$key]['status'] = $this::$KJ_STATUS_WKS;
                        if ($val['starttime'] - TIMESTAMP < 86400 * 6 && $this->openremind == 1) {
                            $remind = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_REMIND) . "WHERE weid='{$_W['weid']}' AND uid='{$uid}' AND aid='{$val['id']}' AND type=2");
                            if (empty($remind)) {
                                $panicbuy_list[$key]['remind'] = 1;
                            } else {
                                $panicbuy_list[$key]['remind'] = 2;
                            }
                        } else {
                            $panicbuy_list[$key]['remind'] = 0;
                        }
                    } elseif (TIMESTAMP > $val['endtime']) {
                        $panicbuy_list[$key]['status'] = $this::$KJ_STATUS_JS;
                    } else {
                        $panicbuy_list[$key]['status'] = $this::$KJ_STATUS_ZC;
                    }
                    $panicbuy_list[$key]['endtime'] = date('y-m-d', $val['endtime']);
                    $panicbuy_list[$key]['starttime'] = date('y-m-d', $val['starttime']);
                    $val['pic'] = unserialize($val['pic']);
                    $panicbuy_list[$key]['pic'] = tomedia($val['pic'][0]);
                }
                $groupbuy_list = pdo_fetchall("SELECT * FROM " . tablename(DBCONFIG::$TABLE_KJB_GROUPBUY) . " WHERE weid='{$_W['weid']}' AND status=0 " . $where . " ORDER BY createtime DESC, id DESC LIMIT " . ($pindex - 1) * $psize . ',' . $psize);
                foreach ($groupbuy_list as $key => $val) {
                    if (TIMESTAMP < $val['starttime']) {
                        $groupbuy_list[$key]['status'] = $this::$KJ_STATUS_WKS;
                        if ($val['starttime'] - TIMESTAMP < 86400 * 6 && $this->openremind == 1) {
                            $remind = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_REMIND) . "WHERE weid='{$_W['weid']}' AND uid='{$uid}' AND aid='{$val['id']}' AND type=2");
                            if (empty($remind)) {
                                $groupbuy_list[$key]['remind'] = 1;
                            } else {
                                $groupbuy_list[$key]['remind'] = 2;
                            }
                        } else {
                            $groupbuy_list[$key]['remind'] = 0;
                        }
                    } elseif (TIMESTAMP > $val['endtime']) {
                        $groupbuy_list[$key]['status'] = $this::$KJ_STATUS_JS;
                    } else {
                        $groupbuy_list[$key]['status'] = $this::$KJ_STATUS_ZC;
                    }
                    $groupnum = pdo_fetchcolumn('SELECT COUNT(*) FROM ' . tablename(DBCONFIG::$TABLE_KJB_GROUP) . " WHERE weid='{$_W['weid']}' AND aid=''{$val['id']}'");
                    $groupbuy_list[$key]['groupnum'] = $val['groupnum_min'] + $groupnum;
                    $groupbuy_list[$key]['endtime'] = date('y-m-d', $val['endtime']);
                    $groupbuy_list[$key]['starttime'] = date('y-m-d', $val['starttime']);
                    $val['pic'] = unserialize($val['pic']);
                    $groupbuy_list[$key]['pic'] = tomedia($val['pic'][0]);
                }
                $result['kanjia'] = $kanjia_list;
                $result['panicbuy'] = $panicbuy_list;
                $result['groupbuy'] = $groupbuy_list;
            }
        } else {
            $pindex = max(1, intval($_GPC['page']));
            $psize = 10;
            $where = ' ';
            if ($mod == 'now') {
                $where = ' AND starttime<' . TIMESTAMP . ' AND endtime>' . TIMESTAMP . ' AND stock>0';
            }
            if ($mod == 'ready') {
                $where = ' AND starttime>' . TIMESTAMP . ' AND endtime>' . TIMESTAMP . ' AND stock>0';
            }
            $list = pdo_fetchall("SELECT * FROM " . tablename(DBCONFIG::$TABLE_KJB_ACTIVITY) . " WHERE weid='{$_W['weid']}' AND status=0 " . $where . " ORDER BY createtime DESC, id DESC LIMIT " . ($pindex - 1) * $psize . ',' . $psize);
            foreach ($list as $key => $val) {
                if (TIMESTAMP < $val['starttime']) {
                    $list[$key]['status'] = $this::$KJ_STATUS_WKS;
                    if ($val['starttime'] - TIMESTAMP < 86400 * 6 && $this->openremind == 1) {
                        $remind = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_REMIND) . "WHERE weid='{$_W['weid']}' AND uid='{$uid}' AND aid='{$val['id']}' AND type=1");
                        if (empty($remind)) {
                            $list[$key]['remind'] = 1;
                        } else {
                            $list[$key]['remind'] = 2;
                        }
                    } else {
                        $list[$key]['remind'] = 0;
                    }
                } elseif (TIMESTAMP > $val['endtime']) {
                    $list[$key]['status'] = $this::$KJ_STATUS_JS;
                } else {
                    $list[$key]['status'] = $this::$KJ_STATUS_ZC;
                }
                $bargainnum = pdo_fetchcolumn('SELECT COUNT(*) FROM ' . tablename(DBCONFIG::$TABLE_KJB_BARGAIN) . " WHERE weid='{$_W['weid']}' AND aid='{$val['id']}'");
                $list[$key]['bargainnum'] = $val['bargainnum_min'] + $bargainnum;
                $userlist = pdo_fetchall("SELECT * FROM " . tablename(DBCONFIG::$TABLE_KJB_BARGAIN) . " WHERE weid='{$_W['weid']}' AND aid='{$val['id']}' ORDER BY createtime DESC, id DESC LIMIT 0,7");
                $avatar_arr = array();
                foreach ($userlist as $ukey => $uval) {
                    $userinfo = mc_fansinfo($uval['uid'], $_W['acid'], $_W['uniacid']);
                    if ($userinfo['avatar']) {
                        array_push($avatar_arr, $userinfo['avatar']);
                    } else {
                        array_push($avatar_arr, $this::$DEFAULT_AVATAR);
                    }
                }
                $list[$key]['avatar'] = $avatar_arr;
                $val['pic'] = unserialize($val['pic']);
                $list[$key]['pic'] = tomedia($val['pic'][0]);
            }
            $result = $list;
        }
        return $this->result(0, $message, $result);
    }
    public function doPageCatKanjia()
    {
        global $_GPC, $_W;
        $message = '成功';
        load()->model('mc');
        $pindex = max(1, intval($_GPC['page']));
        $psize = 20;
        $catid = $_GPC['catid'];
        $type = $_GPC['type'];
        $uid = $_GPC['uid'];
        $where = '';
        if ($type == 'now') {
            $where .= ' AND starttime<' . TIMESTAMP . ' AND endtime>' . TIMESTAMP . ' AND stock>0';
        }
        if ($type == 'ready') {
            $where .= ' AND starttime>' . TIMESTAMP . ' AND endtime>' . TIMESTAMP . ' AND stock>0';
        }
        if ($catid && $catid != '0') {
            $where .= ' AND catid=' . $catid . '';
        }
        $list = pdo_fetchall("SELECT * FROM " . tablename(DBCONFIG::$TABLE_KJB_ACTIVITY) . " WHERE weid='{$_W['weid']}' AND status=0 " . $where . " ORDER BY createtime DESC, id DESC LIMIT " . ($pindex - 1) * $psize . ',' . $psize);
        foreach ($list as $key => $val) {
            if (TIMESTAMP < $val['starttime']) {
                $list[$key]['status'] = $this::$KJ_STATUS_WKS;
                if ($val['starttime'] - TIMESTAMP < 86400 * 6 && $this->openremind == 1) {
                    $remind = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_REMIND) . "WHERE weid='{$_W['weid']}' AND uid='{$uid}' AND aid='{$val['id']}' AND type=1");
                    if (empty($remind)) {
                        $list[$key]['remind'] = 1;
                    } else {
                        $list[$key]['remind'] = 2;
                    }
                } else {
                    $list[$key]['remind'] = 0;
                }
            } elseif (TIMESTAMP > $val['endtime']) {
                $list[$key]['status'] = $this::$KJ_STATUS_JS;
            } else {
                $list[$key]['status'] = $this::$KJ_STATUS_ZC;
            }
            $bargainnum = pdo_fetchcolumn('SELECT COUNT(*) FROM ' . tablename(DBCONFIG::$TABLE_KJB_BARGAIN) . " WHERE weid='{$_W['weid']}' AND aid='{$val['id']}'");
            $list[$key]['bargainnum'] = $val['bargainnum_min'] + $bargainnum;
            $userlist = pdo_fetchall("SELECT * FROM " . tablename(DBCONFIG::$TABLE_KJB_BARGAIN) . " WHERE weid='{$_W['weid']}' AND aid='{$val['id']}' ORDER BY createtime DESC, id DESC LIMIT 0,7");
            $avatar_arr = array();
            foreach ($userlist as $ukey => $uval) {
                $userinfo = mc_fansinfo($uval['uid'], $_W['acid'], $_W['uniacid']);
                if ($userinfo['avatar']) {
                    array_push($avatar_arr, $userinfo['avatar']);
                } else {
                    array_push($avatar_arr, $this::$DEFAULT_AVATAR);
                }
            }
            $list[$key]['avatar'] = $avatar_arr;
            $val['pic'] = unserialize($val['pic']);
            $list[$key]['pic'] = tomedia($val['pic'][0]);
            $list[$key]['stock'] = $this->formatStock($val['stock']);
        }
        return $this->result(0, $message, $list);
    }
    public function doPageCatActivity()
    {
        global $_GPC, $_W;
        $message = '成功';
        load()->model('mc');
        $pindex = max(1, intval($_GPC['page']));
        $psize = 20;
        $catid = $_GPC['catid'];
        $type = $_GPC['type'];
        $uid = $_GPC['uid'];
        $where = ' ';
        if ($type == 'now') {
            $where .= ' AND starttime<' . TIMESTAMP . ' AND endtime>' . TIMESTAMP . ' AND stock>0';
        }
        if ($type == 'ready') {
            $where .= ' AND starttime>' . TIMESTAMP . ' AND endtime>' . TIMESTAMP . ' AND stock>0';
        }
        if ($catid && $catid != '0') {
            $where .= ' AND catid=' . $catid . '';
        }
        $list = pdo_fetchall("SELECT * FROM " . tablename(DBCONFIG::$TABLE_KJB_ACTIVITY) . " WHERE weid='{$_W['weid']}' AND status=0 " . $where . " ORDER BY createtime DESC, id DESC LIMIT " . ($pindex - 1) * $psize . ',' . $psize);
        foreach ($list as $key => $val) {
            if (TIMESTAMP < $val['starttime']) {
                $list[$key]['status'] = $this::$KJ_STATUS_WKS;
                if ($val['starttime'] - TIMESTAMP < 86400 * 6 && $this->openremind == 1) {
                    $remind = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_REMIND) . "WHERE weid='{$_W['weid']}' AND uid='{$uid}' AND aid='{$val['id']}' AND type=1");
                    if (empty($remind)) {
                        $list[$key]['remind'] = 1;
                    } else {
                        $list[$key]['remind'] = 2;
                    }
                } else {
                    $list[$key]['remind'] = 0;
                }
            } elseif (TIMESTAMP > $val['endtime']) {
                $list[$key]['status'] = $this::$KJ_STATUS_JS;
            } else {
                $list[$key]['status'] = $this::$KJ_STATUS_ZC;
            }
            $bargainnum = pdo_fetchcolumn('SELECT COUNT(*) FROM ' . tablename(DBCONFIG::$TABLE_KJB_BARGAIN) . " WHERE weid='{$_W['weid']}' AND aid='{$val['id']}'");
            $list[$key]['bargainnum'] = $val['bargainnum_min'] + $bargainnum;
            $userlist = pdo_fetchall("SELECT * FROM " . tablename(DBCONFIG::$TABLE_KJB_BARGAIN) . " WHERE weid='{$_W['weid']}' AND aid='{$val['id']}' ORDER BY createtime DESC, id DESC LIMIT 0,7");
            $avatar_arr = array();
            foreach ($userlist as $ukey => $uval) {
                $userinfo = mc_fansinfo($uval['uid'], $_W['acid'], $_W['uniacid']);
                if ($userinfo['avatar']) {
                    array_push($avatar_arr, $userinfo['avatar']);
                } else {
                    array_push($avatar_arr, $this::$DEFAULT_AVATAR);
                }
            }
            $list[$key]['avatar'] = $avatar_arr;
            $val['pic'] = unserialize($val['pic']);
            $list[$key]['pic'] = tomedia($val['pic'][0]);
            $list[$key]['stock'] = $this->formatStock($val['stock']);
        }
        return $this->result(0, $message, $list);
    }
    public function doPageCategoryList()
    {
        global $_GPC, $_W;
        $message = '成功';
        $type = $_GPC['type'];
        $category = pdo_fetchall("SELECT * FROM " . tablename(DBCONFIG::$TABLE_KJB_CATEGORY) . " WHERE weid='{$_W['weid']}' AND enabled=1 AND type=" . $type . " ORDER BY sort ASC");
        $categorycount = count($category);
        foreach ($category as $key => $val) {
            $category[$key]['icon'] = tomedia($val['icon']);
            if ($categorycount == 1) {
                $category[$key]['width'] = '100%';
            } elseif ($categorycount == 2) {
                $category[$key]['width'] = '50%';
            } elseif ($categorycount == 3) {
                $category[$key]['width'] = '33.3%';
            } else {
                $category[$key]['width'] = '25%';
            }
        }
        return $this->result(0, $message, $category);
    }
    public function doPageRecommendList()
    {
        global $_GPC, $_W;
        $message = '成功';
        load()->model('mc');
        $list = pdo_fetchall("SELECT * FROM " . tablename(DBCONFIG::$TABLE_KJB_ACTIVITY) . " WHERE weid='{$_W['weid']}' AND status=0 AND recommend=1  AND starttime<'" . TIMESTAMP . "' AND endtime>'" . TIMESTAMP . "' AND stock>0 ORDER BY createtime DESC, id DESC LIMIT 0,7");
        foreach ($list as $key => $val) {
            if (TIMESTAMP < $val['starttime']) {
                $list[$key]['status'] = $this::$KJ_STATUS_WKS;
            } elseif (TIMESTAMP > $val['endtime']) {
                $list[$key]['status'] = $this::$KJ_STATUS_JS;
            } else {
                $list[$key]['status'] = $this::$KJ_STATUS_ZC;
            }
            $val['pic'] = unserialize($val['pic']);
            $list[$key]['pic'] = tomedia($val['pic'][0]);
            $list[$key]['stock'] = $this->formatStock($val['stock']);
        }
        return $this->result(0, $message, $list);
    }
    public function doPageGetDetail()
    {
        global $_GPC, $_W;
        $message = '成功';
        $id = $_GPC['activityid'];
        $uid = $_GPC['uid'];
        $ulat = $_GPC['ulat'];
        $ulng = $_GPC['ulng'];
        $activity = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_ACTIVITY) . "WHERE weid='{$_W['weid']}' AND id='{$id}'");
        if (empty($activity)) {
            return $this->result(1, '活动不存在或已被删除', '');
        }
        $UserBargain = $this->findUserBargain($id, $uid);
        if (!empty($UserBargain)) {
            $activity['user_isbargain'] = 1;
            $activity['user_bargainid'] = $UserBargain['id'];
        } else {
            $activity['user_isbargain'] = 0;
        }
        if (!empty($activity['allowcity'])) {
            $activity['checkcity'] = $this->checkCity($id, $ulng, $ulat);
        } else {
            $activity['checkcity'] = 1;
        }
        if ($activity['pic']) {
            $activity['pic'] = unserialize($activity['pic']);
            foreach ($activity['pic'] as $key => $val) {
                $activity['pic'][$key] = tomedia($activity['pic'][$key]);
            }
        }
        if ($activity['sharepic']) {
            $activity['sharepic'] = tomedia($activity['sharepic']);
        }
        if ($activity['type'] == 1 && $activity['validity'] != 0) {
            $activity['validity'] = date('Y-m-d H:i:s', $activity['validity']);
        }
        $endtime_array = getdate($activity['endtime']);
        $activity['format_endtime'] = date('Y-m-d H:i:s', $activity['endtime']);
        $activity['endhours'] = $endtime_array["hours"];
        $activity['endminutes'] = $endtime_array["minutes"];
        $activity['endseconds'] = $endtime_array["seconds"];
        $activity['endmonth'] = $endtime_array["mon"];
        $activity['endday'] = $endtime_array["mday"];
        $activity['endyear'] = $endtime_array["year"];
        $starttime_array = getdate($activity['starttime']);
        $activity['format_starttime'] = date('Y-m-d H:i:s', $activity['starttime']);
        $activity['starthours'] = $starttime_array["hours"];
        $activity['startminutes'] = $starttime_array["minutes"];
        $activity['startseconds'] = $starttime_array["seconds"];
        $activity['startmonth'] = $starttime_array["mon"];
        $activity['startday'] = $starttime_array["mday"];
        $activity['startyear'] = $starttime_array["year"];
        $activity['intro'] = htmlspecialchars_decode($activity['intro']);
        $activity['nowviewnum'] = $activity['viewnum'];
        if ($activity['goodmodel']) {
            $activity['goodmodel'] = explode('|', $activity['goodmodel']);
        }
        $userlist = pdo_fetchall("SELECT * FROM " . tablename(DBCONFIG::$TABLE_KJB_BARGAIN) . " WHERE weid='{$_W['weid']}' AND aid='{$activity['id']}' ORDER BY createtime DESC, id DESC LIMIT 0,7");
        $avatar_arr = array();
        foreach ($userlist as $ukey => $uval) {
            $userinfo = mc_fansinfo($uval['uid'], $_W['acid'], $_W['uniacid']);
            if ($userinfo['avatar']) {
                array_push($avatar_arr, $userinfo['avatar']);
            } else {
                array_push($avatar_arr, $this::$DEFAULT_AVATAR);
            }
        }
        $activity['avatar'] = $avatar_arr;
        if ($activity['businessid'] != 0) {
            $businessinfo = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_BUSINESS) . "WHERE weid='{$_W['weid']}' AND id='{$activity['businessid']}'");
            $activity['business'] = $businessinfo;
            if (!empty($businessinfo['longitude']) && !empty($businessinfo['business_latitude']) && $businessinfo['latitude'] != 0 && $businessinfo['longitude'] != 0) {
                $pointarr = $this->Convert_BD09_To_GCJ02($businessinfo['latitude'], $businessinfo['longitude']);
                $activity['business']['longitude'] = $pointarr['lng'];
                $activity['business']['latitude'] = $pointarr['lat'];
            }
        }
        $bargainnum = pdo_fetchcolumn('SELECT COUNT(*) FROM ' . tablename(DBCONFIG::$TABLE_KJB_BARGAIN) . " WHERE weid='{$_W['weid']}' AND aid='{$id}'");
        $activity['bargainnum'] = $activity['bargainnum_min'] + $bargainnum;
        $helpnum = pdo_fetchcolumn('SELECT COUNT(*) FROM ' . tablename(DBCONFIG::$TABLE_KJB_RECORD) . " WHERE weid='{$_W['weid']}' AND aid='{$id}'");
        $activity['helpnum'] = $activity['helpnum_min'] + $helpnum;
        $activity['viewnum'] = $activity['viewnum_min'] + $activity['viewnum'];
        if (TIMESTAMP < $activity['starttime']) {
            $activity['status'] = $this::$KJ_STATUS_WKS;
            if ($activity['starttime'] - TIMESTAMP < 86400 * 6 && $this->openremind == 1) {
                $remind = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_REMIND) . "WHERE weid='{$_W['weid']}' AND uid='{$uid}' AND aid='{$id}' AND type=1");
                if (empty($remind)) {
                    $activity['remind'] = 1;
                } else {
                    $activity['remind'] = 2;
                }
            } else {
                $activity['remind'] = 0;
            }
        } elseif (TIMESTAMP > $activity['endtime']) {
            $activity['status'] = $this::$KJ_STATUS_JS;
        } else {
            $activity['status'] = $this::$KJ_STATUS_ZC;
        }
        load()->func('file');
        $poster = ATTACHMENT_ROOT . '/ypuk_kjb/activity_' . $id . '_1_' . $_W['weid'] . '.jpg';
        if (file_exists($poster) && filesize($poster) > 200) {
            $activity['poster'] = tomedia('ypuk_kjb/activity_' . $id . '_1_' . $_W['weid'] . '.jpg');
        } else {
            $activity['poster'] = '';
        }
        $activity['stock'] = $this->formatStock($activity['stock']);
        $updata['viewnum'] = $activity['nowviewnum'] + 1;
        pdo_update(DBCONFIG::$TABLE_KJB_ACTIVITY, $updata, array('id' => $id));
        $setting = pdo_fetch("SELECT joinqun_open,joinqun_setting FROM " . tablename(DBCONFIG::$TABLE_KJB_SETTING) . " WHERE weid='{$_W['weid']}'");
        if ($activity['joinqun_open'] == 1 || $setting['joinqun_open'] == 1) {
            if ($activity['joinqun_open'] == 1) {
                $activity['joinqun_data'] = unserialize($activity['joinqun_setting']);
            } else {
                if ($setting['joinqun_open'] == 1) {
                    $activity['joinqun_data'] = unserialize($setting['joinqun_setting']);
                } else {
                    $activity['joinqun_data'] = '';
                }
            }
            if ($activity['joinqun_data'] != '') {
                $activity['joinqun_data']['joinqun_icon'] = tomedia($activity['joinqun_data']['joinqun_icon']);
                if ($activity['joinqun_data']['joinqun_tips_type'] == 1) {
                    $activity['joinqun_data']['joinqun_tips_img'] = tomedia($activity['joinqun_data']['joinqun_tips_img']);
                }
            }
        } else {
            $activity['joinqun_data'] = '';
        }
        return $this->result(0, $message, $activity);
    }
    public function doPageGetBusinessDetail()
    {
        global $_GPC, $_W;
        $message = '成功';
        $id = $_GPC['businessid'];
        $uid = $_GPC['uid'];
        $ulat = $_GPC['ulat'];
        $ulng = $_GPC['ulng'];
        $business = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_BUSINESS) . "WHERE weid='{$_W['weid']}' AND id='{$id}'");
        if (empty($business)) {
            return $this->result(1, '商户不存在或已被删除', '');
        }
        if ($business['logo']) {
            $business['logo'] = tomedia($business['logo']);
        }
        $business['intro'] = htmlspecialchars_decode($business['intro']);
        if (!empty($business['longitude']) && $business['latitude'] != 0) {
            $pointarr = $this->Convert_BD09_To_GCJ02($business['latitude'], $business['longitude']);
            $business['longitude'] = $pointarr['lng'];
            $business['latitude'] = $pointarr['lat'];
        }
        $activity = pdo_fetchall("SELECT * FROM " . tablename(DBCONFIG::$TABLE_KJB_ACTIVITY) . " WHERE weid='{$_W['weid']}' AND businessid='{$id}' AND status=0  AND starttime<" . TIMESTAMP . " AND endtime>" . TIMESTAMP . " AND stock>0 ORDER BY id ASC LIMIT 0,10");
        $panicbuy = pdo_fetchall("SELECT * FROM " . tablename(DBCONFIG::$TABLE_KJB_PANICBUY) . " WHERE weid='{$_W['weid']}' AND businessid='{$id}' AND status=0 AND starttime<" . TIMESTAMP . " AND endtime>" . TIMESTAMP . " AND stock>0 ORDER BY id ASC LIMIT 0,10");
        $groupbuy = pdo_fetchall("SELECT * FROM " . tablename(DBCONFIG::$TABLE_KJB_GROUPBUY) . " WHERE weid='{$_W['weid']}' AND businessid='{$id}' AND status=0 AND starttime<" . TIMESTAMP . " AND endtime>" . TIMESTAMP . " AND stock>0 ORDER BY id ASC LIMIT 0,10");
        $business['activity'] = array();
        if ($activity) {
            foreach ($activity as $key => $val) {
                $val['pic'] = unserialize($val['pic']);
                $activity[$key]['pic'] = tomedia($val['pic'][0]);
                $activity[$key]['activitymod'] = 'kanjia';
                array_push($business['activity'], $activity[$key]);
            }
        }
        if ($panicbuy) {
            foreach ($panicbuy as $key => $val) {
                $val['pic'] = unserialize($val['pic']);
                $panicbuy[$key]['pic'] = tomedia($val['pic'][0]);
                $panicbuy[$key]['activitymod'] = 'panicbuy';
                array_push($business['activity'], $panicbuy[$key]);
            }
        }
        if ($groupbuy) {
            foreach ($groupbuy as $key => $val) {
                $val['pic'] = unserialize($val['pic']);
                $groupbuy[$key]['pic'] = tomedia($val['pic'][0]);
                $groupbuy[$key]['activitymod'] = 'groupbuy';
                array_push($business['activity'], $groupbuy[$key]);
            }
        }
        $business['activitynum'] = count($business['activity']);
        $setting = pdo_fetch("SELECT joinqun_open,joinqun_setting FROM " . tablename(DBCONFIG::$TABLE_KJB_SETTING) . " WHERE weid='{$_W['weid']}'");
        if ($business['joinqun_open'] == 1 || $setting['joinqun_open'] == 1) {
            if ($business['joinqun_open'] == 1) {
                $business['joinqun_data'] = unserialize($business['joinqun_setting']);
            } else {
                if ($setting['joinqun_open'] == 1) {
                    $business['joinqun_data'] = unserialize($setting['joinqun_setting']);
                } else {
                    $business['joinqun_data'] = '';
                }
            }
            if ($business['joinqun_data'] != '') {
                $business['joinqun_data']['joinqun_icon'] = tomedia($business['joinqun_data']['joinqun_icon']);
                if ($business['joinqun_data']['joinqun_tips_type'] == 1) {
                    $business['joinqun_data']['joinqun_tips_img'] = tomedia($business['joinqun_data']['joinqun_tips_img']);
                }
            }
        } else {
            $business['joinqun_data'] = '';
        }
        return $this->result(0, $message, $business);
    }
    public function doPageGetBargain()
    {
        global $_GPC, $_W;
        $message = '成功';
        load()->model('mc');
        $id = $_GPC['bargainid'];
        $uid = $_GPC['uid'];
        $bargain = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_BARGAIN) . "WHERE weid='{$_W['weid']}' AND id='{$id}'");
        $activity = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_ACTIVITY) . "WHERE weid='{$_W['weid']}' AND id='{$bargain['aid']}'");
        if (empty($activity)) {
            return $this->result(1, '活动不存在或已被删除', '');
        }
        if ($bargain['uid'] == $uid) {
            $bargain['isinitiator'] = 1;
            $activity['status'] = $this->getStatus($activity, $uid, 1);
            if ($activity['status'] > 2) {
                $orderInfo = $this->findOrderInfo($bargain['aid'], $uid, 1);
                $bargain['orderno'] = $orderInfo['order_no'];
            }
        } else {
            $bargain['isinitiator'] = 0;
            $UserBargain = $this->findUserBargain($activity['id'], $uid);
            if (!empty($UserBargain)) {
                $bargain['user_isbargain'] = 1;
                $bargain['user_bargainid'] = $UserBargain['id'];
            } else {
                $bargain['user_isbargain'] = 0;
            }
            if (TIMESTAMP < $activity['starttime']) {
                $activity['status'] = $this::$KJ_STATUS_WKS;
            } elseif (TIMESTAMP > $activity['endtime']) {
                $activity['status'] = $this::$KJ_STATUS_JS;
            } else {
                $activity['status'] = $this::$KJ_STATUS_ZC;
            }
        }
        $activity['stock'] = $this->formatStock($activity['stock']);
        if ($activity['goodmodel']) {
            $activity['goodmodel'] = explode('|', $activity['goodmodel']);
        }
        if ($activity['pic']) {
            $activity['pic'] = unserialize($activity['pic']);
            foreach ($activity['pic'] as $key => $val) {
                $activity['pic'][$key] = tomedia($activity['pic'][$key]);
            }
        }
        if ($activity['sharepic']) {
            $activity['sharepic'] = tomedia($activity['sharepic']);
        }
        if ($activity['type'] == 1 && $activity['validity'] != 0) {
            $activity['validity'] = date('Y-m-d H:i:s', $activity['validity']);
        }
        $endtime_array = getdate($activity['endtime']);
        $activity['format_endtime'] = date('Y-m-d H:i:s', $activity['endtime']);
        $activity['endhours'] = $endtime_array["hours"];
        $activity['endminutes'] = $endtime_array["minutes"];
        $activity['endseconds'] = $endtime_array["seconds"];
        $activity['endmonth'] = $endtime_array["mon"];
        $activity['endday'] = $endtime_array["mday"];
        $activity['endyear'] = $endtime_array["year"];
        $starttime_array = getdate($activity['starttime']);
        $activity['format_starttime'] = date('Y-m-d H:i:s', $activity['starttime']);
        $activity['starthours'] = $starttime_array["hours"];
        $activity['startminutes'] = $starttime_array["minutes"];
        $activity['startseconds'] = $starttime_array["seconds"];
        $activity['startmonth'] = $starttime_array["mon"];
        $activity['startday'] = $starttime_array["mday"];
        $activity['startyear'] = $starttime_array["year"];
        $activity['intro'] = htmlspecialchars_decode($activity['intro']);
        $updata['viewnum'] = $activity['viewnum'] + 1;
        pdo_update(DBCONFIG::$TABLE_KJB_ACTIVITY, $updata, array('id' => $bargain['aid']));
        if (!empty($bargain['endtime']) && $bargain['endtime'] != 0) {
            $bargain['format_endtime'] = date('Y-m-d H:i:s', $bargain['endtime']);
            $bargain_endtime_array = getdate($bargain['endtime']);
            $bargain['endhours'] = $bargain_endtime_array["hours"];
            $bargain['endminutes'] = $bargain_endtime_array["minutes"];
            $bargain['endseconds'] = $bargain_endtime_array["seconds"];
            $bargain['endmonth'] = $bargain_endtime_array["mon"];
            $bargain['endday'] = $bargain_endtime_array["mday"];
            $bargain['endyear'] = $bargain_endtime_array["year"];
            if ($bargain['endtime'] < TIMESTAMP) {
                $bargain['isend'] = 1;
            } else {
                $bargain['isend'] = 0;
            }
        } else {
            $bargain['isend'] = 0;
        }
        $bargain['activity'] = $activity;
        $bargain['initiator'] = mc_fansinfo($bargain['uid'], $_W['acid'], $_W['uniacid']);
        return $this->result(0, $message, $bargain);
    }
    public function doPageAddBargain()
    {
        global $_GPC, $_W;
        load()->model('mc');
        $uid = $_GPC['uid'];
        $aid = $_GPC['aid'];
        $ulat = $_GPC['ulat'];
        $ulng = $_GPC['ulng'];
        $activity = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_ACTIVITY) . "WHERE weid='{$_W['weid']}' AND id='{$aid}'");
        if (empty($activity)) {
            return $this->result(-1, '活动删除或不存在', '');
        }
        if (TIMESTAMP < $activity['starttime']) {
            return $this->result(-2, '活动未开始', '');
        }
        if (TIMESTAMP > $activity['endtime']) {
            return $this->result(-3, '活动已结束', '');
        }
        if ($activity['stock'] <= 0) {
            return $this->result(-4, '已无更多库存，无法发起活动', '');
        }
        if (!empty($activity['allowcity'])) {
            $allowcity = $this->checkCity($aid, $ulng, $ulat);
            if ($allowcity == 0) {
                return $this->result(-5, '当前地区暂不支持参与活动', '');
            }
        }
        $nowtime = TIMESTAMP;
        $user_bargain = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_BARGAIN) . "WHERE weid='{$_W['weid']}' AND aid='{$aid}' AND uid='{$uid}' AND endtime > '{$nowtime}'");
        if (empty($user_bargain)) {
            if (!empty($activity['bargain_time']) && $activity['bargain_time'] != 0) {
                $endtime = $nowtime + $activity['bargain_time'] * 3600;
            } else {
                $endtime = 0;
            }
            $userInfo = mc_fansinfo($uid, $_W['acid'], $_W['uniacid']);
            $data = array('aid' => $aid, 'uid' => $uid, 'weid' => $_W['weid'], 'price' => $activity['oldprice'], 'createtime' => $nowtime, 'endtime' => $endtime);
            pdo_insert(DBCONFIG::$TABLE_KJB_BARGAIN, $data);
            $status = 0;
            $message = '创建成功';
            $result = pdo_insertid();
            $setting = pdo_fetch("SELECT * FROM " . tablename(DBCONFIG::$TABLE_KJB_SETTING) . " WHERE weid='{$_W['weid']}'");
            if (!empty($setting['create_template_id']) && $result) {
                $this->send_create_template_message($_GPC['form_id'], $result);
            }
        } else {
            $status = 1;
            $result = $user_bargain['id'];
            $message = '你已经参加过了，不能再给自己砍了，请重新进入活动或刷新要页面';
        }
        return $this->result($status, $message, $result);
    }
    public function doPageSaveFormid()
    {
        global $_GPC, $_W;
        $this->add_formid($_GPC['activityid'], $_GPC['uid'], $_GPC['form_id'], 1);
    }
    public function doPageGetSetting()
    {
        global $_GPC, $_W;
        $message = '成功';
        $setting = pdo_fetch("SELECT * FROM " . tablename(DBCONFIG::$TABLE_KJB_SETTING) . " WHERE weid='{$_W['weid']}'");
        if (!empty($setting['kefuqr'])) {
            $setting['kefuqr'] = array(tomedia($setting['kefuqr']));
        }
        if (!empty($setting['function_setting'])) {
            $function_data = unserialize($setting['function_setting']);
            if (!empty($function_data['groupbuy_icon'])) {
                $function_data['groupbuy_icon'] = tomedia($function_data['groupbuy_icon']);
            } else {
                $function_data['groupbuy_icon'] = '../../resource/images/default_groupbuy_icon.png';
            }
            if (!empty($function_data['panicbuy_icon'])) {
                $function_data['panicbuy_icon'] = tomedia($function_data['panicbuy_icon']);
            } else {
                $function_data['panicbuy_icon'] = '../../resource/images/default_panicbuy_icon.png';
            }
            if (!empty($function_data['kanjia_icon'])) {
                $function_data['kanjia_icon'] = tomedia($function_data['kanjia_icon']);
            } else {
                $function_data['kanjia_icon'] = '../../resource/images/default_kanjia_icon.png';
            }
            $width = 33;
            if ($function_data['openpanicbuy'] == 0 || $function_data['openpanicbuy'] == 0) {
                $width = 50;
            }
            if ($function_data['opengroupbuy'] == 0 && $function_data['openpanicbuy'] == 0) {
                $width = 100;
            }
            $function_data['width'] = $width;
        } else {
            $function_data = array('openpanicbuy' => 0, 'opengroupbuy' => 0);
        }
        $setting['functiondata'] = $function_data;
        return $this->result(0, $message, $setting);
    }
    public function doPageHelpBargain()
    {
        global $_GPC, $_W;
        $message = '成功';
        load()->model('mc');
        $uid = $_GPC['uid'];
        $bid = $_GPC['bargainid'];
        $bargain = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_BARGAIN) . "WHERE weid='{$_W['weid']}' AND id='{$bid}'");
        $activity = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_ACTIVITY) . "WHERE weid='{$_W['weid']}' AND id='{$bargain['aid']}'");
        if (empty($activity)) {
            return $this->result(-1, '活动删除或不存在', '');
        }
        if (TIMESTAMP < $activity['starttime']) {
            return $this->result(-2, '活动未开始', '');
        }
        if (TIMESTAMP > $activity['endtime']) {
            return $this->result(-3, '活动已结束', '');
        }
        if (!empty($bargain['endtime']) && $bargain['endtime'] != 0 && TIMESTAMP > $bargain['endtime']) {
            return $this->result(-9, '砍价超时，无法继续砍价啦', '');
        }
        if ($activity['stock'] <= 0) {
            return $this->result(-4, '已无更多库存，无法继续帮其砍价', '');
        }
        if ($bargain['price'] <= $activity['lowprice']) {
            return $this->result(-6, 'TA的价格已经达到了最低价，不能继续砍啦！', '');
        }
        if ($bargain['uid'] == $uid) {
            return $this->result(-7, '不能帮自己砍价哦', '');
        }
        if ($uid == 0) {
            return $this->result(-8, '用户信息读取失败，无法参与砍价', '');
        }
        $userInfo = mc_fansinfo($uid, $_W['acid'], $_W['uniacid']);
        $helpFriendCount = $this->getHelpFriendCount($bargain['aid'], $uid);
        if ($helpFriendCount >= $activity['friend_help_limit']) {
            return $this->result(-5, '此活动下您已帮助' . $activity['friend_help_limit'] . '位好友砍价了，不能再继续帮助啦！', '');
        }
        $dbFirend = $this->findHelpFirend($bid, $uid);
        $activity['stock'] = $this->formatStock($activity['stock']);
        $bargainprice = $this->getBargainPrice($activity, $bargain['price']);
        if (empty($dbFirend)) {
            $leftPrice = $bargain['price'] - $bargainprice;
            if ($leftPrice <= $activity['lowprice']) {
                $leftPrice = $activity['lowprice'];
            }
            $setting = pdo_fetch("SELECT * FROM " . tablename(DBCONFIG::$TABLE_KJB_SETTING) . " WHERE weid='{$_W['weid']}'");
            $user = mc_fansinfo($bargain['uid'], $_W['acid'], $_W['uniacid']);
            $formid = pdo_fetch("SELECT * FROM " . tablename(DBCONFIG::$TABLE_KJB_FORMID) . " WHERE weid='{$_W['weid']}' AND openid='{$user['openid']}' AND aid='{$activity['id']}' AND type=1");
            if ($leftPrice == $activity['lowprice'] && !empty($setting['success_template_id']) && !empty($formid)) {
                $this->send_success_template_message($bid);
            }
            $helpFirend = array('aid' => $activity['id'], 'weid' => $_W['weid'], 'uid' => $uid, 'bid' => $bid, 'nickname' => $userInfo['nickname'], 'avatar' => $userInfo['avatar'], 'bargainprice' => $bargainprice, 'leftprice' => $leftPrice, 'createtime' => TIMESTAMP);
            pdo_insert(DBCONFIG::$TABLE_KJB_RECORD, $helpFirend);
            pdo_update(DBCONFIG::$TABLE_KJB_BARGAIN, array('price' => $leftPrice), array('id' => $bid));
        } else {
            return $this->result(-1, '您已经帮助TA砍过一次价了，无法继续砍价', '');
        }
        return $this->result(0, $message, $bargainprice);
    }
    public function doPageGetPoster()
    {
        global $_W, $_GPC;
        $message = '成功';
        load()->model('mc');
        $bid = $_GPC['bargainid'];
        $bargain = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_BARGAIN) . "WHERE weid='{$_W['weid']}' AND id='{$bid}'");
        if (!function_exists('gd_info')) {
            $qrfile = $this->GetBargainQr($bid);
            $image = imagecreatefromjpeg($qrfile);
        } else {
            $activity = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_ACTIVITY) . "WHERE weid='{$_W['weid']}' AND id='{$bargain['aid']}'");
            $userInfo = mc_fansinfo($bargain['uid'], $_W['acid'], $_W['uniacid']);
            mb_internal_encoding('UTF-8');
            $img_name = IA_ROOT . "/addons/" . YPUK_KJB . "/images/poster_bg.jpg";
            $image = imagecreatefromjpeg($img_name);
            $qrfile = $this->GetBargainQr($bid);
            $qr = imagecreatefromjpeg($qrfile);
            $thumblist = unserialize($activity['pic']);
            if (is_array($thumblist)) {
                $thumbfile = tomedia($thumblist[0]);
            } else {
                $thumbfile = tomedia($thumblist);
            }
            $thumbinfo = getimagesize($thumbfile);
            if ($thumbinfo['mime'] == 'image/jpeg' || $thumbinfo['mime'] == 'image/jpg') {
                $thumb = imagecreatefromjpeg($thumbfile);
            }
            if ($thumbinfo['mime'] == 'gif') {
                $thumb = imagecreatefromgif($thumbfile);
            }
            if ($thumbinfo['mime'] == 'png') {
                $thumb = imagecreatefrompng($thumbfile);
            }
            imagecopyresized($image, $thumb, 95, 90, 0, 0, 375, 200, $thumbinfo[0], $thumbinfo[1]);
            $text = '我正在' . $_W['account']['name'] . '参加' . $activity['title'] . '砍价活动，原价' . $activity['oldprice'] . '元，最低' . $activity['lowprice'] . '元即可获得，快来帮我砍一刀吧';
            $temp = array("color" => array(88, 88, 88), "fontsize" => 14, "width" => 270, "left" => 190, "top" => 320, "hang_size" => 30);
            $str_h = $this->draw_txt_to($image, $temp, $text, true);
            if (!empty($userInfo['avatar'])) {
                $per = 0.1;
                list($width, $height) = getimagesize($userInfo['avatar']);
                $n_w = 80;
                $n_h = 80;
                $newavatar = imagecreatetruecolor($n_w, $n_h);
                $avatar = imagecreatefromjpeg($userInfo['avatar']);
                imagecopyresized($newavatar, $avatar, 0, 0, 0, 0, $n_w, $n_h, $width, $height);
                $radius = 35;
                $x = 100;
                $y = 370;
                $lt_corner = $this->get_lt_rounder_corner($radius, 255, 255, 255);
                imagecopy($image, $newavatar, $x, $y, 0, 0, 70, 70);
                $this->myradus($image, $x, $y, $lt_corner, $radius, 70, 70);
            }
            imagecopyresized($image, $qr, 150, 530, 0, 0, 130, 130, 630, 630);
            imagedestroy($qr);
        }
        header('Content-type: image/jpeg;');
        ImageJPEG($image);
        imagedestroy($image);
    }
    public function doPageGetPanicbuySharePoster()
    {
        global $_W, $_GPC;
        $message = '成功';
        $aid = $_GPC['aid'];
        $shareuid = $_GPC['shareuid'];
        if (!function_exists('gd_info')) {
            $qrfile = $this->GetPanicbuyUserQr($aid, $shareuid);
            $image = imagecreatefromjpeg($qrfile);
        } else {
            $activity = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_PANICBUY) . "WHERE weid='{$_W['weid']}' AND id='{$aid}'");
            $userInfo = mc_fansinfo($shareuid, $_W['acid'], $_W['uniacid']);
            mb_internal_encoding('UTF-8');
            $img_name = IA_ROOT . "/addons/" . YPUK_KJB . "/images/poster_bg.jpg";
            $image = imagecreatefromjpeg($img_name);
            $qrfile = $this->GetPanicbuyUserQr($aid, $shareuid);
            $qr = imagecreatefromjpeg($qrfile);
            $thumblist = unserialize($activity['pic']);
            if (is_array($thumblist)) {
                $thumbfile = tomedia($thumblist[0]);
            } else {
                $thumbfile = tomedia($thumblist);
            }
            $thumbinfo = getimagesize($thumbfile);
            if ($thumbinfo['mime'] == 'image/jpeg' || $thumbinfo['mime'] == 'image/jpg') {
                $thumb = imagecreatefromjpeg($thumbfile);
            }
            if ($thumbinfo['mime'] == 'gif') {
                $thumb = imagecreatefromgif($thumbfile);
            }
            if ($thumbinfo['mime'] == 'png') {
                $thumb = imagecreatefrompng($thumbfile);
            }
            imagecopyresized($image, $thumb, 95, 90, 0, 0, 375, 200, $thumbinfo[0], $thumbinfo[1]);
            $text = '我正在' . $_W['account']['name'] . '参加' . $activity['title'] . '抢购活动，原价' . $activity['oldprice'] . '元，现价' . $activity['nowprice'] . '元即可获得。';
            $temp = array("color" => array(88, 88, 88), "fontsize" => 14, "width" => 270, "left" => 190, "top" => 320, "hang_size" => 30);
            $str_h = $this->draw_txt_to($image, $temp, $text, true);
            if (!empty($userInfo['avatar'])) {
                $per = 0.1;
                list($width, $height) = getimagesize($userInfo['avatar']);
                $n_w = 80;
                $n_h = 80;
                $newavatar = imagecreatetruecolor($n_w, $n_h);
                $avatar = imagecreatefromjpeg($userInfo['avatar']);
                imagecopyresized($newavatar, $avatar, 0, 0, 0, 0, $n_w, $n_h, $width, $height);
                $radius = 35;
                $x = 100;
                $y = 370;
                $lt_corner = $this->get_lt_rounder_corner($radius, 255, 255, 255);
                imagecopy($image, $newavatar, $x, $y, 0, 0, 70, 70);
                $this->myradus($image, $x, $y, $lt_corner, $radius, 70, 70);
            }
            imagecopyresized($image, $qr, 150, 530, 0, 0, 130, 130, 630, 630);
            imagedestroy($qr);
        }
        header('Content-type: image/jpeg;');
        ImageJPEG($image);
        imagedestroy($image);
    }
    public function doPageGetUserInfo()
    {
        global $_W, $_GPC;
        $message = '成功';
        load()->model('mc');
        $result = mc_fansinfo($_GPC['uid'], $_W['acid'], $_W['uniacid']);
        $clerk = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_CLERK) . "WHERE weid='{$_W['weid']}' AND uid='{$_GPC['uid']}'");
        if (!empty($clerk)) {
            $result['isclerk'] = 1;
            $setting = pdo_fetch("SELECT withdraw_open FROM " . tablename(DBCONFIG::$TABLE_KJB_SETTING) . " WHERE weid='{$_W['weid']}'");
            if ($clerk['clerk_auth'] == 2 || $clerk['clerk_auth'] == 3) {
                if ($setting['withdraw_open'] == 1) {
                    $result['clerk_auth'] = $clerk['clerk_auth'];
                } else {
                    $result['clerk_auth'] = 1;
                }
            } else {
                $result['clerk_auth'] = $clerk['clerk_auth'];
            }
        } else {
            $result['isclerk'] = 0;
        }
        return $this->result(0, $message, $result);
    }
    public function doPageGetClerkInfo()
    {
        global $_W, $_GPC;
        $message = '成功';
        $clerkinfo = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_CLERK) . "WHERE weid='{$_W['weid']}' AND uid='{$_GPC['uid']}'");
        if (!empty($clerkinfo['name'])) {
            $clerkinfo['name'] = $clerkinfo['name'];
        } else {
            $clerkinfo['name'] = '未设置';
        }
        if (!empty($clerkinfo['workno'])) {
            $clerkinfo['workno'] = $clerkinfo['workno'];
        } else {
            $clerkinfo['workno'] = '未设置';
        }
        if ($clerkinfo['businessid'] != 0) {
            $businessinfo = pdo_fetch("SELECT name FROM" . tablename(DBCONFIG::$TABLE_KJB_BUSINESS) . "WHERE weid='{$_W['weid']}' AND id='{$clerkinfo['businessid']}'");
            $clerkinfo['isbusiness'] = 1;
            $clerkinfo['businessname'] = $businessinfo['name'];
        } else {
            $clerkinfo['isbusiness'] = 0;
        }
        return $this->result(0, $message, $clerkinfo);
    }
    public function doPageUserData()
    {
        global $_GPC, $_W;
        $message = '成功';
        load()->model('mc');
        $uid = $_GPC['uid'];
        $pindex = max(1, intval($_GPC['page']));
        $psize = 20;
        if ($_GPC['mod'] == 'mybargain') {
            $list = pdo_fetchall("SELECT * FROM " . tablename(DBCONFIG::$TABLE_KJB_BARGAIN) . " WHERE weid='{$_W['weid']}' AND uid='{$uid}' ORDER BY id desc LIMIT " . ($pindex - 1) * $psize . "," . $psize);
            foreach ($list as $key => $value) {
                $list[$key]['createtime'] = date('Y-m-d H:i:s', $value['createtime']);
                if (!empty($value['endtime']) && $value['endtime'] != 0) {
                    if ($value['endtime'] < TIMESTAMP) {
                        $list[$key]['isend'] = 1;
                    } else {
                        $list[$key]['isend'] = 0;
                    }
                } else {
                    $list[$key]['isend'] = 0;
                }
                $list[$key]['endtime'] = date('Y-m-d H:i:s', $value['endtime']);
                $activity = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_ACTIVITY) . "WHERE weid='{$_W['weid']}' AND id='{$value['aid']}'");
                $activity['pic'] = unserialize($activity['pic']);
                $activity['pic'] = tomedia($activity['pic'][0]);
                $activity['stock'] = $this->formatStock($activity['stock']);
                $list[$key]['activity'] = $activity;
                $list[$key]['helpnum'] = pdo_fetchcolumn('SELECT COUNT(*) FROM ' . tablename(DBCONFIG::$TABLE_KJB_RECORD) . " WHERE bid='{$list[$key]['id']}' and weid='{$_W['weid']}'");
                $list[$key]['status'] = $this->getStatus($activity, $uid, 1);
            }
        } elseif ($_GPC['mod'] == 'myorder') {
            $list = pdo_fetchall("SELECT * FROM " . tablename(DBCONFIG::$TABLE_KJB_ORDER) . " WHERE weid='{$_W['weid']}' AND uid='{$uid}' AND type=1 ORDER BY id desc LIMIT " . ($pindex - 1) * $psize . "," . $psize);
            foreach ($list as $key => $value) {
                $list[$key]['createtime'] = date('Y-m-d H:i:s', $value['createtime']);
                $activity = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_ACTIVITY) . "WHERE weid='{$_W['weid']}' AND id='{$value['aid']}'");
                if ($activity['type'] == 1 && $activity['validity'] != 0) {
                    if (TIMESTAMP > $activity['validity']) {
                        $list[$key]['validitystatus'] = 0;
                    } else {
                        $list[$key]['validitystatus'] = 1;
                    }
                    $activity['validity'] = date('Y-m-d H:i:s', $activity['validity']);
                }
                $activity['pic'] = unserialize($activity['pic']);
                $activity['pic'] = tomedia($activity['pic'][0]);
                $activity['stock'] = $this->formatStock($activity['stock']);
                $list[$key]['activity'] = $activity;
            }
        } elseif ($_GPC['mod'] == 'panicbuy') {
            $list = pdo_fetchall("SELECT * FROM " . tablename(DBCONFIG::$TABLE_KJB_ORDER) . " WHERE weid='{$_W['weid']}' AND uid='{$uid}' AND type=2 ORDER BY id desc LIMIT " . ($pindex - 1) * $psize . "," . $psize);
            foreach ($list as $key => $value) {
                $list[$key]['createtime'] = date('Y-m-d H:i:s', $value['createtime']);
                $activity = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_PANICBUY) . "WHERE weid='{$_W['weid']}' AND id='{$value['aid']}'");
                if ($activity['type'] == 1 && $activity['validity'] != 0) {
                    if (TIMESTAMP > $activity['validity']) {
                        $list[$key]['validitystatus'] = 0;
                    } else {
                        $list[$key]['validitystatus'] = 1;
                    }
                    $activity['validity'] = date('Y-m-d H:i:s', $activity['validity']);
                }
                $activity['pic'] = unserialize($activity['pic']);
                $activity['pic'] = tomedia($activity['pic'][0]);
                $activity['stock'] = $this->formatStock($activity['stock']);
                $list[$key]['activity'] = $activity;
            }
        } elseif ($_GPC['mod'] == 'mygroup') {
            $list = pdo_fetchall("SELECT * FROM " . tablename(DBCONFIG::$TABLE_KJB_GROUP) . " WHERE weid='{$_W['weid']}' AND uid='{$uid}' ORDER BY id desc LIMIT " . ($pindex - 1) * $psize . "," . $psize);
            foreach ($list as $key => $value) {
                $list[$key]['createtime'] = date('Y-m-d H:i:s', $value['createtime']);
                $activity = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_GROUPBUY) . "WHERE weid='{$_W['weid']}' AND id='{$value['aid']}'");
                $activity['stock'] = $this->formatStock($activity['stock']);
                $activity['pic'] = unserialize($activity['pic']);
                $activity['pic'] = tomedia($activity['pic'][0]);
                $list[$key]['activity'] = $activity;
                if (TIMESTAMP > $value['endtime']) {
                    $list[$key]['timeisend'] = 1;
                } else {
                    $list[$key]['timeisend'] = 0;
                }
                $list[$key]['grouprecordnum'] = pdo_fetchcolumn("SELECT COUNT(*) FROM" . tablename(DBCONFIG::$TABLE_KJB_GROUPRECORD) . "WHERE weid='{$_W['weid']}' AND gid='{$value['id']} AND paystatus=1'");
                $list[$key]['surplusnum'] = $activity['group_success_limit'] - $list[$key]['grouprecordnum'];
            }
        } elseif ($_GPC['mod'] == 'mygrouporder') {
            $list = pdo_fetchall("SELECT * FROM " . tablename(DBCONFIG::$TABLE_KJB_ORDER) . " WHERE weid='{$_W['weid']}' AND uid='{$uid}' AND type=3 ORDER BY id desc LIMIT " . ($pindex - 1) * $psize . "," . $psize);
            foreach ($list as $key => $value) {
                $list[$key]['createtime'] = date('Y-m-d H:i:s', $value['createtime']);
                $activity = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_GROUPBUY) . "WHERE weid='{$_W['weid']}' AND id='{$value['aid']}'");
                if ($activity['type'] == 1 && $activity['validity'] != 0) {
                    if (TIMESTAMP > $activity['validity']) {
                        $list[$key]['validitystatus'] = 0;
                    } else {
                        $list[$key]['validitystatus'] = 1;
                    }
                    $activity['validity'] = date('Y-m-d H:i:s', $activity['validity']);
                }
                $activity['pic'] = unserialize($activity['pic']);
                $activity['pic'] = tomedia($activity['pic'][0]);
                $activity['stock'] = $this->formatStock($activity['stock']);
                $list[$key]['activity'] = $activity;
                $list[$key]['pay_price'] = $value['total_price'];
                if ($value['pay_type'] == 2) {
                    if ($value['oporder'] == 1) {
                        $list[$key]['total_price'] = $activity['buyprice'] + $activity['freight'];
                    }
                    if ($value['oporder'] == 0) {
                        $list[$key]['total_price'] = $activity['groupprice'] + $activity['freight'];
                    }
                }
            }
        }
        return $this->result(0, $message, $list);
    }
    public function doPageSystemBargain()
    {
        global $_GPC, $_W;
        $message = '成功';
        $systemuid = 0;
        $uid = $_GPC['uid'];
        $bid = $_GPC['bargainid'];
        $bargain = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_BARGAIN) . "WHERE weid='{$_W['weid']}' AND id='{$bid}'");
        $activity = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_ACTIVITY) . "WHERE weid='{$_W['weid']}' AND id='{$bargain['aid']}'");
        if (empty($activity)) {
            return false;
        }
        if (TIMESTAMP < $activity['starttime']) {
            return false;
        }
        if (TIMESTAMP > $activity['endtime']) {
            return false;
        }
        if ($activity['stock'] <= 0) {
            return false;
        }
        if ($bargain['price'] <= $activity['lowprice']) {
            return false;
        }
        if ($bargain['uid'] != $uid) {
            return false;
        }
        $dbFirend = $this->findHelpFirend($bid, $systemuid);
        $bargainprice = $this->getBargainPrice($activity, $bargain['price']);
        if (empty($dbFirend)) {
            $leftPrice = $bargain['price'] - $bargainprice;
            if ($leftPrice <= $activity['lowprice']) {
                $leftPrice = $activity['lowprice'];
            }
            $helpFirend = array('aid' => $activity['id'], 'weid' => $_W['weid'], 'uid' => $systemuid, 'bid' => $bid, 'nickname' => '', 'avatar' => '', 'bargainprice' => $bargainprice, 'leftprice' => $leftPrice, 'createtime' => TIMESTAMP);
            pdo_insert(DBCONFIG::$TABLE_KJB_RECORD, $helpFirend);
            pdo_update(DBCONFIG::$TABLE_KJB_BARGAIN, array('price' => $leftPrice), array('id' => $bid));
        } else {
            return false;
        }
        return $this->result(0, $message, $bargainprice);
    }
    public function doPageBargainRecord()
    {
        global $_GPC, $_W;
        $message = '成功';
        $bid = $_GPC['bargainid'];
        $pindex = max(1, intval($_GPC['page']));
        $psize = 20;
        $bargain = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_BARGAIN) . "WHERE weid='{$_W['weid']}' AND id='{$bid}'");
        if (empty($bargain)) {
            return $this->result(-1, '对应的砍价不存在', '');
        }
        $help = pdo_fetchall('SELECT * FROM ' . tablename(DBCONFIG::$TABLE_KJB_RECORD) . " WHERE bid='{$bid}' and weid='{$_W['weid']}' ORDER BY createtime DESC LIMIT " . ($pindex - 1) * $psize . ',' . $psize);
        foreach ($help as $key => $val) {
            if ($val['uid'] == 0) {
                $setting = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_SETTING) . "WHERE weid='{$_W['weid']}'");
                if ($setting['sysavatar']) {
                    $help[$key]['avatar'] = tomedia($setting['sysavatar']);
                }
            }
            $help[$key]['createtime'] = date('Y-m-d H:i:s', $val['createtime']);
        }
        return $this->result(0, $message, $help);
    }
    public function doPageAddApply()
    {
        global $_W, $_GPC;
        $data = array('weid' => $_W['weid'], 'shopname' => $_GPC['shopname'], 'shoptel' => $_GPC['shoptel'], 'shopaddress' => $_GPC['shopaddress'], 'contacts' => $_GPC['contacts'], 'contactstel' => $_GPC['contactstel'], 'starttime' => $_GPC['starttime'], 'endtime' => $_GPC['endtime'], 'activityintro' => $_GPC['activityintro'], 'createtime' => TIMESTAMP);
        pdo_insert(DBCONFIG::$TABLE_KJB_APPLY, $data);
        $oid = pdo_insertid();
        return $this->result(0, '成功', '');
    }
    public function doPageAddOrder()
    {
        global $_W, $_GPC;
        $uid = $_GPC['uid'];
        $bid = $_GPC['bargainid'];
        $bargain = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_BARGAIN) . "WHERE weid='{$_W['weid']}' AND id='{$bid}'");
        $activity = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_ACTIVITY) . "WHERE weid='{$_W['weid']}' AND id='{$bargain['aid']}'");
        if (empty($activity)) {
            return $this->result(-1, '活动不存在', '');
        }
        if (empty($bargain)) {
            return $this->result(-2, '砍价不存在', '');
        }
        if (TIMESTAMP < $activity['starttime']) {
            return $this->result(-3, '活动未开始', '');
        }
        if (TIMESTAMP > $activity['endtime']) {
            return $this->result(-4, '活动已结束', '');
        }
        if ($activity['stock'] <= 0) {
            return $this->result(-5, '对不起库存已不足，请下次再来参加活动吧', '');
        }
        if ($bargain['price'] != $activity['lowprice']) {
            return $this->result(-6, '当前价格未达到活动最低价，无法创建订单哦', '');
        }
        if ($bargain['uid'] != $uid) {
            return $this->result(-7, '参数错误，用户ID不符', '');
        }
        if ($uid == 0) {
            return $this->result(-8, '用户信息读取失败，无法创建订单', '');
        }
        $uname = $_GPC['uname'];
        $address = $_GPC['address'];
        $goodmodel = $_GPC['goodmodel'];
        $tel = $_GPC['tel'];
        $orderInfo = $this->findOrderInfo($bargain['aid'], $uid, 1);
        if (empty($orderInfo)) {
            $order_no = $this->getOrderNo($bargain['aid'], $bid, 'kanjia', $uid);
            $order_array = array('aid' => $activity['id'], 'bid' => $bargain['id'], 'uid' => $uid, 'oporder' => 0, 'weid' => $_W['weid'], 'order_no' => $order_no, 'uname' => $uname, 'address' => $address, 'tel' => $tel, 'oldprice' => $activity['oldprice'], 'nowprice' => $bargain['price'], 'freight' => $activity['freight'], 'total_price' => $bargain['price'] + $activity['freight'], 'status' => $this::$KJ_STATUS_XD, 'goodmodel' => $goodmodel, 'createtime' => TIMESTAMP, 'pay_type' => $activity['pay_type'], 'type' => 1);
            pdo_insert(DBCONFIG::$TABLE_KJB_ORDER, $order_array);
            $oid = pdo_insertid();
            if ($activity['pay_type'] == 2) {
                $setting = pdo_fetch("SELECT * FROM " . tablename(DBCONFIG::$TABLE_KJB_SETTING) . " WHERE weid='{$_W['weid']}'");
                if (!empty($setting['order_template_id'])) {
                    $this->send_order_template_message($order_no, $_GPC['form_id']);
                }
                if ($activity['type'] == 0) {
                    $status = 4;
                } else {
                    $status = 5;
                    $this->makeQrcodeFile($order_no);
                }
                pdo_update(DBCONFIG::$TABLE_KJB_ORDER, array('status' => $status), array('id' => $oid));
                pdo_update(DBCONFIG::$TABLE_KJB_ACTIVITY, array('stock' => $activity['stock'] - 1), array('id' => $bargain['aid']));
                pdo_update(DBCONFIG::$TABLE_KJB_ACTIVITYINDEX, array('stock' => $activity['stock'] - 1), array('id' => $bargain['aid'], 'activitytype' => 1));
            } else {
                $setting = pdo_fetch("SELECT * FROM " . tablename(DBCONFIG::$TABLE_KJB_SETTING) . " WHERE weid='{$_W['weid']}'");
                if (!empty($setting['order_template_id'])) {
                    $this->add_formid($activity['id'], $uid, $_GPC['form_id'], 1);
                }
            }
        } else {
            return $this->result(-8, '一次砍价只能创建一个订单哦', '');
        }
        return $this->result(0, '成功', $order_no);
    }
    public function doPageAddOpOrder()
    {
        global $_W, $_GPC;
        $uid = $_GPC['uid'];
        $activityid = $_GPC['activityid'];
        $activity = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_ACTIVITY) . "WHERE weid='{$_W['weid']}' AND id='{$activityid}'");
        if (empty($activity)) {
            return $this->result(-1, '活动不存在', '');
        }
        if (TIMESTAMP < $activity['starttime']) {
            return $this->result(-3, '活动未开始', '');
        }
        if (TIMESTAMP > $activity['endtime']) {
            return $this->result(-4, '活动已结束', '');
        }
        if ($activity['stock'] <= 0) {
            return $this->result(-5, '对不起库存已不足，请下次再来参加活动吧', '');
        }
        if ($uid == 0) {
            return $this->result(-8, '用户信息读取失败，无法创建订单', '');
        }
        $uname = $_GPC['uname'];
        $address = $_GPC['address'];
        $goodmodel = $_GPC['goodmodel'];
        $tel = $_GPC['tel'];
        if ($activity['opbuy_price'] != '' && $activity['opbuy_price'] != '0.00') {
            $nowprice = $activity['opbuy_price'];
        } else {
            $nowprice = $activity['oldprice'];
        }
        $order_no = $this->getOrderNo($activityid, 0, 'kanjia', $uid);
        $order_array = array('aid' => $activityid, 'bid' => 0, 'uid' => $uid, 'weid' => $_W['weid'], 'order_no' => $order_no, 'uname' => $uname, 'address' => $address, 'tel' => $tel, 'oldprice' => $activity['oldprice'], 'nowprice' => $nowprice, 'freight' => $activity['freight'], 'total_price' => $nowprice + $activity['freight'], 'status' => $this::$KJ_STATUS_XD, 'goodmodel' => $goodmodel, 'oporder' => 1, 'createtime' => TIMESTAMP, 'updatetime' => TIMESTAMP, 'pay_type' => $activity['pay_type'], 'type' => 1);
        pdo_insert(DBCONFIG::$TABLE_KJB_ORDER, $order_array);
        $oid = pdo_insertid();
        if ($activity['pay_type'] == 2) {
            $setting = pdo_fetch("SELECT * FROM " . tablename(DBCONFIG::$TABLE_KJB_SETTING) . " WHERE weid='{$_W['weid']}'");
            if (!empty($setting['order_template_id'])) {
                $this->send_order_template_message($order_no, $_GPC['form_id']);
            }
            if ($activity['type'] == 0) {
                $status = 4;
            } else {
                $status = 5;
                $this->makeQrcodeFile($order_no);
            }
            pdo_update(DBCONFIG::$TABLE_KJB_ORDER, array('status' => $status), array('id' => $oid));
            pdo_update(DBCONFIG::$TABLE_KJB_ACTIVITY, array('stock' => $activity['stock'] - 1), array('id' => $activityid));
            pdo_update(DBCONFIG::$TABLE_KJB_ACTIVITYINDEX, array('stock' => $activity['stock'] - 1), array('id' => $activityid, 'activitytype' => 1));
        } else {
            $setting = pdo_fetch("SELECT * FROM " . tablename(DBCONFIG::$TABLE_KJB_SETTING) . " WHERE weid='{$_W['weid']}'");
            if (!empty($setting['order_template_id'])) {
                $this->add_formid($activity['id'], $uid, $_GPC['form_id'], 1);
            }
        }
        return $this->result(0, '成功', $order_no);
    }
    public function doPageOrderDetail()
    {
        global $_GPC, $_W;
        $message = '成功';
        $uid = $_GPC['uid'];
        $orderno = $_GPC['orderno'];
        if ($_GPC['type'] == 'verification') {
            $order = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_ORDER) . "WHERE weid='{$_W['weid']}' AND order_no='{$orderno}'");
        } else {
            $order = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_ORDER) . "WHERE weid='{$_W['weid']}' AND order_no='{$orderno}' AND uid='{$uid}'");
        }
        if (empty($order) && $_GPC['type'] != 'verification') {
            return $this->result(-1, '订单不存在', '');
        }
        if ($order['type'] == 2) {
            $activity = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_PANICBUY) . "WHERE weid='{$_W['weid']}' AND id='{$order['aid']}'");
        } elseif ($order['type'] == 3) {
            $activity = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_GROUPBUY) . "WHERE weid='{$_W['weid']}' AND id='{$order['aid']}'");
            $order['pay_price'] = $order['total_price'];
            if ($order['pay_type'] == 2) {
                if ($order['oporder'] == 1) {
                    $order['total_price'] = $activity['buyprice'] + $activity['freight'];
                }
                if ($order['oporder'] == 0) {
                    $order['total_price'] = $activity['groupprice'] + $activity['freight'];
                }
            }
        } else {
            $activity = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_ACTIVITY) . "WHERE weid='{$_W['weid']}' AND id='{$order['aid']}'");
        }
        $order['createtime'] = date('Y-m-d H:i:s', $order['createtime']);
        if ($activity['type'] == 1 && $activity['validity'] != 0) {
            if (TIMESTAMP > $activity['validity']) {
                $order['validitystatus'] = 0;
            } else {
                $order['validitystatus'] = 1;
            }
            $activity['validity'] = date('Y-m-d H:i:s', $activity['validity']);
        }
        if (TIMESTAMP < $activity['starttime']) {
            $activity['status'] = $this::$KJ_STATUS_WKS;
        } elseif (TIMESTAMP > $activity['endtime']) {
            $activity['status'] = $this::$KJ_STATUS_JS;
        } else {
            $activity['status'] = $this::$KJ_STATUS_ZC;
        }
        $activity['pic'] = unserialize($activity['pic']);
        foreach ($activity['pic'] as $key => $val) {
            $activity['pic'][$key] = tomedia($activity['pic'][$key]);
        }
        $activity['stock'] = $this->formatStock($activity['stock']);
        $order['activity'] = $activity;
        $order['qr'] = tomedia('ypuk_kjb/' . $orderno . '.png');
        return $this->result(0, $message, $order);
    }
    public function doPageCatGroupbuy()
    {
        global $_GPC, $_W;
        $message = '成功';
        load()->model('mc');
        $pindex = max(1, intval($_GPC['page']));
        $psize = 20;
        $catid = $_GPC['catid'];
        $type = $_GPC['type'];
        $uid = $_GPC['uid'];
        $where = ' ';
        if ($type == 'now') {
            $where .= ' AND starttime<' . TIMESTAMP . ' AND endtime>' . TIMESTAMP . ' AND stock>0';
        }
        if ($type == 'ready') {
            $where .= ' AND starttime>' . TIMESTAMP . ' AND endtime>' . TIMESTAMP . ' AND stock>0';
        }
        if ($catid && $catid != '0') {
            $where .= ' AND catid=' . $catid . '';
        }
        $list = pdo_fetchall("SELECT * FROM " . tablename(DBCONFIG::$TABLE_KJB_GROUPBUY) . " WHERE weid='{$_W['weid']}' AND status=0 " . $where . " ORDER BY createtime DESC, id DESC LIMIT " . ($pindex - 1) * $psize . ',' . $psize);
        foreach ($list as $key => $val) {
            if (TIMESTAMP < $val['starttime']) {
                $list[$key]['status'] = $this::$KJ_STATUS_WKS;
                if ($val['starttime'] - TIMESTAMP < 86400 * 6 && $this->openremind == 1) {
                    $remind = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_REMIND) . "WHERE weid='{$_W['weid']}' AND uid='{$uid}' AND aid='{$val['id']}' AND type=3");
                    if (empty($remind)) {
                        $list[$key]['remind'] = 1;
                    } else {
                        $list[$key]['remind'] = 2;
                    }
                } else {
                    $list[$key]['remind'] = 0;
                }
            } elseif (TIMESTAMP > $val['endtime']) {
                $list[$key]['status'] = $this::$KJ_STATUS_JS;
            } else {
                $list[$key]['status'] = $this::$KJ_STATUS_ZC;
            }
            $groupnum = pdo_fetchcolumn('SELECT COUNT(*) FROM ' . tablename(DBCONFIG::$TABLE_KJB_GROUPRECORD) . " WHERE weid='{$_W['weid']}' AND aid='{$val['id']}' AND paystatus=1");
            $list[$key]['groupnum'] = $groupnum;
            $list[$key]['stock'] = $this->formatStock($val['stock']);
            $val['pic'] = unserialize($val['pic']);
            $list[$key]['pic'] = tomedia($val['pic'][0]);
        }
        return $this->result(0, $message, $list);
    }
    public function doPageGetGroup()
    {
        global $_GPC, $_W;
        $message = '成功';
        load()->model('mc');
        $id = $_GPC['gid'];
        $uid = $_GPC['uid'];
        $group = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_GROUP) . "WHERE weid='{$_W['weid']}' AND id='{$id}'");
        $groupfirst = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_GROUPRECORD) . "WHERE weid='{$_W['weid']}' AND gid='{$id}' AND isfirst=1");
        $activity = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_GROUPBUY) . "WHERE weid='{$_W['weid']}' AND id='{$group['aid']}'");
        if (empty($activity)) {
            return $this->result(1, '活动不存在或已被删除', '');
        }
        if ($groupfirst['uid'] == $uid) {
            $group['user_isfirst'] = 1;
        } else {
            $group['user_isfirst'] = 0;
            $UserHelpGroup = $this->findUserHelpGroup($id, $uid);
            if (!empty($UserHelpGroup)) {
                $group['user_ishelp'] = 1;
            } else {
                $group['user_ishelp'] = 0;
            }
        }
        if (TIMESTAMP < $activity['starttime']) {
            $activity['status'] = $this::$KJ_STATUS_WKS;
        } elseif (TIMESTAMP > $activity['endtime']) {
            $activity['status'] = $this::$KJ_STATUS_JS;
        } else {
            $activity['status'] = $this::$KJ_STATUS_ZC;
        }
        if (TIMESTAMP > $group['endtime']) {
            $group['timeisend'] = 1;
        } else {
            $group['timeisend'] = 0;
        }
        if ($activity['pic']) {
            $activity['pic'] = unserialize($activity['pic']);
            $activity['pic'] = tomedia($activity['pic'][0]);
        }
        if ($activity['sharepic']) {
            $activity['sharepic'] = tomedia($activity['sharepic']);
        }
        $endtime_array = getdate($group['endtime']);
        $group['format_endtime'] = date('Y-m-d H:i:s', $group['endtime']);
        $group['endhours'] = $endtime_array["hours"];
        $group['endminutes'] = $endtime_array["minutes"];
        $group['endseconds'] = $endtime_array["seconds"];
        $group['endmonth'] = $endtime_array["mon"];
        $group['endday'] = $endtime_array["mday"];
        $group['endyear'] = $endtime_array["year"];
        $group['group_success_limit_array'] = array();
        for ($i = 0; $i < $activity['group_success_limit']; $i++) {
            array_push($group['group_success_limit_array'], $i);
        }
        $activity['stock'] = $this->formatStock($activity['stock']);
        $group['activity'] = $activity;
        $grouprecord = pdo_fetchall("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_GROUPRECORD) . "WHERE weid='{$_W['weid']}' AND gid='{$id}' AND paystatus=1");
        foreach ($grouprecord as $key => $val) {
            $userinfo = mc_fansinfo($val['uid'], $_W['acid'], $_W['uniacid']);
            $group['record'][$key]['avatar'] = $userinfo['avatar'];
            $group['record'][$key]['isfirst'] = $val['isfirst'];
        }
        $group['grouprecordnum'] = count($grouprecord);
        $group['surplusnum'] = $activity['group_success_limit'] - $group['grouprecordnum'];
        if ($group['status'] == 2 && ($group['user_isfirst'] == 1 || $group['user_ishelp'] == 1)) {
            $recordinfo = pdo_fetch("SELECT order_no FROM" . tablename(DBCONFIG::$TABLE_KJB_GROUPRECORD) . "WHERE weid='{$_W['weid']}' AND gid='{$id}' AND uid={$uid}");
            $group['userorderno'] = $recordinfo['order_no'];
        }
        return $this->result(0, $message, $group);
    }
    public function doPageGetGroupbuyDetail()
    {
        global $_GPC, $_W;
        $message = '成功';
        $id = $_GPC['activityid'];
        $uid = $_GPC['uid'];
        $ulat = $_GPC['ulat'];
        $ulng = $_GPC['ulng'];
        $activity = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_GROUPBUY) . "WHERE weid='{$_W['weid']}' AND id='{$id}'");
        if (empty($activity)) {
            return $this->result(1, '活动不存在或已被删除', '');
        }
        $activity['stock'] = $this->formatStock($activity['stock']);
        if (!empty($activity['allowcity'])) {
            $activity['checkcity'] = $this->checkCity($id, $ulng, $ulat);
        } else {
            $activity['checkcity'] = 1;
        }
        if ($activity['pic']) {
            $activity['pic'] = unserialize($activity['pic']);
            foreach ($activity['pic'] as $key => $val) {
                $activity['pic'][$key] = tomedia($activity['pic'][$key]);
            }
        }
        if ($activity['sharepic']) {
            $activity['sharepic'] = tomedia($activity['sharepic']);
        }
        if ($activity['type'] == 1 && $activity['validity'] != 0) {
            $activity['validity'] = date('Y-m-d H:i:s', $activity['validity']);
        }
        $endtime_array = getdate($activity['endtime']);
        $activity['format_endtime'] = date('Y-m-d H:i:s', $activity['endtime']);
        $activity['endhours'] = $endtime_array["hours"];
        $activity['endminutes'] = $endtime_array["minutes"];
        $activity['endseconds'] = $endtime_array["seconds"];
        $activity['endmonth'] = $endtime_array["mon"];
        $activity['endday'] = $endtime_array["mday"];
        $activity['endyear'] = $endtime_array["year"];
        $starttime_array = getdate($activity['starttime']);
        $activity['format_starttime'] = date('Y-m-d H:i:s', $activity['starttime']);
        $activity['starthours'] = $starttime_array["hours"];
        $activity['startminutes'] = $starttime_array["minutes"];
        $activity['startseconds'] = $starttime_array["seconds"];
        $activity['startmonth'] = $starttime_array["mon"];
        $activity['startday'] = $starttime_array["mday"];
        $activity['startyear'] = $starttime_array["year"];
        $activity['intro'] = htmlspecialchars_decode($activity['intro']);
        $activity['nowviewnum'] = $activity['viewnum'];
        if ($activity['goodmodel']) {
            $activity['goodmodel'] = explode('|', $activity['goodmodel']);
        }
        $userlist = pdo_fetchall("SELECT * FROM " . tablename(DBCONFIG::$TABLE_KJB_GROUPRECORD) . " WHERE weid='{$_W['weid']}' AND aid='{$activity['id']}' ORDER BY createtime DESC, id DESC LIMIT 0,7");
        $avatar_arr = array();
        foreach ($userlist as $ukey => $uval) {
            $userinfo = mc_fansinfo($uval['uid'], $_W['acid'], $_W['uniacid']);
            if ($userinfo['avatar']) {
                array_push($avatar_arr, $userinfo['avatar']);
            } else {
                array_push($avatar_arr, $this::$DEFAULT_AVATAR);
            }
        }
        $activity['avatar'] = $avatar_arr;
        if ($activity['businessid'] != 0) {
            $businessinfo = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_BUSINESS) . "WHERE weid='{$_W['weid']}' AND id='{$activity['businessid']}'");
            $activity['business'] = $businessinfo;
            if (!empty($businessinfo['longitude']) && !empty($businessinfo['business_latitude']) && $businessinfo['latitude'] != 0 && $businessinfo['longitude'] != 0) {
                $pointarr = $this->Convert_BD09_To_GCJ02($businessinfo['latitude'], $businessinfo['longitude']);
                $activity['business']['longitude'] = $pointarr['lng'];
                $activity['business']['latitude'] = $pointarr['lat'];
            }
        }
        $groupnum = pdo_fetchcolumn('SELECT COUNT(*) FROM ' . tablename(DBCONFIG::$TABLE_KJB_GROUP) . " WHERE weid='{$_W['weid']}' AND aid='{$id}'");
        $activity['groupnum'] = $activity['groupnum_min'] + $groupnum;
        $helpnum = pdo_fetchcolumn('SELECT COUNT(*) FROM ' . tablename(DBCONFIG::$TABLE_KJB_GROUPRECORD) . " WHERE weid='{$_W['weid']}' AND aid='{$id}'");
        $activity['helpnum'] = $activity['helpnum_min'] + $helpnum;
        $activity['viewnum'] = $activity['viewnum_min'] + $activity['viewnum'];
        if (TIMESTAMP < $activity['starttime']) {
            $activity['status'] = $this::$KJ_STATUS_WKS;
            if ($activity['starttime'] - TIMESTAMP < 86400 * 6 && $this->openremind == 1) {
                $remind = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_REMIND) . "WHERE weid='{$_W['weid']}' AND uid='{$uid}' AND aid='{$id}' AND type=3");
                if (empty($remind)) {
                    $activity['remind'] = 1;
                } else {
                    $activity['remind'] = 2;
                }
            } else {
                $activity['remind'] = 0;
            }
        } elseif (TIMESTAMP > $activity['endtime']) {
            $activity['status'] = $this::$KJ_STATUS_JS;
        } else {
            $activity['status'] = $this::$KJ_STATUS_ZC;
        }
        $updata['viewnum'] = $activity['nowviewnum'] + 1;
        pdo_update(DBCONFIG::$TABLE_KJB_GROUPBUY, $updata, array('id' => $id));
        load()->func('file');
        $poster = ATTACHMENT_ROOT . '/ypuk_kjb/activity_' . $id . '_3_' . $_W['weid'] . '.jpg';
        if (file_exists($poster) && filesize($poster) > 200) {
            $activity['poster'] = tomedia('ypuk_kjb/activity_' . $id . '_3_' . $_W['weid'] . '.jpg');
        } else {
            $activity['poster'] = '';
        }
        $user_grouprecord = pdo_fetchall("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_GROUPRECORD) . "WHERE weid='{$_W['weid']}' AND aid='{$id}' AND uid='{$uid}'");
        $where = ' AND endtime>' . TIMESTAMP;
        $where .= ' AND status=1';
        if (!empty($user_grouprecord)) {
            $tmp = array();
            foreach ($user_grouprecord as $v) {
                array_push($tmp, $v['gid']);
            }
            $gids = implode(",", $tmp);
            $where .= ' AND id not in (' . $gids . ')';
        }
        $group = pdo_fetchall("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_GROUP) . "WHERE weid='{$_W['weid']}' AND aid='{$id}'" . $where . " ORDER BY id DESC LIMIT 0,3");
        if (!empty($group)) {
            foreach ($group as $key => $val) {
                $recordCount = pdo_fetchcolumn('SELECT COUNT(*) FROM ' . tablename(DBCONFIG::$TABLE_KJB_GROUPRECORD) . " WHERE weid='{$_W['weid']}' AND gid='{$val['id']}'");
                $groupfirst = pdo_fetch("SELECT uid FROM" . tablename(DBCONFIG::$TABLE_KJB_GROUPRECORD) . "WHERE weid='{$_W['weid']}' AND aid='{$id}' AND gid='{$val['id']}' AND isfirst=1");
                $user = mc_fansinfo($groupfirst['uid'], $_W['acid'], $_W['uniacid']);
                $group[$key]['useravatar'] = $user['avatar'];
                $group[$key]['username'] = $user['nickname'];
                $group[$key]['endtime'] = date('m-d H:i:s', $val['endtime']);
                $group[$key]['surplusnum'] = $activity['group_success_limit'] - $recordCount;
            }
            $activity['nowgroup'] = $group;
        } else {
            $activity['nowgroup'] = '';
        }
        $setting = pdo_fetch("SELECT joinqun_open,joinqun_setting FROM " . tablename(DBCONFIG::$TABLE_KJB_SETTING) . " WHERE weid='{$_W['weid']}'");
        if ($activity['joinqun_open'] == 1 || $setting['joinqun_open'] == 1) {
            if ($activity['joinqun_open'] == 1) {
                $activity['joinqun_data'] = unserialize($activity['joinqun_setting']);
            } else {
                if ($setting['joinqun_open'] == 1) {
                    $activity['joinqun_data'] = unserialize($setting['joinqun_setting']);
                } else {
                    $activity['joinqun_data'] = '';
                }
            }
            if ($activity['joinqun_data'] != '') {
                $activity['joinqun_data']['joinqun_icon'] = tomedia($activity['joinqun_data']['joinqun_icon']);
                if ($activity['joinqun_data']['joinqun_tips_type'] == 1) {
                    $activity['joinqun_data']['joinqun_tips_img'] = tomedia($activity['joinqun_data']['joinqun_tips_img']);
                }
            }
        } else {
            $activity['joinqun_data'] = '';
        }
        return $this->result(0, $message, $activity);
    }
    public function doPageGetGroupbuyDetailMin()
    {
        global $_GPC, $_W;
        $message = '成功';
        $id = $_GPC['activityid'];
        $uid = $_GPC['uid'];
        $activity = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_GROUPBUY) . "WHERE weid='{$_W['weid']}' AND id='{$id}'");
        if (empty($activity)) {
            return $this->result(1, '活动不存在或已被删除', '');
        }
        if ($activity['pic']) {
            $activity['pic'] = unserialize($activity['pic']);
            $activity['logo'] = tomedia($activity['pic'][0]);
        }
        $activity['stock'] = $this->formatStock($activity['stock']);
        if ($activity['goodmodel']) {
            $activity['goodmodel'] = explode('|', $activity['goodmodel']);
        } else {
            $activity['goodmodel'] = '';
        }
        return $this->result(0, $message, $activity);
    }
    public function doPageGroupbuyRecommendList()
    {
        global $_GPC, $_W;
        $message = '成功';
        $list = pdo_fetchall("SELECT * FROM " . tablename(DBCONFIG::$TABLE_KJB_GROUPBUY) . " WHERE weid='{$_W['weid']}' AND status=0 AND recommend=1  AND starttime<'" . TIMESTAMP . "' AND endtime>'" . TIMESTAMP . "' AND stock>0 ORDER BY createtime DESC, id DESC LIMIT 0,7");
        foreach ($list as $key => $val) {
            if (TIMESTAMP < $val['starttime']) {
                $list[$key]['status'] = $this::$KJ_STATUS_WKS;
            } elseif (TIMESTAMP > $val['endtime']) {
                $list[$key]['status'] = $this::$KJ_STATUS_JS;
            } else {
                $list[$key]['status'] = $this::$KJ_STATUS_ZC;
            }
            $groupnum = pdo_fetchcolumn('SELECT COUNT(*) FROM ' . tablename(DBCONFIG::$TABLE_KJB_GROUPRECORD) . " WHERE weid='{$_W['weid']}' AND aid='{$val['id']}' AND paystatus=1");
            $list[$key]['groupnum'] = $groupnum;
            $val['pic'] = unserialize($val['pic']);
            $list[$key]['pic'] = tomedia($val['pic'][0]);
            $list[$key]['stock'] = $this->formatStock($val['stock']);
        }
        return $this->result(0, $message, $list);
    }
    public function doPageGetAd()
    {
        global $_GPC, $_W;
        $ad = pdo_fetch("SELECT * FROM " . tablename(DBCONFIG::$TABLE_KJB_AD) . " WHERE weid='{$_W['weid']}'");
        if (!empty($ad)) {
            $result = $ad;
        } else {
            $result['index_middle_ad'] = '';
            $result['bargain_middle_ad'] = '';
            $result['group_middle_ad'] = '';
            $result['detail_middle_ad'] = '';
            $result['official_account'] = '';
        }
        return $this->result(0, '成功', $result);
    }
    public function doPageGroupbuyAdd()
    {
        global $_W, $_GPC;
        $uid = $_GPC['uid'];
        $activityid = $_GPC['activityid'];
        $activity = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_GROUPBUY) . "WHERE weid='{$_W['weid']}' AND id='{$activityid}'");
        $userGroup = $this->findUserGroup($activityid, $uid);
        if (empty($activity)) {
            return $this->result(-1, '活动不存在', '');
        }
        if (TIMESTAMP < $activity['starttime']) {
            return $this->result(-3, '活动未开始', '');
        }
        if (TIMESTAMP > $activity['endtime']) {
            return $this->result(-4, '活动已结束', '');
        }
        if ($activity['stock'] - $activity['group_success_limit'] <= 0) {
            return $this->result(-5, '对不起库存已不足，请下次再来参加活动吧', '');
        }
        if (!empty($userGroup)) {
            return $this->result(-6, '您在当前活动已经发起过一次拼团，点击可前往', $userGroup['gid']);
        }
        if ($uid == 0) {
            return $this->result(-8, '用户信息读取失败，无法发起拼团', '');
        }
        $order_no = $this->getOrderNo($activityid, 0, 'groupbuy', $uid);
        if ($activity['pay_type'] == 1) {
            $price = $activity['groupprice'];
        } else {
            $price = $activity['ol_groupprice'];
        }
        $payprice = $price + $activity['freight'];
        $totalprice = $activity['groupprice'] + $activity['freight'];
        $grouparray = array('weid' => $_W['weid'], 'aid' => $activityid, 'uid' => $uid, 'payprice' => $payprice, 'totalprice' => $totalprice, 'createtime' => TIMESTAMP, 'status' => 0);
        pdo_insert(DBCONFIG::$TABLE_KJB_GROUP, $grouparray);
        $gid = pdo_insertid();
        $record_array = array('aid' => $activityid, 'uid' => $uid, 'gid' => $gid, 'weid' => $_W['weid'], 'isfirst' => 1, 'order_no' => $order_no, 'uname' => $_GPC['uname'], 'uaddress' => $_GPC['uaddress'], 'utel' => $_GPC['utel'], 'wxorder_no' => '', 'goodmodel' => $_GPC['goodmodel'], 'createtime' => TIMESTAMP, 'paystatus' => 0);
        pdo_insert(DBCONFIG::$TABLE_KJB_GROUPRECORD, $record_array);
        $setting = pdo_fetch("SELECT * FROM " . tablename(DBCONFIG::$TABLE_KJB_SETTING) . " WHERE weid='{$_W['weid']}'");
        if (!empty($setting['order_template_id'])) {
            $this->add_formid($activity['id'], $uid, $_GPC['form_id'], 3);
        }
        $params = array('ordersn' => $order_no, 'tid' => $order_no, 'user' => $uid, 'fee' => floatval($payprice), 'title' => $_W['account']['name'] . "拼团活动订单{$order_no}");
        $pay_params = $this->pay($params);
        $pay_params['gid'] = $gid;
        if (is_error($pay_params)) {
            return $this->result(1, '支付失败，请重试', $pay_params);
        }
        return $this->result(0, '', $pay_params);
    }
    public function doPageGroupbuyPay()
    {
        global $_W, $_GPC;
        $uid = $_GPC['uid'];
        $gid = $_GPC['gid'];
        $group = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_GROUP) . "WHERE weid='{$_W['weid']}' AND id='{$gid}'");
        if (empty($group)) {
            return $this->result(-9, '无对应拼团或已被删除', '');
        }
        $groupfirst = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_GROUPRECORD) . "WHERE weid='{$_W['weid']}' AND gid='{$gid}' AND isfirst=1");
        if ($groupfirst['uid'] != $uid) {
            return $this->result(-10, '拼团未发起，无法参与', '');
        }
        $activity = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_GROUPBUY) . "WHERE weid='{$_W['weid']}' AND id='{$group['aid']}'");
        $userGroup = $this->findUserGroup($activity['id'], $uid);
        if (empty($activity)) {
            return $this->result(-1, '活动不存在', '');
        }
        if (TIMESTAMP < $activity['starttime']) {
            return $this->result(-3, '活动未开始', '');
        }
        if (TIMESTAMP > $activity['endtime']) {
            return $this->result(-4, '活动已结束', '');
        }
        if ($activity['stock'] <= 0) {
            return $this->result(-5, '对不起库存已不足，请下次再来参加活动吧', '');
        }
        if (!empty($userGroup)) {
            if ($userGroup['gid'] != $gid) {
                return $this->result(-6, '您在当前活动已经发起过一次拼团，点击可前往', $userGroup['gid']);
            }
        }
        if ($uid == 0) {
            return $this->result(-8, '用户信息读取失败，无法发起拼团', '');
        }
        if ($activity['pay_type'] == 1) {
            $price = $activity['groupprice'];
        } else {
            $price = $activity['ol_groupprice'];
        }
        $payprice = $price + $activity['freight'];
        $params = array('ordersn' => $groupfirst['order_no'], 'tid' => $groupfirst['order_no'], 'user' => $uid, 'fee' => floatval($payprice), 'title' => $_W['account']['name'] . "拼团活动订单" . $groupfirst['order_no']);
        $pay_params = $this->pay($params);
        $pay_params['gid'] = $gid;
        if (is_error($pay_params)) {
            return $this->result(1, '支付失败，请重试', $pay_params);
        }
        return $this->result(0, '', $pay_params);
    }
    public function doPageGroupbuyBuy()
    {
        global $_W, $_GPC;
        $uid = $_GPC['uid'];
        $activityid = $_GPC['activityid'];
        $activity = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_GROUPBUY) . "WHERE weid='{$_W['weid']}' AND id='{$activityid}'");
        if (empty($activity)) {
            return $this->result(-1, '活动不存在', '');
        }
        if (TIMESTAMP < $activity['starttime']) {
            return $this->result(-3, '活动未开始', '');
        }
        if (TIMESTAMP > $activity['endtime']) {
            return $this->result(-4, '活动已结束', '');
        }
        if ($activity['stock'] <= 0) {
            return $this->result(-5, '对不起库存已不足，请下次再来参加活动吧', '');
        }
        if ($uid == 0) {
            return $this->result(-8, '用户信息读取失败，无法发起拼团', '');
        }
        if ($activity['pay_type'] == 1) {
            $price = $activity['buyprice'];
        } else {
            $price = $activity['ol_buyprice'];
        }
        $payprice = $price + $activity['freight'];
        $totalprice = $activity['buyprice'] + $activity['freight'];
        $order_no = $this->getOrderNo($activityid, 0, 'groupbuy_buy', $uid);
        $order_array = array('aid' => $activityid, 'bid' => 0, 'uid' => $uid, 'weid' => $_W['weid'], 'order_no' => $order_no, 'uname' => $_GPC['uname'], 'address' => $_GPC['uaddress'], 'tel' => $_GPC['utel'], 'oldprice' => $activity['oldprice'], 'nowprice' => $activity['buyprice'], 'freight' => $activity['freight'], 'total_price' => $payprice, 'status' => $this::$KJ_STATUS_XD, 'goodmodel' => $_GPC['goodmodel'], 'oporder' => 1, 'createtime' => TIMESTAMP, 'updatetime' => TIMESTAMP, 'pay_type' => $activity['pay_type'], 'type' => 3);
        pdo_insert(DBCONFIG::$TABLE_KJB_ORDER, $order_array);
        $oid = pdo_insertid();
        return $this->result(0, '', $order_no);
    }
    public function doPageGroupbuyHelp()
    {
        global $_W, $_GPC;
        $uid = $_GPC['uid'];
        $activityid = $_GPC['activityid'];
        $gid = $_GPC['gid'];
        $activity = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_GROUPBUY) . "WHERE weid='{$_W['weid']}' AND id='{$activityid}'");
        $group = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_GROUP) . "WHERE weid='{$_W['weid']}' AND id='{$gid}'");
        if (empty($activity)) {
            return $this->result(-1, '活动不存在', '');
        }
        if (TIMESTAMP < $activity['starttime']) {
            return $this->result(-3, '活动未开始', '');
        }
        if (TIMESTAMP > $activity['endtime']) {
            return $this->result(-4, '活动已结束', '');
        }
        if ($activity['stock'] <= 0) {
            return $this->result(-5, '对不起库存已不足，请下次再来参加活动吧', '');
        }
        $UserHelpGroup = $this->findUserHelpGroup($gid, $uid);
        if (!empty($UserHelpGroup)) {
            return $this->result(-6, '您已经参与过此拼团，点击可前往', $gid);
        }
        if (TIMESTAMP > $group['endtime']) {
            return $this->result(-7, '拼团已到期失效', '');
        }
        if ($group['status'] == 2) {
            return $this->result(-9, '拼团已成功', '');
        }
        if ($uid == 0) {
            return $this->result(-8, '用户信息读取失败，无法发起拼团', '');
        }
        $order_no = $this->getOrderNo($activityid, 0, 'groupbuy', $uid);
        if ($activity['pay_type'] == 1) {
            $price = $activity['groupprice'];
        } else {
            $price = $activity['ol_groupprice'];
        }
        $payprice = $price + $activity['freight'];
        $record_array = array('aid' => $activityid, 'uid' => $uid, 'gid' => $gid, 'weid' => $_W['weid'], 'isfirst' => 0, 'order_no' => $order_no, 'uname' => $_GPC['uname'], 'uaddress' => $_GPC['uaddress'], 'utel' => $_GPC['utel'], 'wxorder_no' => '', 'goodmodel' => $_GPC['goodmodel'], 'createtime' => TIMESTAMP, 'paystatus' => 0);
        pdo_insert(DBCONFIG::$TABLE_KJB_GROUPRECORD, $record_array);
        $oid = pdo_insertid();
        $setting = pdo_fetch("SELECT * FROM " . tablename(DBCONFIG::$TABLE_KJB_SETTING) . " WHERE weid='{$_W['weid']}'");
        if (!empty($setting['order_template_id'])) {
            $this->add_formid($activity['id'], $uid, $_GPC['form_id'], 3);
        }
        $params = array('ordersn' => $order_no, 'tid' => $order_no, 'user' => $uid, 'fee' => floatval($payprice), 'title' => $_W['account']['name'] . "拼团活动订单{$order_no}");
        $pay_params = $this->pay($params);
        $pay_params['gid'] = $gid;
        if (is_error($pay_params)) {
            return $this->result(1, '支付失败，请重试', $pay_params);
        }
        return $this->result(0, '', $pay_params);
    }
    public function doPageCatPanicbuy()
    {
        global $_GPC, $_W;
        $message = '成功';
        load()->model('mc');
        $pindex = max(1, intval($_GPC['page']));
        $psize = 20;
        $catid = $_GPC['catid'];
        $type = $_GPC['type'];
        $uid = $_GPC['uid'];
        $where = ' ';
        if ($type == 'now') {
            $where .= ' AND starttime<' . TIMESTAMP . ' AND endtime>' . TIMESTAMP . ' AND stock>0';
        }
        if ($type == 'ready') {
            $where .= ' AND starttime>' . TIMESTAMP . ' AND endtime>' . TIMESTAMP . ' AND stock>0';
        }
        if ($catid && $catid != '0') {
            $where .= ' AND catid=' . $catid . '';
        }
        $list = pdo_fetchall("SELECT * FROM " . tablename(DBCONFIG::$TABLE_KJB_PANICBUY) . " WHERE weid='{$_W['weid']}' AND status=0" . $where . " ORDER BY createtime DESC, id DESC LIMIT " . ($pindex - 1) * $psize . ',' . $psize);
        foreach ($list as $key => $val) {
            if (TIMESTAMP < $val['starttime']) {
                $list[$key]['status'] = $this::$KJ_STATUS_WKS;
                if ($val['starttime'] - TIMESTAMP < 86400 * 6 && $this->openremind == 1) {
                    $remind = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_REMIND) . "WHERE weid='{$_W['weid']}' AND uid='{$uid}' AND aid='{$val['id']}' AND type=2");
                    if (empty($remind)) {
                        $list[$key]['remind'] = 1;
                    } else {
                        $list[$key]['remind'] = 2;
                    }
                } else {
                    $list[$key]['remind'] = 0;
                }
            } elseif (TIMESTAMP > $val['endtime']) {
                $list[$key]['status'] = $this::$KJ_STATUS_JS;
            } else {
                $list[$key]['status'] = $this::$KJ_STATUS_ZC;
            }
            $list[$key]['stock'] = $this->formatStock($val['stock']);
            $val['pic'] = unserialize($val['pic']);
            $list[$key]['pic'] = tomedia($val['pic'][0]);
        }
        return $this->result(0, $message, $list);
    }
    public function doPageGetPanicbuyDetail()
    {
        global $_GPC, $_W;
        $message = '成功';
        $id = $_GPC['activityid'];
        $uid = $_GPC['uid'];
        $ulat = $_GPC['ulat'];
        $ulng = $_GPC['ulng'];
        $activity = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_PANICBUY) . "WHERE weid='{$_W['weid']}' AND id='{$id}'");
        if (empty($activity)) {
            return $this->result(1, '活动不存在或已被删除', '');
        }
        $UserPanicbuy = $this->findUserPanicbuy($id, $uid);
        if (!empty($UserPanicbuy) && $UserPanicbuy >= $activity['allowbuy_limit']) {
            $activity['user_isbuy'] = 1;
        } else {
            $activity['user_isbuy'] = 0;
        }
        if (!empty($activity['allowcity'])) {
            $activity['checkcity'] = $this->checkCity($id, $ulng, $ulat);
        } else {
            $activity['checkcity'] = 1;
        }
        if ($activity['pic']) {
            $activity['pic'] = unserialize($activity['pic']);
            foreach ($activity['pic'] as $key => $val) {
                $activity['pic'][$key] = tomedia($activity['pic'][$key]);
            }
        }
        if ($activity['sharepic']) {
            $activity['sharepic'] = tomedia($activity['sharepic']);
        }
        if ($activity['type'] == 1 && $activity['validity'] != 0) {
            $activity['validity'] = date('Y-m-d H:i:s', $activity['validity']);
        }
        $endtime_array = getdate($activity['endtime']);
        $activity['format_endtime'] = date('Y-m-d H:i:s', $activity['endtime']);
        $activity['endhours'] = $endtime_array["hours"];
        $activity['endminutes'] = $endtime_array["minutes"];
        $activity['endseconds'] = $endtime_array["seconds"];
        $activity['endmonth'] = $endtime_array["mon"];
        $activity['endday'] = $endtime_array["mday"];
        $activity['endyear'] = $endtime_array["year"];
        $starttime_array = getdate($activity['starttime']);
        $activity['format_starttime'] = date('Y-m-d H:i:s', $activity['starttime']);
        $activity['starthours'] = $starttime_array["hours"];
        $activity['startminutes'] = $starttime_array["minutes"];
        $activity['startseconds'] = $starttime_array["seconds"];
        $activity['startmonth'] = $starttime_array["mon"];
        $activity['startday'] = $starttime_array["mday"];
        $activity['startyear'] = $starttime_array["year"];
        $activity['intro'] = htmlspecialchars_decode($activity['intro']);
        $activity['stock'] = $this->formatStock($activity['stock']);
        $activity['nowviewnum'] = $activity['viewnum'];
        if ($activity['goodmodel']) {
            $activity['goodmodel'] = explode('|', $activity['goodmodel']);
        }
        $userlist = pdo_fetchall("SELECT * FROM " . tablename(DBCONFIG::$TABLE_KJB_ORDER) . " WHERE weid='{$_W['weid']}' AND aid='{$activity['id']}' AND type=2 ORDER BY createtime DESC, id DESC LIMIT 0,7");
        $avatar_arr = array();
        foreach ($userlist as $ukey => $uval) {
            $userinfo = mc_fansinfo($uval['uid'], $_W['acid'], $_W['uniacid']);
            if ($userinfo['avatar']) {
                array_push($avatar_arr, $userinfo['avatar']);
            } else {
                array_push($avatar_arr, $this::$DEFAULT_AVATAR);
            }
        }
        $activity['avatar'] = $avatar_arr;
        if ($activity['businessid'] != 0) {
            $businessinfo = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_BUSINESS) . "WHERE weid='{$_W['weid']}' AND id='{$activity['businessid']}'");
            $activity['business'] = $businessinfo;
            if (!empty($businessinfo['longitude']) && !empty($businessinfo['business_latitude']) && $businessinfo['latitude'] != 0 && $businessinfo['longitude'] != 0) {
                $pointarr = $this->Convert_BD09_To_GCJ02($businessinfo['latitude'], $businessinfo['longitude']);
                $activity['business']['longitude'] = $pointarr['lng'];
                $activity['business']['latitude'] = $pointarr['lat'];
            }
        }
        $buynum = pdo_fetchcolumn('SELECT COUNT(*) FROM ' . tablename(DBCONFIG::$TABLE_KJB_ORDER) . " WHERE weid='{$_W['weid']}' AND aid='{$id}' AND type=2");
        $activity['buynum'] = $activity['buynum_min'] + $buynum;
        $activity['viewnum'] = $activity['viewnum_min'] + $activity['viewnum'];
        if (TIMESTAMP < $activity['starttime']) {
            $activity['status'] = $this::$KJ_STATUS_WKS;
            if ($activity['starttime'] - TIMESTAMP < 86400 * 6 && $this->openremind == 1) {
                $remind = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_REMIND) . "WHERE weid='{$_W['weid']}' AND uid='{$uid}' AND aid='{$id}' AND type=2");
                if (empty($remind)) {
                    $activity['remind'] = 1;
                } else {
                    $activity['remind'] = 2;
                }
            } else {
                $activity['remind'] = 0;
            }
        } elseif (TIMESTAMP > $activity['endtime']) {
            $activity['status'] = $this::$KJ_STATUS_JS;
        } else {
            $activity['status'] = $this::$KJ_STATUS_ZC;
        }
        $updata['viewnum'] = $activity['nowviewnum'] + 1;
        pdo_update(DBCONFIG::$TABLE_KJB_PANICBUY, $updata, array('id' => $id));
        load()->func('file');
        $poster = ATTACHMENT_ROOT . '/ypuk_kjb/activity_' . $id . '_2_' . $_W['weid'] . '.jpg';
        if (file_exists($poster) && filesize($poster) > 200) {
            $activity['poster'] = tomedia('ypuk_kjb/activity_' . $id . '_2_' . $_W['weid'] . '.jpg');
        } else {
            $activity['poster'] = '';
        }
        $setting = pdo_fetch("SELECT joinqun_open,joinqun_setting,weid,panicbuy_opendistribution,panicbuy_distribution_discount,panicbuy_distribution_commission FROM " . tablename(DBCONFIG::$TABLE_KJB_SETTING) . " WHERE weid='{$_W['weid']}'");
        if ($activity['joinqun_open'] == 1 || $setting['joinqun_open'] == 1) {
            if ($activity['joinqun_open'] == 1) {
                $activity['joinqun_data'] = unserialize($activity['joinqun_setting']);
            } else {
                if ($setting['joinqun_open'] == 1) {
                    $activity['joinqun_data'] = unserialize($setting['joinqun_setting']);
                } else {
                    $activity['joinqun_data'] = '';
                }
            }
            if ($activity['joinqun_data'] != '') {
                $activity['joinqun_data']['joinqun_icon'] = tomedia($activity['joinqun_data']['joinqun_icon']);
                if ($activity['joinqun_data']['joinqun_tips_type'] == 1) {
                    $activity['joinqun_data']['joinqun_tips_img'] = tomedia($activity['joinqun_data']['joinqun_tips_img']);
                }
            }
        } else {
            $activity['joinqun_data'] = '';
        }
        if ($setting['panicbuy_opendistribution'] == 1 && !empty($setting['panicbuy_distribution_discount']) && $setting['panicbuy_distribution_discount'] != 0) {
            $setting['discount_price'] = floatval($activity['nowprice'] - $setting['panicbuy_distribution_discount'] * $activity['nowprice']);
            $setting['distribution_discount'] = $setting['panicbuy_distribution_discount'] * 100;
        }
        $activity['setting'] = $setting;
        return $this->result(0, $message, $activity);
    }
    public function doPagePanicbuyRecommendList()
    {
        global $_GPC, $_W;
        $message = '成功';
        load()->model('mc');
        $list = pdo_fetchall("SELECT * FROM " . tablename(DBCONFIG::$TABLE_KJB_PANICBUY) . " WHERE weid='{$_W['weid']}' AND status=0 AND recommend=1  AND starttime<'" . TIMESTAMP . "' AND endtime>'" . TIMESTAMP . "' AND stock>0 ORDER BY createtime DESC, id DESC LIMIT 0,7");
        foreach ($list as $key => $val) {
            if (TIMESTAMP < $val['starttime']) {
                $list[$key]['status'] = $this::$KJ_STATUS_WKS;
            } elseif (TIMESTAMP > $val['endtime']) {
                $list[$key]['status'] = $this::$KJ_STATUS_JS;
            } else {
                $list[$key]['status'] = $this::$KJ_STATUS_ZC;
            }
            $val['pic'] = unserialize($val['pic']);
            $list[$key]['pic'] = tomedia($val['pic'][0]);
            $list[$key]['stock'] = $this->formatStock($val['stock']);
        }
        return $this->result(0, $message, $list);
    }
    public function doPageCheckStock()
    {
        global $_W, $_GPC;
        $type = $_GPC['type'];
        $activityid = $_GPC['id'];
        if ($type == 1) {
            $activity = pdo_fetch("SELECT id,stock FROM" . tablename(DBCONFIG::$TABLE_KJB_ACTIVITY) . "WHERE weid='{$_W['weid']}' AND id='{$activityid}'");
        } elseif ($type == 2) {
            $activity = pdo_fetch("SELECT id,stock FROM" . tablename(DBCONFIG::$TABLE_KJB_PANICBUY) . "WHERE weid='{$_W['weid']}' AND id='{$activityid}'");
        } else {
            $activity = pdo_fetch("SELECT id,stock FROM" . tablename(DBCONFIG::$TABLE_KJB_GROUPBUY) . "WHERE weid='{$_W['weid']}' AND id='{$activityid}'");
        }
        if (empty($activity)) {
            return $this->result(-1, '活动不存在', '');
        }
        if ($activity['stock'] <= 0) {
            return $this->result(-2, '库存已不足，无法购买', '');
        }
        return $this->result(0, '成功', $activity['stock']);
    }
    public function doPageBackStock()
    {
        global $_W, $_GPC;
        $type = $_GPC['type'];
        $activityid = $_GPC['id'];
        if ($type == 1) {
            pdo_query("UPDATE " . tablename(DBCONFIG::$TABLE_KJB_ACTIVITY) . " SET stock=stock+1 WHERE id='{$activityid}'");
        } elseif ($type == 2) {
            pdo_query("UPDATE " . tablename(DBCONFIG::$TABLE_KJB_PANICBUY) . " SET stock=stock+1 WHERE id='{$activityid}'");
        } else {
            pdo_query('UPDATE ' . tablename(DBCONFIG::$TABLE_KJB_GROUPBUY) . " SET stock=stock+1 WHERE id='{$activityid}'");
        }
        pdo_query('UPDATE ' . tablename(DBCONFIG::$TABLE_KJB_ACTIVITYINDEX) . " SET stock=stock+1 WHERE aid='{$activityid}' AND type='{$type}'");
        return $this->result(0, '成功', '');
    }
    public function doPageAddPanicbuyOrder()
    {
        global $_W, $_GPC;
        $uid = $_GPC['uid'];
        $shareuid = $_GPC['shareuid'];
        $activityid = $_GPC['activityid'];
        $activity = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_PANICBUY) . "WHERE weid='{$_W['weid']}' AND id='{$activityid}'");
        $user_buynum = pdo_fetchcolumn("SELECT COUNT(*) FROM" . tablename(DBCONFIG::$TABLE_KJB_ORDER) . "WHERE weid='{$_W['weid']}' AND aid='{$activityid}' AND uid='{$uid}' AND type=2");
        if (empty($activity)) {
            return $this->result(-1, '活动不存在', '');
        }
        if (TIMESTAMP < $activity['starttime']) {
            return $this->result(-3, '活动未开始', '');
        }
        if (TIMESTAMP > $activity['endtime']) {
            return $this->result(-4, '活动已结束', '');
        }
        if ($activity['stock'] <= 0) {
            return $this->result(-5, '对不起库存已不足，请下次再来参加活动吧', '');
        }
        if ($user_buynum >= $activity['allowbuy_limit']) {
            return $this->result(-6, '当前活动每个用户只可参与' . $activity['allowbuy_limit'] . '次哦', '');
        }
        if ($uid == 0) {
            return $this->result(-8, '用户信息读取失败，无法创建订单', '');
        }
        $uname = $_GPC['uname'];
        $address = $_GPC['address'];
        $goodmodel = $_GPC['goodmodel'];
        $tel = $_GPC['tel'];
        $setting = pdo_fetch("SELECT weid,panicbuy_opendistribution,panicbuy_distribution_discount,panicbuy_distribution_commission FROM" . tablename(DBCONFIG::$TABLE_KJB_SETTING) . "WHERE weid='{$_W['weid']}'");
        if (!empty($shareuid) && $shareuid != 0 && $setting['panicbuy_opendistribution'] == 1 && !empty($setting['panicbuy_distribution_discount']) && $setting['panicbuy_distribution_discount'] != 0 && $activity['pay_type'] == 1) {
            $nowprice = floatval($activity['nowprice'] - $setting['panicbuy_distribution_discount'] * $activity['nowprice']);
            $total_price = $nowprice + $activity['freight'];
        } else {
            $nowprice = $activity['nowprice'];
            $total_price = $activity['nowprice'] + $activity['freight'];
        }
        $order_no = $this->getOrderNo($activityid, 0, 'panicbuy', $uid);
        $order_array = array('aid' => $activityid, 'uid' => $uid, 'bid' => 0, 'weid' => $_W['weid'], 'oporder' => 0, 'order_no' => $order_no, 'uname' => $uname, 'address' => $address, 'tel' => $tel, 'oldprice' => $activity['oldprice'], 'nowprice' => $nowprice, 'freight' => $activity['freight'], 'total_price' => $total_price, 'status' => $this::$KJ_STATUS_XD, 'goodmodel' => $goodmodel, 'createtime' => TIMESTAMP, 'updatetime' => TIMESTAMP, 'pay_type' => $activity['pay_type'], 'type' => 2);
        pdo_insert(DBCONFIG::$TABLE_KJB_ORDER, $order_array);
        $oid = pdo_insertid();
        if (!empty($shareuid) && $shareuid != 0 && $setting['panicbuy_opendistribution'] == 1 && $activity['pay_type'] == 1) {
            $distribution_array = array('weid' => $_W['weid'], 'price' => $activity['nowprice'] * $setting['panicbuy_distribution_commission'], 'uid' => $shareuid, 'createtime' => TIMESTAMP, 'aid' => $activityid, 'status' => 0, 'orderno' => $order_no);
            pdo_insert(DBCONFIG::$TABLE_KJB_PANICBUY_DISTRIBUTION, $distribution_array);
        }
        if ($activity['pay_type'] == 2) {
            if ($activity['type'] == 0) {
                $status = 4;
            } else {
                $status = 5;
                $this->makeQrcodeFile($order_no);
            }
            pdo_update(DBCONFIG::$TABLE_KJB_ORDER, array('status' => $status), array('id' => $oid));
        } else {
            $setting = pdo_fetch("SELECT * FROM " . tablename(DBCONFIG::$TABLE_KJB_SETTING) . " WHERE weid='{$_W['weid']}'");
            if (!empty($setting['order_template_id'])) {
                $this->add_formid($activity['id'], $uid, $_GPC['form_id'], 2);
            }
        }
        return $this->result(0, '成功', $order_no);
    }
    public function doPageGetPanicbuyDistributionInfo()
    {
        global $_W, $_GPC;
        $message = '成功';
        $uid = $_GPC['uid'];
        $setting = pdo_fetch("SELECT * FROM " . tablename(DBCONFIG::$TABLE_KJB_SETTING) . " WHERE weid='{$_W['weid']}'");
        if ($setting['panicbuy_opendistribution'] == 0 && empty($setting['panicbuy_opendistribution'])) {
            return $this->result(-1, '未开启抢购分享赚功能', '');
        } else {
            $setting['panicbuy_distribution_commission'] = $setting['panicbuy_distribution_commission'] * 100;
            if ($setting['panicbuy_distribution_discount'] != 0 && $setting['panicbuy_distribution_discount'] != '') {
                $setting['panicbuy_distribution_discount'] = $setting['panicbuy_distribution_discount'] * 100;
            }
        }
        $result['setting'] = $setting;
        $distribution_num = pdo_fetchcolumn('SELECT COUNT(*) FROM ' . tablename(DBCONFIG::$TABLE_KJB_PANICBUY_DISTRIBUTION) . " WHERE weid='{$_W['weid']}' AND uid='{$uid}' AND status=1");
        if (empty($distribution_num)) {
            $distribution_num = 0;
        }
        $result['distribution_num'] = $distribution_num;
        $distribution_price = pdo_fetchcolumn('SELECT SUM(price) FROM ' . tablename(DBCONFIG::$TABLE_KJB_PANICBUY_DISTRIBUTION) . " WHERE weid='{$_W['weid']}' AND uid='{$uid}' AND status=1");
        if (empty($distribution_price)) {
            $distribution_price = 0;
        }
        $withdrawprice = pdo_fetchcolumn('SELECT SUM(withdraw_price) FROM ' . tablename(DBCONFIG::$TABLE_KJB_USERWITHDRAW) . " WHERE weid='{$_W['weid']}' AND uid='{$uid}' AND status=1 ");
        if (empty($withdrawprice)) {
            $withdrawprice = 0;
        }
        $result['withdraw_price'] = $withdrawprice;
        $result['distribution_price'] = $distribution_price;
        $result['allow_price'] = $distribution_price - $withdrawprice;
        return $this->result(0, $message, $result);
    }
    public function doPagePay()
    {
        global $_GPC, $_W;
        $mod = $_GPC['mod'];
        if ($mod == 'kanjia' || empty($mod)) {
            $type = 1;
            $ordertitle = '砍价';
        } elseif ($mod == 'groupbuy_buy') {
            $type = 3;
            $ordertitle = '拼团';
        } else {
            $type = 2;
            $ordertitle = '抢购';
        }
        $order = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_ORDER) . "WHERE weid='{$_W['weid']}' AND order_no='{$_GPC['orderno']}' AND uid='{$_GPC['uid']}' AND type='{$type}'");
        if ($type == 1) {
            $activity = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_ACTIVITY) . "WHERE weid='{$_W['weid']}' AND id='{$order['aid']}'");
        } elseif ($type == 2) {
            $activity = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_PANICBUY) . "WHERE weid='{$_W['weid']}' AND id='{$order['aid']}'");
        } else {
            $activity = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_GROUPBUY) . "WHERE weid='{$_W['weid']}' AND id='{$order['aid']}'");
        }
        if (empty($order)) {
            return $this->result(-1, '订单不存在', '');
        }
        if ($activity['stock'] <= 0) {
            return $this->result(-2, '库存已不足，无法支付', '');
        }
        $params = array('ordersn' => $_GPC['orderno'], 'tid' => $_GPC['orderno'], 'user' => $order['uid'], 'fee' => floatval($order['total_price']), 'title' => $_W['account']['name'] . "" . $ordertitle . "活动订单{$_GPC['ordersn']}");
        $pay_params = $this->pay($params);
        if (is_error($pay_params)) {
            return $this->result(1, '支付失败，请重试', $pay_params);
        }
        return $this->result(0, '', $pay_params);
    }
    public function doPagepayResult()
    {
        global $_GPC, $_W;
        $pay_result = array('tid' => $_GPC['orderno'], 'result' => 'success', 'fee' => 100);
        if ($pay_result['result'] == 'success') {
            $mod = $this->GetStrBetween($pay_result['tid'], 's', 'gi');
            $goodid = $this->GetStrBetween($pay_result['tid'], 'gi', 'ui');
            $paramsid = $this->GetStrBetween($pay_result['tid'], 'pi', 'e');
            if ($mod == '03') {
                $nowrecord = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_GROUPRECORD) . "WHERE weid='{$_W['weid']}' AND order_no='{$pay_result['tid']}'");
                $activity = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_GROUPBUY) . "WHERE weid='{$_W['weid']}' AND id='{$nowrecord['aid']}'");
                $group = pdo_fetch("SELECT price FROM" . tablename(DBCONFIG::$TABLE_KJB_GROUP) . "WHERE weid='{$_W['weid']}' AND id='{$nowrecord['gid']}'");
                if ($nowrecord['isfirst'] == 1) {
                    pdo_update(DBCONFIG::$TABLE_KJB_GROUPRECORD, array('paystatus' => 1, 'wxorder_no' => $pay_result['transaction_id']), array('id' => $nowrecord['id']));
                    pdo_update(DBCONFIG::$TABLE_KJB_GROUPBUY, array('stock' => $activity['stock'] - 1), array('id' => $nowrecord['aid']));
                    pdo_update(DBCONFIG::$TABLE_KJB_ACTIVITYINDEX, array('stock' => $activity['stock'] - 1), array('id' => $nowrecord['aid'], 'activitytype' => 3));
                    pdo_update(DBCONFIG::$TABLE_KJB_GROUP, array('status' => 1, 'endtime' => TIMESTAMP + $activity['grouptime'] * 3600), array('id' => $nowrecord['gid']));
                } else {
                    pdo_update(DBCONFIG::$TABLE_KJB_GROUPRECORD, array('paystatus' => 1, 'wxorder_no' => $pay_result['transaction_id']), array('id' => $nowrecord['id']));
                    $record = pdo_fetchall('SELECT * FROM ' . tablename(DBCONFIG::$TABLE_KJB_GROUPRECORD) . " WHERE gid='{$nowrecord['gid']}' and paystatus=1 and weid='{$_W['weid']}'");
                    if (count($record) == $activity['group_success_limit']) {
                        foreach ($record as $key => $val) {
                            $order_array = array('aid' => $activity['id'], 'bid' => 0, 'gid' => $nowrecord['gid'], 'uid' => $val['uid'], 'oporder' => 0, 'weid' => $_W['weid'], 'order_no' => $val['order_no'], 'uname' => $val['uname'], 'address' => $val['uaddress'], 'tel' => $val['utel'], 'oldprice' => $activity['oldprice'], 'nowprice' => $activity['groupprice'], 'freight' => $activity['freight'], 'total_price' => $group['price'], 'goodmodel' => $val['goodmodel'], 'createtime' => TIMESTAMP, 'updatetime' => TIMESTAMP, 'pay_type' => $activity['pay_type'], 'type' => 3);
                            if ($activity['type'] == 0) {
                                $order_array['status'] = 4;
                            } else {
                                $order_array['status'] = 5;
                                $this->makeQrcodeFile($val['order_no']);
                            }
                            pdo_insert(DBCONFIG::$TABLE_KJB_ORDER, $order_array);
                        }
                        pdo_update(DBCONFIG::$TABLE_KJB_GROUP, array('status' => 2), array('id' => $nowrecord['gid']));
                    }
                }
                return $this->result(0, '支付成功', $nowrecord['gid']);
            } elseif ($mod == '04') {
                $order = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_ORDER) . "WHERE weid='{$_W['weid']}' AND order_no='{$pay_result['tid']}'");
                $activity = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_GROUPBUY) . "WHERE weid='{$_W['weid']}' AND id='{$order['aid']}'");
                if ($activity['type'] == 0) {
                    $status = 4;
                } else {
                    $status = 5;
                    $this->makeQrcodeFile($order['order_no']);
                }
                pdo_update(DBCONFIG::$TABLE_KJB_GROUPBUY, array('stock' => $activity['stock'] - 1), array('id' => $order['aid']));
                pdo_update(DBCONFIG::$TABLE_KJB_ACTIVITYINDEX, array('stock' => $activity['stock'] - 1), array('id' => $order['aid'], 'activitytype' => 3));
                pdo_update(DBCONFIG::$TABLE_KJB_ORDER, array('status' => $status, 'notifytime' => TIMESTAMP, 'wxnotify' => '', 'wxorder_no' => $pay_result['transaction_id'], 'updatetime' => TIMESTAMP), array('order_no' => $pay_result['tid']));
                return $this->result(0, '支付成功', '');
            } else {
                $order = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_ORDER) . "WHERE weid='{$_W['weid']}' AND order_no='{$pay_result['tid']}'");
                if ($order['type'] == 1) {
                    $activity = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_ACTIVITY) . "WHERE weid='{$_W['weid']}' AND id='{$order['aid']}'");
                    if ($activity['type'] == 0) {
                        $status = 4;
                    } else {
                        $status = 5;
                        $this->makeQrcodeFile($order['order_no']);
                    }
                    pdo_update(DBCONFIG::$TABLE_KJB_ACTIVITY, array('stock' => $activity['stock'] - 1), array('id' => $order['aid']));
                    pdo_update(DBCONFIG::$TABLE_KJB_ACTIVITYINDEX, array('stock' => $activity['stock'] - 1), array('id' => $order['aid'], 'activitytype' => 1));
                } else {
                    $activity = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_PANICBUY) . "WHERE weid='{$_W['weid']}' AND id='{$order['aid']}'");
                    if ($activity['type'] == 0) {
                        $status = 4;
                    } else {
                        $status = 5;
                        $this->makeQrcodeFile($order['order_no']);
                    }
                    pdo_update(DBCONFIG::$TABLE_KJB_PANICBUY, array('stock' => $activity['stock'] - 1), array('id' => $order['aid']));
                    pdo_update(DBCONFIG::$TABLE_KJB_ACTIVITYINDEX, array('stock' => $activity['stock'] - 1), array('id' => $order['aid'], 'activitytype' => 2));
                }
                $setting = pdo_fetch("SELECT * FROM " . tablename(DBCONFIG::$TABLE_KJB_SETTING) . " WHERE weid='{$_W['weid']}'");
                if (!empty($setting['order_template_id'])) {
                    $this->send_order_template_message($pay_result['tid'], '');
                }
                pdo_update(DBCONFIG::$TABLE_KJB_ORDER, array('status' => $status, 'notifytime' => TIMESTAMP, 'updatetime' => TIMESTAMP, 'wxnotify' => '', 'wxorder_no' => $pay_result['transaction_id']), array('order_no' => $pay_result['tid']));
                return $this->result(0, '支付成功', '');
            }
        }
    }
    public function payResult($pay_result)
    {
        global $_GPC, $_W;
        if ($pay_result['result'] == 'success') {
            $mod = $this->GetStrBetween($pay_result['tid'], 's', 'gi');
            $goodid = $this->GetStrBetween($pay_result['tid'], 'gi', 'pi');
            $paramsid = $this->GetStrBetween($pay_result['tid'], 'pi', 'e');
            if ($mod == '03') {
                $nowrecord = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_GROUPRECORD) . "WHERE weid='{$_W['weid']}' AND order_no='{$pay_result['tid']}'");
                $activity = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_GROUPBUY) . "WHERE weid='{$_W['weid']}' AND id='{$nowrecord['aid']}'");
                $group = pdo_fetch("SELECT price FROM" . tablename(DBCONFIG::$TABLE_KJB_GROUP) . "WHERE weid='{$_W['weid']}' AND id='{$nowrecord['gid']}'");
                if ($nowrecord['isfirst'] == 1) {
                    pdo_update(DBCONFIG::$TABLE_KJB_GROUPRECORD, array('paystatus' => 1, 'wxorder_no' => $pay_result['tag']['transaction_id']), array('id' => $nowrecord['id']));
                    pdo_update(DBCONFIG::$TABLE_KJB_GROUPBUY, array('stock' => $activity['stock'] - 1), array('id' => $nowrecord['aid']));
                    pdo_update(DBCONFIG::$TABLE_KJB_ACTIVITYINDEX, array('stock' => $activity['stock'] - 1), array('aid' => $nowrecord['aid'], 'activitytype' => 3));
                    pdo_update(DBCONFIG::$TABLE_KJB_GROUP, array('status' => 1, 'endtime' => TIMESTAMP + $activity['grouptime'] * 3600), array('id' => $nowrecord['gid']));
                } else {
                    pdo_update(DBCONFIG::$TABLE_KJB_GROUPRECORD, array('paystatus' => 1, 'wxorder_no' => $pay_result['tag']['transaction_id']), array('id' => $nowrecord['id']));
                    $record = pdo_fetchall('SELECT * FROM ' . tablename(DBCONFIG::$TABLE_KJB_GROUPRECORD) . " WHERE gid='{$nowrecord['gid']}' and paystatus=1 and weid='{$_W['weid']}'");
                    pdo_update(DBCONFIG::$TABLE_KJB_GROUPBUY, array('stock' => $activity['stock'] - 1), array('id' => $activity['id']));
                    if (count($record) == $activity['group_success_limit']) {
                        foreach ($record as $key => $val) {
                            $order_array = array('aid' => $activity['id'], 'bid' => 0, 'gid' => $nowrecord['gid'], 'uid' => $val['uid'], 'oporder' => 0, 'weid' => $_W['weid'], 'order_no' => $val['order_no'], 'uname' => $val['uname'], 'address' => $val['uaddress'], 'tel' => $val['utel'], 'oldprice' => $activity['oldprice'], 'nowprice' => $activity['groupprice'], 'freight' => $activity['freight'], 'total_price' => $group['payprice'], 'goodmodel' => $val['goodmodel'], 'createtime' => TIMESTAMP, 'updatetime' => TIMESTAMP, 'pay_type' => $activity['pay_type'], 'type' => 3, 'wxorder_no' => $pay_result['tag']['transaction_id']);
                            if ($activity['type'] == 0) {
                                $order_array['status'] = 4;
                            } else {
                                $order_array['status'] = 5;
                                $this->makeQrcodeFile($val['order_no']);
                            }
                            pdo_insert(DBCONFIG::$TABLE_KJB_ORDER, $order_array);
                        }
                        pdo_update(DBCONFIG::$TABLE_KJB_GROUP, array('status' => 2), array('id' => $nowrecord['gid']));
                    }
                }
                return $this->result(0, '支付成功', $nowrecord['gid']);
            } elseif ($mod == '04') {
                $order = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_ORDER) . "WHERE weid='{$_W['weid']}' AND order_no='{$pay_result['tid']}'");
                $activity = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_GROUPBUY) . "WHERE weid='{$_W['weid']}' AND id='{$order['aid']}'");
                if ($activity['type'] == 0) {
                    $status = 4;
                } else {
                    $status = 5;
                    $this->makeQrcodeFile($order['order_no']);
                }
                pdo_update(DBCONFIG::$TABLE_KJB_GROUPBUY, array('stock' => $activity['stock'] - 1), array('id' => $order['aid']));
                pdo_update(DBCONFIG::$TABLE_KJB_ACTIVITYINDEX, array('stock' => $activity['stock'] - 1), array('aid' => $order['aid'], 'activitytype' => 3));
                pdo_update(DBCONFIG::$TABLE_KJB_ORDER, array('status' => $status, 'notifytime' => TIMESTAMP, 'updatetime' => TIMESTAMP, 'wxnotify' => '', 'wxorder_no' => $pay_result['tag']['transaction_id']), array('order_no' => $pay_result['tid']));
                return $this->result(0, '支付成功', '');
            } else {
                $order = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_ORDER) . "WHERE weid='{$_W['weid']}' AND order_no='{$pay_result['tid']}'");
                if ($order['type'] == 1) {
                    $activity = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_ACTIVITY) . "WHERE weid='{$_W['weid']}' AND id='{$order['aid']}'");
                    if ($activity['type'] == 0) {
                        $status = 4;
                    } else {
                        $status = 5;
                        $this->makeQrcodeFile($order['order_no']);
                    }
                    pdo_update(DBCONFIG::$TABLE_KJB_ACTIVITY, array('stock' => $activity['stock'] - 1), array('id' => $order['aid']));
                    pdo_update(DBCONFIG::$TABLE_KJB_ACTIVITYINDEX, array('stock' => $activity['stock'] - 1), array('aid' => $order['aid'], 'activitytype' => 1));
                } else {
                    $activity = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_PANICBUY) . "WHERE weid='{$_W['weid']}' AND id='{$order['aid']}'");
                    if ($activity['type'] == 0) {
                        $status = 4;
                    } else {
                        $status = 5;
                        $this->makeQrcodeFile($order['order_no']);
                    }
                    pdo_update(DBCONFIG::$TABLE_KJB_PANICBUY, array('stock' => $activity['stock'] - 1), array('id' => $order['aid']));
                    pdo_update(DBCONFIG::$TABLE_KJB_ACTIVITYINDEX, array('stock' => $activity['stock'] - 1), array('aid' => $order['aid'], 'activitytype' => 2));
                    $distribution = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_PANICBUY_DISTRIBUTION) . "WHERE weid='{$_W['weid']}' AND aid='{$order['aid']}' AND orderno='{$pay_result['tid']}' AND status=0");
                    if (!empty($distribution)) {
                        pdo_update(DBCONFIG::$TABLE_KJB_PANICBUY_DISTRIBUTION, array('status' => 1), array('weid' => $_W['weid'], 'aid' => $order['aid'], 'orderno' => $pay_result['tid'], 'status' => 0));
                    }
                }
                $setting = pdo_fetch("SELECT * FROM " . tablename(DBCONFIG::$TABLE_KJB_SETTING) . " WHERE weid='{$_W['weid']}'");
                if (!empty($setting['order_template_id'])) {
                    $this->send_order_template_message($pay_result['tid'], '');
                }
                pdo_update(DBCONFIG::$TABLE_KJB_ORDER, array('status' => $status, 'notifytime' => TIMESTAMP, 'updatetime' => TIMESTAMP, 'wxnotify' => '', 'wxorder_no' => $pay_result['tag']['transaction_id']), array('order_no' => $pay_result['tid']));
                return $this->result(0, '支付成功', '');
            }
        }
    }
    public function doPageVerificationOrder()
    {
        global $_GPC, $_W;
        $orderno = $_GPC['orderno'];
        $vpass = $_GPC['vpass'];
        $uid = $_GPC['userid'];
        $clerkinfo = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_CLERK) . "WHERE weid='{$_W['weid']}' AND uid='{$uid}'");
        $order = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_ORDER) . "WHERE weid='{$_W['weid']}' AND order_no='{$orderno}'");
        if ($order['type'] == 1) {
            $activity = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_ACTIVITY) . "WHERE weid='{$_W['weid']}' AND id='{$order['aid']}'");
        } elseif ($order['type'] == 3) {
            $activity = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_GROUPBUY) . "WHERE weid='{$_W['weid']}' AND id='{$order['aid']}'");
        } else {
            $activity = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_PANICBUY) . "WHERE weid='{$_W['weid']}' AND id='{$order['aid']}'");
        }
        if (empty($order)) {
            return $this->result(-1, '订单信息错误', '');
        }
        if (empty($clerkinfo)) {
            return $this->result(-2, '用户无核销权限', '');
        }
        if ($clerkinfo['businessid'] != 0) {
            if ($clerkinfo['businessid'] != $activity['businessid']) {
                return $this->result(-6, '此订单非您所属商户，无核销权限', '');
            }
        } else {
            if ($activity['vpassword'] != $vpass) {
                return $this->result(-3, '核销密码错误', '');
            }
        }
        if ($order['status'] < 5) {
            return $this->result(-4, '订单未达核销状态', '');
        }
        if ($order['status'] == 6) {
            return $this->result(-5, '订单已核销过', '');
        }
        $adddata = array('weid' => $_W['weid'], 'oid' => $order['id'], 'order_no' => $orderno, 'clerk' => $clerkinfo['id'], 'createtime' => TIMESTAMP);
        pdo_insert(DBCONFIG::$TABLE_KJB_VERIFICATION, $adddata);
        pdo_update(DBCONFIG::$TABLE_KJB_ORDER, array('status' => 6, 'updatetime' => TIMESTAMP), array('order_no' => $orderno));
        unlink(ATTACHMENT_ROOT . '/ypuk_kjb/' . $orderno . '.png');
        return $this->result(0, '成功', '');
    }
    public function doPageVerificationRecord()
    {
        global $_GPC, $_W;
        $pindex = max(1, intval($_GPC['page']));
        $psize = 20;
        $uid = $_GPC['uid'];
        $clerkinfo = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_CLERK) . "WHERE weid='{$_W['weid']}' AND uid='{$uid}'");
        if (empty($clerkinfo)) {
            return $this->result(-2, '用户无核销权限', '');
        }
        $list = pdo_fetchall("SELECT * FROM " . tablename(DBCONFIG::$TABLE_KJB_VERIFICATION) . " WHERE weid='{$_W['weid']}' AND clerk='{$clerkinfo['id']}' ORDER BY id desc LIMIT " . ($pindex - 1) * $psize . "," . $psize);
        foreach ($list as $key => $value) {
            $list[$key]['createtime'] = date('Y-m-d H:i:s', $value['createtime']);
            $order = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_ORDER) . "WHERE weid='{$_W['weid']}' AND id='{$value['oid']}'");
            if ($order['type'] == 1) {
                $activity = pdo_fetch("SELECT title,validity,pic,pay_type FROM" . tablename(DBCONFIG::$TABLE_KJB_ACTIVITY) . "WHERE weid='{$_W['weid']}' AND id='{$order['aid']}'");
            } elseif ($order['type'] == 2) {
                $activity = pdo_fetch("SELECT title,validity,pic,pay_type FROM" . tablename(DBCONFIG::$TABLE_KJB_PANICBUY) . "WHERE weid='{$_W['weid']}' AND id='{$order['aid']}'");
            } else {
                $activity = pdo_fetch("SELECT title,validity,pic,pay_type,buyprice,freight,groupprice FROM" . tablename(DBCONFIG::$TABLE_KJB_GROUPBUY) . "WHERE weid='{$_W['weid']}' AND id='{$order['aid']}'");
                if ($order['oporder'] == 1) {
                    $order['total_price'] = $activity['buyprice'] + $activity['freight'];
                } else {
                    $order['total_price'] = $activity['groupprice'] + $activity['freight'];
                }
            }
            $activity['stock'] = $this->formatStock($activity['stock']);
            $activity['pic'] = unserialize($activity['pic']);
            $activity['pic'] = tomedia($activity['pic'][0]);
            $list[$key]['order'] = $order;
            $list[$key]['activity'] = $activity;
        }
        return $this->result(0, '成功', $list);
    }
    public function doPageGetIndexMoreSetting()
    {
        global $_GPC, $_W;
        $setting = pdo_fetch("SELECT * FROM " . tablename(DBCONFIG::$TABLE_KJB_SETTING) . " WHERE weid='{$_W['weid']}'");
        if (empty($setting['fixedopen']) || $setting['fixedopen'] == 0) {
            $result['fixedico']['fixedopen'] = 0;
        } else {
            $result['fixedico']['fixedopen'] = 1;
            $result['fixedico']['fixedico'] = tomedia($setting['fixedico']);
            $result['fixedico']['fixedaction'] = $setting['fixedaction'];
            $result['fixedico']['fixedactionid'] = $setting['fixedactionid'];
            $result['fixedico']['fixedbargain'] = $setting['fixedbargain'];
            if ($setting['fixedaction'] == 'openmapp') {
                $result['fixedico']['fixedmappid'] = $setting['fixedmappid'];
                $result['fixedico']['fixedmapppath'] = $setting['fixedmapppath'];
            }
        }
        if (empty($setting['toptipopen']) || $setting['toptipopen'] == 0) {
            $result['toptip']['toptipopen'] = 0;
        } else {
            $result['toptip']['toptipopen'] = 1;
            $result['toptip']['toptipaction'] = $setting['toptipaction'];
            $result['toptip']['toptipactionid'] = $setting['toptipactionid'];
            $result['toptip']['toptiptext'] = $setting['toptiptext'];
            $result['toptip']['toptipbtn'] = $setting['toptipbtn'];
            $result['toptip']['toptiphidden'] = true;
            if ($setting['toptipaction'] == 'openmapp') {
                $result['toptip']['toptipmappid'] = $setting['toptipmappid'];
                $result['toptip']['toptipmapppath'] = $setting['toptipmapppath'];
            }
        }
        if (!empty($setting['swiper'])) {
            $swiper = unserialize($setting['swiper']);
            foreach ($swiper as $key => $val) {
                $swiper[$key]['swiper_image'] = tomedia($val['swiper_image']);
                $sorts[$key] = $val['sort'];
            }
            array_multisort($sorts, SORT_ASC, $swiper);
        } else {
            $swiper = '';
        }
        $notice = pdo_fetchall("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_NOTICE) . "WHERE weid='{$_W['weid']}' ORDER BY id desc LIMIT 0,5");
        foreach ($notice as $k => $n) {
            $notice[$k]['createtime'] = date('Y-m-d', $n['createtime']);
        }
        if (!empty($setting['function_setting'])) {
            $function_data = unserialize($setting['function_setting']);
            if (!empty($function_data['groupbuy_icon'])) {
                $function_data['groupbuy_icon'] = tomedia($function_data['groupbuy_icon']);
            } else {
                $function_data['groupbuy_icon'] = '../../resource/images/default_groupbuy_icon.png';
            }
            if (!empty($function_data['panicbuy_icon'])) {
                $function_data['panicbuy_icon'] = tomedia($function_data['panicbuy_icon']);
            } else {
                $function_data['panicbuy_icon'] = '../../resource/images/default_panicbuy_icon.png';
            }
            if (!empty($function_data['kanjia_icon'])) {
                $function_data['kanjia_icon'] = tomedia($function_data['kanjia_icon']);
            } else {
                $function_data['kanjia_icon'] = '../../resource/images/default_kanjia_icon.png';
            }
            $width = 33;
            if ($function_data['openpanicbuy'] == 0 || $function_data['openpanicbuy'] == 0) {
                $width = 50;
            }
            if ($function_data['opengroupbuy'] == 0 && $function_data['openpanicbuy'] == 0) {
                $width = 100;
            }
            $function_data['width'] = $width;
        } else {
            $function_data = array('openpanicbuy' => 0, 'opengroupbuy' => 0);
        }
        $result['notice'] = $notice;
        $result['swiper'] = $swiper;
        $result['functiondata'] = $function_data;
        return $this->result(0, '成功', $result);
    }
    public function doPageFixedOrTipSetting()
    {
        global $_GPC, $_W;
        $setting = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_SETTING) . "WHERE weid='{$_W['weid']}'");
        if (empty($setting['fixedopen']) || $setting['fixedopen'] == 0) {
            $result['fixedico']['fixedopen'] = 0;
        } else {
            $result['fixedico']['fixedopen'] = 1;
            $result['fixedico']['fixedico'] = tomedia($setting['fixedico']);
            $result['fixedico']['fixedaction'] = $setting['fixedaction'];
            $result['fixedico']['fixedactionid'] = $setting['fixedactionid'];
            $result['fixedico']['fixedbargain'] = $setting['fixedbargain'];
            if ($setting['fixedaction'] == 'openmapp') {
                $result['fixedico']['fixedmappid'] = $setting['fixedmappid'];
                $result['fixedico']['fixedmapppath'] = $setting['fixedmapppath'];
            }
        }
        if (empty($setting['toptipopen']) || $setting['toptipopen'] == 0) {
            $result['toptip']['toptipopen'] = 0;
        } else {
            $result['toptip']['toptipopen'] = 1;
            $result['toptip']['toptipaction'] = $setting['toptipaction'];
            $result['toptip']['toptipactionid'] = $setting['toptipactionid'];
            $result['toptip']['toptiptext'] = $setting['toptiptext'];
            $result['toptip']['toptipbtn'] = $setting['toptipbtn'];
            $result['toptip']['toptiphidden'] = true;
            if ($setting['toptipaction'] == 'openmapp') {
                $result['toptip']['toptipmappid'] = $setting['toptipmappid'];
                $result['toptip']['toptipmapppath'] = $setting['toptipmapppath'];
            }
        }
        if (!empty($setting['apply_open']) && $setting['apply_open'] == 1) {
            $result['apply_open'] = $setting['apply_open'];
        } else {
            $result['apply_open'] = 0;
        }
        return $this->result(0, '成功', $result);
    }
    public function doPageSetRemind()
    {
        global $_GPC, $_W;
        if ($_GPC['mod'] == 'kanjia') {
            $type = 1;
        } elseif ($_GPC['mod'] == 'panicbuy') {
            $type = 2;
        } else {
            $type = 3;
        }
        $id = $this->add_formid($_GPC['activityid'], $_GPC['uid'], $_GPC['form_id'], $type);
        $remind_data = array('weid' => $_W['weid'], 'uid' => $_GPC['uid'], 'formid' => $id, 'aid' => $_GPC['activityid'], 'createtime' => TIMESTAMP, 'type' => $type);
        pdo_insert(DBCONFIG::$TABLE_KJB_REMIND, $remind_data);
        return $this->result(0, '成功', '');
    }
    public function doPageCronApi()
    {
        global $_GPC, $_W;
        $where = ' AND (starttime-' . TIMESTAMP . ' BETWEEN 0 AND 1200) AND endtime>' . TIMESTAMP . ' AND stock>0';
        $alist = pdo_fetchall("SELECT * FROM " . tablename(DBCONFIG::$TABLE_KJB_ACTIVITY) . " WHERE weid='{$_W['weid']}'" . $where . " ORDER BY createtime DESC");
        if ($alist) {
            foreach ($alist as $akey => $aval) {
                $rlist = pdo_fetchall("SELECT * FROM " . tablename(DBCONFIG::$TABLE_KJB_REMIND) . " WHERE weid='{$_W['weid']}' AND aid='{$aval['id']}' ORDER BY createtime DESC");
                if ($rlist) {
                    foreach ($rlist as $rkey => $rval) {
                        $this->send_remind_template_message($rval['id']);
                    }
                }
            }
        }
        $grouplist = pdo_fetchall("SELECT * FROM " . tablename(DBCONFIG::$TABLE_KJB_GROUP) . " WHERE weid='{$_W['weid']}' AND status=1 AND " . TIMESTAMP . ">endtime ORDER BY createtime DESC");
        if (!empty($grouplist)) {
            require_once IA_ROOT . "/addons/" . YPUK_KJB . "/refund_func.php";
            $tmp = array();
            foreach ($grouplist as $v) {
                array_push($tmp, $v['id']);
            }
            $gids = implode(",", $tmp);
            $grouprecord = pdo_fetchall("SELECT * FROM " . tablename(DBCONFIG::$TABLE_KJB_GROUPRECORD) . " WHERE weid='{$_W['weid']}' AND paystatus=1 AND gid in ({$gids}) AND refund=0 ORDER BY id DESC");
            foreach ($grouprecord as $key => $val) {
                pdo_query("UPDATE " . tablename(DBCONFIG::$TABLE_KJB_GROUPBUY) . " SET stock=stock+1 WHERE id='{$val['aid']}'");
                $refundid = refund_create_order($val['order_no'], 'ypuk_kjb');
                $refundstatus = refund($refundid, $val['id'], 'groupbuy');
            }
        }
        return $this->result(0, '成功', '');
    }
    public function doPageConfirmOrder()
    {
        global $_GPC, $_W;
        pdo_update(DBCONFIG::$TABLE_KJB_ORDER, array('status' => 6, 'updatetime' => TIMESTAMP), array('order_no' => $_GPC['orderno'], 'uid' => $_GPC['uid']));
        return $this->result(0, '成功', '');
    }
    public function doPageGetNoticeList()
    {
        global $_W, $_GPC;
        $message = '成功';
        $pindex = max(1, intval($_GPC['page']));
        $psize = 10;
        $notice = pdo_fetchall("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_NOTICE) . "WHERE weid='{$_W['weid']}' ORDER BY id desc LIMIT " . ($pindex - 1) * $psize . "," . $psize);
        foreach ($notice as $k => $n) {
            $notice[$k]['createtime'] = date('Y-m-d H:i:s', $n['createtime']);
        }
        return $this->result(0, $message, $notice);
    }
    public function doPageGetNotice()
    {
        global $_W, $_GPC;
        $message = '成功';
        $notice = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_NOTICE) . "WHERE weid='{$_W['weid']}' AND id='{$_GPC['noticeid']}'");
        $notice['content'] = htmlspecialchars_decode($notice['content']);
        $notice['createtime'] = date('Y-m-d H:i:s', $notice['createtime']);
        return $this->result(0, $message, $notice);
    }
    public function doPageWithdrawLog()
    {
        global $_W, $_GPC;
        $message = '成功';
        $uid = $_GPC['uid'];
        $clerkinfo = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_CLERK) . "WHERE weid='{$_W['weid']}' AND uid='{$uid}'");
        $endtime = TIMESTAMP;
        if (empty($clerkinfo['businessid']) || $clerkinfo['businessid'] == 0) {
            return $this->result(-1, '用户未绑定商户，无法提现', '');
        }
        $last_success_withdraw = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_WITHDRAWLOG) . "WHERE weid='{$_W['weid']}' AND businessid='{$clerkinfo['businessid']}' AND status=1  ORDER BY id desc");
        $setting = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_SETTING) . "WHERE weid='{$_W['weid']}'");
        if (!empty($last_success_withdraw)) {
            $price = 0;
            $business_activity = pdo_fetchall("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_ACTIVITYINDEX) . "WHERE weid='{$_W['weid']}' AND businessid='{$clerkinfo['businessid']}' ORDER BY id desc");
            foreach ($business_activity as $key => $val) {
                $activity_price = pdo_fetchcolumn('SELECT SUM(total_price) FROM ' . tablename(DBCONFIG::$TABLE_KJB_ORDER) . " WHERE weid='{$_W['weid']}' AND aid='{$val['aid']}' AND pay_type=1 AND type='{$val['activitytype']}' AND status=6 AND updatetime >'{$setting['withdraw_date']}' ORDER BY id desc");
                $price = $price + $activity_price;
            }
            $withdraw_price = pdo_fetchcolumn('SELECT SUM(withdraw_price) FROM ' . tablename(DBCONFIG::$TABLE_KJB_WITHDRAWLOG) . " WHERE weid='{$_W['weid']}' AND businessid='{$clerkinfo['businessid']}' AND status=1 ORDER BY id desc");
            $result['all_price'] = $price;
            $result['already_price'] = $withdraw_price;
            $result['allow_price'] = $price - $withdraw_price;
            $last_success_withdraw['createtime'] = date('Y-m-d H:i', $last_success_withdraw['createtime']);
            $result['last_success_withdraw'] = $last_success_withdraw;
        } else {
            $price = 0;
            $business_activity = pdo_fetchall("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_ACTIVITYINDEX) . "WHERE weid='{$_W['weid']}' AND businessid='{$clerkinfo['businessid']}' ORDER BY id desc");
            foreach ($business_activity as $key => $val) {
                $activity_price = pdo_fetchcolumn('SELECT SUM(total_price) FROM ' . tablename(DBCONFIG::$TABLE_KJB_ORDER) . " WHERE weid='{$_W['weid']}' AND aid='{$val['aid']}' AND pay_type=1 AND type='{$val['activitytype']}' AND status=6 AND updatetime > '{$setting['withdraw_date']}' ORDER BY id desc");
                $price = $price + $activity_price;
            }
            $result['all_price'] = $price;
            $result['already_price'] = 0;
            $result['allow_price'] = $price;
            $last_success_withdraw['createtime'] = date('Y-m-d H:i', $last_success_withdraw['createtime']);
            $result['last_success_withdraw'] = '';
        }
        $last_withdraw = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_WITHDRAWLOG) . "WHERE weid='{$_W['weid']}' AND businessid='{$clerkinfo['businessid']}' ORDER BY id desc");
        if (!empty($last_withdraw)) {
            $last_withdraw['createtime'] = date('Y-m-d H:i', $last_withdraw['createtime']);
            $result['last_withdraw'] = $last_withdraw;
        } else {
            $result['last_withdraw'] = '';
        }
        if ($setting['withdraw_charge'] != '' && $setting['withdraw_charge'] != 0) {
            $charged_price = round($result['allow_price'] - $result['allow_price'] * $setting['withdraw_charge'], 2);
            $result['withdraw_charge'] = $setting['withdraw_charge'] * 100 . '%';
        } else {
            $charged_price = $result['allow_price'];
            $result['withdraw_charge'] = 0;
        }
        $result['charged_price'] = $charged_price;
        return $this->result(0, $message, $result);
    }
    public function doPageUserWithdrawLog()
    {
        global $_W, $_GPC;
        $message = '成功';
        $uid = $_GPC['uid'];
        $endtime = TIMESTAMP;
        $last_success_withdraw = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_USERWITHDRAW) . "WHERE weid='{$_W['weid']}' AND uid='{$uid}' AND status=1  ORDER BY id desc");
        $setting = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_SETTING) . "WHERE weid='{$_W['weid']}'");
        if (!empty($last_success_withdraw)) {
            $price = pdo_fetchcolumn('SELECT SUM(price) FROM ' . tablename(DBCONFIG::$TABLE_KJB_PANICBUY_DISTRIBUTION) . " WHERE weid='{$_W['weid']}' AND uid='{$uid}' AND status=1");
            if (empty($price)) {
                $price = 0;
            }
            $withdraw_price = pdo_fetchcolumn('SELECT SUM(withdraw_price) FROM ' . tablename(DBCONFIG::$TABLE_KJB_USERWITHDRAW) . " WHERE weid='{$_W['weid']}' AND uid='{$uid}' AND status=1 ");
            if (empty($withdraw_price)) {
                $withdraw_price = 0;
            }
            $result['all_price'] = $price;
            $result['already_price'] = $withdraw_price;
            $result['allow_price'] = $price - $withdraw_price;
            $last_success_withdraw['createtime'] = date('Y-m-d H:i', $last_success_withdraw['createtime']);
            $result['last_success_withdraw'] = $last_success_withdraw;
        } else {
            $price = pdo_fetchcolumn('SELECT SUM(price) FROM ' . tablename(DBCONFIG::$TABLE_KJB_PANICBUY_DISTRIBUTION) . " WHERE weid='{$_W['weid']}' AND uid='{$uid}' AND status=1");
            if (empty($price)) {
                $price = 0;
            }
            $result['all_price'] = $price;
            $result['already_price'] = 0;
            $result['allow_price'] = $price;
            $last_success_withdraw['createtime'] = date('Y-m-d H:i', $last_success_withdraw['createtime']);
            $result['last_success_withdraw'] = '';
        }
        $last_withdraw = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_USERWITHDRAW) . "WHERE weid='{$_W['weid']}' AND uid='{$uid}' ORDER BY id desc");
        if (!empty($last_withdraw)) {
            $last_withdraw['createtime'] = date('Y-m-d H:i', $last_withdraw['createtime']);
            $result['last_withdraw'] = $last_withdraw;
        } else {
            $result['last_withdraw'] = '';
        }
        if ($setting['user_withdraw_charge'] != '' && $setting['user_withdraw_charge'] != 0) {
            $charged_price = round($result['allow_price'] - $result['allow_price'] * $setting['user_withdraw_charge'], 2);
            $result['withdraw_charge'] = $setting['user_withdraw_charge'] * 100 . '%';
        } else {
            $charged_price = $result['allow_price'];
            $result['withdraw_charge'] = 0;
        }
        $result['charged_price'] = $charged_price;
        return $this->result(0, $message, $result);
    }
    public function doPageGetBusinessManageDetail()
    {
        global $_GPC, $_W;
        $message = '成功';
        $uid = $_GPC['uid'];
        $clerkinfo = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_CLERK) . "WHERE weid='{$_W['weid']}' AND uid='{$uid}'");
        if (empty($clerkinfo['businessid']) || $clerkinfo['businessid'] == 0) {
            return $this->result(-1, '您还未绑定商户，无法访问商户中心', '');
        }
        if (!empty($clerkinfo['name'])) {
            $result['user']['name'] = $clerkinfo['name'];
        } else {
            $result['user']['name'] = '未设置店员姓名';
        }
        $result['clerk'] = $clerkinfo;
        $business = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_BUSINESS) . "WHERE weid='{$_W['weid']}' AND id='{$clerkinfo['businessid']}'");
        if (empty($business)) {
            return $this->result(1, '商户不存在或已被删除', '');
        }
        if ($business['logo']) {
            $business['logo'] = tomedia($business['logo']);
        }
        $result['business'] = $business;
        $business_activity = pdo_fetchall("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_ACTIVITYINDEX) . "WHERE weid='{$_W['weid']}' AND businessid='{$clerkinfo['businessid']}' ORDER BY id desc");
        $tmp = array();
        foreach ($business_activity as $v) {
            array_push($tmp, $v['aid']);
        }
        $activityids = implode(",", $tmp);
        $setting = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_SETTING) . "WHERE weid='{$_W['weid']}'");
        $result['withdraw']['withdraw_open'] = $setting['withdraw_open'];
        $last_success_withdraw = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_WITHDRAWLOG) . "WHERE weid='{$_W['weid']}' AND businessid='{$clerkinfo['businessid']}' AND status=1  ORDER BY id desc");
        if (!empty($last_success_withdraw)) {
            $price = 0;
            foreach ($business_activity as $key => $val) {
                $activity_price = pdo_fetchcolumn('SELECT SUM(total_price) FROM ' . tablename(DBCONFIG::$TABLE_KJB_ORDER) . " WHERE weid='{$_W['weid']}' AND aid='{$val['aid']}' AND pay_type=1 AND status=6 AND type='{$val['activitytype']}' AND updatetime >'{$setting['withdraw_date']}' ORDER BY id desc");
                $price = $price + $activity_price;
            }
            $withdraw_price = pdo_fetchcolumn('SELECT SUM(withdraw_price) FROM ' . tablename(DBCONFIG::$TABLE_KJB_WITHDRAWLOG) . " WHERE weid='{$_W['weid']}' AND businessid='{$clerkinfo['businessid']}' AND status=1 ORDER BY id desc");
            $result['withdraw']['all_price'] = $price;
            $result['withdraw']['already_price'] = $withdraw_price;
            $result['withdraw']['allow_price'] = $price - $withdraw_price;
        } else {
            $price = 0;
            foreach ($business_activity as $key => $val) {
                $activity_price = pdo_fetchcolumn('SELECT SUM(total_price) FROM ' . tablename(DBCONFIG::$TABLE_KJB_ORDER) . " WHERE weid='{$_W['weid']}' AND aid='{$val['aid']}' AND pay_type=1 AND status=6 AND type='{$val['activitytype']}' AND updatetime > '{$setting['withdraw_date']}' ORDER BY id desc");
                $price = $price + $activity_price;
            }
            $result['withdraw']['all_price'] = $price;
            $result['withdraw']['already_price'] = 0;
            $result['withdraw']['allow_price'] = $price;
        }
        $today_ordernum = 0;
        foreach ($business_activity as $key => $val) {
            $activity_ordernum = pdo_fetchcolumn('SELECT COUNT(*) FROM ' . tablename(DBCONFIG::$TABLE_KJB_ORDER) . " WHERE weid='{$_W['weid']}' AND aid={$val['aid']} AND type='{$val['activitytype']}' AND TO_DAYS(DATE_FORMAT(FROM_UNIXTIME(createtime), '%Y-%m-%d')) = TO_DAYS(NOW())");
            $today_ordernum = $today_ordernum + $activity_ordernum;
        }
        $all_ordernum = 0;
        foreach ($business_activity as $key => $val) {
            $activity_ordernum = pdo_fetchcolumn('SELECT COUNT(*) FROM ' . tablename(DBCONFIG::$TABLE_KJB_ORDER) . " WHERE weid='{$_W['weid']}' AND aid={$val['aid']} AND type='{$val['activitytype']}'");
            $all_ordernum = $all_ordernum + $activity_ordernum;
        }
        $yesterday_ordernum = 0;
        foreach ($business_activity as $key => $val) {
            $activity_ordernum = pdo_fetchcolumn('SELECT COUNT(*) FROM ' . tablename(DBCONFIG::$TABLE_KJB_ORDER) . " WHERE weid='{$_W['weid']}' AND aid={$val['aid']} AND type='{$val['activitytype']}' AND TO_DAYS(NOW())-TO_DAYS(DATE_FORMAT(FROM_UNIXTIME(createtime), '%Y-%m-%d')) <= 1");
            $yesterday_ordernum = $yesterday_ordernum + $activity_ordernum;
        }
        $days7_ordernum = 0;
        foreach ($business_activity as $key => $val) {
            $activity_ordernum = pdo_fetchcolumn('SELECT COUNT(*) FROM ' . tablename(DBCONFIG::$TABLE_KJB_ORDER) . " WHERE weid='{$_W['weid']}' AND aid={$val['aid']} AND type='{$val['activitytype']}'AND date_sub(curdate(), INTERVAL 7 DAY) <= DATE_FORMAT(FROM_UNIXTIME(createtime), '%Y-%m-%d')");
            $days7_ordernum = $days7_ordernum + $activity_ordernum;
        }
        $days30_ordernum = 0;
        foreach ($business_activity as $key => $val) {
            $activity_ordernum = pdo_fetchcolumn('SELECT COUNT(*) FROM ' . tablename(DBCONFIG::$TABLE_KJB_ORDER) . " WHERE weid='{$_W['weid']}' AND aid={$val['aid']} AND type='{$val['activitytype']}'AND date_sub(curdate(), INTERVAL 30 DAY) <= DATE_FORMAT(FROM_UNIXTIME(createtime), '%Y-%m-%d')");
            $days30_ordernum = $days30_ordernum + $activity_ordernum;
        }
        $wait_verification_ordernum = 0;
        foreach ($business_activity as $key => $val) {
            $activity_ordernum = pdo_fetchcolumn('SELECT COUNT(*) FROM ' . tablename(DBCONFIG::$TABLE_KJB_ORDER) . " WHERE weid='{$_W['weid']}' AND aid={$val['aid']} AND type='{$val['activitytype']}'AND status=5");
            $wait_verification_ordernum = $wait_verification_ordernum + $activity_ordernum;
        }
        $wait_fahuo_ordernum = 0;
        foreach ($business_activity as $key => $val) {
            $activity_ordernum = pdo_fetchcolumn('SELECT COUNT(*) FROM ' . tablename(DBCONFIG::$TABLE_KJB_ORDER) . " WHERE weid='{$_W['weid']}' AND aid={$val['aid']} AND type='{$val['activitytype']}'AND status=4");
            $wait_fahuo_ordernum = $wait_fahuo_ordernum + $activity_ordernum;
        }
        $ok_ordernum = 0;
        foreach ($business_activity as $key => $val) {
            $activity_ordernum = pdo_fetchcolumn('SELECT COUNT(*) FROM ' . tablename(DBCONFIG::$TABLE_KJB_ORDER) . " WHERE weid='{$_W['weid']}' AND aid={$val['aid']} AND type='{$val['activitytype']}'AND status=6");
            $ok_ordernum = $ok_ordernum + $activity_ordernum;
        }
        $result['ordernum']['today'] = $today_ordernum;
        $result['ordernum']['all'] = $all_ordernum;
        $result['ordernum']['yesterday'] = $yesterday_ordernum;
        $result['ordernum']['days7'] = $days7_ordernum;
        $result['ordernum']['days30'] = $days30_ordernum;
        $result['ordernum']['wait_verification'] = $wait_verification_ordernum;
        $result['ordernum']['wait_fahuo'] = $wait_fahuo_ordernum;
        $result['ordernum']['ok'] = $ok_ordernum;
        $verification_num = pdo_fetchcolumn("SELECT COUNT(*) FROM " . tablename(DBCONFIG::$TABLE_KJB_VERIFICATION) . " WHERE weid='{$_W['weid']}' AND clerk='{$clerkinfo['id']}'");
        if (!empty($verification_num)) {
            $verification_num = $verification_num;
        } else {
            $verification_num = 0;
        }
        $result['clerk']['verification_num'] = $verification_num;
        return $this->result(0, '成功', $result);
    }
    public function doPageGetBusinessOrder()
    {
        global $_GPC, $_W;
        $message = '成功';
        $businessid = $_GPC['businessid'];
        $mod = $_GPC['mod'];
        $pindex = max(1, intval($_GPC['page']));
        $psize = 20;
        $where = '';
        if ($mod == 'today') {
            $where .= ' AND TO_DAYS(DATE_FORMAT(FROM_UNIXTIME(createtime), "%Y-%m-%d")) = TO_DAYS(NOW())';
        }
        if ($mod == 'yesterday') {
            $where .= ' AND TO_DAYS(NOW())-TO_DAYS(DATE_FORMAT(FROM_UNIXTIME(createtime), "%Y-%m-%d")) <= 1';
        }
        if ($mod == 'days7') {
            $where .= ' AND date_sub(curdate(), INTERVAL 7 DAY) <=  DATE_FORMAT(FROM_UNIXTIME(createtime), "%Y-%m-%d")';
        }
        if ($mod == 'days30') {
            $where .= ' AND date_sub(curdate(), INTERVAL 30 DAY) <=  DATE_FORMAT(FROM_UNIXTIME(createtime), "%Y-%m-%d")';
        }
        if ($mod == 'wait_verification') {
            $where .= ' AND status=5';
        }
        if ($mod == 'wait_fahuo') {
            $where .= ' AND status=4';
        }
        if ($mod == 'ok') {
            $where .= ' AND status=6';
        }
        $business = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_BUSINESS) . "WHERE weid='{$_W['weid']}' AND id='{$businessid}'");
        if (empty($business)) {
            return $this->result(1, '商户不存在或已被删除', '');
        }
        $business_activity = pdo_fetchall("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_ACTIVITYINDEX) . "WHERE weid='{$_W['weid']}' AND businessid='{$businessid}'");
        $tmp = array();
        foreach ($business_activity as $v) {
            array_push($tmp, $v['aid']);
        }
        $activityids = implode(",", $tmp);
        $list = pdo_fetchall('SELECT * FROM ' . tablename(DBCONFIG::$TABLE_KJB_ORDER) . " WHERE weid='{$_W['weid']}' AND aid in ({$activityids}) " . $where . " ORDER BY createtime DESC, id DESC LIMIT " . ($pindex - 1) * $psize . ',' . $psize);
        foreach ($list as $key => $value) {
            $list[$key]['order_no'] = substr_replace($value['order_no'], '****', 9, 4);
            $list[$key]['createtime'] = date('Y-m-d H:i:s', $value['createtime']);
            if ($value['type'] == 1) {
                $activity = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_ACTIVITY) . "WHERE weid='{$_W['weid']}' AND id='{$value['aid']}'");
            }
            if ($value['type'] == 2) {
                $activity = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_PANICBUY) . "WHERE weid='{$_W['weid']}' AND id='{$value['aid']}'");
            }
            if ($value['type'] == 3) {
                $activity = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_GROUPBUY) . "WHERE weid='{$_W['weid']}' AND id='{$value['aid']}'");
            }
            if ($activity['type'] == 1 && $activity['validity'] != 0) {
                if (TIMESTAMP > $activity['validity']) {
                    $list[$key]['validitystatus'] = 0;
                } else {
                    $list[$key]['validitystatus'] = 1;
                }
                $activity['validity'] = date('Y-m-d H:i:s', $activity['validity']);
            }
            $activity['pic'] = unserialize($activity['pic']);
            $activity['pic'] = tomedia($activity['pic'][0]);
            $activity['stock'] = $this->formatStock($activity['stock']);
            $list[$key]['activity'] = $activity;
        }
        return $this->result(0, '成功', $list);
    }
    public function doPagePostWithdraw()
    {
        global $_W, $_GPC;
        $message = '成功';
        $uid = $_GPC['uid'];
        $clerkinfo = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_CLERK) . "WHERE weid='{$_W['weid']}' AND uid='{$uid}'");
        if (empty($clerkinfo['businessid']) || $clerkinfo['businessid'] == 0) {
            return $this->result(-1, '用户未绑定商户，无法提现', '');
        }
        $lastwithdraw = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_WITHDRAWLOG) . "WHERE weid='{$_W['weid']}' AND businessid='{$clerkinfo['businessid']}' AND status=0");
        if (!empty($lastwithdraw)) {
            return $this->result(-2, '您还有正在审核中的提现申请，请等待审核完成后再提交', '');
        }
        $setting = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_SETTING) . "WHERE weid='{$_W['weid']}'");
        if ($setting['withdraw_charge'] != '' && $setting['withdraw_charge'] != 0) {
            $charged_price = round($_GPC['withdrawprice'] - $_GPC['withdrawprice'] * $setting['withdraw_charge'], 2);
        } else {
            $charged_price = $_GPC['withdrawprice'];
        }
        $result['charged_price'] = $charged_price;
        $data = array('businessid' => $clerkinfo['businessid'], 'clerkid' => $clerkinfo['id'], 'weid' => $_W['weid'], 'status' => 0, 'charged_price' => $charged_price, 'withdraw_price' => $_GPC['withdrawprice'], 'allprice' => $_GPC['allprice'], 'createtime' => TIMESTAMP);
        pdo_insert(DBCONFIG::$TABLE_KJB_WITHDRAWLOG, $data);
        return $this->result(0, '成功', '');
    }
    public function doPagePostUserWithdraw()
    {
        global $_W, $_GPC;
        $message = '成功';
        $uid = $_GPC['uid'];
        $lastwithdraw = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_USERWITHDRAW) . "WHERE weid='{$_W['weid']}' AND uid='{$uid}' AND status=0");
        if (!empty($lastwithdraw)) {
            return $this->result(-2, '您还有正在审核中的提现申请，请等待审核完成后再提交', '');
        }
        $setting = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_SETTING) . "WHERE weid='{$_W['weid']}'");
        if ($setting['user_withdraw_charge'] != '' && $setting['user_withdraw_charge'] != 0) {
            $charged_price = round($_GPC['withdrawprice'] - $_GPC['withdrawprice'] * $setting['user_withdraw_charge'], 2);
        } else {
            $charged_price = $_GPC['withdrawprice'];
        }
        $result['charged_price'] = $charged_price;
        $data = array('uid' => $uid, 'weid' => $_W['weid'], 'status' => 0, 'charged_price' => $charged_price, 'withdraw_price' => $_GPC['withdrawprice'], 'allprice' => $_GPC['allprice'], 'createtime' => TIMESTAMP);
        pdo_insert(DBCONFIG::$TABLE_KJB_USERWITHDRAW, $data);
        return $this->result(0, '成功', '');
    }
    public function fileUpload2($file, $type = 'image', $name = '')
    {
        if (empty($file)) {
            return '-1';
        }
        global $_W;
        if (empty($cfg['size'])) {
            $defsize = 2;
        }
        $deftype = array('jpg', 'png', 'jpeg');
        if (empty($_W['uploadsetting'])) {
            $_W['uploadsetting'] = array();
            $_W['uploadsetting'][$type]['folder'] = 'images';
            $_W['uploadsetting'][$type]['extentions'] = $deftype;
            $_W['uploadsetting'][$type]['limit'] = 1024 * $defsize;
        }
        $settings = $_W['uploadsetting'];
        if (!array_key_exists($type, $settings)) {
            return '-1';
        }
        $extention = pathinfo($file['name'], PATHINFO_EXTENSION);
        if (!in_array(strtolower($extention), $settings[$type]['extentions'])) {
            return '-1';
        }
        if (!empty($settings[$type]['limit']) && $settings[$type]['limit'] * 1024 < $file['size']) {
            return '-2';
        }
        $result = array();
        load()->func('file');
        if (empty($name) || $name == 'auto') {
            $result['path'] = "{$settings[$type]['folder']}/" . date('Y/m/');
            mkdirs(ATTACHMENT_ROOT . '/' . $result['path']);
            do {
                $filename = random(30) . ".{$extention}";
            } while (file_exists(ATTACHMENT_ROOT . '/' . $result['path'] . $filename));
            $result['path'] .= $filename;
        } else {
            $result['path'] = $name . '.' . $extention;
        }
        if (!file_move($file['tmp_name'], ATTACHMENT_ROOT . '/' . $result['path'])) {
            return '-3';
        }
        return $result;
    }
    public function getStatusText($status)
    {
        switch ($status) {
            case $this::$KJ_STATUS_WKS:
                return "未开始";
                break;
            case $this::$KJ_STATUS_ZC:
                return "正常";
                break;
            case $this::$KJ_STATUS_JS:
                return "已结束";
                break;
            case $this::$KJ_STATUS_XD:
                return "已下单";
                break;
            case $this::$KJ_STATUS_GM:
                return "等待发货";
                break;
            case $this::$KJ_STATUS_YFH:
                return "已发货";
                break;
            case $this::$KJ_STATUS_YTK:
                return "已退款";
                break;
        }
    }
    public function getOrderNo($goodid, $bid, $mod, $uid)
    {
        if ($mod == 'kanjia') {
            return date('YmdHis', time()) . "s01gi" . $goodid . "pi" . $bid . "e";
        } elseif ($mod == 'panicbuy') {
            return date('YmdHis', time()) . "s02gi" . $goodid . "pi" . $uid . "e";
        } elseif ($mod == 'groupbuy_buy') {
            return date('YmdHis', time()) . "s04gi" . $goodid . "pi" . $uid . "e";
        } else {
            return date('YmdHis', time()) . 's03gi' . $goodid . "pi" . $uid . "e";
        }
    }
    public function getOut_trade_no($oid)
    {
        return date('YmdHis', time()) . "o" . $oid;
    }
    public function getStatus($activty, $uid, $type)
    {
        if (TIMESTAMP < $activty['starttime']) {
            return $this::$KJ_STATUS_WKS;
        }
        if (TIMESTAMP > $activty['endtime']) {
            return $this::$KJ_STATUS_JS;
        }
        $orderInfo = $this->findOrderInfo($activty['id'], $uid, $type);
        if (empty($orderInfo)) {
            return $this::$KJ_STATUS_ZC;
        } else {
            return $orderInfo['status'];
        }
    }
    public function GetBargainQr($bargainid)
    {
        global $_GPC, $_W;
        load()->func('file');
        $filename = ATTACHMENT_ROOT . '/ypuk_kjb/bargain_' . $bargainid . '_' . $_W['weid'] . '.jpg';
        if (file_exists($filename) && filesize($filename) > 200) {
            return $filename;
        } else {
            if (!file_exists(ATTACHMENT_ROOT . '/ypuk_kjb')) {
                mkdirs(ATTACHMENT_ROOT . '/ypuk_kjb');
            }
            load()->classs('wxapp.account');
            $appinfo = new WxappAccount($_W['account']);
            $accesstoken = $appinfo->getAccessToken();
            load()->func('communication');
            $url = 'https://api.weixin.qq.com/wxa/getwxacodeunlimit?access_token=' . $accesstoken;
            $data = array('scene' => $bargainid, 'page' => 'ypuk_kjb/pages/bargain/bargain', 'width' => 630);
            $response = ihttp_post($url, json_encode($data));
            if (empty($response['content'])) {
                echo 'nostream';
                exit;
            }
            $file = fopen($filename, "w");
            fwrite($file, $response['content']);
            fclose($file);
            return $filename;
        }
    }
    public function GetPanicbuyUserQr($aid, $shareuid)
    {
        global $_GPC, $_W;
        load()->func('file');
        $filename = ATTACHMENT_ROOT . '/ypuk_kjb/qr_' . $_W['weid'] . '/panibuyqr_' . $shareuid . '_' . $_W['weid'] . '.jpg';
        if (file_exists($filename) && filesize($filename) > 200) {
            return $filename;
        } else {
            if (!file_exists(ATTACHMENT_ROOT . '/ypuk_kjb/qr_' . $_W['weid'])) {
                mkdirs(ATTACHMENT_ROOT . '/ypuk_kjb/qr_' . $_W['weid']);
            }
            load()->classs('wxapp.account');
            $appinfo = new WxappAccount($_W['account']);
            $accesstoken = $appinfo->getAccessToken();
            load()->func('communication');
            $url = 'https://api.weixin.qq.com/wxa/getwxacodeunlimit?access_token=' . $accesstoken;
            $data = array('scene' => 'aid' . $aid . 'shareuid' . $shareuid, 'page' => 'ypuk_kjb/pages/panicbuy_detail/panicbuy_detail', 'width' => 630);
            $response = ihttp_post($url, json_encode($data));
            if (empty($response['content'])) {
                echo 'nostream';
                exit;
            }
            $file = fopen($filename, "w");
            fwrite($file, $response['content']);
            fclose($file);
            return $filename;
        }
    }
    public function getOrderCount($aid)
    {
        global $_W;
        $orderCount = pdo_fetchcolumn('SELECT COUNT(*) FROM ' . tablename(DBCONFIG::$TABLE_KJB_ORDER) . " WHERE aid='{$aid}'");
        return $orderCount;
    }
    public function findOrderInfo($aid, $uid, $type)
    {
        global $_W;
        $orderInfo = pdo_fetch("select * from " . tablename(DBCONFIG::$TABLE_KJB_ORDER) . "WHERE aid='{$aid}' AND uid='{$uid}' AND weid='{$_W['weid']}' AND type='{$type}'");
        return $orderInfo;
    }
    public function makeQrcodeFile($order_no)
    {
        global $_GPC, $_W;
        require_once IA_ROOT . '/framework/library/qrcode/phpqrcode.php';
        load()->func('file');
        if (!file_exists(ATTACHMENT_ROOT . '/ypuk_kjb')) {
            mkdirs(ATTACHMENT_ROOT . '/ypuk_kjb');
        }
        $filename = ATTACHMENT_ROOT . '/ypuk_kjb/' . $order_no . '.png';
        QRcode::png($order_no, $filename, 'L', 6, 2);
    }
    public function checkCity($aid, $lng, $lat)
    {
        global $_W;
        $activity = pdo_fetch("select * from " . tablename(DBCONFIG::$TABLE_KJB_ACTIVITY) . "WHERE id='{$aid}' AND weid='{$_W['weid']}'");
        $allowcity = explode('|', $activity['allowcity']);
        $api_url = 'http://apis.map.qq.com/ws/geocoder/v1/?location=' . $lat . ',' . $lng . '&key=' . $this->qqmapkey . '&get_poi=1';
        $ch = curl_init();
        $timeout = 5;
        curl_setopt($ch, CURLOPT_URL, $api_url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, $timeout);
        $api_result = curl_exec($ch);
        curl_close($ch);
        $api_result = json_decode($api_result, true);
        if ($api_result['status'] == 0) {
            $usercity = $api_result['result']['address_component']['city'];
            if (count($allowcity) == 1) {
                if ($usercity == $allowcity[0]) {
                    return 1;
                }
            } else {
                foreach ($allowcity as $key => $val) {
                    if ($usercity == $val) {
                        return 1;
                    }
                }
            }
        }
        return 0;
    }
    public function findUserBargain($aid, $uid)
    {
        global $_W;
        return pdo_fetch('select * from ' . tablename(DBCONFIG::$TABLE_KJB_BARGAIN) . "WHERE aid='{$aid}' AND uid='{$uid}' AND weid='{$_W['weid']}'");
    }
    public function findUserGroup($aid, $uid)
    {
        global $_W;
        $userrecord = pdo_fetchall("select * from " . tablename(DBCONFIG::$TABLE_KJB_GROUPRECORD) . "WHERE aid='{$aid}' AND uid='{$uid}' AND weid='{$_W['weid']}' AND isfirst=1");
        if (!empty($userrecord)) {
            foreach ($userrecord as $key => $val) {
                $group = pdo_fetch("select * from " . tablename(DBCONFIG::$TABLE_KJB_GROUP) . "WHERE id='{$val['gid']}' AND weid='{$_W['weid']}'");
                if ($group['status'] == 0) {
                    return $userrecord[$key];
                } elseif ($group['status'] == 1 && $group['endtime'] > TIMESTAMP) {
                    return $userrecord[$key];
                } else {
                    return false;
                }
            }
        } else {
            return false;
        }
    }
    public function findUserHelpGroup($gid, $uid)
    {
        global $_W;
        return pdo_fetch('select * from ' . tablename(DBCONFIG::$TABLE_KJB_GROUPRECORD) . "WHERE gid='{$gid}' AND uid='{$uid}' AND weid='{$_W['weid']}'");
    }
    public function findUserPanicbuy($aid, $uid)
    {
        global $_W;
        return $BuyCount = pdo_fetchcolumn('SELECT COUNT(*) FROM ' . tablename(DBCONFIG::$TABLE_KJB_ORDER) . " WHERE aid='{$aid}' and uid='{$uid}' and type='2' and weid='{$_W['weid']}'");
    }
    public function getHelpFriendCount($aid, $uid)
    {
        global $_W;
        return $helpFriendCount = pdo_fetchcolumn('SELECT COUNT(*) FROM ' . tablename(DBCONFIG::$TABLE_KJB_RECORD) . " WHERE aid='{$aid}' and uid='{$uid}' and weid='{$_W['weid']}'");
    }
    public function findHelpFirend($bid, $fuid)
    {
        global $_W;
        return pdo_fetch('select * from ' . tablename(DBCONFIG::$TABLE_KJB_RECORD) . "WHERE bid='{$bid}' AND uid='{$fuid}' AND weid='{$_W['weid']}'");
    }
    public function getBargainPrice($activity, $BargainNowPrice)
    {
        if (empty($activity['bargain_rule'])) {
            return 0;
        }
        if ($BargainNowPrice <= $activity['lowprice']) {
            return 0;
        }
        $bargain_rule = unserialize($activity['bargain_rule']);
        $bargain_price = 0;
        $inRule = false;
        foreach ($bargain_rule as $rule) {
            if ($BargainNowPrice >= $rule['rule_pice']) {
                $bargain_price = rand($rule['rule_start'] * 10, $rule['rule_end'] * 10) / 10;
                $inRule = true;
                break;
            }
        }
        if (!$inRule) {
            $bargain_price = rand(1 * 10, 2 * 10) / 10;
        }
        return $bargain_price;
    }
    public function draw_txt_to($card, $pos, $str, $iswrite)
    {
        $_str_h = $pos["top"];
        $fontsize = $pos["fontsize"];
        $width = $pos["width"];
        $margin_lift = $pos["left"];
        $hang_size = $pos["hang_size"];
        $temp_string = "";
        $font_file = IA_ROOT . "/addons/" . YPUK_KJB . "/images/font.TTF";
        $tp = 0;
        $font_color = imagecolorallocate($card, $pos["color"][0], $pos["color"][1], $pos["color"][2]);
        for ($i = 0; $i < mb_strlen($str); $i++) {
            $box = imagettfbbox($fontsize, 0, $font_file, $temp_string);
            $_string_length = $box[2] - $box[0];
            $temptext = mb_substr($str, $i, 1);
            $temp = imagettfbbox($fontsize, 0, $font_file, $temptext);
            if ($_string_length + $temp[2] - $temp[0] < $width) {
                $temp_string .= mb_substr($str, $i, 1);
                if ($i == mb_strlen($str) - 1) {
                    $_str_h += $hang_size;
                    $tp++;
                    if ($iswrite) {
                        imagettftext($card, $fontsize, 0, $margin_lift, $_str_h, $font_color, $font_file, $temp_string);
                    }
                }
            } else {
                $texts = mb_substr($str, $i, 1);
                $isfuhao = preg_match("/[\\\\pP]/u", $texts) ? true : false;
                if ($isfuhao) {
                    $temp_string .= $texts;
                    $f = mb_substr($str, $i + 1, 1);
                    $fh = preg_match("/[\\\\pP]/u", $f) ? true : false;
                    if ($fh) {
                        $temp_string .= $f;
                        $i++;
                    }
                } else {
                    $i--;
                }
                $tmp_str_len = mb_strlen($temp_string);
                $s = mb_substr($temp_string, $tmp_str_len - 1, 1);
                if ($this->is_firstfuhao($s)) {
                    $temp_string = rtrim($temp_string, $s);
                    $i--;
                }
                $_str_h += $hang_size;
                $tp++;
                if ($iswrite) {
                    imagettftext($card, $fontsize, 0, $margin_lift, $_str_h, $font_color, $font_file, $temp_string);
                }
                $temp_string = "";
            }
        }
        return $tp * $hang_size;
    }
    public function is_firstfuhao($str)
    {
        $fuhaos = array("“", "'", "<", "《");
        return in_array($str, $fuhaos);
    }
    public function get_lt_rounder_corner($radius, $color_r, $color_g, $color_b)
    {
        $img = imagecreatetruecolor($radius, $radius);
        $bgcolor = imagecolorallocate($img, $color_r, $color_g, $color_b);
        $fgcolor = imagecolorallocate($img, 0, 0, 0);
        imagefill($img, 0, 0, $bgcolor);
        imagefilledarc($img, $radius, $radius, $radius * 2, $radius * 2, 180, 270, $fgcolor, IMG_ARC_PIE);
        imagecolortransparent($img, $fgcolor);
        return $img;
    }
    public function myradus($im, $lift, $top, $lt_corner, $radius, $image_h, $image_w)
    {
        imagecopymerge($im, $lt_corner, $lift, $top, 0, 0, $radius, $radius, 100);
        $lb_corner = imagerotate($lt_corner, 90, 0);
        imagecopymerge($im, $lb_corner, $lift, $image_h - $radius + $top, 0, 0, $radius, $radius, 100);
        $rb_corner = imagerotate($lt_corner, 180, 0);
        imagecopymerge($im, $rb_corner, $image_w + $lift - $radius, $image_h + $top - $radius, 0, 0, $radius, $radius, 100);
        $rt_corner = imagerotate($lt_corner, 270, 0);
        imagecopymerge($im, $rt_corner, $image_w - $radius + $lift, $top, 0, 0, $radius, $radius, 100);
    }
    public function add_formid($aid, $uid, $formid, $type)
    {
        global $_W;
        load()->model('mc');
        $user = mc_fansinfo($uid, $_W['acid'], $_W['uniacid']);
        $formid_data = array('weid' => $_W['weid'], 'openid' => $user['openid'], 'formid' => $formid, 'aid' => $aid, 'createtime' => TIMESTAMP, 'type' => $type);
        pdo_insert(DBCONFIG::$TABLE_KJB_FORMID, $formid_data);
        return pdo_insertid();
    }
    public function del_one_formid($formid)
    {
        global $_W;
        pdo_delete(DBCONFIG::$TABLE_KJB_FORMID, array("id" => $formid));
    }
    public function del_all_formid($aid, $uid, $type)
    {
        global $_W;
        load()->model('mc');
        $user = mc_fansinfo($uid, $_W['acid'], $_W['uniacid']);
        pdo_delete(DBCONFIG::$TABLE_KJB_FORMID, array("aid" => $aid, "openid" => $user['openid'], "type" => $type));
    }
    public function formatStock($stock)
    {
        if ($stock > 0) {
            return $stock;
        } else {
            return 0;
        }
    }
    public function FloatPrice($activity)
    {
        $activity['oldprice'] = floatval($activity['oldprice']);
        $activity['lowprice'] = floatval($activity['lowprice']);
        if ($activity['freight'] != '' && $activity['freight'] != '0.00') {
            $activity['freight'] = floatval($activity['freight']);
        }
        if ($activity['opbuy_price'] != '' && $activity['opbuy_price'] != '0.00') {
            $activity['opbuy_price'] = floatval($activity['oldprice']);
        }
        return $activity;
    }
    public function Convert_BD09_To_GCJ02($lat, $lng)
    {
        $x_pi = 3.141592653589793 * 3000.0 / 180.0;
        $x = $lng - 0.0065;
        $y = $lat - 0.006;
        $z = sqrt($x * $x + $y * $y) - 2.0E-5 * sin($y * $x_pi);
        $theta = atan2($y, $x) - 3.0E-6 * cos($x * $x_pi);
        $lng = $z * cos($theta);
        $lat = $z * sin($theta);
        return array('lng' => $lng, 'lat' => $lat);
    }
    public function GetStrBetween($content, $start, $end)
    {
        $r = explode($start, $content);
        if (isset($r[1])) {
            $r = explode($end, $r[1]);
            return $r[0];
        }
        return '';
    }
    public function send_success_template_message($bargainid)
    {
        global $_W;
        load()->model('mc');
        $setting = pdo_fetch("select * from " . tablename(DBCONFIG::$TABLE_KJB_SETTING) . "WHERE weid='{$_W['weid']}'");
        $template_id = $setting['success_template_id'];
        $bargain = pdo_fetch("select * from " . tablename(DBCONFIG::$TABLE_KJB_BARGAIN) . "WHERE id='{$bargainid}' AND weid='{$_W['weid']}'");
        $activity = pdo_fetch("select * from " . tablename(DBCONFIG::$TABLE_KJB_ACTIVITY) . "WHERE id='{$bargain['aid']}' AND weid='{$_W['weid']}'");
        $user = mc_fansinfo($bargain['uid'], $_W['acid'], $_W['uniacid']);
        $formid = pdo_fetch("SELECT * FROM " . tablename(DBCONFIG::$TABLE_KJB_FORMID) . " WHERE weid='{$_W['weid']}' AND openid='{$user['openid']}' AND aid='{$activity['id']}' AND type=1 ORDER BY createtime desc");
        $opendId = $user['openid'];
        $page = "ypuk_kjb/pages/bargain/bargain?bargainid=" . $bargainid;
        $data = array("keyword1" => array("value" => $activity['title'], "color" => "#4a4a4a"), "keyword2" => array("value" => "你发起的砍价已砍价成功，点击提交订单", "color" => "#9b9b9b"), "keyword3" => array("value" => date('Y-m-d H:i:s', time()), "color" => "#9b9b9b"));
        $color = "#3f3f3f";
        $content = json_encode(array('touser' => $opendId, 'template_id' => $template_id, 'page' => $page, 'form_id' => $formid['formid'], 'data' => $data, 'color' => $color));
        load()->classs('wxapp.account');
        $appinfo = new WxappAccount($_W['account']);
        $accesstoken = $appinfo->getAccessToken();
        load()->func('communication');
        $url = "https://api.weixin.qq.com/cgi-bin/message/wxopen/template/send?access_token={$accesstoken}";
        $response = ihttp_post($url, $content);
        if (empty($response['content'])) {
            echo 'nostream';
            exit;
        }
        $this->del_one_formid($formid['id']);
        return $response;
    }
    public function send_order_template_message($orderno, $form_id)
    {
        global $_W;
        load()->model('mc');
        $setting = pdo_fetch("select * from " . tablename(DBCONFIG::$TABLE_KJB_SETTING) . "WHERE weid='{$_W['weid']}'");
        $template_id = $setting['order_template_id'];
        $order = pdo_fetch("SELECT * FROM" . tablename(DBCONFIG::$TABLE_KJB_ORDER) . "WHERE weid='{$_W['weid']}' AND order_no='{$orderno}'");
        if ($order['type'] == 1) {
            $activity = pdo_fetch("select * from " . tablename(DBCONFIG::$TABLE_KJB_ACTIVITY) . "WHERE id='{$order['aid']}' AND weid='{$_W['weid']}'");
            $page = "ypuk_kjb/pages/orderdetail/orderdetail?orderno=" . $orderno;
        } else {
            $activity = pdo_fetch("select * from " . tablename(DBCONFIG::$TABLE_KJB_PANICBUY) . "WHERE id='{$order['aid']}' AND weid='{$_W['weid']}'");
            $page = "ypuk_kjb/pages/panicbuy_orderdetail/panicbuy_orderdetail?orderno=" . $orderno;
        }
        $user = mc_fansinfo($order['uid'], $_W['acid'], $_W['uniacid']);
        if ($activity['pay_type'] == 2) {
            $formid = $form_id;
            if ($activity['type'] == 0) {
                $pay_type = '货到付款';
                $msg = '您的订单已成功提交，请耐心等待发货';
            } else {
                $pay_type = '线下到店付款';
                $msg = '您的订单已成功提交，请到店后出示订单二维码（点击进入获取二维码）并完成付款';
            }
        } else {
            $formid_data = pdo_fetch("SELECT * FROM " . tablename(DBCONFIG::$TABLE_KJB_FORMID) . " WHERE weid='{$_W['weid']}' AND openid='{$user['openid']}' AND aid='{$activity['id']}' AND type='{$order['type']}' ORDER BY createtime desc");
            $formid = $formid_data['formid'];
            if ($activity['type'] == 0) {
                $pay_type = '线上支付（已付款）';
                $msg = '您的订单已完成支付，请耐心等待发货';
            } else {
                $pay_type = '线上支付（已付款）';
                $msg = '您的订单已完成支付，请到店后出示订单二维码（点击进入获取二维码）';
            }
        }
        $opendId = $user['openid'];
        $data = array("keyword1" => array("value" => $orderno, "color" => "#4a4a4a"), "keyword2" => array("value" => $activity['title'], "color" => "#9b9b9b"), "keyword3" => array("value" => $pay_type, "color" => "#9b9b9b"), "keyword4" => array("value" => $msg, "color" => "#9b9b9b"), "keyword5" => array("value" => date('Y-m-d', $order['createtime']), "color" => "#9b9b9b"));
        $color = "#3f3f3f";
        $content = json_encode(array('touser' => $opendId, 'template_id' => $template_id, 'page' => $page, 'form_id' => $formid, 'data' => $data, 'color' => $color));
        load()->classs('wxapp.account');
        $appinfo = new WxappAccount($_W['account']);
        $accesstoken = $appinfo->getAccessToken();
        load()->func('communication');
        $url = "https://api.weixin.qq.com/cgi-bin/message/wxopen/template/send?access_token={$accesstoken}";
        $response = ihttp_post($url, $content);
        if (empty($response['content'])) {
            echo 'nostream';
            exit;
        }
        $this->del_all_formid($order['aid'], $order['uid'], $order['type']);
        return $response;
    }
    public function send_create_template_message($form_id, $bargainid)
    {
        global $_W;
        load()->model('mc');
        $setting = pdo_fetch("select * from " . tablename(DBCONFIG::$TABLE_KJB_SETTING) . "WHERE weid='{$_W['weid']}'");
        $template_id = $setting['create_template_id'];
        $bargain = pdo_fetch("select * from " . tablename(DBCONFIG::$TABLE_KJB_BARGAIN) . "WHERE id='{$bargainid}' AND weid='{$_W['weid']}'");
        $user = mc_fansinfo($bargain['uid'], $_W['acid'], $_W['uniacid']);
        $activity = pdo_fetch("select * from " . tablename(DBCONFIG::$TABLE_KJB_ACTIVITY) . "WHERE id='{$bargain['aid']}' AND weid='{$_W['weid']}'");
        $opendId = $user['openid'];
        $page = "ypuk_kjb/pages/bargain/bargain?bargainid=" . $bargainid;
        $data = array("keyword1" => array("value" => $user['nickname'], "color" => "#4a4a4a"), "keyword2" => array("value" => "您已成功发起砍价，砍至" . $activity['lowprice'] . "即为砍价成功，点击进入分享给您的好友，让TA们帮助您砍价吧", "color" => "#9b9b9b"), "keyword3" => array("value" => $activity['title'], "color" => "#9b9b9b"), "keyword4" => array("value" => date('Y-m-d H:i:s', time()), "color" => "#9b9b9b"));
        $color = "#3f3f3f";
        $content = json_encode(array('touser' => $opendId, 'template_id' => $template_id, 'page' => $page, 'form_id' => $form_id, 'data' => $data, 'color' => $color));
        load()->classs('wxapp.account');
        $appinfo = new WxappAccount($_W['account']);
        $accesstoken = $appinfo->getAccessToken();
        load()->func('communication');
        $url = "https://api.weixin.qq.com/cgi-bin/message/wxopen/template/send?access_token={$accesstoken}";
        $response = ihttp_post($url, $content);
        if (empty($response['content'])) {
            echo 'nostream';
            exit;
        }
        return $response;
    }
    public function send_remind_template_message($remindid)
    {
        global $_W;
        load()->model('mc');
        $setting = pdo_fetch("select * from " . tablename(DBCONFIG::$TABLE_KJB_SETTING) . "WHERE weid='{$_W['weid']}'");
        $template_id = $setting['remind_template_id'];
        $remindinfo = pdo_fetch("select * from " . tablename(DBCONFIG::$TABLE_KJB_REMIND) . "WHERE weid='{$_W['weid']}' AND id='{$remindid}'");
        if ($remindinfo['type'] == 1) {
            $activity = pdo_fetch("select * from " . tablename(DBCONFIG::$TABLE_KJB_ACTIVITY) . "WHERE id='{$remindinfo['aid']}' AND weid='{$_W['weid']}'");
            $page = "ypuk_kjb/pages/detail/detail?activityid=" . $remindinfo['aid'];
            $modtite = '砍价';
        } else {
            $activity = pdo_fetch("select * from " . tablename(DBCONFIG::$TABLE_KJB_PANICBUY) . "WHERE id='{$remindinfo['aid']}' AND weid='{$_W['weid']}'");
            $page = "ypuk_kjb/pages/panicbuy_detail/panicbuy_detail?activityid=" . $remindinfo['aid'];
            $modtite = '抢购';
        }
        $user = mc_fansinfo($remindinfo['uid'], $_W['acid'], $_W['uniacid']);
        $formid = pdo_fetch("SELECT * FROM " . tablename(DBCONFIG::$TABLE_KJB_FORMID) . " WHERE weid='{$_W['weid']}' AND id='{$remindinfo['formid']}' ORDER BY createtime desc");
        $opendId = $user['openid'];
        $time = $activity['starttime'] - TIMESTAMP;
        if ($time > 60) {
            $time = round($time / 60) . '分钟';
        } else {
            $time = $time . '秒';
        }
        $data = array("keyword1" => array("value" => $activity['title'], "color" => "#4a4a4a"), "keyword2" => array("value" => date('Y-m-d H:i:s', $activity['starttime']), "color" => "#9b9b9b"), "keyword3" => array("value" => '您关注的' . $modtite . '活动将在' . $time . '后开始，可点击此消息进入活动详情页面。', "color" => "#9b9b9b"));
        $color = "#3f3f3f";
        $content = json_encode(array('touser' => $opendId, 'template_id' => $template_id, 'page' => $page, 'form_id' => $formid['formid'], 'data' => $data, 'color' => $color));
        load()->classs('wxapp.account');
        $appinfo = new WxappAccount($_W['account']);
        $accesstoken = $appinfo->getAccessToken();
        load()->func('communication');
        $url = "https://api.weixin.qq.com/cgi-bin/message/wxopen/template/send?access_token={$accesstoken}";
        $response = ihttp_post($url, $content);
        if (empty($response['content'])) {
            echo 'nostream';
            exit;
        }
        pdo_delete(DBCONFIG::$TABLE_KJB_FORMID, array("id" => $remindinfo['formid']));
        pdo_delete(DBCONFIG::$TABLE_KJB_REMIND, array("id" => $remindid));
        return $response;
    }
}