
--[[
CPP_wm_skellington_melee,
CPP_wm_skellington_archer,
CPP_wm_skellington_dog,
CPP_wm_skellington_captain_melee,
--]]

--set_global("g_debug_start_at_wave", 15) -- Note: indices start at 1
--set_global("g_debug_never_end", true)

-------------------------------------------------------------------------------
-- Wait a bit for player to land

add_wave_initial_wait()

-------------------------------------------------------------------------------
-- Intro, easy few enemies 

local function make_intro_repeat_attack(interval, repeat_count, dist)
  return waves_repeat(
    {
      wave_spawn(pos_single(vec(-dist, 0.0)), CPP_wm_skellington_melee),
      wave_spawn(pos_single(vec( dist, 0.0)), CPP_wm_skellington_melee),
      wave_timed_wait(interval),
      wave_spawn(pos_single(vec(0.0, -dist)), CPP_wm_skellington_melee),
      wave_spawn(pos_single(vec(0.0,  dist)), CPP_wm_skellington_melee),
      wave_timed_wait(interval),
    },
    repeat_count,
    0.0)
end

add_wave(function ()
  local repeat_attack = make_intro_repeat_attack(4.5, 1, 2.5)
  return waves_sequential(wait_time_or_dead(60, 0.50), repeat_attack)
end)

add_wave(function ()
  local repeat_attack = make_intro_repeat_attack(3.5, 3, 2.5)
  return waves_sequential(wait_time_or_dead(60, 0.60), repeat_attack)
end)

add_wave(function ()
  return waves_sequential(
    wait_time_or_dead(30.0, 0.6),
    {
      wave_spammer_free_in_time(8, 20.0, CPP_wm_skellington_melee),
    })
end)

-------------------------------------------------------------------------------
-- Bring in archers

add_wave(function ()
  return waves_sequential(
    wait_time_or_dead(30.0, 0.75), 
    { 
      -- pos, size, amount, interval, et
      wave_spammer_box(vec(0,0), 7.0, 4, 2.5, CPP_wm_skellington_archer), 
    })
end)

add_wave(function ()
  return waves_parallel(
    wait_time_or_dead(20.0, 0.80), 
    { 
      -- pos, size, amount, interval, et
      wave_spammer_box(vec(0,0), 7.0, 4, 3.0, CPP_wm_skellington_melee), 
      wave_spammer_box(vec(0,0), 7.0, 4, 3.0, CPP_wm_skellington_archer), 
    })
end)

-------------------------------------------------------------------------------
-- First dogs

add_wave(function ()
  return waves_parallel(
    wait_time_or_dead(30.0, 0.5),
    {
      wave_spammer_free_in_time(3, 10.0, CPP_wm_skellington_melee),
      wave_spammer_free_in_time(6, 10.0, CPP_wm_skellington_dog),
    })
end)

-------------------------------------------------------------------------------
-- First captain

add_wave(function ()
  return waves_sequential(
    wait_time_or_dead(6.0, 0.5),
    {
      wave_spawn(pos_single(vec(0.0, 0.0)), CPP_wm_skellington_captain_melee),
    })
end)

-------------------------------------------------------------------------------
-- ...

add_wave(function ()
  return waves_sequential(
    wait_time_or_dead(10.0, 0.50), 
    { 
      wave_spammer_free_in_time(10, 5.0, CPP_wm_skellington_melee),
    })
end)

add_wave(function ()
  return waves_sequential(
    wait_time_or_dead(10.0, 0.50), 
    { 
      wave_spammer_free_in_time(5, 5.0, CPP_wm_skellington_archer),
    })
end)

add_wave(function ()
  return waves_sequential(
    wait_time_or_dead(15.0, 0.50), 
    { 
      -- pos, size, amount, interval, et
      wave_spammer_box(vec(0,0), 5.0, 12, 0.4, CPP_wm_skellington_dog), 
    })
end)

add_wave(function ()
  local dist = 2.5
  return waves_sequential(
    wait_time_or_dead(25.0, 0.10),
    {
      wave_spawn(pos_single(vec(dist, 0.0)), CPP_wm_skellington_captain_melee),
      wave_spawn(pos_single(vec(-dist, 0.0)), CPP_wm_skellington_captain_melee),
      wave_spawn(pos_single(vec(0.0, dist)), CPP_wm_skellington_captain_melee),
      wave_spawn(pos_single(vec(0.0, -dist)), CPP_wm_skellington_captain_melee),
    })
end)

add_wave(function ()
  return waves_parallel(
    wait_time_or_dead(60.0, 0.50), 
    { 
      wave_spammer_free_in_time(26, 30.0, CPP_wm_skellington_melee),
      wave_spammer_free_in_time(10, 30.0, CPP_wm_skellington_archer),
    })
end)

add_wave(function ()
  return waves_parallel(
    wait_time_or_dead(60.0, 0.50), 
    { 
      wave_spammer_free_in_time(8, 6.0, CPP_wm_skellington_melee),
      wave_spammer_free_in_time(4, 6.0, CPP_wm_skellington_archer),
    })
end)

-------------------------------------------------------------------------------
-- Final wait (all dead)

add_wave_final_wait()
