
--[[
CPP_wm_skellington_melee
CPP_wm_skellington_archer
CPP_wm_skellington_dog
CPP_wm_skellington_captain_melee
CPP_wm_skellington_captain_shooter
CPP_wm_skellington_mage
CPP_wm_spider
CPP_wm_bombshroom
CCP_wm_bulletorama
CPP_wm_rollerball
CPP_wm_shockblob
--]]

--set_global("g_debug_start_at_wave", 7) -- Note: indices start at 1
--set_global("g_debug_never_end", true)

-------------------------------------------------------------------------------
-- Wait a bit for player to land

add_wave_initial_wait()

-------------------------------------------------------------------------------
-- ...

add_wave(function ()
  return waves_sequential(
    wait_time_or_dead(26.0, 0.60), 
  	waves_repeat(
    { 
			wave_spawn(pos_single_line(vec(-2.5, -6.0), vec(2.5, -6.0), 4), CPP_wm_spider),
			wave_spawn(pos_single_line(vec(-2.5,  6.0), vec(2.5,  6.0), 4), CPP_wm_spider),
    },
    3,
    2.0))
end)

add_wave(function ()
  return waves_sequential(
    wait_time_or_dead(10.0, 0.50), 
    { 
			wave_spawn(pos_single_line(vec(-2.5, -6.0), vec(2.5, -6.0), 4), CPP_wm_skellington_archer),
			wave_spawn(pos_single_line(vec(-2.5,  6.0), vec(2.5,  6.0), 4), CPP_wm_skellington_archer),
    })
end)

add_wave(function ()
  return waves_sequential(
  	wait_time_or_dead(6, 0.50), 
	  {
	    wave_spawn(pos_single(vec(0.0, 0.0)), CPP_wm_skellington_captain_shooter),
	  })
end)

add_wave(function ()
  return waves_sequential(
  	wait_time_or_dead(10, 0.50), 
	  {
	    wave_spawn(pos_single(vec(0.0, -3.0)), CPP_wm_skellington_captain_shooter),
	    wave_spawn(pos_single(vec(0.0, 3.0)), CPP_wm_skellington_captain_shooter),
	  })
end)

add_wave(function ()
  return waves_parallel(
    wait_time_or_dead(30.0, 0.60), 
    { 
      wave_spammer_free_in_time(10, 12.0, CPP_wm_skellington_melee),
      wave_spammer_free_in_time(5, 12.0, CPP_wm_spider),
    })
end)

add_wave(function ()
  return waves_sequential(
    wait_time_or_dead(15, 0.50), 
    { 
			wave_spawn(pos_single_line(vec(0.0, -5.0), vec(0.0, 5.0), 10), CPP_wm_rollerball),
    })
end)

add_wave(function ()
  return waves_sequential(
    wait_time_or_dead(12.0, 0.50), 
    { 
			wave_spawn(pos_single_line(vec(-2.5, -6.0), vec(2.5, -6.0), 4), CPP_wm_skellington_archer),
			wave_spawn(pos_single_line(vec(-2.5,  6.0), vec(2.5,  6.0), 4), CPP_wm_skellington_archer),
    })
end)

add_wave(function ()
  return waves_sequential(
  	wait_time_or_dead(6.0, 0.50), 
	  {
	    wave_spawn(pos_single(vec(0.0, -1.5)), CPP_wm_skellington_captain_shooter),
	    wave_spawn(pos_single(vec(0.0,  1.5)), CPP_wm_skellington_captain_shooter),
	    wave_spawn(pos_single(vec(0.0, -4.5)), CPP_wm_skellington_captain_shooter),
	    wave_spawn(pos_single(vec(0.0,  4.5)), CPP_wm_skellington_captain_shooter),
	  })
end)

add_wave(function ()
  return waves_parallel(
    wait_time_or_dead(30.0, 0.50), 
    { 
      wave_spammer_free_in_time(12, 15.0, CPP_wm_skellington_melee),
      wave_spammer_free_in_time(10, 15.0, CPP_wm_spider),
    })
end)

add_wave(function ()
  return waves_sequential(
  	wait_time_or_dead(10.0, 0.50), 
	  {
			wave_spawn(pos_single_line(vec(-2.5, -6.0), vec(2.5, -6.0), 4), CPP_wm_rollerball),
			wave_spawn(pos_single_line(vec(-2.5,  6.0), vec(2.5,  6.0), 4), CPP_wm_rollerball),
			wave_spawn(pos_single_line(vec(0.0, -4.0), vec(0.0, 4.0), 5), CPP_wm_skellington_captain_shooter),
	  })
end)

add_wave(function ()
  return waves_parallel(
    wait_time_or_dead(30.0, 0.50), 
    { 
      wave_spammer_free_in_time(15, 20.0, CPP_wm_skellington_melee),
      wave_spammer_free_in_time(10, 20.0, CPP_wm_skellington_archer),
      wave_spammer_free_in_time(10, 20.0, CPP_wm_spider),
    })
end)

-------------------------------------------------------------------------------
-- Final wait (all dead)

add_wave_final_wait()
