// Copyright (C) Kimmo Lahtinen - All Rights Reserved

// Uniforms
// ...

// Input from engine (per vertex)
attribute highp vec2 in_pos;

// Output to pixel shader
varying highp vec2 frag_clip_pos;
varying vec2 frag_map_pos;

void main(void)
{
	vec4 out_pos = to_screen_pos_3d(vec3(in_pos, 0.0));
	gl_Position = out_pos;
	frag_clip_pos = out_pos.xy;
	frag_map_pos = in_pos;
}
