// Copyright (C) Kimmo Lahtinen - All Rights Reserved

// Input from vertex shader
varying vec2 frag_water_depth_uv;
varying vec2 frag_uv_lightmap;
varying vec3 frag_lighting_color;

// Uniforms
uniform lowp sampler2D uni_texture_water_depth;
uniform lowp sampler2D uni_texture_depth_gradient;

uniform vec4 uni_effect_params_frag[3];

void main(void) 
{
	float depth_gradient_scaler 	= uni_effect_params_frag[0][0];
	float water_gradient_brightness = uni_effect_params_frag[0][1];
	float water_bottom_brightness 	= uni_effect_params_frag[0][2];
	float cutaway_brightness_factor = uni_effect_params_frag[0][3];
	vec2  blur_step					= vec2(uni_effect_params_frag[1][0], uni_effect_params_frag[1][1]);
	float final_alpha				= uni_effect_params_frag[1][2];
	float brightness_add			= uni_effect_params_frag[1][3];
	float water_gradient_v_coord	= uni_effect_params_frag[2][0];

	// Read bottom color from lightmap and blur it a bit
	// TODO: DEPENDENT texture reads, calculate in vtx shader?
	vec3 bottom_color = vec3(0.0);
	bottom_color += sample_level_lightmap(frag_uv_lightmap - blur_step * 2.0) 	* 0.14; // TODO: adhoc multipliers, does not even count to 1
	bottom_color += sample_level_lightmap(frag_uv_lightmap - blur_step) 		* 0.19;
	bottom_color += sample_level_lightmap(frag_uv_lightmap) 					* 0.25;
	bottom_color *= (cutaway_brightness_factor * water_bottom_brightness) + brightness_add;

	// Water color based on how deep it is (in eye dir)
	float water_depth_eye_dir = texture2D(uni_texture_water_depth, frag_water_depth_uv).r;

	// DEPENDENT texture read
	// ---> TODO: ??? probably ignore as the screen area of these are so small + never overlapping, so should be fine
	vec3 water_color = texture2D(uni_texture_depth_gradient, vec2(water_depth_eye_dir * depth_gradient_scaler, water_gradient_v_coord)).rgb;
	water_color *= water_gradient_brightness * frag_lighting_color;

	// Final color
	gl_FragColor = vec4((bottom_color + water_color) * final_alpha, final_alpha);
}
