// Copyright (C) 2011 Kimmo Lahtinen - All Rights Reserved

// Uniform transforms
// ...

// Input from engine (per vertex)
attribute highp vec3 in_pos;
attribute highp float in_texturing_axis;

// Output to pixel shader
varying vec2 frag_uv_lightmap;
varying vec2 frag_water_depth_uv;
varying vec3 frag_lighting_color;

void main(void)
{
	// Transform position
	highp vec4 pos_out = to_screen_pos_3d(in_pos);
	gl_Position = pos_out;

	// Uvs
	frag_uv_lightmap = cutaway_lightmap_uv(in_pos.xy, int(in_texturing_axis));
	frag_water_depth_uv	= pos_out.xy * 0.5 + 0.5;

	// Adjust a bit so depth map inaccuracy at border doesn't show
	// TODO: this will be borked if depthmap resolution is lowered, so yeah...
	// TODO: could avoid this by stretching the depthmap in positive dir the same way as negative dir
	frag_water_depth_uv.y += 0.01;

	// Lighting
	frag_lighting_color = light_surface(vec3(0, 0, 1));
}
