// Copyright (C) Kimmo Lahtinen - All Rights Reserved

// Input from engine (per vertex)
attribute highp vec2 in_pos;
attribute highp vec2 in_uv;
attribute highp vec3 in_color;

// Output to pixel shader
varying mediump vec4 frag_color;
varying mediump vec2 frag_uv;

void main(void)
{
	gl_Position = to_screen_pos_2d(in_pos);
	frag_uv 	= in_uv;
	frag_color	= vec4(in_color, 0.0);
}
