// Copyright (C) Kimmo Lahtinen - All Rights Reserved

// Uniforms

// Input from engine (per vertex)
attribute highp vec2 in_pos;
attribute highp vec3 in_normal;

// Output to pixel shader
varying mediump vec3 frag_color;
varying mediump vec2 frag_diffuse_uv;
varying mediump vec2 frag_shadow_uv;

void main(void)
{
	mediump vec3 color = light_surface(in_normal);
	mediump vec4 screen_pos = to_screen_pos_2d(in_pos);
	mediump vec2 source_rt_uv = (screen_pos.xy + 1.0) * 0.5;

	gl_Position 		= screen_pos;
	frag_diffuse_uv		= source_rt_uv;
	frag_shadow_uv		= source_rt_uv;
	frag_color 			= color;
}
