// Copyright (C) Kimmo Lahtinen - All Rights Reserved

// Input per vertex
attribute highp vec3 in_pos;
attribute highp vec2 in_uv_fade;
attribute highp vec2 in_uv_animation;
attribute lowp  vec4 in_color;

// Output to pixel shader
varying lowp 	vec4 pixel_color;
varying mediump vec2 pixel_uv_fade;
varying mediump vec2 pixel_uv_animation;

void main(void)
{
	gl_Position 		= to_screen_pos_3d(in_pos);
	pixel_color 		= in_color;
	pixel_uv_fade 		= in_uv_fade;
	pixel_uv_animation 	= in_uv_animation;
}
