// Copyright (C) Kimmo Lahtinen - All Rights Reserved

// Per vertex input
attribute highp vec2 in_pos;
attribute highp vec2 in_uv_diffuse;
attribute highp vec2 in_uv_ground;
attribute lowp  vec4 in_color;
attribute highp vec3 in_ground_add_mul_and_wind_factor;

// Uniforms
uniform highp vec3 uni_wind_phase;
uniform highp vec3 uni_wind_phase_scale;
uniform highp vec3 uni_wind_vtx_scale;

// Output to frag shader
varying lowp vec4 frag_color;
varying highp vec2 frag_uv_diffuse;
varying mediump vec2 frag_uv_ground;
varying mediump vec2 frag_ground_add_mul;

void main(void)
{
	gl_Position 		= to_screen_pos_2d(in_pos);
	frag_uv_diffuse 	= in_uv_diffuse;
	frag_uv_ground 		= in_uv_ground;
	frag_color 			= in_color;
	frag_ground_add_mul = in_ground_add_mul_and_wind_factor.xy;

	// Note: wind is calculated in screen space and !!doesn't respect the camera zoom setting!!
	// (as we don't change the actual view transform, we just zoom the sprites manually... legacy reasons, zoom was hacked in at last moment)

	float wind_factor = in_ground_add_mul_and_wind_factor.z;

	gl_Position.x += wind_factor * sin(uni_wind_phase.x + in_uv_ground.x * uni_wind_phase_scale.x) * uni_wind_vtx_scale.x;
	gl_Position.x += wind_factor * cos(uni_wind_phase.y + in_uv_ground.y * uni_wind_phase_scale.y) * uni_wind_vtx_scale.y;
	gl_Position.y += wind_factor * cos(uni_wind_phase.z + in_uv_ground.y * uni_wind_phase_scale.z) * uni_wind_vtx_scale.z;
}
