// Copyright (C) 2011 Kimmo Lahtinen - All Rights Reserved

// Uniform transforms
// ...

// Input from engine (per vertex)
attribute highp vec4 in_pos_and_is_culled;

// Output to pixel shader
varying float frag_depth;

#define WATER_STORED_DEPTH 1.0 // TODO: one step is 0.25 currently, so this is 4 steps ... get that from a uniform
#define WATER_SCALER (1.0 / WATER_STORED_DEPTH)

void main(void)
{
	const float stretch_distance = 50.0;

	// Stretch top sides outwards so when rendering water, it doesn't sample empty space when rendering top parts
	vec3 stretched_pos = in_pos_and_is_culled.xyz;
	if (stretched_pos.x <= 0.0)	stretched_pos.x = -stretch_distance;
	if (stretched_pos.y <= 0.0) stretched_pos.y = -stretch_distance;

	frag_depth			= -in_pos_and_is_culled.z * WATER_SCALER;
	gl_Position 		= to_screen_pos_3d(stretched_pos);
}
